/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.component.applies;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.MechanismApplyRecord;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.StaticParamsDO;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyContext;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyService;
import com.digiwin.athena.knowledgegraph.domain.MechanismTenantVariable;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.enums.MechanismParameterTypeEnum;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleMechanismParameterService;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.rule.model.parameter.MechanismParameterReqDO;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.knowledgegraph.vo.VariableBean;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.mechanismEnum.VariableTypeEnum;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskByQuantityPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskOnTimeOverPart;
import com.digiwin.athena.mechanism.pre.parts.SourceSchedulePart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.PersonnelCondition;
import com.digiwin.athena.mechanism.widgets.plan.ActivityPlanWidget;
import com.digiwin.athena.mechanism.widgets.source.ScheduleApiSourceWidget;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@Order(value=1)
public class AbilityComponentApplyService
implements ComponentApplyService {
    private static final Logger log = LoggerFactory.getLogger(AbilityComponentApplyService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    TenantService tenantService;
    @Autowired
    IMechanismService iMechanismService;
    @Autowired
    private List<AbstractMonitorRuleMechanismParameterService> monitorRuleMechanismParameterServices;
    @Autowired
    private IMechanismService mechanismService;
    private static final List<String> ALLOW_REPLACE_VARIABLE_TYPES = Arrays.asList("NUMBER", "STRING", "DATE", "DATETIME");
    @Autowired
    private DataPickService dataPickService;

    @Override
    public boolean accept(ComponentBO componentBO) {
        return ComponentTypeEnum.MechanismControl.equals((Object)componentBO.getType()) || ComponentTypeEnum.MechanismDecision.equals((Object)componentBO.getType()) || ComponentTypeEnum.MechanismAssign.equals((Object)componentBO.getType()) || ComponentTypeEnum.MechanismDrive.equals((Object)componentBO.getType()) || ComponentTypeEnum.MechanismLimit.equals((Object)componentBO.getType());
    }

    @Override
    public void apply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        log.info("\u5f00\u59cb\u5e94\u7528\u673a\u5236\u80fd\u529bstartApplyMechanismCapacity: " + JSON.toJSONString((Object)componentBO));
        String tenantId = AthenaUtils.getTenantId();
        String logicCode = componentBO.getLogicCode();
        if (null == logicCode) {
            logicCode = componentBO.getCode();
        }
        if (null == logicCode) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.componentCodeError", new Object[0]));
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)logicCode).and("tenantId").is((Object)tenantId));
        MechanismLogic logic = (MechanismLogic)this.mongoTemplateUser.findOne(query, MechanismLogic.class);
        if (null == logic || logic.getLogic() == null) {
            logic = this.getSystemLogic(logicCode);
        }
        if (null == logic || logic.getLogic() == null) {
            log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MechanismLogic\uff1a" + logicCode);
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", componentBO.getType().name());
        param.put("pluginId", componentBO.getCode());
        param.put("mechanismCode", context.getMechanismCode());
        param.put("mechanismVersion", componentBO.getMechanismCapacity().getMechanismVersion());
        param.put("ability", logic.getLogic());
        param.put("mechanismVariables", context.getMechanismVariables());
        if (null != logic.getType()) {
            param.put("type", logic.getType());
        }
        this.replaceImNoticeReceiverFromMechanismVariable(logic, tenantId);
        this.setDataViewCode(logic, param);
        this.replaceVariableCodeToTenantValueForLimit(logic);
        this.dataMapService.bindMechanismComponent(param);
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("mechanismAbilityCode").is((Object)componentBO.getCode())), MechanismApplyRecord.class);
        MechanismApplyRecord applyRecord = new MechanismApplyRecord();
        applyRecord.setMechanismCode(context.getMechanismCode());
        applyRecord.setMechanismAbilityCode(componentBO.getCode());
        applyRecord.setTenantId(tenantId);
        applyRecord.setUpdateTime(new Date());
        this.mongoTemplateUser.save((Object)applyRecord);
        String version = this.tenantService.getTenantVersion(tenantId);
        String pluginId = componentBO.getCode() + tenantId;
        if (ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())) {
            List<com.digiwin.athena.knowledgegraph.domain.MonitorRule> rules;
            DriveAbilityBo bo = this.kgHelpService.convert(logic.getLogic(), DriveAbilityBo.class);
            if (bo.getNeedLightDetection() != null && bo.getNeedLightDetection().booleanValue()) {
                if (bo.getCheckSource() instanceof ScheduleSourceWidget) {
                    MechanismPart part = componentBO.getMechanismCapacity().getCheck();
                    ScheduleSourceWidget checkSource = (ScheduleSourceWidget)bo.getCheckSource();
                    MonitorRule monitorRule = checkSource.getMonitorRule();
                    TaskSchedule taskSchedule = this.kgHelpService.convert(monitorRule, TaskSchedule.class);
                    taskSchedule.setTenantId(AthenaUtils.getTenantId());
                    taskSchedule.setMechanismLogicCode(logicCode);
                    taskSchedule.setType("taskDetail");
                    taskSchedule.setActionType("task");
                    taskSchedule.setActionCommonId(bo.getProjectCode());
                    if (part instanceof CheckTaskByQuantityPart) {
                        CheckTaskByQuantityPart checkPart = (CheckTaskByQuantityPart)part;
                        String jobCode = checkPart.getCheckByQuantity().getJobCode();
                        taskSchedule.setTaskCode(jobCode);
                        taskSchedule.setDataStates((List)Lists.newArrayList((Object[])new String[]{StringUtils.isEmpty((CharSequence)checkPart.getCheckByQuantity().getDataStateCode()) ? "waitting" : checkPart.getCheckByQuantity().getDataStateCode()}));
                    }
                    if (part instanceof CheckTaskOnTimeOverPart && componentBO.getMechanismCapacity().getSource() instanceof SourceSchedulePart) {
                        String taskCode = ((SourceSchedulePart)componentBO.getMechanismCapacity().getSource()).getTargetSource().getTarget();
                        taskSchedule.setTaskCode(taskCode);
                        taskSchedule.setDataStates((List)Lists.newArrayList((Object[])new String[]{StringUtils.isEmpty((CharSequence)((CheckTaskOnTimeOverPart)part).getCheckComplete().getDataStateCode()) ? "waitting" : ((CheckTaskOnTimeOverPart)part).getCheckComplete().getDataStateCode()}));
                    }
                    this.MonitorMechanismParameterProcess(componentBO, taskSchedule, tenantId, bo);
                    this.dataMapService.postTaskSchedule(taskSchedule);
                }
                return;
            }
            this.MonitorSupportMechanismParameter(bo, tenantId);
            String monitorRuleId = pluginId;
            String actionId = bo.getActionId();
            HashMap<String, Object> param2 = new HashMap<String, Object>();
            param2.put("pluginId", pluginId);
            param2.put("tenantId", tenantId);
            param2.put("monitorRuleId", monitorRuleId);
            param2.put("actionId", actionId);
            String product = this.kgHelpService.getTenantProduct(monitorRuleId);
            String deleteCyhper1 = "match(m:MonitorRule{pluginId:$pluginId}) detach delete m";
            Query query1 = Query.query((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)pluginId));
            this.kgHelpService.executeCyhper(deleteCyhper1, param2);
            this.mongoTemplateSystem.remove(query1, MonitorRuleProductConfig.class);
            TriggerDTO triggerDTO = null;
            ScheduleApiSourceWidget scheduleSource = null;
            if (!Objects.isNull(componentBO.getMechanismCapacity())) {
                MechanismPart part = componentBO.getMechanismCapacity().getSource();
                SourceSchedulePart sourceSchedulePart = (SourceSchedulePart)part;
                scheduleSource = sourceSchedulePart.getScheduleSource();
            }
            if (null != scheduleSource && MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue().equals(scheduleSource.getCheckFrequencyType())) {
                triggerDTO = this.getTriggerDTO(tenantId, bo, scheduleSource);
            }
            if ((rules = this.dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(monitorRuleId, version))).size() == 0) {
                Object ruleObj = JSONPath.eval((Object)logic.getLogic(), (String)"$.checkSource.monitorRule");
                String projectCode = (String)JSONPath.eval((Object)logic.getLogic(), (String)"$.projectCode");
                if (null != ruleObj) {
                    com.digiwin.athena.knowledgegraph.domain.MonitorRule rule = (com.digiwin.athena.knowledgegraph.domain.MonitorRule)((Object)JSON.parseObject((String)JSON.toJSONString((Object)ruleObj), com.digiwin.athena.knowledgegraph.domain.MonitorRule.class));
                    rule.setCode(monitorRuleId);
                    rule.setVersion(version);
                    rule.setActionType("task");
                    rule.setActionCommonId(projectCode);
                    rule.setPluginId(pluginId);
                    rule.setDynamicParams(rule.getDynamicParamsDto());
                    if (!Objects.isNull(triggerDTO)) {
                        rule.setStandardPollingRule(JSON.toJSONString((Object)triggerDTO));
                    }
                    this.kgHelpService.executeCyhperSave(rule);
                    if (null != rule.getMonitorActionId()) {
                        param2.put("monitorRuleActionId", rule.getMonitorActionId());
                    }
                    MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
                    monitorRuleProductConfig.setMonitorRuleId(monitorRuleId);
                    monitorRuleProductConfig.setProductName(product == null ? "Athena" : product);
                    monitorRuleProductConfig.setVersion(version);
                    monitorRuleProductConfig.setPluginId(pluginId);
                    if (null != rule.getStaticParams()) {
                        ArrayList<StaticParamsDO> staticParams = new ArrayList<StaticParamsDO>();
                        for (DynamicParam p : rule.getStaticParams()) {
                            StaticParamsDO sp = new StaticParamsDO();
                            sp.setParam_name(p.getParam_name());
                            this.replaceValue(tenantId, rule, p, sp, staticParams);
                        }
                        monitorRuleProductConfig.setStaticParams(staticParams);
                    }
                    if (null != rule.getDynamicParamsDto()) {
                        List dynamicParams = JSON.parseArray((String)rule.getDynamicParamsDto(), DynamicParamsDO.class);
                        monitorRuleProductConfig.setDynamicParams(dynamicParams);
                    }
                    this.mongoTemplateSystem.save((Object)monitorRuleProductConfig);
                }
            }
            String createMonitorRelation = "match(t:TenantEntity{tenantId:$tenantId}),(m:MonitorRule{code:$monitorRuleId}) merge (t)-[:USE]->(m)";
            String createActionRelation = "match(t:TenantEntity{tenantId:$tenantId}),(m:StartDataEventAction{actionId:$actionId}) merge (t)-[:ACTION]->(m)";
            String createApiActionRelation = "match(t:TenantEntity{tenantId:$tenantId}),(m:Action{actionId:$monitorRuleActionId}) merge (t)-[:ACTION]->(m)";
            this.kgHelpService.executeCyhper(createMonitorRelation, param2);
            this.kgHelpService.executeCyhper(createActionRelation, param2);
            if (null != param2.get("monitorRuleActionId")) {
                this.kgHelpService.executeCyhper(createApiActionRelation, param2);
            }
            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setConfigId(logicCode);
            config.setTenantId(tenantId);
            config.setMonitorRuleId(monitorRuleId);
            config.setProductName(product);
            config.setStatus(1);
            config.setHasMechanismOrCustomParam(this.hasMechanismOrCustomParam(logic));
            try {
                Object standardPollingRule = JSONPath.eval((Object)bo, (String)"$.checkSource.monitorRule.standardPollingRule");
                if (triggerDTO == null && null != standardPollingRule) {
                    triggerDTO = (TriggerDTO)JSON.parseObject((String)JSON.toJSONString((Object)standardPollingRule), TriggerDTO.class);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Objects.nonNull(triggerDTO)) {
                config.setStandardPollingRule(triggerDTO);
            }
            this.monitorRuleConfigService.post(config);
        }
    }

    private void MonitorMechanismParameterProcess(ComponentBO componentBO, TaskSchedule taskSchedule, String tenantId, DriveAbilityBo bo) {
        if (taskSchedule.getStandardPollingRule() == null) {
            ScheduleApiSourceWidget scheduleSource = null;
            if (!Objects.isNull(componentBO.getMechanismCapacity())) {
                MechanismPart sourcePart = componentBO.getMechanismCapacity().getSource();
                SourceSchedulePart sourceSchedulePart = (SourceSchedulePart)sourcePart;
                scheduleSource = sourceSchedulePart.getScheduleSource();
            }
            if (null != scheduleSource && MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue().equals(scheduleSource.getCheckFrequencyType())) {
                TriggerDTO triggerDTO = this.getTriggerDTO(tenantId, bo, scheduleSource);
                StandardPollingRule pollingRule = (StandardPollingRule)JSON.parseObject((String)JSON.toJSONString((Object)triggerDTO), StandardPollingRule.class);
                pollingRule.setStartTimeType(Integer.valueOf(1));
                taskSchedule.setStandardPollingRule(pollingRule);
            }
        }
    }

    private void setDataViewCode(MechanismLogic logic, Map<String, Object> param) {
        try {
            List<ActivityConfig> activityConfigs;
            LimitAbilityBo limitAbilityBo = this.kgHelpService.convert(logic.getLogic(), LimitAbilityBo.class);
            if (Objects.nonNull(limitAbilityBo) && limitAbilityBo.getCheckSource().getType().equalsIgnoreCase("dataEntrySource") && !CollectionUtils.isEmpty(activityConfigs = this.dataPickService.find(Criteria.where((String)"code").in(new Object[]{limitAbilityBo.getCheckSource().getTarget()}), ActivityConfig.class, "activityConfigs"))) {
                ActivityConfig activityConfig = activityConfigs.get(0);
                Map pages = activityConfig.getPages();
                Optional.ofNullable(pages).map(p -> (Map)p.get("browse-page")).map(browsePage -> browsePage.get("dataSourceName")).map(Object::toString).flatMap(dataSourceName -> Optional.ofNullable(activityConfig.getDataSources()).map(dataSources -> (Map)dataSources.get(dataSourceName))).map(dataSource -> (Map)dataSource.get("dataViewQuery")).map(dataViewQuery -> (String)dataViewQuery.get("code")).ifPresent(dataViewCode -> param.put("dataViewCode", dataViewCode));
            }
        }
        catch (Exception e) {
            log.error("Route==>AbilityComponentApplyService method=setDataViewCode error:", (Throwable)e);
        }
    }

    private Map getRealDataSource(Map<String, Object> dataSources) {
        if (dataSources == null || dataSources.isEmpty()) {
            return null;
        }
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)dataSources.entrySet().iterator().next().getValue()), Map.class);
    }

    private boolean hasMechanismOrCustomParam(MechanismLogic logic) {
        try {
            com.digiwin.athena.knowledgegraph.domain.MonitorRule rule;
            Object ruleObj = JSONPath.eval((Object)logic.getLogic(), (String)"$.checkSource.monitorRule");
            if (null != ruleObj && !CollectionUtils.isEmpty((rule = (com.digiwin.athena.knowledgegraph.domain.MonitorRule)((Object)JSON.parseObject((String)JSON.toJSONString((Object)ruleObj), com.digiwin.athena.knowledgegraph.domain.MonitorRule.class))).getStaticParams())) {
                return true;
            }
        }
        catch (Exception ex) {
            log.error("\u5224\u65ad\u662f\u5426\u5b58\u5728\u673a\u5236\u53c2\u6570\u6216\u8005\u81ea\u5b9a\u4e49\u53c2\u6570\u5f02\u5e38", (Throwable)ex);
        }
        return false;
    }

    private void replaceImNoticeReceiverFromMechanismVariable(MechanismLogic logic, String tenantId) throws DWBusinessException {
        if (ComponentTypeEnum.MechanismDrive.name().equals(logic.getType()) || ComponentTypeEnum.MechanismControl.name().equals(logic.getType())) {
            ActivityPlanWidget activityPlanWidget;
            List activityWidget;
            DriveAbilityBo bo;
            PlanWidget positiveTarget = null;
            List preActivities = null;
            if (ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())) {
                bo = this.kgHelpService.convert(logic.getLogic(), DriveAbilityBo.class);
                positiveTarget = bo.getChoose().getPositiveTarget();
                preActivities = bo.getPreActivities();
            } else if (ComponentTypeEnum.MechanismControl.name().equals(logic.getType())) {
                bo = this.kgHelpService.convert(logic.getLogic(), ControlAbilityBO.class);
                positiveTarget = bo.getChoose().getPositiveTarget();
                preActivities = bo.getPreActivities();
            }
            if (positiveTarget != null && "activityPlan".equals(positiveTarget.getType()) && !CollectionUtils.isEmpty((Collection)(activityWidget = (activityPlanWidget = (ActivityPlanWidget)positiveTarget).getActivityWidget()))) {
                for (ActivityWidget activityWidgetItem : activityWidget) {
                    if (!"im".equals(activityWidgetItem.getType())) continue;
                    IMActivityWidget imActivityWidgetItem = (IMActivityWidget)activityWidgetItem;
                    if (MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue().equals(imActivityWidgetItem.getPerformerType())) {
                        String mechanismVariableCode = imActivityWidgetItem.getPerformerValue();
                        Object object = this.iMechanismService.postSelectVariable(mechanismVariableCode, tenantId);
                        if (Objects.isNull(object)) {
                            throw new DWBusinessException("IM\u901a\u77e5\u4eba\u673a\u5236\u53c2\u6570\u672a\u914d\u7f6e");
                        }
                        if (object instanceof String) {
                            imActivityWidgetItem.setUserId("['" + object + "']");
                        } else if (object instanceof List) {
                            List list = (List)object;
                            List collect = list.stream().map(s -> "'" + s + "'").collect(Collectors.toList());
                            imActivityWidgetItem.setUserId("[" + String.join((CharSequence)",", collect) + "]");
                        } else {
                            throw new DWBusinessException("IM\u901a\u77e5\u4eba\u673a\u5236\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
                        }
                    }
                    if (!StringUtils.isNotBlank((CharSequence)imActivityWidgetItem.getMessage())) continue;
                    imActivityWidgetItem.setMessage(this.replaceMessageVariables(imActivityWidgetItem.getMessage()));
                    if (imActivityWidgetItem.getLang() == null || !imActivityWidgetItem.getLang().containsKey("message") || imActivityWidgetItem.getLang().get("message") == null) continue;
                    for (Map.Entry entry : ((Map)imActivityWidgetItem.getLang().get("message")).entrySet()) {
                        entry.setValue(this.replaceMessageVariables((String)entry.getValue()));
                    }
                }
            }
            if (!CollectionUtils.isEmpty(preActivities)) {
                String patternString = "#(.*?)#";
                Pattern pattern = Pattern.compile(patternString);
                for (ActivityWidget activityWidgetItem : preActivities) {
                    String responseScript;
                    Matcher matcher;
                    Object resObj;
                    if (!"script".equals(activityWidgetItem.getType()) || null == (resObj = JSONPath.eval((Object)activityWidgetItem, (String)"$.config.scriptMode.responseScript")) || !(matcher = pattern.matcher(responseScript = String.valueOf(resObj))).find()) continue;
                    String placeholderText = matcher.group(0);
                    String matchedText = matcher.group(1);
                    Object value = this.iMechanismService.postSelectVariable(matchedText, tenantId);
                    if (Objects.isNull(value)) continue;
                    responseScript = responseScript.replaceAll(placeholderText, String.valueOf(value));
                    JSONPath.set((Object)activityWidgetItem, (String)"$.config.scriptMode.responseScript", (Object)responseScript);
                }
            }
        }
    }

    private String replaceMessageVariables(String msg) throws DWBusinessException {
        Pattern pattern = Pattern.compile("#\\{(.+?)}");
        Matcher matcher = pattern.matcher(msg);
        StringBuffer result = new StringBuffer();
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        while (matcher.find()) {
            String key = matcher.group(1);
            Criteria criteria = Criteria.where((String)"code").is((Object)key).and("version").is((Object)version).and("displayType").in(ALLOW_REPLACE_VARIABLE_TYPES);
            VariableDefinition variable = this.dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
            Object value = null;
            if (variable != null) {
                Query tenantQuery = new Query();
                tenantQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"variableId").is((Object)key).and("tenantId").is((Object)tenantId));
                MechanismTenantVariable tenantVariable = (MechanismTenantVariable)this.mongoTemplateUser.findOne(tenantQuery, MechanismTenantVariable.class);
                value = Optional.ofNullable(tenantVariable).map(MechanismTenantVariable::getValue).orElse(variable.getDefaultValue());
            }
            matcher.appendReplacement(result, Optional.ofNullable(value).map(String::valueOf).orElse(""));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private void replaceVariableCodeToTenantValueForLimit(MechanismLogic logic) throws Exception {
        if (!ComponentTypeEnum.MechanismLimit.name().equals(logic.getType())) {
            return;
        }
        LimitAbilityBo bo = this.kgHelpService.convert(logic.getLogic(), LimitAbilityBo.class);
        PersonnelCondition personnelCondition = bo.getPersonnelCondition();
        this.doReplaceVariableCodeToTenantValue(personnelCondition);
        if (null != bo.getStrategies()) {
            for (SingleStrategyWidget strategy : bo.getStrategies()) {
                if (null == strategy.getPersonnelCondition()) continue;
                this.doReplaceVariableCodeToTenantValue(strategy.getPersonnelCondition());
            }
        }
    }

    private void doReplaceVariableCodeToTenantValue(PersonnelCondition personnelCondition) throws Exception {
        if (null == personnelCondition) {
            return;
        }
        if (MechanismEnum.RightCondType.MECHANISM_VARIABLE.getCode().equalsIgnoreCase(personnelCondition.getRightCondType())) {
            VariableBean bean = new VariableBean();
            bean.setVariableIds(Lists.newArrayList((Object[])new String[]{personnelCondition.getToValue().toString()}));
            if (!ObjectUtils.isEmpty((Object)personnelCondition.getFromValue())) {
                bean.getVariableIds().add(personnelCondition.getFromValue().toString());
            }
            Object variableObj = this.mechanismService.postVariableListSimple(bean);
            JSONObject variableJsonObj = JSONObject.parseObject((String)JSON.toJSONString((Object)variableObj));
            if (!ObjectUtils.isEmpty((Object)personnelCondition.getFromValue())) {
                personnelCondition.setFromValue((Object)variableJsonObj.getString(personnelCondition.getFromValue().toString()));
            }
            personnelCondition.setToValue((Object)variableJsonObj.getString(personnelCondition.getToValue().toString()));
        }
    }

    private TriggerDTO getTriggerDTO(String tenantId, DriveAbilityBo bo, ScheduleApiSourceWidget scheduleSource) {
        ScheduleSourceWidget checkSource = (ScheduleSourceWidget)bo.getCheckSource();
        MonitorRule rule = checkSource.getMonitorRule();
        MechanismParameterReqDO mechanismParameterReqDO = new MechanismParameterReqDO();
        mechanismParameterReqDO.setActionId(rule.getMonitorActionId());
        mechanismParameterReqDO.setType(scheduleSource.getCheckFrequencyType());
        mechanismParameterReqDO.setTenantId(tenantId);
        String checkFrequencyVariableCode = scheduleSource.getCheckFrequencyVariableCode();
        mechanismParameterReqDO.setVariableCode(checkFrequencyVariableCode);
        TriggerDTO triggerDTO = (TriggerDTO)this.monitorRuleMechanismParameterServices.stream().filter(res -> res.accept(String.valueOf(checkFrequencyVariableCode))).findFirst().get().parse(mechanismParameterReqDO);
        return triggerDTO;
    }

    private void replaceValue(String tenantId, com.digiwin.athena.knowledgegraph.domain.MonitorRule rule, DynamicParam p, StaticParamsDO sp, List<StaticParamsDO> staticParams) {
        if ("php_api".equals(p.getConfigType()) && "task_info".equals(p.getParam_name())) {
            List<DynamicParam> taskInfos = JsonUtil.toList(p.getParam_value(), DynamicParam.class);
            taskInfos.forEach(task -> {
                StaticParamsDO newDynamicParam = new StaticParamsDO();
                if (MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue().equals(task.getConfigType())) {
                    Map map = null;
                    try {
                        map = (Map)this.mechanismService.getVariable(task.getParam_value(), tenantId);
                    }
                    catch (DWBusinessException e) {
                        throw new RuntimeException(e);
                    }
                    String value = map.get(task.getParam_value()) == null ? null : String.valueOf(map.get(task.getParam_value()));
                    List services = this.monitorRuleMechanismParameterServices.stream().filter(res -> res.accept(rule.getMonitorActionId() + "." + task.getParam_value())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(services)) {
                        Object changeValue = ((AbstractMonitorRuleMechanismParameterService)services.stream().findFirst().get()).parse(value);
                        task.setParam_value(String.valueOf(changeValue));
                    } else {
                        task.setParam_value(value);
                    }
                }
                newDynamicParam.setParam_name(task.getParam_name());
                newDynamicParam.setParam_value(task.getParam_value());
                staticParams.add(newDynamicParam);
            });
        } else {
            sp.setParam_value(p.getParam_value());
            staticParams.add(sp);
        }
    }

    public void MonitorSupportMechanismParameter(DriveAbilityBo bo, String tenantId) {
        StandardPollingRule pollingRule = (StandardPollingRule)JSONPath.eval((Object)bo, (String)"$.checkSource.monitorRule.standardPollingRule");
        if (pollingRule != null && null != pollingRule.getStartTimeType() && pollingRule.getStartTimeType().equals(VariableTypeEnum.VARIABLE_VALUE.getKey())) {
            String startVariableCode = pollingRule.getStartVariableCode();
            String variableTimeValue = this.iMechanismService.postSelectVariable(startVariableCode, tenantId).toString();
            String startTime = pollingRule.getStart_time();
            if (startTime.contains("null")) {
                int startIndex = startTime.indexOf(32) + 1;
                String timePart = startTime.substring(startIndex);
                pollingRule.setStart_time(variableTimeValue + " " + timePart);
            }
        }
    }

    @Override
    public void unApply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        log.info("\u5f00\u59cb\u5220\u9664\u673a\u5236\u80fd\u529bstartDeleteMechanismCapacity: " + JSON.toJSONString((Object)componentBO));
        String logicCode = componentBO.getLogicCode();
        String tenantId = AthenaUtils.getTenantId();
        if (null == logicCode) {
            logicCode = componentBO.getCode();
        }
        if (null == logicCode) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.componentCodeError", new Object[0]));
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)logicCode).and("tenantId").is((Object)tenantId));
        MechanismLogic logic = (MechanismLogic)this.mongoTemplateUser.findOne(query, MechanismLogic.class);
        if (null == logic || logic.getLogic() == null) {
            logic = this.getSystemLogic(logicCode);
        }
        if (null == logic || logic.getLogic() == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.componentCodeNotFound", logicCode));
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", componentBO.getType().name());
        param.put("pluginId", componentBO.getCode());
        param.put("mechanismCode", context.getMechanismCode());
        param.put("ability", logic.getLogic());
        this.dataMapService.unBindMechanismComponent(param);
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("mechanismAbilityCode").is((Object)componentBO.getCode())), MechanismApplyRecord.class);
        if (ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())) {
            DriveAbilityBo bo = this.kgHelpService.convert(logic.getLogic(), DriveAbilityBo.class);
            String monitorRuleId = logicCode + tenantId;
            String actionId = bo.getActionId();
            HashMap<String, Object> param2 = new HashMap<String, Object>();
            param2.put("tenantId", tenantId);
            param2.put("monitorRuleId", monitorRuleId);
            param2.put("actionId", actionId);
            String createMonitorRelation = "match(t:TenantEntity{tenantId:$tenantId})-[r:USE]->(m:MonitorRule{code:$monitorRuleId}) delete r";
            String createActionRelation = "match(t:TenantEntity{tenantId:$tenantId})-[r:ACTION]->(m:StartServiceComposerAction{actionId:$actionId}) delete r";
            this.kgHelpService.executeCyhper(createMonitorRelation, param2);
            this.kgHelpService.executeCyhper(createActionRelation, param2);
            String product = this.kgHelpService.getTenantProduct(monitorRuleId);
            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setConfigId(logicCode);
            config.setTenantId(tenantId);
            config.setMonitorRuleId(monitorRuleId);
            config.setProductName(product);
            config.setStatus(0);
            this.monitorRuleConfigService.delete(tenantId, monitorRuleId);
            if (bo.getNeedLightDetection() != null && bo.getNeedLightDetection().booleanValue() && bo.getCheckSource() instanceof ScheduleSourceWidget) {
                MechanismPart part = componentBO.getMechanismCapacity().getCheck();
                ScheduleSourceWidget checkSource = (ScheduleSourceWidget)bo.getCheckSource();
                MonitorRule monitorRule = checkSource.getMonitorRule();
                TaskSchedule taskSchedule = this.kgHelpService.convert(monitorRule, TaskSchedule.class);
                taskSchedule.setTenantId(AthenaUtils.getTenantId());
                taskSchedule.setMechanismLogicCode(logicCode);
                if (part instanceof CheckTaskByQuantityPart) {
                    CheckTaskByQuantityPart checkPart = (CheckTaskByQuantityPart)part;
                    String jobCode = checkPart.getCheckByQuantity().getJobCode();
                    taskSchedule.setTaskCode(jobCode);
                }
                if (part instanceof CheckTaskOnTimeOverPart && componentBO.getMechanismCapacity().getSource() instanceof SourceSchedulePart) {
                    String taskCode = ((SourceSchedulePart)componentBO.getMechanismCapacity().getSource()).getTargetSource().getTarget();
                    taskSchedule.setTaskCode(taskCode);
                }
                this.dataMapService.postDeleteTaskSchedule(taskSchedule);
            }
        }
    }

    private MechanismLogic getSystemLogic(String logicCode) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"code").is((Object)logicCode);
        Query query = Query.query((CriteriaDefinition)criteria);
        List<MechanismLogic> mechanismLogics = this.mongoTemplateSystem.find(query, MechanismLogic.class);
        return CollectionUtils.isEmpty(mechanismLogics = this.dataPickService.excludeWithSameCode(mechanismLogics, BaseEntity::getCode, HierarchicalEntity::getSourceLevel)) ? null : mechanismLogics.get(0);
    }
}

