/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.component.dao;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class TenantAppComponentListDAO {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;

    public void SaveTenantAppComponentList(TenantAppComponentListBO tenantAppComponentList) throws DWBusinessException {
        this.mongoTemplate.save((Object)tenantAppComponentList);
    }

    public TenantAppComponentListBO findTenantAppComponentList(String appCode, String tenantId) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode).and("tenantId").is((Object)tenantId));
        TenantAppComponentListBO result = (TenantAppComponentListBO)this.mongoTemplate.findOne(query, TenantAppComponentListBO.class);
        if (result != null) {
            return result;
        }
        return null;
    }

    public void removeTenantAppComponentList(String appCode, String tenantId) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode).and("tenantId").is((Object)tenantId));
        this.mongoTemplate.remove(query, TenantAppComponentListBO.class);
    }
}

