/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableRabbit
public class AthenaRabbitMQConfig {
    private static final Logger log = LoggerFactory.getLogger(AthenaRabbitMQConfig.class);
    @Value(value="${spring.rabbitmq.addresses}")
    private String addresses;

    public AthenaRabbitMQConfig() {
        System.out.println("========AthenaRabbitMQConfig init========");
    }

    @Bean(value={"kgconnectionFactory"})
    public ConnectionFactory kgconnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        RabbitProperties properties = new RabbitProperties();
        properties.setAddresses(this.addresses);
        connectionFactory.setHost(properties.determineHost());
        connectionFactory.setPort(properties.determinePort());
        connectionFactory.setUsername(properties.determineUsername());
        connectionFactory.setPassword(properties.determinePassword());
        connectionFactory.setVirtualHost(properties.determineVirtualHost());
        return connectionFactory;
    }

    @Bean(name={"kgamqpAdmin"})
    public RabbitAdmin kgamqpAdmin() {
        return new RabbitAdmin(this.kgconnectionFactory());
    }

    @Bean(name={"kgrabbitTemplate"})
    public RabbitTemplate kgrabbitTemplate(@Qualifier(value="kgconnectionFactory") ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        return rabbitTemplate;
    }

    @Bean(name={"kgrabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory kgrabbitListenerContainerFactory(@Qualifier(value="kgconnectionFactory") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        return factory;
    }
}

