/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.configuration;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.gateway.token.TokenService;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ModuleAspect {
    @Autowired
    TokenService tokenService;

    @Pointcut(value="execution(public * com.digiwin.athena.knowledgegraph.service.impl.*.*(..))")
    public void serviceImpl() {
    }

    @Pointcut(value="target(com.digiwin.athena.knowledgegraph.service.KgInnerService)")
    public void kgInnerService() {
    }

    @Around(value="kgInnerService()")
    public Object kgInnerServiceAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if (null != KgFilter.getLoginInfo()) {
            try {
                Map profile = DWServiceContext.getContext().getProfile();
                String tenantId = profile.getOrDefault("tenantId", "");
                if (tenantId.isEmpty() && !KgFilter.getLoginInfo().getToken().isEmpty()) {
                    this.tokenService.verifyIamToken(KgFilter.getLoginInfo().getToken());
                }
                KgFilter.getLoginInfo().setTenantId(DWServiceContext.getContext().getProfile().getOrDefault("tenantId", ""));
            }
            catch (Exception profile) {
                // empty catch block
            }
        }
        Object result = joinPoint.proceed();
        return result;
    }

    @Around(value="serviceImpl()")
    public Object serviceImplAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = joinPoint.proceed();
        if (null != KgFilter.getLoginInfo()) {
            try {
                Map profile = DWServiceContext.getContext().getProfile();
                String tenantId = profile.getOrDefault("tenantId", "");
                KgFilter.getLoginInfo().setTenantId(tenantId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            TranslateUtil.dealLangRecusive((Object)result, (String)AthenaUtils.getCurrentLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

