/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.controller;

import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroup;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"test"})
public class TestController {
    private static Logger logger = LoggerFactory.getLogger(TestController.class);
    @Value(value="${hello1}")
    private String hello1;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    public TestController() {
        System.out.println("TestController...........");
    }

    @PostMapping(value={"/test/jugg"})
    public String test() {
        ThreadContext.put((String)JaMDC.TraceId, (String)JaMDC.get());
        Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)"activityCode").and("version").is((Object)"activityVersion").and("tenantId").is((Object)"tenantId"));
        Activity tenantActivity = (Activity)this.mongoTemplateUser.findOne(query2, Activity.class, "activityConfigs");
        String demo = (String)this.redisTemplate.opsForValue().get((Object)"demo");
        return "ok";
    }

    @RequestMapping(value={"test01"})
    public String test01() {
        logger.info("test01.............");
        CardGroup cardGroup = new CardGroup();
        cardGroup.setTenantId("tenantTuo01");
        cardGroup.setVersion("version111");
        this.mongoTemplateUser.save((Object)cardGroup);
        return "ok";
    }

    @RequestMapping(value={"/getBigRedisKeyValue"})
    public String getBigRedisKeyValue(@RequestParam(value="pattern") String pattern) {
        try {
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            Set keys = this.redisTemplate.keys((Object)pattern);
            if (keys == null || keys.isEmpty()) {
                return "km\u76f8\u5173key\u4e3a\u7a7a";
            }
            result.put("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173key\u6570\u91cf", Integer.valueOf(keys.size()));
            logger.info("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173keys\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)JsonUtil.toJsonString(keys), (Object)keys.size());
            HashMap<String, Integer> stringKeyValueMap = new HashMap<String, Integer>();
            HashMap<String, Integer> stringKeyValueBigMap = new HashMap<String, Integer>();
            HashSet<String> errorKeys = new HashSet<String>();
            for (String key : keys) {
                try {
                    String value = (String)this.redisTemplate.opsForValue().get((Object)key);
                    int valueSize = String.valueOf(value).getBytes().length;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB <= 10) continue;
                    stringKeyValueBigMap.put(key, valueSizeKB);
                }
                catch (RedisConnectionFailureException e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
                catch (Exception e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u7684value\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        }
        catch (Exception e) {
            logger.error("getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return "getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38";
        }
    }

    @RequestMapping(value={"/getBigRedisKeyValueScan"})
    public String getBigRedisKeyValueScan(@RequestParam(value="pattern") String pattern) {
        try {
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            ScanOptions options = ScanOptions.scanOptions().match(pattern).build();
            HashSet keys = new HashSet();
            this.redisTemplate.execute(connection -> {
                try (Cursor cursor = connection.scan(options);){
                    while (cursor.hasNext()) {
                        String key = new String((byte[])cursor.next(), StandardCharsets.UTF_8);
                        DataType type = connection.type(key.getBytes());
                        if (type != DataType.STRING) continue;
                        keys.add(key);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return keys;
            });
            if (keys.isEmpty()) {
                return "km\u76f8\u5173key\u4e3a\u7a7a";
            }
            result.put("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173key\u7c7b\u578b\u4e3aString\u7684\u6570\u91cf", Integer.valueOf(keys.size()));
            logger.info("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173\u7c7b\u578b\u4e3aString\u7684keys\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)JsonUtil.toJsonString(keys), (Object)keys.size());
            HashMap<String, Integer> stringKeyValueMap = new HashMap<String, Integer>();
            HashMap<String, Integer> stringKeyValueBigMap = new HashMap<String, Integer>();
            HashSet<String> errorKeys = new HashSet<String>();
            for (String key : keys) {
                try {
                    String value = (String)this.redisTemplate.opsForValue().get((Object)key);
                    int valueSize = String.valueOf(value).getBytes().length;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB <= 10) continue;
                    stringKeyValueBigMap.put(key, valueSizeKB);
                }
                catch (RedisConnectionFailureException e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
                catch (Exception e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u7684value\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        }
        catch (Exception e) {
            logger.error("getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return "getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38";
        }
    }
}

