/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.domain.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MergeRule {
    private String type;
    private String code;
    private Boolean delete;
    private Boolean merge;
    private List<Map> mergeRules;
    private String tenantId;
    private String version;

    public static Map<String, Object> convertToMergeConfig(List<Map> mergeRules, Map<String, Object> activityConfig) {
        String mergeType;
        if (mergeRules == null || mergeRules.isEmpty()) {
            throw new IllegalArgumentException("mergeRules cannot be empty");
        }
        HashMap<String, Object> mergeConfig = new HashMap<String, Object>();
        Map sysMergeConfig = (Map)activityConfig.get("mergeConfig");
        if (CollectionUtils.isEmpty((Map)sysMergeConfig)) {
            mergeConfig.put("type", "businessFieldNONE");
            mergeConfig.put("planFields", Collections.EMPTY_LIST);
            mergeConfig.put("fields", Collections.EMPTY_LIST);
            return mergeConfig;
        }
        String variableKey = (String)sysMergeConfig.get("variableKey");
        String variableType = (String)sysMergeConfig.get("variableType");
        List fieldMeta = sysMergeConfig.get("fieldMeta") == null ? Collections.emptyList() : (List)sysMergeConfig.get("fieldMeta");
        HashSet<String> dataNames = new HashSet<String>();
        for (Map field : fieldMeta) {
            String dataName = (String)field.get("data_name");
            if (dataName == null || dataName.isEmpty()) continue;
            dataNames.add(dataName);
        }
        mergeConfig.put("variableKey", variableKey);
        mergeConfig.put("variableType", variableType);
        mergeConfig.put("fieldMeta", fieldMeta);
        Object submit = sysMergeConfig.get("submit");
        if (!ObjectUtils.isEmpty(submit)) {
            mergeConfig.put("submit", String.valueOf(submit));
        }
        Map planEndDateRule = null;
        Map businessFieldRule = null;
        Map businessTypeRule = null;
        for (Map rule : mergeRules) {
            String type = (String)rule.get("type");
            if ("planEndDate".equals(type)) {
                planEndDateRule = rule;
                continue;
            }
            if ("businessField".equals(type)) {
                businessFieldRule = rule;
                continue;
            }
            if (!"businessType".equals(type)) continue;
            businessTypeRule = rule;
        }
        if (planEndDateRule == null || businessTypeRule == null) {
            throw new IllegalArgumentException("Invalid mergeRules format");
        }
        List planFields = null;
        List<Object> fields = null;
        boolean isEnabledPlanEndDate = (Boolean)planEndDateRule.get("enabled");
        boolean isEnabledBusinessField = businessFieldRule == null ? false : (Boolean)businessFieldRule.get("enabled");
        boolean isEnabledBusinessType = (Boolean)businessTypeRule.get("enabled");
        if (!(isEnabledPlanEndDate || isEnabledBusinessField || isEnabledBusinessType)) {
            mergeType = "noPlanTime";
            planFields = new ArrayList();
            fields = new ArrayList();
        } else if (isEnabledPlanEndDate) {
            mergeType = "businessFieldNONE";
            if (isEnabledBusinessType) {
                planFields = (List)businessTypeRule.get("types");
            }
            if (isEnabledBusinessField) {
                fields = (ArrayList)businessFieldRule.get("fields");
            }
        } else if (!isEnabledPlanEndDate) {
            mergeType = "businessField";
            if (isEnabledBusinessType) {
                planFields = (List)businessTypeRule.get("types");
            }
            if (isEnabledBusinessField) {
                fields = (List)businessFieldRule.get("fields");
            }
        } else {
            throw new IllegalArgumentException("Invalid combination of mergeRules");
        }
        if (fields != null && !dataNames.isEmpty()) {
            fields = fields.stream().filter(dataNames::contains).collect(Collectors.toList());
        }
        mergeConfig.put("type", mergeType);
        if (!CollectionUtils.isEmpty(planFields)) {
            mergeConfig.put("planFields", planFields);
        }
        if (!CollectionUtils.isEmpty(fields)) {
            mergeConfig.put("fields", fields);
        }
        if (mergeType.equals("businessField") && CollectionUtils.isEmpty(planFields) && CollectionUtils.isEmpty(fields)) {
            mergeConfig.put("type", "noPlanTime");
        }
        return mergeConfig;
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public Boolean getMerge() {
        return this.merge;
    }

    public List<Map> getMergeRules() {
        return this.mergeRules;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public void setMerge(Boolean merge) {
        this.merge = merge;
    }

    public void setMergeRules(List<Map> mergeRules) {
        this.mergeRules = mergeRules;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeRule)) {
            return false;
        }
        MergeRule other = (MergeRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Boolean this$delete = this.getDelete();
        Boolean other$delete = other.getDelete();
        if (this$delete == null ? other$delete != null : !((Object)this$delete).equals(other$delete)) {
            return false;
        }
        Boolean this$merge = this.getMerge();
        Boolean other$merge = other.getMerge();
        if (this$merge == null ? other$merge != null : !((Object)this$merge).equals(other$merge)) {
            return false;
        }
        List<Map> this$mergeRules = this.getMergeRules();
        List<Map> other$mergeRules = other.getMergeRules();
        if (this$mergeRules == null ? other$mergeRules != null : !((Object)this$mergeRules).equals(other$mergeRules)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MergeRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Boolean $delete = this.getDelete();
        result = result * 59 + ($delete == null ? 43 : ((Object)$delete).hashCode());
        Boolean $merge = this.getMerge();
        result = result * 59 + ($merge == null ? 43 : ((Object)$merge).hashCode());
        List<Map> $mergeRules = this.getMergeRules();
        result = result * 59 + ($mergeRules == null ? 43 : ((Object)$mergeRules).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "MergeRule(type=" + this.getType() + ", code=" + this.getCode() + ", delete=" + this.getDelete() + ", merge=" + this.getMerge() + ", mergeRules=" + this.getMergeRules() + ", tenantId=" + this.getTenantId() + ", version=" + this.getVersion() + ")";
    }
}

