/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.enums;

import com.digiwin.athena.knowledgegraph.enums.IOption;
import com.digiwin.athena.knowledgegraph.enums.WeekDaysEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum TimeTypeEnum implements IOption<String>
{
    week("day", "03:10"){

        @Override
        public List<String> prefix() {
            return Stream.of("\u6bcf\u5468", "\u6bcf\u9031").collect(Collectors.toList());
        }

        public Integer conversion(String desc) {
            return WeekDaysEnum.byDesc(desc).getCode();
        }
    }
    ,
    day("day", "03:10"){

        @Override
        public List<String> prefix() {
            return Stream.of("\u6bcf\u5929").collect(Collectors.toList());
        }

        public String conversion(String desc) {
            return "";
        }
    }
    ,
    month("day", "03:10"){

        @Override
        public List<String> prefix() {
            return Stream.of("\u6bcf\u6708").collect(Collectors.toList());
        }

        public Integer conversion(String desc) {
            return null;
        }
    }
    ,
    hour("day", ""){

        @Override
        public List<String> prefix() {
            return Stream.of("\u5c0f\u65f6", "\u5c0f\u6642").collect(Collectors.toList());
        }

        public String conversion(String desc) {
            return "";
        }
    };

    private String interval;
    private String timeValue;
    private String timeValueFixedValue;

    private TimeTypeEnum(String interval, String timeValueFixedValue) {
        this.interval = interval;
        this.timeValueFixedValue = timeValueFixedValue;
    }

    public static TimeTypeEnum adapt(String monitorRuleValue) {
        return Arrays.stream(TimeTypeEnum.values()).filter(res -> TimeTypeEnum.extracted(monitorRuleValue, res)).findFirst().orElse(null);
    }

    private static boolean extracted(String monitorRuleValue, TimeTypeEnum res) {
        String prefixValue = res.prefix().stream().filter(prefix -> monitorRuleValue.startsWith((String)prefix)).findFirst().orElse(null);
        if (StringUtils.isNotBlank((CharSequence)prefixValue)) {
            String replace = monitorRuleValue.replace(prefixValue, "");
            Object conversion = res.conversion(replace);
            res.setTimeValue(conversion + ";");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getTimeValue() {
        return this.timeValue;
    }

    public void setTimeValue(String timeValue) {
        this.timeValue = timeValue;
    }

    @Override
    public String getValue() {
        return this.name();
    }

    public abstract List<String> prefix();

    public abstract <R> R conversion(String var1);

    public String getTimeValueFixedValue() {
        return this.timeValueFixedValue;
    }
}

