/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ActionStartTaskPart;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.activity.TaskInitiateActivityWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.ActivityPlanWidget;
import java.util.Arrays;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class ActionStartTaskPartParser
extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return "actionStartTask".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        ActionStartTaskPart startTaskPart = (ActionStartTaskPart)part;
        TaskInitiateActivityWidget activityWidget = startTaskPart.getTarget();
        SingleStrategyWidget choose = new SingleStrategyWidget();
        ActivityPlanWidget activityPlanWidget = new ActivityPlanWidget();
        activityPlanWidget.setActivityWidget(Arrays.asList(activityWidget));
        activityPlanWidget.setType("activityPlan");
        choose.setPositiveTarget((PlanWidget)activityPlanWidget);
        choose.setType("singleChoose");
        MechanismAbility logic = context.getLogic();
        if (logic instanceof DriveAbilityBo) {
            DriveAbilityBo bo = (DriveAbilityBo)logic;
            bo.setChoose(choose);
        } else if (logic instanceof ControlAbilityBO) {
            ControlAbilityBO bo = (ControlAbilityBO)logic;
            bo.setChoose(choose);
        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        ActionStartTaskPart startTaskPart = (ActionStartTaskPart)part;
        TaskInitiateActivityWidget widget = startTaskPart.getTarget();
        if (null != widget) {
            String nodeId = "widget_" + UUID.randomUUID().toString().replaceAll("-", "");
            context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{").append("code").append(":'").append(widget.getCode()).append("',").append("name").append(":'").append(widget.getName() == null ? "Widget_" + widget.getType() : widget.getName()).append("',").append("type").append(":'").append(widget.getType()).append("',").append("pluginId").append(":'").append(context.getPluginId()).append("'").append("})\r\n");
            context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
        }
    }
}

