/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ActionWarnMessagePart;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.ActivityPlanWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ActionWarnMessageParser
extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return "actionWarnMessage".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        MechanismAbility logic;
        ActionWarnMessagePart messagePart = (ActionWarnMessagePart)part;
        ArrayList<IMActivityWidget> activityWidget = new ArrayList<IMActivityWidget>();
        if ("im".equalsIgnoreCase(messagePart.getType())) {
            List imWidgets = messagePart.getImWidget();
            if (CollectionUtils.isNotEmpty((Collection)imWidgets)) {
                for (IMActivityWidget imWidget : imWidgets) {
                    if ("personInCharge".equalsIgnoreCase(imWidget.getPerformerType())) {
                        imWidget.setUserId((String)context.getNamedParams().get("im_userId"));
                        imWidget.setPerformerValue((String)context.getNamedParams().get("im_userId"));
                    } else if ("performerId".equalsIgnoreCase(imWidget.getPerformerType())) {
                        imWidget.setUserId("$(list)[*].performerId");
                        imWidget.setPerformerValue("$(performerId)");
                    } else if (!("user".equalsIgnoreCase(imWidget.getPerformerType()) || "duty".equalsIgnoreCase(imWidget.getPerformerType()) || "deptDirector".equalsIgnoreCase(imWidget.getPerformerType()) || "deptUser".equalsIgnoreCase(imWidget.getPerformerType()) || "MECHANISM_PARAMETER".equalsIgnoreCase(imWidget.getPerformerType()))) {
                        if ("businessField".equals(imWidget.getPerformerType())) {
                            imWidget.setUserId((String)context.getNamedParams().get("im_userId"));
                        } else {
                            if (!"taskExecutor".equalsIgnoreCase(imWidget.getPerformerType())) continue;
                            imWidget.setPerformerValue((String)context.getNamedParams().get("im_performerId"));
                        }
                    }
                    activityWidget.add(imWidget);
                }
            }
        } else if (!"email".equalsIgnoreCase(messagePart.getType())) {
            throw new DWBusinessException("type not support:" + part.getType());
        }
        SingleStrategyWidget choose = new SingleStrategyWidget();
        ActivityPlanWidget activityPlanWidget = new ActivityPlanWidget();
        activityPlanWidget.setActivityWidget(activityWidget);
        activityPlanWidget.setType("activityPlan");
        choose.setPositiveTarget((PlanWidget)activityPlanWidget);
        choose.setType("singleChoose");
        Object checkCondition = context.getNamedParams().get("checkCondition");
        if (null != checkCondition) {
            choose.setCondition((CheckWidget)checkCondition);
        }
        if ((logic = context.getLogic()) instanceof DriveAbilityBo) {
            DriveAbilityBo bo = (DriveAbilityBo)logic;
            bo.setChoose(choose);
        } else if (logic instanceof ControlAbilityBO) {
            ControlAbilityBO bo = (ControlAbilityBO)logic;
            bo.setChoose(choose);
        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        ActionWarnMessagePart messagePart = (ActionWarnMessagePart)part;
        if ("im".equalsIgnoreCase(messagePart.getType())) {
            List imWidgets = messagePart.getImWidget();
            if (CollectionUtils.isNotEmpty((Collection)imWidgets)) {
                for (IMActivityWidget imWidget : imWidgets) {
                    String nodeId = "widget_" + UUID.randomUUID().toString().replaceAll("-", "");
                    context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{").append("code").append(":'").append(imWidget.getCode()).append("',").append("name").append(":'").append(imWidget.getName() == null ? "Widget_" + imWidget.getType() : imWidget.getName()).append("',").append("type").append(":'").append(imWidget.getType()).append("',").append("title").append(":'").append(imWidget.getTitle()).append("',").append("message").append(":'").append(imWidget.getMessage()).append("',").append("userId").append(":'").append(imWidget.getUserId()).append("',").append("pluginId").append(":'").append(context.getPluginId()).append("'").append("})\r\n");
                    context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
                }
            }
        } else if ("email".equalsIgnoreCase(messagePart.getType())) {
            // empty if block
        }
    }
}

