/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ConditionsPart;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.ApiDataCheckCondition;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ApiDataCheckConditionParser
extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return "apiDataCheckCondition".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        ConditionsPart conditionsPart = (ConditionsPart)part;
        ApiDataCheckCondition apiDataCheckCondition = conditionsPart.getApiDataCheckCondition();
        String performerType = apiDataCheckCondition.getPerformerType();
        LimitAbilityBo logic = (LimitAbilityBo)context.getLogic();
        List<SingleStrategyWidget> strategies = ObjectUtils.isEmpty((Object)logic.getStrategies()) ? new ArrayList() : logic.getStrategies();
        SingleStrategyWidget singleStrategyWidget = new SingleStrategyWidget();
        singleStrategyWidget.setType("singleChoose");
        singleStrategyWidget.setApiDataCheckCondition(apiDataCheckCondition);
        LimitPlan limitPlan = new LimitPlan();
        if (!performerType.equals("default")) {
            limitPlan.setIsAsync(Boolean.valueOf(true));
        }
        limitPlan.setLimitType(performerType);
        limitPlan.setConditionPatch(apiDataCheckCondition.getConditionPatch());
        limitPlan.setRuleContent(apiDataCheckCondition.getTemplateRuleContent());
        singleStrategyWidget.setPositiveTarget((PlanWidget)limitPlan);
        strategies.add(singleStrategyWidget);
        logic.setStrategies(strategies);
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        ConditionsPart conditionsPart = (ConditionsPart)part;
        String code = conditionsPart.getCode();
        String nodeId = "widget_" + UUID.randomUUID().toString().replaceAll("-", "");
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{").append("code").append(":'").append(code).append("',").append("name").append(":'").append("api\u6570\u636e\u6821\u9a8c").append("',").append("type").append(":'").append("apiDataCheckCondition").append("',").append("pluginId").append(":'").append(context.getPluginId()).append("'").append("})\r\n");
        context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
    }
}

