/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskAccordingToStandardPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskOnTimeOverPart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.check.CheckAccordingToStandard;
import com.digiwin.athena.mechanism.widgets.check.CheckCompleteParam;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CheckTaskAccordingToStandardParser
extends AbstractMechanismPartParser {
    private static final Logger log = LoggerFactory.getLogger(CheckTaskAccordingToStandardParser.class);
    @Autowired
    TaskService taskService;
    @Autowired
    ActionService actionService;
    @Autowired
    ActionMetadataManager actionMetadataManager;

    @Override
    public boolean accept(MechanismPart part) {
        return "byStandard".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        String checkJob;
        CheckTaskAccordingToStandardPart checkPart = (CheckTaskAccordingToStandardPart)part;
        DriveAbilityBo logic = (DriveAbilityBo)context.getLogic();
        ScheduleSourceWidget checkSource = (ScheduleSourceWidget)logic.getCheckSource();
        MonitorRule rule = checkSource.getMonitorRule();
        if (null == rule.getStaticParams()) {
            rule.setStaticParams(new ArrayList());
        }
        if (null == logic.getPreActivities()) {
            logic.setPreActivities(new ArrayList());
        }
        if (StringUtils.isEmpty((Object)(checkJob = checkPart.getCheckAccordingToStandard().getCheckJob()))) {
            throw new DWBusinessException("checkJob is required by CheckTaskAccordingToStandardPart");
        }
        if ("reportForWorkOnTime".equalsIgnoreCase(checkJob)) {
            if (null == checkPart.getCheckAccordingToStandard() || StringUtils.isEmpty((Object)checkPart.getCheckAccordingToStandard().getCheckField()) || StringUtils.isEmpty((Object)checkPart.getCheckAccordingToStandard().getCheckDataSource())) {
                throw new DWBusinessException("checkField is required by CheckTaskAccordingToStandardPart");
            }
            String checkAccordingToStandardStr = JSON.toJSONString((Object)checkPart.getCheckAccordingToStandard());
            String reportEoc = checkPart.getCheckAccordingToStandard().getEocPath();
            rule.setMonitorActionId("mechanism_CheckTaskByStandardAction");
            SourceWidget targetSource = context.getTargetSource();
            DynamicParam param1 = new DynamicParam();
            param1.setParam_name("taskDefCode");
            param1.setParam_value(targetSource.getTarget());
            rule.getStaticParams().add(param1);
            DynamicParam param2 = new DynamicParam();
            param2.setParam_name("closed");
            param2.setParam_value("false");
            rule.getStaticParams().add(param2);
            ActivityWidget activityWidget1 = new ActivityWidget();
            activityWidget1.setType("script");
            activityWidget1.setConfig(new HashMap());
            activityWidget1.getConfig().put("executionMode", "script");
            HashMap<String, String> scriptMode = new HashMap<String, String>();
            scriptMode.put("requestScript", "");
            String responseScript = "var data = $(data); var processData = data[0]['data']; return {processVariable: { list: processData} }";
            scriptMode.put("responseScript", responseScript);
            activityWidget1.getConfig().put("scriptMode", scriptMode);
            activityWidget1.setName("\u8fd4\u56de\u6240\u6709\u8fdb\u884c\u4e2d\u7684\u5305\u542b\u6d41\u7a0b\u53d8\u91cf\u4efb\u52a1");
            logic.getPreActivities().add(activityWidget1);
            checkPart.setActivityWidget0(activityWidget1);
            ActivityWidget activityWidget2 = new ActivityWidget();
            activityWidget2.setType("http");
            activityWidget2.setConfig(new HashMap());
            activityWidget2.getConfig().put("executionMode", "script");
            activityWidget2.getConfig().put("method", "post");
            activityWidget2.getConfig().put("domain", "thememap");
            activityWidget2.getConfig().put("contentType", "json");
            activityWidget2.getConfig().put("url", "/restful/service/knowledgegraph/mechanismEnhancement/taskBizData");
            String kgRequestScript = "var request = { \"taskId\": \"#taskId#\", \"taskList\": $(list), \"checkDataSource\": \"#checkDataSource#\", \"tenantId\": \"$(tenantId)\", \"checkAccordingToStandard\": #checkAccordingToStandard#}; return request;";
            kgRequestScript = kgRequestScript.replace("#taskId#", targetSource.getTarget());
            String checkDataSource = checkPart.getCheckAccordingToStandard().getCheckDataSource();
            kgRequestScript = kgRequestScript.replace("#checkDataSource#", checkDataSource);
            kgRequestScript = kgRequestScript.replace("#checkAccordingToStandard#", checkAccordingToStandardStr);
            String kgResponseScript = "var data = $(response); var processData = data['response']['data']; return {processVariable: { bizData: processData} }";
            HashMap<String, String> scriptMode2 = new HashMap<String, String>();
            scriptMode2.put("requestScript", kgRequestScript);
            scriptMode2.put("responseScript", kgResponseScript);
            activityWidget2.getConfig().put("scriptMode", scriptMode2);
            activityWidget2.setName("\u8fd4\u56de\u5305\u542b\u4e1a\u52a1\u6570\u636e\u7684\u4efb\u52a1");
            logic.getPreActivities().add(activityWidget2);
            checkPart.setActivityWidget1(activityWidget2);
            ActivityWidget activityWidget3 = new ActivityWidget();
            activityWidget3.setType("http");
            activityWidget3.setConfig(new HashMap());
            activityWidget3.getConfig().put("executionMode", "script");
            activityWidget3.getConfig().put("method", "post");
            activityWidget3.getConfig().put("domain", "thememap");
            activityWidget3.getConfig().put("contentType", "json");
            activityWidget3.getConfig().put("url", "/restful/service/knowledgegraph/mechanismEnhancement/taskInformPersonByEoc");
            String kgGetUserRequestScript = "var request = { \"taskCode\": \"#taskCode#\", \"taskList\": $(bizData), \"checkDataSource\": \"#checkDataSource#\", \"tenantId\": \"$(tenantId)\",\"eocField\": \"#eocField#\"}; return request;";
            kgGetUserRequestScript = kgGetUserRequestScript.replace("#taskCode#", targetSource.getTarget());
            kgGetUserRequestScript = kgGetUserRequestScript.replace("#checkDataSource#", checkDataSource);
            String eocField = reportEoc;
            kgGetUserRequestScript = !StringUtils.isEmpty((Object)eocField) ? kgGetUserRequestScript.replace("#eocField#", eocField) : kgGetUserRequestScript.replace("#eocField#", "");
            String kgGetUserResponseScript = "var data = $(response); var informPersons = data['response']['data']; return { processVariable: { informPersons: informPersons} }";
            HashMap<String, String> scriptMode3 = new HashMap<String, String>();
            scriptMode3.put("requestScript", kgGetUserRequestScript);
            scriptMode3.put("responseScript", kgGetUserResponseScript);
            activityWidget3.getConfig().put("scriptMode", scriptMode3);
            activityWidget3.setName("\u4ece\u4e1a\u52a1\u6570\u636e\u4e2d\u53d6\u51faeoc\u8f6c\u4e3auserId");
            logic.getPreActivities().add(activityWidget3);
            checkPart.setActivityWidget2(activityWidget3);
            context.getNamedParams().put("im_userId", "$(informPersons)");
        } else if ("reportForWorkOnApi".equalsIgnoreCase(checkJob)) {
            String dataName;
            GetActionLocaleResponseDTO getActionLocaleResponseDTO;
            if (null == checkPart.getCheckAccordingToStandard()) {
                throw new DWBusinessException("CheckTaskAccordingToStandard is required");
            }
            CheckAccordingToStandard checkAccordingToStandard = checkPart.getCheckAccordingToStandard();
            String actionId = checkAccordingToStandard.getObjectApiActionId();
            rule.setMonitorActionId(checkAccordingToStandard.getObjectApiActionId());
            try {
                EspActionMetadataDTO responseDTO = this.actionMetadataManager.getActionMetadata(actionId, "SYSTEM", "1.0");
                getActionLocaleResponseDTO = (GetActionLocaleResponseDTO)JSON.parseObject((String)JSON.toJSONString((Object)responseDTO), GetActionLocaleResponseDTO.class);
                dataName = getActionLocaleResponseDTO.getResponse().getData().getData_name();
            }
            catch (Exception e) {
                throw new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionId));
            }
            if (StringUtils.isEmpty((Object)dataName)) {
                throw new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionResponseDataNameNotFound", actionId));
            }
            if (null != getActionLocaleResponseDTO) {
                List groups = checkAccordingToStandard.getBusinessCondition().getGroups();
                if (!CollectionUtils.isEmpty((Collection)groups)) {
                    groups.forEach(mechanismConditionGroup -> {
                        List conditions = mechanismConditionGroup.getConditions();
                        if (!CollectionUtils.isEmpty((Collection)conditions)) {
                            DynamicParam dynamicParam = new DynamicParam();
                            dynamicParam.setParam_name("task_info");
                            dynamicParam.setConfigType("php_api");
                            ArrayList taskInfo = new ArrayList();
                            conditions.forEach(mechanismConditionConfig -> {
                                MechanismVariable to = mechanismConditionConfig.getRight().getTo();
                                DynamicParam param = new DynamicParam();
                                param.setParam_name(to.getConfigItem());
                                param.setConfigType(to.getConfigType());
                                param.setParam_value(String.valueOf(to.getValue()));
                                taskInfo.add(param);
                            });
                            dynamicParam.setParam_value(JsonUtil.toJsonString(taskInfo));
                            rule.getStaticParams().add(dynamicParam);
                        }
                    });
                }
                ActivityWidget activityWidget1 = new ActivityWidget();
                activityWidget1.setType("script");
                activityWidget1.setConfig(new HashMap());
                activityWidget1.getConfig().put("executionMode", "script");
                HashMap<String, String> scriptMode = new HashMap<String, String>();
                scriptMode.put("requestScript", "");
                String responseScript = "var data = $(data);var taskInfo = data[0]['" + dataName + "']; return {processVariable: { taskBizData: taskInfo} }";
                scriptMode.put("responseScript", responseScript);
                activityWidget1.getConfig().put("scriptMode", scriptMode);
                activityWidget1.setName(getActionLocaleResponseDTO.getName());
                logic.getPreActivities().add(activityWidget1);
                checkPart.setActivityWidget0(activityWidget1);
            }
        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        CheckTaskOnTimeOverPart checkPart = (CheckTaskOnTimeOverPart)part;
        CheckCompleteParam widget = checkPart.getCheckComplete();
        ActivityWidget activityWidget0 = checkPart.getActivityWidget0();
        ActivityWidget activityWidget1 = checkPart.getActivityWidget1();
        if (null != activityWidget0) {
            super.generateCypherActivity(context, activityWidget0, parentNode);
        }
        if (null != activityWidget1) {
            super.generateCypherActivity(context, activityWidget1, parentNode);
        }
    }
}

