/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskByQuantityPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskOnTimeOverPart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.check.CheckByQuantity;
import com.digiwin.athena.mechanism.widgets.check.CheckCompleteParam;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CheckTaskByQuantityParser
extends AbstractMechanismPartParser {
    private static final Logger log = LoggerFactory.getLogger(CheckTaskByQuantityParser.class);
    @Autowired
    TaskService taskService;
    @Autowired
    ActionService actionService;
    @Autowired
    DataMapService dataMapService;

    @Override
    public boolean accept(MechanismPart part) {
        return "byQuantity".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        CheckTaskByQuantityPart checkPart = (CheckTaskByQuantityPart)part;
        DriveAbilityBo logic = (DriveAbilityBo)context.getLogic();
        ScheduleSourceWidget checkSource = (ScheduleSourceWidget)logic.getCheckSource();
        MonitorRule rule = checkSource.getMonitorRule();
        if (null == rule.getStaticParams()) {
            rule.setStaticParams(new ArrayList());
        }
        if (null == logic.getPreActivities()) {
            logic.setPreActivities(new ArrayList());
        }
        if (null == checkPart.getCheckByQuantity()) {
            throw new DWBusinessException("checkField is required by CheckTaskByQuantityPart");
        }
        String checkType = checkPart.getCheckByQuantity().getObjectType();
        String jobCode = checkPart.getCheckByQuantity().getJobCode();
        CheckByQuantity checkByQuantity = checkPart.getCheckByQuantity();
        if (StringUtils.isEmpty((Object)checkType)) {
            throw new DWBusinessException("checkType is required by CheckTaskByQuantityPart");
        }
        if ("1".equals(checkType)) {
            if (StringUtils.isEmpty((Object)jobCode)) {
                throw new DWBusinessException("jobCode is required by CheckTaskByQuantityPart");
            }
            this.generateActivityWidget(jobCode, checkByQuantity, rule, logic, checkPart, checkPart.getCheckByQuantity().getFullPath());
            Task task = new Task();
            task.setCode(jobCode);
            task.setNeedScheduledTaskDetail(Boolean.TRUE);
            task.setNeedLightDetection(Boolean.TRUE);
            task.setVersion(context.getTenantVersion());
            this.dataMapService.updateTaskScheduleFlag(task);
            logic.setNeedLightDetection(Boolean.TRUE);
            logic.setProjectCode(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        }
        if ("3".equals(checkType)) {
            if (StringUtils.isEmpty((Object)jobCode)) {
                throw new DWBusinessException("jobCode is required by CheckTaskByQuantityPart");
            }
            this.generateActivityWidget(jobCode, checkByQuantity, rule, logic, checkPart, "data");
        }
    }

    private void generateActivityWidget(String jobCode, CheckByQuantity checkByQuantity, MonitorRule rule, DriveAbilityBo logic, CheckTaskByQuantityPart checkPart, String dataName) throws DWBusinessException {
        String businessConditionStr = JSON.toJSONString((Object)checkByQuantity.getBusinessCondition());
        String quantityConditionStr = JSON.toJSONString((Object)checkByQuantity.getQuantityCondition());
        rule.setMonitorActionId("mechanism_CheckTaskByQuantityOfBaseDataAction");
        DynamicParam param1 = new DynamicParam();
        param1.setParam_name("code");
        param1.setParam_value(jobCode);
        rule.getStaticParams().add(param1);
        ActivityWidget activityWidget1 = new ActivityWidget();
        activityWidget1.setType("script");
        activityWidget1.setConfig(new HashMap());
        activityWidget1.getConfig().put("executionMode", "script");
        HashMap<String, String> scriptMode = new HashMap<String, String>();
        scriptMode.put("requestScript", "");
        String responseScript = "var data = $(data); var processData = data[0]['" + dataName + "']; return {processVariable: { dataList: processData} }";
        scriptMode.put("responseScript", responseScript);
        activityWidget1.getConfig().put("scriptMode", scriptMode);
        activityWidget1.setName("\u8fd4\u56de\u6240\u6709\u8fdb\u884c\u4e2d\u7684\u5305\u542b\u6d41\u7a0b\u53d8\u91cf\u4efb\u52a1");
        logic.getPreActivities().add(activityWidget1);
        checkPart.setActivityWidget0(activityWidget1);
        ActivityWidget activityWidget2 = new ActivityWidget();
        activityWidget2.setType("http");
        activityWidget2.setConfig(new HashMap());
        activityWidget2.getConfig().put("executionMode", "script");
        activityWidget2.getConfig().put("method", "post");
        activityWidget2.getConfig().put("domain", "thememap");
        activityWidget2.getConfig().put("contentType", "json");
        activityWidget2.getConfig().put("url", "/restful/service/knowledgegraph/mechanismEnhancement/filterByQuantity");
        String kgRequestScript = "var request = { \"dataList\": $(dataList), \"businessCondition\": #businessCondition#, \"quantityCondition\": #quantityCondition#}; return request;";
        kgRequestScript = kgRequestScript.replace("#businessCondition#", businessConditionStr);
        kgRequestScript = kgRequestScript.replace("#quantityCondition#", quantityConditionStr);
        String kgResponseScript = "var data = $(response); var processData = data['response']; return {processVariable: { taskBizData: processData, list : processData} }";
        HashMap<String, String> scriptMode2 = new HashMap<String, String>();
        scriptMode2.put("requestScript", kgRequestScript);
        scriptMode2.put("responseScript", kgResponseScript);
        activityWidget2.getConfig().put("scriptMode", scriptMode2);
        activityWidget2.setName("\u8fd4\u56de\u5305\u542b\u4e1a\u52a1\u6570\u636e\u7684\u4efb\u52a1");
        logic.getPreActivities().add(activityWidget2);
        checkPart.setActivityWidget1(activityWidget2);
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        CheckTaskOnTimeOverPart checkPart = (CheckTaskOnTimeOverPart)part;
        CheckCompleteParam widget = checkPart.getCheckComplete();
        ActivityWidget activityWidget0 = checkPart.getActivityWidget0();
        ActivityWidget activityWidget1 = checkPart.getActivityWidget1();
        if (null != activityWidget0) {
            super.generateCypherActivity(context, activityWidget0, parentNode);
        }
        if (null != activityWidget1) {
            super.generateCypherActivity(context, activityWidget1, parentNode);
        }
    }
}

