/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.ConditionsPart;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.PersonnelCondition;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.config.RuleTrigger;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PersonnelConditionParser
extends AbstractMechanismPartParser {
    private static final Logger log = LoggerFactory.getLogger(PersonnelConditionParser.class);
    @Autowired
    IMechanismService mechanismService;

    @Override
    public boolean accept(MechanismPart part) {
        return "personnelCondition".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        ConditionsPart conditionsPart = (ConditionsPart)part;
        PersonnelCondition personnelCondition = conditionsPart.getPersonnelCondition();
        this.handlePersonnelCondition(context, personnelCondition);
        String performerType = personnelCondition.getPerformerType();
        LimitAbilityBo logic = (LimitAbilityBo)context.getLogic();
        List<SingleStrategyWidget> strategies = ObjectUtils.isEmpty((Object)logic.getStrategies()) ? new ArrayList() : logic.getStrategies();
        SingleStrategyWidget singleStrategyWidget = new SingleStrategyWidget();
        singleStrategyWidget.setType("singleChoose");
        singleStrategyWidget.setPersonnelCondition(personnelCondition);
        LimitPlan limitPlan = new LimitPlan();
        limitPlan.setLimitType(performerType);
        limitPlan.setConditionPatch(personnelCondition.getConditionPatch());
        limitPlan.setConditionType("personnelCondition");
        this.parseReminder(context, performerType, limitPlan);
        singleStrategyWidget.setPositiveTarget((PlanWidget)limitPlan);
        strategies.add(singleStrategyWidget);
        logic.setStrategies(strategies);
        if (null != logic) {
            logic.setPersonnelCondition(personnelCondition);
        }
    }

    private void handlePersonnelCondition(MechanismParseContext context, PersonnelCondition personnelCondition) {
        String performerType = personnelCondition.getPerformerType();
        if ("proficiency".equalsIgnoreCase(performerType)) {
            String type = context.getTargetSource().getType();
            String workType = "";
            if ("dataEntrySource".equalsIgnoreCase(type)) {
                workType = "BASE-DATA";
            } else if ("taskSource".equalsIgnoreCase(type)) {
                workType = "TASK";
            } else if ("projectSource".equalsIgnoreCase(type)) {
                workType = "START-PROJECT";
            }
            personnelCondition.setWorkCode(context.getTargetSource().getTarget());
            personnelCondition.setWorkType(workType);
        }
    }

    public void parseReminder(MechanismParseContext context, String performerType, LimitPlan limitPlan) {
        RuleContent ruleContent = new RuleContent();
        RuleTrigger ruleTrigger = new RuleTrigger();
        ruleTrigger.setType("async");
        switch (performerType) {
            case "duty": 
            case "staff": {
                ruleTrigger.setApiUrl("/api/eoc/v2/duty/list?pageSize=99999");
                ruleTrigger.setApiPrefixType("eocUrl");
                ruleTrigger.setMethod("GET");
                ruleTrigger.setApiMethodType("get");
                limitPlan.setIsAsync(Boolean.valueOf(true));
                break;
            }
            case "proficiency": {
                String type = context.getTargetSource().getType();
                String workType = "";
                if ("dataEntrySource".equalsIgnoreCase(type)) {
                    workType = "BASE-DATA";
                } else if ("taskSource".equalsIgnoreCase(type)) {
                    workType = "TASK";
                } else if ("projectSource".equalsIgnoreCase(type)) {
                    workType = "START-PROJECT";
                }
                String operations = "OPEN";
                ruleTrigger.setApiUrl("/api/v1/user/track/search");
                ruleTrigger.setApiPrefixType("audcUrl");
                ruleTrigger.setApiMethodType("post");
                ruleTrigger.setMethod("POST");
                ruleTrigger.setParameterScript("const {userId, tenantId} = JSON.parse(sessionStorage.getItem('DwUserInfo'));return {'workType':'" + workType + "','workCode':'" + context.getTargetSource().getTarget() + "', 'operations':['" + operations + "'],'userId':userId,'tenantId':tenantId}");
                limitPlan.setIsAsync(Boolean.valueOf(true));
            }
        }
        ruleContent.setTrigger(ruleTrigger);
        limitPlan.setRuleContent(ruleContent);
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        ConditionsPart conditionsPart = (ConditionsPart)part;
        String code = conditionsPart.getCode();
        String nodeId = "widget_" + UUID.randomUUID().toString().replaceAll("-", "");
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismWidget:MechanismComponent{").append("code").append(":'").append(code).append("',").append("name").append(":'").append("\u4eba\u5458\u6761\u4ef6").append("',").append("type").append(":'").append("personnelCondition").append("',").append("pluginId").append(":'").append(context.getPluginId()).append("'").append("})\r\n");
        context.getCypherSb().append("create(").append(parentNode).append(")-[:WIDGET]->(").append(nodeId).append(")\r\n");
    }
}

