/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.product;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.product.model.ProductTenantConfigDO;
import com.digiwin.athena.knowledgegraph.product.model.ProductTypeEnum;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ProductTenantConfigManager {
    private static final String PRODUCT_CONFIG_COLLECTION_NAME = "productTenantConfig";
    private static final String PRODUCT_CONFIG_INDEX_NAME = "idx_ProductTenantConfig";
    public static final String TENANT_ID_FIELD = "tenantId";
    public static final String PRODUCT_NAME_FIELD = "productName";
    public static final String TYPE_FIELD = "type";

    public ProductTenantConfigDO readTenantConfig(String tenantId, String productName, ProductTypeEnum type) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, PRODUCT_NAME_FIELD);
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)PRODUCT_NAME_FIELD, (Object)productName), Filters.eq((String)TENANT_ID_FIELD, (Object)tenantId)})).first();
        if (doc != null) {
            ProductTenantConfigDO tenantConfigDO = (ProductTenantConfigDO)JSON.parseObject((String)doc.toJson(), ProductTenantConfigDO.class);
            return tenantConfigDO;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.productNotFound", tenantId, productName));
    }

    public ProductTenantConfigDO readTenantConfig(String tenantId, ProductTypeEnum type) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, PRODUCT_NAME_FIELD);
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)TYPE_FIELD, (Object)type.toString()), Filters.eq((String)TENANT_ID_FIELD, (Object)tenantId)})).first();
        if (doc != null) {
            ProductTenantConfigDO tenantConfigDO = (ProductTenantConfigDO)JSON.parseObject((String)doc.toJson(), ProductTenantConfigDO.class);
            return tenantConfigDO;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.productNotFound2", tenantId));
    }
}

