/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.rule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.domain.OperationUnitV2;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.kg.monitorRule.MonitorNoticeVO;
import com.digiwin.athena.kg.monitorRule.MonitorRuleDynamicParam;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleSyncRecord;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kg.monitorRule.product.FieldMappingConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.TenantDynamicConditionDO;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.povo.productOperation.OrgTypeCompany;
import com.digiwin.athena.kmservice.povo.productOperation.OrgTypeSite;
import com.digiwin.athena.kmservice.povo.productOperation.ProdEocMapping;
import com.digiwin.athena.kmservice.povo.productOperation.ProductOperationResult;
import com.digiwin.athena.kmservice.utils.EocUtils;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.rule.MonitorRuleConfig;
import com.digiwin.athena.knowledgegraph.mq.RabbitMQManager;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.service.IMonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.OperationUnitService;
import com.digiwin.athena.knowledgegraph.service.impl.ConfigChangeTypeEnum;
import com.digiwin.athena.knowledgegraph.service.impl.KgProductService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleSyncResult;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.MonitorRuleUtil;
import com.digiwin.athena.knowledgegraph.vo.MonitorEocChangeVO;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@MyExceptionHandler
@Service
public class MonitorRuleConfigService
implements IMonitorRuleConfigService {
    private static String monitorRuleConfigColName = "monitorRuleTenantConfig";
    private static String monitorRuleConfigKeyName = "configId";
    private static Log log = LogFactory.getLog(MonitorRuleConfigService.class);
    @Value(value="${monitorRuleConfigQueueName}")
    private String rabbitQueueName = "MonitorRuleConfigQueue";
    @Value(value="${monitorRuleConfigRoutingKey}")
    private String rabbitRoutingKey = "MonitorRuleConfig";
    @Value(value="${monitorCrossLevelRoutingKey}")
    private String monitorCrossLevelRoutingKey = "routingKey.monitor.crossLevel";
    @Value(value="${monitorRuleConfigCDCRoutingKey}")
    private String monitorRuleConfigCDCRoutingKey;
    @Value(value="${monitorRuleConfigCDCQueueName}")
    private String monitorRuleConfigCDCQueueName;
    @Value(value="${monitorCrossLevelCDCRoutingKey}")
    private String monitorCrossLevelCDCRoutingKey;
    @Value(value="${monitorCrossLevelCDCQueueName}")
    private String monitorCrossLevelCDCQueueName;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    private MonitorRuleRepository monitorRuleRepository;
    @Autowired
    private OperationUnitService operationUnitService;
    @Autowired
    TenantService tenantService;
    @Autowired
    private ProductNameResolver productNameResolver;
    @Autowired
    private MonitorRuleManager monitorRuleManager;
    @Autowired
    private KgProductService productService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private ESPUtils espUtils;
    @Autowired
    private EocService eocService;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    EocUtils eocUtils;
    @Autowired
    IAMUtils iamUtils;

    private void sendMessage(String tenantId, String ruleId, EocMapDTO eocMap, ConfigChangeTypeEnum changeType) throws Exception {
        this.sendMessage(tenantId, ruleId, eocMap, changeType, null, null, null, null);
    }

    private void sendMessage(String tenantId, String ruleId, ConfigChangeTypeEnum changeType) throws Exception {
        this.sendMessage(tenantId, ruleId, null, changeType, null, null, null, null);
    }

    private String sendMessage(String tenantId, String ruleId, EocMapDTO eocMap, ConfigChangeTypeEnum changeType, Boolean enableStatus, String sendWay, String transactionId) throws Exception {
        return this.sendMessage(tenantId, ruleId, eocMap, changeType, enableStatus, null, sendWay, transactionId);
    }

    public String sendMessage(String tenantId, String ruleId, EocMapDTO eocMap, ConfigChangeTypeEnum changeType, Boolean enableStatus, String backtrackDate, String sendWay, String transactionId) throws Exception {
        RabbitMQManager mqManager = RabbitMQManager.getRabbitMQManager();
        String strEnable = "";
        if (enableStatus != null) {
            strEnable = enableStatus != false ? ",\"enableStatus\":\"Y\"" : ",\"enableStatus\":\"N\"";
        }
        String strBacktrackDate = "";
        if (StringUtils.isNotEmpty((CharSequence)backtrackDate)) {
            strBacktrackDate = String.format(",\"backtrackDate\":\"%s\"", backtrackDate);
        }
        String curTransationId = "";
        if (StringUtils.isNotEmpty((CharSequence)transactionId)) {
            curTransationId = String.format(",\"transactionId\":\"%s\"", transactionId);
        }
        String msg = String.format("{\"tenantId\":\"%s\",\"ruleId\":\"%s\",\"changeType\":\"%s\",\"eocMap\":%s%s%s%s}", new Object[]{tenantId, ruleId, changeType, eocMap != null ? JSONObject.toJSONString((Object)eocMap) : "{}", strEnable, strBacktrackDate, curTransationId});
        log.info((Object)("sendMsg:" + msg));
        if (StringUtils.equalsIgnoreCase((CharSequence)"HTTP", (CharSequence)sendWay)) {
            return msg;
        }
        if (mqManager.getEnabled()) {
            try {
                String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                MonitorRule monitorRule = this.monitorRuleManager.queryMonitorRule(ruleId, tenantId, tenantVersion);
                String category = monitorRule.getCategory();
                log.info((Object)("RabbitMQ message begin\uff0cruleId:" + ruleId + ",tenantId:" + tenantId + ",category:" + category));
                boolean sendSuccess = MonitorRuleUtil.Category.CATEGORYS.contains(category) ? mqManager.PublishMessage(msg, this.monitorRuleConfigCDCQueueName, this.monitorRuleConfigCDCRoutingKey) : mqManager.PublishMessage(msg, this.rabbitQueueName, this.rabbitRoutingKey);
                if (!sendSuccess) {
                    log.info((Object)"RabbitMQ message not send");
                    return null;
                }
                return msg;
            }
            catch (Exception e) {
                if (Objects.equals(changeType.toString(), ConfigChangeTypeEnum.DELETED.toString())) {
                    boolean sendSuccessCdc = mqManager.PublishMessage(msg, this.monitorRuleConfigCDCQueueName, this.monitorRuleConfigCDCRoutingKey);
                    boolean sendSuccessNotCdc = mqManager.PublishMessage(msg, this.rabbitQueueName, this.rabbitRoutingKey);
                    log.info((Object)("RabbitMQ message send sendSuccessCdc :" + sendSuccessCdc + ",sendSuccessNotCdc:" + sendSuccessNotCdc));
                    if (!sendSuccessCdc || !sendSuccessNotCdc) {
                        log.info((Object)"RabbitMQ message not send");
                        return null;
                    }
                    return msg;
                }
                log.info((Object)"RabbitMQ message was sent failed");
                throw new DWBusinessException(e.getLocalizedMessage());
            }
        }
        return null;
    }

    private void sendMessage(String message, String rabbitRoutingKey) throws Exception {
        RabbitMQManager mqManager = RabbitMQManager.getRabbitMQManager();
        if (mqManager.getEnabled()) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)message);
                String tenantId = (String)jsonObject.get((Object)"tenantId");
                String ruleId = (String)jsonObject.get((Object)"ruleId");
                String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                MonitorRule monitorRule = this.monitorRuleManager.queryMonitorRule(ruleId, tenantId, tenantVersion);
                String category = monitorRule.getCategory();
                log.info((Object)("RabbitMQ message begin\uff0cruleId:" + ruleId + ",tenantId:" + tenantId + ",tenantId:" + category));
                if (Objects.equals(category, MonitorRuleCategoryEnum.CDC.toString())) {
                    rabbitRoutingKey = this.monitorCrossLevelCDCRoutingKey;
                }
                log.info((Object)("rabbitRoutingKey:" + rabbitRoutingKey));
                boolean sendSuccess = mqManager.PublishMessage(message, rabbitRoutingKey);
                if (!sendSuccess) {
                    log.info((Object)("RabbitMQ message was sent failed, msg:{}" + message));
                }
            }
            catch (Exception e) {
                log.info((Object)("RabbitMQ message was sent failed, msg:{}" + message));
                throw new DWBusinessException(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public Object put(MonitorRuleConfigDTO config) throws Exception {
        String configId = config.getConfigId();
        if (configId == null || configId.isEmpty()) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.configIdEmpty", new Object[0]));
        }
        String tenantId = config.getTenantId();
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.tenantIdEmpty", new Object[0]));
        }
        String ruleId = config.getMonitorRuleId();
        if (ruleId == null || ruleId.isEmpty()) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.ruleIdEmpty", new Object[0]));
        }
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put(monitorRuleConfigKeyName, config.getConfigId());
        configMap.put("tenantId", tenantId);
        configMap.put("monitorRuleId", ruleId);
        configMap.put("productName", config.getProductName());
        if (config.getStatus() != null) {
            configMap.put("status", config.getStatus());
        } else {
            configMap.put("status", 1);
        }
        if (config.getEocMap() != null) {
            configMap.put("eocMap", config.getEocMap());
        }
        if (config.getStandardPollingRule() != null) {
            configMap.put("standardPollingRule", config.getStandardPollingRule());
        }
        if (config.getStandardPollingRules() != null) {
            configMap.put("standardPollingRules", config.getStandardPollingRules());
        }
        try {
            this.mongoTemplate.insert(configMap, monitorRuleConfigColName);
            this.sendMessage(tenantId, ruleId, config.getEocMap(), ConfigChangeTypeEnum.CREATED, null, config.getBacktrackDate(), "MQ", UUID.randomUUID().toString());
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object delete(String tenantId, String ruleId) throws Exception {
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)tenantId);
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{criteria1, criteria2}));
        try {
            this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);
            this.sendMessage(tenantId, ruleId, ConfigChangeTypeEnum.DELETED);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    private Document get(String configId) throws Exception {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(monitorRuleConfigColName, monitorRuleConfigKeyName);
        Document doc = (Document)col.find(Filters.eq((String)"configId", (Object)configId)).first();
        return doc;
    }

    public void saveTenantMonitorRule(MonitorRuleConfigDTO config) throws Exception {
        try {
            HashMap<String, String> profile = new HashMap<String, String>();
            profile.put("tenantId", config.getTenantId());
            DWServiceContext.getContext().setProfile(profile);
            List productNames = this.productNameResolver.getCloudProductNamesAfterEocSet(config.getTenantId());
            if (!CollectionUtils.isEmpty((Collection)productNames) && (productNames.contains("E10") || productNames.contains("e10"))) {
                this.post(config);
            }
        }
        catch (Exception e) {
            log.error((Object)"call saveTenantMonitorRule error : {}", (Throwable)e);
        }
    }

    @Override
    public Object post(MonitorRuleConfigDTO config) throws Exception {
        String tenantId = StringUtils.isNotEmpty((CharSequence)config.getTenantId()) ? config.getTenantId() : AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String isEocChange = this.checkIsEocChange(config);
        log.info((Object)("isEocChange:" + isEocChange));
        MonitorRule monitorRule = this.monitorRuleManager.queryMonitorRule(config.getMonitorRuleId(), tenantId, tenantVersion);
        if (StringUtils.isNotEmpty((CharSequence)isEocChange)) {
            String curTransactionId = UUID.randomUUID().toString();
            String o = this.handleCropToEoc(config, curTransactionId, isEocChange);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("transactionId", curTransactionId);
            result.put("sendMessage", o);
            result.put("isCropToEoc", "Y");
            result.put("category", monitorRule.getCategory());
            return result;
        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)config.getTenantId());
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria2});
        EocMapDTO eocMap = config.getEocMap();
        if (eocMap != null) {
            boolean check = this.validateEocLevel(config.getMonitorRuleId(), config.getProductName(), eocMap);
            if (!check) {
                throw new DWBusinessException("P.KG.500.0031", I18nUtils.getValue("knowledgegraph.ruleError", new Object[0]) + config.getMonitorRuleId());
            }
            criteria = this.addOperationUnitCondition(criteria, eocMap);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        MonitorRuleTenantConfig one = (MonitorRuleTenantConfig)this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if ((config.getDirectExecution() == null || !config.getDirectExecution().booleanValue()) && !config.isHasMechanismOrCustomParam() && one != null && Objects.equals(one.getStatus(), config.getStatus()) && StringUtils.equals((CharSequence)one.getProductName(), (CharSequence)config.getProductName()) && !this.checkStandardPollingRuleHasChange(one, config) && ObjectUtils.isEmpty(config.getTenantDynamicCondition()) && ObjectUtils.isEmpty((Object)one.getDynamicCondition())) {
            return new HashMap();
        }
        String curTransactionId = UUID.randomUUID().toString();
        String sendMessage = null;
        Update update = new Update();
        update.set("standardPollingRule", (Object)config.getStandardPollingRule());
        update.set("standardPollingRules", config.getStandardPollingRules());
        update.set("productName", (Object)config.getProductName());
        if (config.getStatus() != null) {
            update.set("status", (Object)config.getStatus());
        }
        update.set("dynamicCondition", config.getTenantDynamicCondition());
        update.set("transactionId", (Object)curTransactionId);
        String backtrackDate = this.getBacktrackDate(config, one, monitorRule, config.getDirectExecution());
        config.setBacktrackDate(backtrackDate);
        if (Objects.equals(monitorRule.getCategory(), MonitorRuleCategoryEnum.SQL_SCRIPT.toString())) {
            List<String> tenantProductList = this.handleEspTenantProduct(tenantId);
            String script = this.handleScript(config.getMonitorRuleId(), config.getProductName(), tenantProductList, tenantVersion);
            if (StringUtils.isNotEmpty((CharSequence)script)) {
                update.set("script", (Object)script);
            }
        }
        try {
            UpdateResult re = this.mongoTemplate.upsert(query, update, MonitorRuleTenantConfig.class);
            if (monitorRule.isDataCheck()) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("transactionId", curTransactionId);
                result.put("sendMessage", null);
                result.put("category", monitorRule.getCategory());
                return result;
            }
            if (re.getUpsertedId() == null || re.getUpsertedId().isNull()) {
                if (config.getStatus() != null) {
                    if (config.getStatus() == 1) {
                        sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.MODIFIED, true, config.getBacktrackDate(), config.getSendWay(), curTransactionId);
                    } else if (config.getStatus() == 0) {
                        sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.MODIFIED, false, config.getBacktrackDate(), config.getSendWay(), curTransactionId);
                    }
                } else if (one != null && one.getStatus() == 1) {
                    sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.MODIFIED, true, config.getBacktrackDate(), config.getSendWay(), curTransactionId);
                }
            } else {
                sendMessage = this.sendMessage(config.getTenantId(), config.getMonitorRuleId(), config.getEocMap(), ConfigChangeTypeEnum.CREATED, 0 != config.getStatus(), config.getBacktrackDate(), config.getSendWay(), curTransactionId);
            }
        }
        catch (Exception e) {
            throw new DWBusinessException("P.KG.500.0032", e.getLocalizedMessage());
        }
        this.recordPreMonitorRuleTenantConfig(curTransactionId, config.getSendWay(), sendMessage, false, one, config.getMonitorRuleId());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("transactionId", curTransactionId);
        result.put("sendMessage", sendMessage);
        result.put("category", monitorRule.getCategory());
        return result;
    }

    private String getBacktrackDate(MonitorRuleConfigDTO config, MonitorRuleTenantConfig tenantConfig, MonitorRule monitorRule, Boolean directExecution) {
        if (StringUtils.isNotEmpty((CharSequence)config.getBacktrackDate())) {
            return config.getBacktrackDate();
        }
        if (monitorRule == null) {
            return null;
        }
        if (Boolean.TRUE.equals(monitorRule.getBacktrackDateEqualsStartTime())) {
            String oldStartDate;
            String newStartTime = this.getStartTime(config.getStandardPollingRule(), config.getStandardPollingRules());
            String oldStartTime = null;
            if (tenantConfig != null) {
                oldStartTime = this.getStartTime(tenantConfig.getStandardPollingRule(), tenantConfig.getStandardPollingRules());
            }
            if (null == newStartTime || newStartTime.isEmpty()) {
                return null;
            }
            if (null == oldStartTime || oldStartTime.isEmpty()) {
                String newStartDate = newStartTime.split(" ")[0];
                return newStartDate + " 00:00:00";
            }
            if (tenantConfig != null && tenantConfig.getStatus() == 1 && config.getStatus() == 0) {
                return null;
            }
            String newStartDate = newStartTime.split(" ")[0];
            if (StringUtils.equals((CharSequence)newStartDate, (CharSequence)(oldStartDate = oldStartTime.split(" ")[0]))) {
                return null;
            }
            return newStartDate + " 00:00:00";
        }
        if (tenantConfig == null && StringUtils.isNotEmpty((CharSequence)monitorRule.getBacktrackDate())) {
            return monitorRule.getBacktrackDate();
        }
        return null;
    }

    private String getStartTime(Object standardPollingRule, Object standardPollingRules) {
        List triggerDTOS = null;
        TriggerDTO triggerDTO = null;
        if (standardPollingRules != null) {
            triggerDTOS = JSON.parseArray((String)JSON.toJSONString((Object)standardPollingRules), TriggerDTO.class);
        }
        if (standardPollingRule != null) {
            triggerDTO = (TriggerDTO)JSON.parseObject((String)JSON.toJSONString((Object)standardPollingRule), TriggerDTO.class);
        }
        return this.getStartTime(triggerDTO, triggerDTOS);
    }

    private String getStartTime(TriggerDTO standardPollingRule, List<TriggerDTO> standardPollingRules) {
        if (null == standardPollingRules || standardPollingRules.isEmpty()) {
            return standardPollingRule == null ? null : standardPollingRule.getStart_time();
        }
        return standardPollingRules.get(0).getStart_time();
    }

    private boolean checkStandardPollingRuleHasChange(MonitorRuleTenantConfig tenantConfig, MonitorRuleConfigDTO configDTO) {
        List<TriggerDTO> standardPollingRules;
        TriggerDTO standardPollingRule = configDTO.getStandardPollingRule();
        if (standardPollingRule != null) {
            String s1;
            Object tenantConfigStandardPollingRule = tenantConfig.getStandardPollingRule();
            if (tenantConfigStandardPollingRule == null) {
                return true;
            }
            String s = JSON.toJSONString((Object)tenantConfigStandardPollingRule);
            if (!StringUtils.equals((CharSequence)s, (CharSequence)(s1 = JSON.toJSONString((Object)standardPollingRule)))) {
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(standardPollingRules = configDTO.getStandardPollingRules())) {
            String s1;
            Object standardPollingRules1 = tenantConfig.getStandardPollingRules();
            if (standardPollingRules1 == null) {
                return true;
            }
            String s = JSON.toJSONString(standardPollingRules);
            if (!StringUtils.equals((CharSequence)s, (CharSequence)(s1 = JSON.toJSONString((Object)standardPollingRules1)))) {
                return true;
            }
        }
        return false;
    }

    private void handleEocHighToLow(MonitorRuleConfigDTO config, Map<String, String> oldEocMap) throws Exception {
        if (oldEocMap == null) {
            return;
        }
        boolean check = this.validateEocLevel(config.getMonitorRuleId(), config.getProductName(), config.getEocMap());
        if (!check) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleError", new Object[0]) + config.getMonitorRuleId());
        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)config.getTenantId()).and("monitorRuleId").is((Object)config.getMonitorRuleId());
        OperationUnit operationUnit = this.operationUnitService.transToOperationUnit(oldEocMap);
        criteria1 = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria1);
        query.addCriteria((CriteriaDefinition)criteria1);
        MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
        monitorRuleTenantConfig.setTenantId(config.getTenantId());
        monitorRuleTenantConfig.setMonitorRuleId(config.getMonitorRuleId());
        monitorRuleTenantConfig.setProductName(config.getProductName());
        monitorRuleTenantConfig.setStandardPollingRule((Object)config.getStandardPollingRule());
        monitorRuleTenantConfig.setStatus(Integer.valueOf(config.getStatus() == null ? 1 : config.getStatus()));
        monitorRuleTenantConfig.setEocMap(config.getEocMap());
        if (!ObjectUtils.isEmpty(config.getTenantDynamicCondition())) {
            monitorRuleTenantConfig.setDynamicCondition((TenantDynamicConditionDO)JSON.parseObject((String)JSON.toJSONString(config.getTenantDynamicCondition()), TenantDynamicConditionDO.class));
        }
        this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);
        this.mongoTemplate.save((Object)monitorRuleTenantConfig, "monitorRuleTenantConfig");
        this.postEocChangeFromHighToLow(config.getTenantId(), Arrays.asList(config.getMonitorRuleId()), oldEocMap, (Map)JSON.parseObject((String)JSON.toJSONString((Object)config.getEocMap())));
    }

    private String handleCropToEoc(MonitorRuleConfigDTO config, String curTransactionId, String beforeEocLevel) throws Exception {
        boolean check = this.validateEocLevel(config.getMonitorRuleId(), config.getProductName(), config.getEocMap());
        if (!check) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleError", new Object[0]) + config.getMonitorRuleId());
        }
        String eocLevel = this.operationUnitService.getEocLevel(this.operationUnitService.transToOperationUnit(config.getEocMap()));
        List<EocMapDTO> eocMapList = this.getEocMap(eocLevel, config.getTenantId(), config.getProductName(), beforeEocLevel, config.getEocMap());
        if (CollectionUtils.isEmpty(eocMapList)) {
            log.info((Object)("====>\u79df\u6237\uff1a" + config.getTenantId() + "\u4ea7\u54c1\uff1a" + config.getProductName() + "\u6ca1\u6709\u4eceesp\u627e\u5230eoc\u7684\u4fe1\u606f, \u6309\u4f20\u5165\u7684eoc\u4fe1\u606f\u8fdb\u884c\u964d\u7ea7\u64cd\u4f5c"));
            eocMapList = new ArrayList<EocMapDTO>();
            EocMapDTO newEocMap = new EocMapDTO();
            if (config.getEocMap() != null) {
                if (StringUtils.isNotEmpty((CharSequence)config.getEocMap().getEocCompanyId())) {
                    newEocMap.setEocCompanyId(config.getEocMap().getEocCompanyId());
                }
                if (StringUtils.isNotEmpty((CharSequence)config.getEocMap().getEocSiteId())) {
                    newEocMap.setEocSiteId(config.getEocMap().getEocSiteId());
                }
                if (StringUtils.isNotEmpty((CharSequence)config.getEocMap().getEocRegionId())) {
                    newEocMap.setEocRegionId(config.getEocMap().getEocRegionId());
                }
            }
            eocMapList.add(newEocMap);
        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)config.getTenantId()).and("monitorRuleId").is((Object)config.getMonitorRuleId());
        OperationUnit operationUnit = new OperationUnit();
        if (StringUtils.equalsIgnoreCase((CharSequence)"company", (CharSequence)beforeEocLevel)) {
            operationUnit.setEoc_company_id(config.getEocMap().getEocCompanyId());
        }
        criteria1 = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria1);
        query.addCriteria((CriteriaDefinition)criteria1);
        ArrayList<MonitorRuleTenantConfig> monitorRuleTenantConfigList = new ArrayList<MonitorRuleTenantConfig>();
        for (EocMapDTO eocMapDTO : eocMapList) {
            MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
            monitorRuleTenantConfig.setTenantId(config.getTenantId());
            monitorRuleTenantConfig.setMonitorRuleId(config.getMonitorRuleId());
            monitorRuleTenantConfig.setProductName(config.getProductName());
            if (CollectionUtils.isEmpty(config.getStandardPollingRules())) {
                ArrayList<TriggerDTO> standardPollingRules = new ArrayList<TriggerDTO>();
                if (config.getStandardPollingRule() != null) {
                    standardPollingRules.add(config.getStandardPollingRule());
                }
                monitorRuleTenantConfig.setStandardPollingRules(standardPollingRules);
            } else {
                monitorRuleTenantConfig.setStandardPollingRules(config.getStandardPollingRules());
            }
            monitorRuleTenantConfig.setStatus(Integer.valueOf(config.getStatus() == null ? 1 : config.getStatus()));
            monitorRuleTenantConfig.setEocMap(eocMapDTO);
            if (!ObjectUtils.isEmpty(config.getTenantDynamicCondition())) {
                monitorRuleTenantConfig.setDynamicCondition((TenantDynamicConditionDO)JSON.parseObject((String)JSON.toJSONString(config.getTenantDynamicCondition()), TenantDynamicConditionDO.class));
            }
            monitorRuleTenantConfig.setTransactionId(curTransactionId);
            monitorRuleTenantConfigList.add(monitorRuleTenantConfig);
        }
        MonitorRuleTenantConfig preTenantConfig = (MonitorRuleTenantConfig)this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class, "monitorRuleTenantConfig");
        this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);
        this.mongoTemplate.insert(monitorRuleTenantConfigList, "monitorRuleTenantConfig");
        String sendMessage = this.postEocChange(config.getTenantId(), config.getSendWay(), config.getMonitorRuleId(), beforeEocLevel, eocMapList);
        this.recordPreMonitorRuleTenantConfig(curTransactionId, config.getSendWay(), sendMessage, true, preTenantConfig, config.getMonitorRuleId());
        return sendMessage;
    }

    public void recordPreMonitorRuleTenantConfig(String curTransactionId, String sendWay, String sendMessage, Boolean crossLevel, MonitorRuleTenantConfig tenantConfig, String ruleId) {
        MonitorRuleSyncRecord monitorRuleSyncRecord = new MonitorRuleSyncRecord();
        monitorRuleSyncRecord.setTransactionId(curTransactionId);
        monitorRuleSyncRecord.setType(StringUtils.equalsIgnoreCase((CharSequence)"HTTP", (CharSequence)sendWay) ? "HTTP" : "MQ");
        monitorRuleSyncRecord.setRuleId(ruleId);
        monitorRuleSyncRecord.setTenantId(tenantConfig == null ? null : tenantConfig.getTenantId());
        monitorRuleSyncRecord.setEocMap(tenantConfig == null ? null : tenantConfig.getEocMap());
        monitorRuleSyncRecord.setCrossLevel(crossLevel);
        monitorRuleSyncRecord.setPreTenantConfig(tenantConfig);
        monitorRuleSyncRecord.setSendMessage(sendMessage);
        monitorRuleSyncRecord.setCreateDate(new Date());
        monitorRuleSyncRecord.setErrorTimes(Integer.valueOf(0));
        monitorRuleSyncRecord.setPreTransactionId(tenantConfig == null ? "" : tenantConfig.getTransactionId());
        this.mongoTemplate.insert((Object)monitorRuleSyncRecord, "monitorRuleSyncRecord");
    }

    public List<EocMapDTO> getEocMapWithOutProduct(String eocLevel, String tenantId, String token) throws Exception {
        ArrayList<EocMapDTO> eocMapDTOList = new ArrayList<EocMapDTO>();
        try {
            Map operationUnitWithToken = this.eocService.getOperationUnitWithToken(token);
            log.info((Object)("operationUnitWithToken:{}" + operationUnitWithToken));
            if (operationUnitWithToken != null) {
                List factories;
                if (StringUtils.equals((CharSequence)eocLevel, (CharSequence)"company")) {
                    List companies = (List)operationUnitWithToken.get("companies");
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)companies)) {
                        for (Map i : companies) {
                            if (null == i.get("id")) continue;
                            EocMapDTO eocMapDTO = new EocMapDTO();
                            eocMapDTO.setEocCompanyId(String.valueOf(i.get("id")));
                            eocMapDTOList.add(eocMapDTO);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)eocLevel, (CharSequence)"site") && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(factories = (List)operationUnitWithToken.get("factories")))) {
                    for (Map i : factories) {
                        if (null == i.get("companyId") || null == i.get("id")) continue;
                        EocMapDTO eocMapDTO = new EocMapDTO();
                        eocMapDTO.setEocCompanyId((String)i.get("companyId"));
                        eocMapDTO.setEocSiteId((String)i.get("id"));
                        eocMapDTOList.add(eocMapDTO);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return eocMapDTOList;
    }

    public EocMapDTO getRootEocMapWithOutProductV2(String token) throws Exception {
        JSONObject operationUnitTree = this.eocUtils.getOperationUnitTree(token);
        if (operationUnitTree == null || operationUnitTree.get((Object)"id") == null) {
            return null;
        }
        EocMapDTO eocMapDTO = new EocMapDTO();
        OperationUnitV2 operationUnitV2 = new OperationUnitV2();
        operationUnitV2.setEoc_mapping_id(operationUnitTree.getString("id"));
        eocMapDTO.setOperation_unit_v2(operationUnitV2);
        return eocMapDTO;
    }

    public List<EocMapDTO> getEocMap(String eocLevel, String tenantId, String productName) throws Exception {
        ArrayList<EocMapDTO> eocMapDTOList = new ArrayList<EocMapDTO>();
        try {
            Optional<ProdEocMapping> any;
            ProductOperationResult productEoc = this.productNameResolver.getProductEoc(tenantId);
            List prod_eoc_mapping = productEoc.getProd_eoc_mapping();
            if (!CollectionUtils.isEmpty((Collection)prod_eoc_mapping) && (any = prod_eoc_mapping.stream().filter(e -> StringUtils.equals((CharSequence)productName, (CharSequence)e.getProd_name())).findAny()).isPresent()) {
                ProdEocMapping prodEocMapping = any.get();
                List org_type_companyList = prodEocMapping.getOrg_type_company();
                if (StringUtils.equals((CharSequence)eocLevel, (CharSequence)"company")) {
                    for (OrgTypeCompany orgTypeCompany : org_type_companyList) {
                        EocMapDTO eocMapDTO = new EocMapDTO();
                        eocMapDTO.setEocCompanyId(orgTypeCompany.getEoc_company_id());
                        eocMapDTOList.add(eocMapDTO);
                    }
                } else if (StringUtils.equals((CharSequence)eocLevel, (CharSequence)"site")) {
                    for (OrgTypeCompany orgTypeCompany : org_type_companyList) {
                        String eoc_company_id = orgTypeCompany.getEoc_company_id();
                        List org_type_site = orgTypeCompany.getOrg_type_site();
                        for (OrgTypeSite orgTypeSite : org_type_site) {
                            EocMapDTO eocMapDTO = new EocMapDTO();
                            eocMapDTO.setEocCompanyId(eoc_company_id);
                            eocMapDTO.setEocSiteId(orgTypeSite.getEoc_site_id());
                            eocMapDTOList.add(eocMapDTO);
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return eocMapDTOList;
    }

    public List<EocMapDTO> getEocMap(String eocLevel, String tenantId, String productName, String beforeEocLevel, EocMapDTO eocMap) throws Exception {
        ArrayList<EocMapDTO> eocMapDTOList = new ArrayList<EocMapDTO>();
        try {
            Optional<ProdEocMapping> any;
            ProductOperationResult productEoc = this.productNameResolver.getProductEoc(tenantId);
            List prod_eoc_mapping = productEoc.getProd_eoc_mapping();
            if (!CollectionUtils.isEmpty((Collection)prod_eoc_mapping) && (any = prod_eoc_mapping.stream().filter(e -> StringUtils.equals((CharSequence)productName, (CharSequence)e.getProd_name())).findAny()).isPresent()) {
                ProdEocMapping prodEocMapping = any.get();
                List org_type_companyList = prodEocMapping.getOrg_type_company();
                if (StringUtils.equals((CharSequence)eocLevel, (CharSequence)"company")) {
                    for (OrgTypeCompany orgTypeCompany : org_type_companyList) {
                        EocMapDTO eocMapDTO = new EocMapDTO();
                        eocMapDTO.setEocCompanyId(orgTypeCompany.getEoc_company_id());
                        eocMapDTOList.add(eocMapDTO);
                    }
                } else if (StringUtils.equals((CharSequence)eocLevel, (CharSequence)"site")) {
                    for (OrgTypeCompany orgTypeCompany : org_type_companyList) {
                        String eoc_company_id = orgTypeCompany.getEoc_company_id();
                        if (StringUtils.equalsIgnoreCase((CharSequence)beforeEocLevel, (CharSequence)"company") && !StringUtils.equals((CharSequence)eoc_company_id, (CharSequence)eocMap.getEocCompanyId())) continue;
                        List org_type_site = orgTypeCompany.getOrg_type_site();
                        for (OrgTypeSite orgTypeSite : org_type_site) {
                            EocMapDTO eocMapDTO = new EocMapDTO();
                            eocMapDTO.setEocCompanyId(eoc_company_id);
                            eocMapDTO.setEocSiteId(orgTypeSite.getEoc_site_id());
                            eocMapDTOList.add(eocMapDTO);
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return eocMapDTOList;
    }

    private boolean checkIsCropToEoc(MonitorRuleConfigDTO config) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)config.getTenantId());
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        List tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if (CollectionUtils.isEmpty((Collection)tenantConfigList)) {
            return false;
        }
        if (this.checkIsCorpLevel(config.getEocMap())) {
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e -> this.checkIsCompanyLevel(e.getEocMap()) || this.checkIsSiteLevel(e.getEocMap()) || this.checkIsRegionLevel(e.getEocMap())).findAny();
            if (any.isPresent()) {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.canNotUpdateError", config.getTenantId(), config.getMonitorRuleId()));
            }
        } else {
            boolean allMatch = tenantConfigList.stream().allMatch(e -> this.checkIsCorpLevel(e.getEocMap()));
            if (allMatch) {
                return true;
            }
            String eocLevel = this.operationUnitService.getEocLevel(this.operationUnitService.transToOperationUnit(config.getEocMap()));
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e -> StringUtils.equals((CharSequence)eocLevel, (CharSequence)"company") && this.checkIsSiteLevel(e.getEocMap()) || StringUtils.equals((CharSequence)eocLevel, (CharSequence)"site") && this.checkIsCompanyLevel(e.getEocMap())).findAny();
            if (any.isPresent()) {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.dataNotConsistent", config.getTenantId(), config.getMonitorRuleId()));
            }
        }
        return false;
    }

    private String checkIsEocChange(MonitorRuleConfigDTO config) throws DWBusinessException {
        if (this.iamUtils.isTenantOperationUnitV2()) {
            return null;
        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)config.getTenantId());
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        List tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if (CollectionUtils.isEmpty((Collection)tenantConfigList)) {
            return null;
        }
        if (this.checkIsCorpLevel(config.getEocMap())) {
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e -> this.checkIsCompanyLevel(e.getEocMap()) || this.checkIsSiteLevel(e.getEocMap()) || this.checkIsRegionLevel(e.getEocMap())).findAny();
            if (any.isPresent()) {
                throw new DWBusinessException("tenantId:" + config.getTenantId() + "\u4fa6\u6d4b:" + config.getMonitorRuleId() + "\u539f\u5148\u4e3a\u975e\u96c6\u56e2\u7ea7\uff0c\u65e0\u6cd5\u5347\u4e3a\u96c6\u56e2\u7ea7");
            }
        } else if (this.checkIsCompanyLevel(config.getEocMap())) {
            boolean allMatch = tenantConfigList.stream().allMatch(e -> this.checkIsCorpLevel(e.getEocMap()));
            if (allMatch) {
                return "crop";
            }
            boolean siteMatch = tenantConfigList.stream().filter(e -> StringUtils.equals((CharSequence)e.getEocMap().getEocCompanyId(), (CharSequence)config.getEocMap().getEocCompanyId())).anyMatch(e -> this.checkIsSiteLevel(e.getEocMap()));
            if (siteMatch) {
                throw new DWBusinessException("tenantId:" + config.getTenantId() + "\u4fa6\u6d4b:" + config.getMonitorRuleId() + "\u65e0\u6cd5\u4ece\u5de5\u5382\u7ea7\u53d8\u4e3a\u516c\u53f8\u7ea7");
            }
        } else if (this.checkIsSiteLevel(config.getEocMap())) {
            boolean b;
            boolean allMatch = tenantConfigList.stream().allMatch(e -> this.checkIsCorpLevel(e.getEocMap()));
            if (allMatch) {
                return "crop";
            }
            List collect = tenantConfigList.stream().filter(e -> StringUtils.equals((CharSequence)e.getEocMap().getEocCompanyId(), (CharSequence)config.getEocMap().getEocCompanyId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect) && (b = collect.stream().allMatch(e -> this.checkIsCompanyLevel(e.getEocMap())))) {
                return "company";
            }
        }
        return null;
    }

    private Map checkIsEocHighToLow(MonitorRuleConfigDTO config) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)config.getTenantId());
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        List tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if (this.checkIsCorpLevel(config.getEocMap())) {
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e -> this.checkIsCompanyLevel(e.getEocMap()) || this.checkIsSiteLevel(e.getEocMap()) || this.checkIsRegionLevel(e.getEocMap())).findAny();
            if (any.isPresent()) {
                throw new DWBusinessException("tenantId:" + config.getTenantId() + "\u4fa6\u6d4b:" + config.getMonitorRuleId() + "\u975e\u96c6\u56e2\u7ea7\u6570\u636e");
            }
        } else if (this.checkIsCompanyLevel(config.getEocMap())) {
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e -> this.checkIsCorpLevel(e.getEocMap())).findAny();
            if (any.isPresent()) {
                return new HashMap();
            }
        } else if (this.checkIsSiteLevel(config.getEocMap())) {
            Optional<MonitorRuleTenantConfig> any = tenantConfigList.stream().filter(e -> this.checkIsCompanyLevel(e.getEocMap()) && StringUtils.equals((CharSequence)e.getEocMap().getEocCompanyId(), (CharSequence)config.getEocMap().getEocCompanyId())).findAny();
            if (any.isPresent()) {
                return JSON.parseObject((String)JSON.toJSONString((Object)any.get().getEocMap()));
            }
            Optional<MonitorRuleTenantConfig> anyCorp = tenantConfigList.stream().filter(e -> this.checkIsCorpLevel(e.getEocMap())).findAny();
            if (anyCorp.isPresent()) {
                return new HashMap();
            }
        }
        return null;
    }

    private boolean checkIsCorpLevel(EocMapDTO eocMap) {
        return eocMap == null || StringUtils.isEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocSiteId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocRegionId());
    }

    private boolean checkIsCompanyLevel(EocMapDTO eocMap) {
        return eocMap != null && StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocSiteId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocRegionId());
    }

    private boolean checkIsSiteLevel(EocMapDTO eocMap) {
        return eocMap != null && StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocSiteId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocRegionId());
    }

    private boolean checkIsRegionLevel(EocMapDTO eocMap) {
        return eocMap != null && StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocSiteId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocRegionId());
    }

    @Override
    public Object putEnable(String tenantId, String ruleId) throws Exception {
        this.sendMessage(tenantId, ruleId, ConfigChangeTypeEnum.ENABLED);
        return null;
    }

    @Override
    public Object putDisable(String tenantId, String ruleId) throws Exception {
        log.info((Object)("\u505c\u7528\u4fa6\u6d4b\uff0ctenantId\uff1a" + tenantId + "\uff0cruleId\uff1a{}" + ruleId));
        this.sendMessage(tenantId, ruleId, ConfigChangeTypeEnum.DISABLED);
        return null;
    }

    @Override
    public Object putEnable(String tenantId, String ruleId, EocMapDTO eocMap) throws Exception {
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)tenantId);
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        Criteria criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria2});
        if (eocMap != null) {
            criteria = this.addOperationUnitCondition(criteria, eocMap);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)1);
        try {
            this.mongoTemplate.updateMulti(query, update, MonitorRuleTenantConfig.class);
            this.sendMessage(tenantId, ruleId, eocMap, ConfigChangeTypeEnum.ENABLED);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object putDisable(String tenantId, String ruleId, EocMapDTO eocMap) throws Exception {
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)tenantId);
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        Criteria criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria2});
        if (eocMap != null) {
            criteria = this.addOperationUnitCondition(criteria, eocMap);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)0);
        try {
            this.mongoTemplate.updateMulti(query, update, MonitorRuleTenantConfig.class);
            this.sendMessage(tenantId, ruleId, eocMap, ConfigChangeTypeEnum.DISABLED);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    private Criteria addOperationUnitCondition(Criteria criteria, EocMapDTO eocMap) throws DWBusinessException {
        Criteria c = null;
        if (StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId())) {
            c = Criteria.where((String)"eocMap.eocCompanyId").is((Object)eocMap.getEocCompanyId());
        }
        if (StringUtils.isNotEmpty((CharSequence)eocMap.getEocSiteId())) {
            c = c == null ? Criteria.where((String)"eocMap.eocSiteId").is((Object)eocMap.getEocSiteId()) : new Criteria().andOperator(new Criteria[]{c, Criteria.where((String)"eocMap.eocSiteId").is((Object)eocMap.getEocSiteId())});
        }
        if (StringUtils.isNotEmpty((CharSequence)eocMap.getEocRegionId())) {
            c = c == null ? Criteria.where((String)"eocMap.eocRegionId").is((Object)eocMap.getEocRegionId()) : new Criteria().andOperator(new Criteria[]{c, Criteria.where((String)"eocMap.eocRegionId").is((Object)eocMap.getEocRegionId())});
        }
        if (this.iamUtils.isTenantOperationUnitV2()) {
            c = c == null ? Criteria.where((String)"eocMap.operation_unit_v2.eoc_mapping_id").is((Object)eocMap.getOperation_unit_v2().getEoc_mapping_id()) : new Criteria().andOperator(new Criteria[]{c, Criteria.where((String)"eocMap.operation_unit_v2.eoc_mapping_id").is((Object)eocMap.getOperation_unit_v2().getEoc_mapping_id())});
        }
        if (c != null) {
            return new Criteria().andOperator(new Criteria[]{criteria, c});
        }
        return criteria;
    }

    @Override
    public Object postNotice(MonitorRuleConfigDTO config) throws Exception {
        String tenantId = config.getTenantId();
        String ruleId = config.getMonitorRuleId();
        ConfigChangeTypeEnum configChangeTypeEnum = ConfigChangeTypeEnum.valueOf(config.getChangeType());
        if (configChangeTypeEnum == null || StringUtils.isEmpty((CharSequence)configChangeTypeEnum.toString())) {
            throw new DWBusinessException("changeType\u4e0d\u6b63\u786e");
        }
        this.sendMessage(tenantId, ruleId, config.getEocMap(), configChangeTypeEnum);
        return null;
    }

    @Override
    public Object getRuleCodeByMechanism(String mechanismCode) throws DWBusinessException {
        try {
            return this.monitorRuleRepository.getCodeByMechainismCode(mechanismCode);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
    }

    @Override
    public Object postRuleCodeByMechanismWithEoc(String mechanismCode, OperationUnit operationUnit, String product) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        try {
            ArrayList<String> result = new ArrayList<String>();
            List<String> codeByMechainismCode = this.monitorRuleRepository.getCodeByMechainismCode(mechanismCode, tenantVersion);
            if (!CollectionUtils.isEmpty(codeByMechainismCode)) {
                for (String code : codeByMechainismCode) {
                    Criteria criteria1 = Criteria.where((String)"productName").is((Object)product).and("monitorRuleId").is((Object)code);
                    MonitorRuleProductConfig productConfig = this.dataPickService.findOneByCondition(criteria1, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
                    if (productConfig == null) continue;
                    String eocLevel = productConfig.getEocLevel();
                    String eocLevel1 = this.operationUnitService.getEocLevel(operationUnit);
                    if ((!StringUtils.isEmpty((CharSequence)eocLevel) || !StringUtils.isEmpty((CharSequence)eocLevel1)) && !StringUtils.equalsIgnoreCase((CharSequence)eocLevel, (CharSequence)eocLevel1)) continue;
                    result.add(code);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
    }

    @Override
    public Object get(String tenantId, String ruleId) throws Exception {
        MonitorRuleTenantConfig re = null;
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)tenantId);
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{criteria1, criteria2}));
        try {
            re = (MonitorRuleTenantConfig)this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return re;
    }

    public Object postEocChangeFromHighToLow(String tenantId, List<String> ruleIds, Map oldEocMap, Map eocMap) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("monitorRuleId").in(ruleIds).and("status").is((Object)1);
        criteria = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(eocMap), criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        List monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if (CollectionUtils.isEmpty((Collection)monitorRuleTenantConfigs)) {
            throw new DWBusinessException("\u672a\u627e\u5230\u76f8\u5173\u7684\u7684\u4fa6\u6d4b\u914d\u7f6e, tenantId:" + tenantId);
        }
        Map<String, List<MonitorRuleTenantConfig>> groupedTenantConfig = monitorRuleTenantConfigs.stream().collect(Collectors.groupingBy(e -> e.getMonitorRuleId() + "#" + e.getProductName()));
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").in(ruleIds);
        List<MonitorRuleProductConfig> monitorRuleProductConfigs = this.dataPickService.find(criteria2, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        ArrayList<String> sendContentList = new ArrayList<String>();
        for (Map.Entry<String, List<MonitorRuleTenantConfig>> entry : groupedTenantConfig.entrySet()) {
            String key = entry.getKey();
            String[] keySplit = key.split("#");
            List<MonitorRuleTenantConfig> value = entry.getValue();
            ArrayList<Map<String, Object>> newEocMapList = new ArrayList<Map<String, Object>>();
            Optional<MonitorRuleProductConfig> any = monitorRuleProductConfigs.stream().filter(e -> StringUtils.equals((CharSequence)e.getMonitorRuleId(), (CharSequence)keySplit[0]) && StringUtils.equals((CharSequence)e.getProductName(), (CharSequence)keySplit[1])).findAny();
            if (any.isPresent()) {
                MonitorRuleProductConfig monitorRuleProductConfig = any.get();
                for (MonitorRuleTenantConfig tenantConfig : value) {
                    HashMap<String, String> newEocMap = new HashMap<String, String>();
                    if (this.checkEoc(monitorRuleProductConfig.getEocLevel(), tenantConfig.getEocMap())) {
                        if (StringUtils.isNotEmpty((CharSequence)tenantConfig.getEocMap().getEocCompanyId())) {
                            newEocMap.put("eocCompanyId", tenantConfig.getEocMap().getEocCompanyId());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)tenantConfig.getEocMap().getEocSiteId())) {
                            newEocMap.put("eocSiteId", tenantConfig.getEocMap().getEocSiteId());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)tenantConfig.getEocMap().getEocRegionId())) {
                            newEocMap.put("eocRegionId", tenantConfig.getEocMap().getEocRegionId());
                        }
                        if (this.iamUtils.isTenantOperationUnitV2()) {
                            newEocMap.put("operation_unit_v2", (String)tenantConfig.getEocMap().getOperation_unit_v2());
                        }
                        newEocMapList.add(newEocMap);
                        continue;
                    }
                    throw new DWBusinessException("\u4ea7\u54c1\u7ea7\u7684eocLevel\u4e0e\u79df\u6237\u7ea7\u7684eocMap\u4e0d\u5339\u914d,\u8bf7\u4fee\u6539\u6b63\u786e\u540e\u91cd\u8bd5, monitorRuleId:" + keySplit[0] + " ,productName:" + keySplit[1] + " ,tenantId:" + tenantId);
                }
                sendContentList.add(this.generateSendContent(keySplit[0], tenantId, oldEocMap == null ? new HashMap() : oldEocMap, newEocMapList));
                continue;
            }
            throw new DWBusinessException("\u672a\u5728\u4fa6\u6d4b\u4ea7\u54c1\u8868MonitorRuleProductConfig\u627e\u5230\u6570\u636e, monitorRuleId:" + keySplit[0] + " productName:" + keySplit[1]);
        }
        for (String str : sendContentList) {
            this.sendMessage(str, this.monitorCrossLevelRoutingKey);
        }
        return "success";
    }

    public String postEocChange(String tenantId, String sendWay, String ruleId, String beforeEocLevel, List<EocMapDTO> eocMapList) throws Exception {
        ArrayList<Map<String, Object>> newEocMapList = new ArrayList<Map<String, Object>>();
        for (EocMapDTO eocMapDTO : eocMapList) {
            HashMap<String, String> newEocMap = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)eocMapDTO.getEocCompanyId())) {
                newEocMap.put("eocCompanyId", eocMapDTO.getEocCompanyId());
            }
            if (StringUtils.isNotEmpty((CharSequence)eocMapDTO.getEocSiteId())) {
                newEocMap.put("eocSiteId", eocMapDTO.getEocSiteId());
            }
            if (StringUtils.isNotEmpty((CharSequence)eocMapDTO.getEocRegionId())) {
                newEocMap.put("eocRegionId", eocMapDTO.getEocRegionId());
            }
            if (this.iamUtils.isTenantOperationUnitV2()) {
                newEocMap.put("operation_unit_v2", (String)eocMapDTO.getOperation_unit_v2());
            }
            newEocMapList.add(newEocMap);
        }
        HashMap<String, Object> oldEocMap = new HashMap<String, Object>();
        if (StringUtils.equalsIgnoreCase((CharSequence)"company", (CharSequence)beforeEocLevel)) {
            oldEocMap.put("eocCompanyId", eocMapList.get(0).getEocCompanyId());
        }
        String sendContent = this.generateSendContent(ruleId, tenantId, oldEocMap, newEocMapList);
        if (StringUtils.equalsIgnoreCase((CharSequence)sendWay, (CharSequence)"HTTP")) {
            return sendContent;
        }
        this.sendMessage(sendContent, this.monitorCrossLevelRoutingKey);
        return sendContent;
    }

    public Object postEocChangeFromTenant(String tenantId, String sendWay, List<String> ruleIds) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("monitorRuleId").in(ruleIds).and("status").is((Object)1);
        query.addCriteria((CriteriaDefinition)criteria);
        List monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if (CollectionUtils.isEmpty((Collection)monitorRuleTenantConfigs)) {
            throw new DWBusinessException("\u672a\u627e\u5230\u76f8\u5173\u7684\u7684\u4fa6\u6d4b\u914d\u7f6e, tenantId:" + tenantId);
        }
        Map<String, List<MonitorRuleTenantConfig>> groupedTenantConfig = monitorRuleTenantConfigs.stream().collect(Collectors.groupingBy(e -> e.getMonitorRuleId() + "#" + e.getProductName()));
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").in(ruleIds);
        List<MonitorRuleProductConfig> monitorRuleProductConfigs = this.dataPickService.find(criteria2, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        ArrayList<String> sendContentList = new ArrayList<String>();
        for (Map.Entry<String, List<MonitorRuleTenantConfig>> entry : groupedTenantConfig.entrySet()) {
            String key = entry.getKey();
            String[] keySplit = key.split("#");
            List<MonitorRuleTenantConfig> value = entry.getValue();
            ArrayList<Map<String, Object>> newEocMapList = new ArrayList<Map<String, Object>>();
            Optional<MonitorRuleProductConfig> any = monitorRuleProductConfigs.stream().filter(e -> StringUtils.equals((CharSequence)e.getMonitorRuleId(), (CharSequence)keySplit[0]) && StringUtils.equals((CharSequence)e.getProductName(), (CharSequence)keySplit[1])).findAny();
            if (any.isPresent()) {
                MonitorRuleProductConfig monitorRuleProductConfig = any.get();
                for (MonitorRuleTenantConfig tenantConfig : value) {
                    HashMap<String, String> newEocMap = new HashMap<String, String>();
                    if (this.checkEoc(monitorRuleProductConfig.getEocLevel(), tenantConfig.getEocMap())) {
                        if (StringUtils.isNotEmpty((CharSequence)tenantConfig.getEocMap().getEocCompanyId())) {
                            newEocMap.put("eocCompanyId", tenantConfig.getEocMap().getEocCompanyId());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)tenantConfig.getEocMap().getEocSiteId())) {
                            newEocMap.put("eocSiteId", tenantConfig.getEocMap().getEocSiteId());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)tenantConfig.getEocMap().getEocRegionId())) {
                            newEocMap.put("eocRegionId", tenantConfig.getEocMap().getEocRegionId());
                        }
                        if (this.iamUtils.isTenantOperationUnitV2()) {
                            newEocMap.put("operation_unit_v2", (String)tenantConfig.getEocMap().getOperation_unit_v2());
                        }
                        newEocMapList.add(newEocMap);
                        continue;
                    }
                    throw new DWBusinessException("\u4ea7\u54c1\u7ea7\u7684eocLevel\u4e0e\u79df\u6237\u7ea7\u7684eocMap\u4e0d\u5339\u914d,\u8bf7\u4fee\u6539\u6b63\u786e\u540e\u91cd\u8bd5, monitorRuleId:" + keySplit[0] + " ,productName:" + keySplit[1] + " ,tenantId:" + tenantId);
                }
                sendContentList.add(this.generateSendContent(keySplit[0], tenantId, new HashMap<String, Object>(), newEocMapList));
                continue;
            }
            throw new DWBusinessException("\u672a\u5728\u4fa6\u6d4b\u4ea7\u54c1\u8868MonitorRuleProductConfig\u627e\u5230\u6570\u636e, monitorRuleId:" + keySplit[0] + " productName:" + keySplit[1]);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)sendWay, (CharSequence)"HTTP")) {
            return sendContentList;
        }
        for (String str : sendContentList) {
            this.sendMessage(str, this.monitorCrossLevelRoutingKey);
        }
        return sendContentList;
    }

    @Override
    public Object postEocChangeFromTenant(String tenantId, List<String> ruleIds) throws Exception {
        return this.postEocChangeFromTenant(tenantId, "MQ", ruleIds);
    }

    private boolean checkEoc(String eocLevel, EocMapDTO eocMap) throws Exception {
        if (StringUtils.isEmpty((CharSequence)eocLevel)) {
            throw new DWBusinessException("MonitorRuleProductConfig eocLevel is null");
        }
        if (eocMap == null) {
            throw new DWBusinessException("MonitorRuleTenantConfig eocMap is null");
        }
        String level = null;
        if (StringUtils.isNotEmpty((CharSequence)eocMap.getEocRegionId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocSiteId())) {
            level = "region";
        }
        if (StringUtils.isEmpty((CharSequence)eocMap.getEocRegionId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocSiteId())) {
            level = "site";
        }
        if (StringUtils.isEmpty((CharSequence)eocMap.getEocRegionId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocSiteId())) {
            level = "company";
        }
        if (StringUtils.isEmpty((CharSequence)level)) {
            throw new DWBusinessException("\u8f93\u5165\u7684\u8fd0\u8425\u5355\u5143\u503c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u6838\u5bf9");
        }
        return StringUtils.equals((CharSequence)level, (CharSequence)eocLevel);
    }

    private String generateSendContent(String ruleId, String tenantId, Map<String, Object> oldEocMap, List<Map<String, Object>> newEocMap) {
        JSONObject obj = new JSONObject();
        obj.put("ruleId", (Object)ruleId);
        obj.put("tenantId", (Object)tenantId);
        obj.put("eocMap", oldEocMap);
        obj.put("newEocList", newEocMap);
        return obj.toJSONString();
    }

    @Override
    public Object postEocChange(MonitorEocChangeVO monitorEocChange) throws Exception {
        this.sendMessage(JSON.toJSONString((Object)monitorEocChange), this.monitorCrossLevelRoutingKey);
        return "success";
    }

    private boolean validateEocLevel(String ruleId, String productName, EocMapDTO eocMap) throws DWBusinessException {
        if (this.iamUtils.isTenantOperationUnitV2()) {
            return true;
        }
        String level = null;
        if (StringUtils.isNotEmpty((CharSequence)eocMap.getEocRegionId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocSiteId())) {
            level = "region";
        }
        if (StringUtils.isEmpty((CharSequence)eocMap.getEocRegionId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocSiteId())) {
            level = "site";
        }
        if (StringUtils.isEmpty((CharSequence)eocMap.getEocRegionId()) && StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && StringUtils.isEmpty((CharSequence)eocMap.getEocSiteId())) {
            level = "company";
        }
        if (StringUtils.isEmpty((CharSequence)level)) {
            throw new DWBusinessException("\u8f93\u5165\u7684\u8fd0\u8425\u5355\u5143\u503c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u6838\u5bf9");
        }
        Criteria criteria = Criteria.where((String)"productName").is((Object)productName).and("monitorRuleId").is((Object)ruleId).and("eocLevel").is((Object)level);
        MonitorRuleProductConfig config = this.dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        return config != null;
    }

    @Override
    public Object getProductNameByMonitorRule(String ruleId) throws Exception {
        ArrayList names = new ArrayList();
        Criteria criteria = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        List<MonitorRuleProductConfig> configs = this.dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        configs.forEach(r -> names.add(r.getProductName()));
        return names;
    }

    @Override
    public Object delete(MonitorRuleConfigDTO config) throws Exception {
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)"tenantId").is((Object)config.getTenantId());
        Criteria criteria2 = Criteria.where((String)"monitorRuleId").is((Object)config.getMonitorRuleId());
        Criteria criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria2});
        criteria = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(config.getEocMap()), criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        try {
            List monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
            this.mongoTemplate.remove(query, MonitorRuleTenantConfig.class);
            for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigs) {
                this.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.DELETED);
            }
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object getCheckExecutingAction(String ruleId) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<Object> actionIds = new ArrayList();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"monitorRuleId").is((Object)ruleId).and("version").is((Object)tenantVersion));
        try {
            MonitorRuleConfig config = (MonitorRuleConfig)((Object)this.mongoTemplateSystem.findOne(query, MonitorRuleConfig.class));
            if (config != null && !CollectionUtils.isEmpty(config.getCheckExecutingActionIds())) {
                actionIds = config.getCheckExecutingActionIds();
            }
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return actionIds;
    }

    @Override
    public Object postFindMonitorRuleConfig(String tenantId, String ruleId, OperationUnit operationUnit, String product) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<MonitorRule> byCode = this.dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion));
        if (CollectionUtils.isEmpty(byCode)) {
            throw new DWBusinessException(String.format("Monitor rule %s not found", ruleId));
        }
        MonitorRuleDynamicParam monitorRuleDynamicParam = new MonitorRuleDynamicParam();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("monitorRuleId").is((Object)ruleId);
        criteria = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        MonitorRuleTenantConfig re = (MonitorRuleTenantConfig)this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if (re != null) {
            BeanUtils.copyProperties((Object)re, (Object)monitorRuleDynamicParam);
        }
        String monitorProduct = re == null ? product : re.getProductName();
        MonitorRule monitorRule = byCode.get(0);
        String dynamicConditionFields = monitorRule.getDynamicConditionFields();
        String[] dynamicConditionFieldsSplit = null;
        if (StringUtils.isEmpty((CharSequence)dynamicConditionFields)) {
            return monitorRuleDynamicParam;
        }
        dynamicConditionFieldsSplit = dynamicConditionFields.split(",");
        Criteria criteria1 = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        List<MonitorRuleProductConfig> productConfigList = this.dataPickService.find(criteria1, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        if (CollectionUtils.isEmpty(productConfigList)) {
            throw new DWBusinessException(String.format("Monitor rule %s not found ProductConfig", ruleId));
        }
        MonitorRuleProductConfig productConfig = null;
        if (this.checkOnlyOneNonSteadyProductOnMonitorConfig(productConfigList)) {
            productConfig = productConfigList.get(0);
        } else {
            Optional<MonitorRuleProductConfig> first = productConfigList.stream().filter(e -> StringUtils.equals((CharSequence)product, (CharSequence)e.getProductName())).findFirst();
            if (first.isPresent()) {
                productConfig = first.get();
            }
        }
        if (productConfig == null) {
            throw new DWBusinessException(String.format("Monitor rule %s not found ProductConfig", ruleId));
        }
        ArrayList<FieldMappingConfigDO> dynamicfieldMappings = new ArrayList<FieldMappingConfigDO>();
        List fieldMappings = productConfig.getFieldMappings();
        if (!CollectionUtils.isEmpty((Collection)fieldMappings)) {
            Map<String, FieldMappingConfigDO> collect = fieldMappings.stream().collect(Collectors.toMap(FieldMappingConfigDO::getField, e -> e, (a, b) -> a));
            for (String returnFieldName : dynamicConditionFieldsSplit) {
                if (!collect.containsKey(returnFieldName)) continue;
                dynamicfieldMappings.add(collect.get(returnFieldName));
            }
        }
        monitorRuleDynamicParam.setFieldMappings(dynamicfieldMappings);
        return monitorRuleDynamicParam;
    }

    @Override
    public Object postFindMonitorRuleConfig(String tenantId, List<String> ruleIdList, OperationUnit operationUnit, String product) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String ruleId : ruleIdList) {
            Object obj = this.postFindMonitorRuleConfig(tenantId, ruleId, operationUnit, product);
            result.put(ruleId, obj);
        }
        return result;
    }

    private boolean checkOnlyOneNonSteadyProductOnMonitorConfig(List<MonitorRuleProductConfig> productConfigList) throws DWException {
        MonitorRuleProductConfig productConfig;
        Object steadyProduct;
        return productConfigList.size() == 1 && ObjectUtils.isEmpty((Object)(steadyProduct = this.productService.getSteadyProduct((productConfig = productConfigList.get(0)).getProductName())));
    }

    @Override
    public Object getProductNamesByMonitorRuleList(List<String> ruleIdList) throws Exception {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"monitorRuleId").in(ruleIdList);
        query.addCriteria((CriteriaDefinition)criteria);
        List<MonitorRuleProductConfig> configs = this.dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        for (MonitorRuleProductConfig config : configs) {
            ArrayList<String> o = (ArrayList<String>)result.get(config.getMonitorRuleId());
            if (o == null) {
                o = new ArrayList<String>();
            }
            o.add(config.getProductName());
            result.put(config.getMonitorRuleId(), o);
        }
        return result;
    }

    @Override
    public Object postReceiveMonitorRuleSyncResult(MonitorRuleSyncResult syncResult) throws Exception {
        log.info((Object)("ReceiveMonitorRuleSyncResult: " + JSON.toJSONString((Object)syncResult)));
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"transactionId").is((Object)syncResult.getTransactionId());
        query.addCriteria((CriteriaDefinition)criteria);
        if (StringUtils.equalsIgnoreCase((CharSequence)"success", (CharSequence)syncResult.getResult())) {
            this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
        } else {
            MonitorRuleSyncRecord monitorRuleSyncRecord = (MonitorRuleSyncRecord)this.mongoTemplate.findOne(query, MonitorRuleSyncRecord.class, "monitorRuleSyncRecord");
            if (monitorRuleSyncRecord == null) {
                return "success";
            }
            MonitorRuleTenantConfig monitorRuleTenantConfig = (MonitorRuleTenantConfig)this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class, "monitorRuleTenantConfig");
            if (monitorRuleTenantConfig == null) {
                Query query2 = new Query();
                Criteria criteria2 = Criteria.where((String)"preTransactionId").is((Object)syncResult.getTransactionId());
                query2.addCriteria((CriteriaDefinition)criteria2);
                MonitorRuleSyncRecord otherLinkedMonitorRuleSyncRecord = (MonitorRuleSyncRecord)this.mongoTemplate.findOne(query2, MonitorRuleSyncRecord.class, "monitorRuleSyncRecord");
                if (otherLinkedMonitorRuleSyncRecord == null) {
                    this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
                } else {
                    Query query3 = new Query();
                    Criteria criteria3 = Criteria.where((String)"transactionId").is((Object)otherLinkedMonitorRuleSyncRecord.getTransactionId());
                    query3.addCriteria((CriteriaDefinition)criteria3);
                    Update update = new Update();
                    update.set("preTenantConfig", (Object)monitorRuleSyncRecord.getPreTenantConfig());
                    update.set("preTransactionId", (Object)monitorRuleSyncRecord.getPreTransactionId());
                    this.mongoTemplate.updateFirst(query3, update, "monitorRuleSyncRecord");
                    this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
                }
            } else {
                this.mongoTemplate.remove(query, "monitorRuleTenantConfig");
                if (monitorRuleSyncRecord.getPreTenantConfig() != null) {
                    this.mongoTemplate.insert((Object)monitorRuleSyncRecord.getPreTenantConfig(), "monitorRuleTenantConfig");
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)monitorRuleSyncRecord.getType(), (CharSequence)"HTTP")) {
                    this.mongoTemplate.remove(query, "monitorRuleSyncRecord");
                } else {
                    Update update = new Update();
                    update.set("errorMessage", (Object)syncResult.getErrorMessage());
                    update.set("errorTimes", (Object)(monitorRuleSyncRecord.getErrorTimes() + 1));
                    this.mongoTemplate.updateFirst(query, update, "monitorRuleSyncRecord");
                }
            }
        }
        return "success";
    }

    @Override
    public Object getCodeByTenant() throws Exception {
        List<String> ruleIds = this.dataPickService.tenantApplicationRelationCodes("monitorRule");
        return ruleIds;
    }

    @Override
    public Object postNoticeWhenMonitorRuleConfigChange(MonitorNoticeVO noticeInfo) throws Exception {
        log.info((Object)"=======NoticeWhenMonitorRuleConfigChangeStart=======");
        Assert.notNull((Object)noticeInfo.getRuleIds(), (String)"monitorRule id is null");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"monitorRuleId").in((Collection)noticeInfo.getRuleIds()));
        List tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if (CollectionUtils.isEmpty((Collection)tenantConfigList)) {
            return null;
        }
        HashMap productChangeInfo = noticeInfo.getProductChangeInfo();
        if (productChangeInfo == null) {
            productChangeInfo = new HashMap();
        }
        for (MonitorRuleTenantConfig monitorRuleTenantConfig : tenantConfigList) {
            TenantEntity tenantEntity;
            log.info((Object)("NoticeWhenMonitorRuleConfigChange tenantId:" + monitorRuleTenantConfig.getTenantId() + "ruleId:" + monitorRuleTenantConfig.getMonitorRuleId()));
            if (StringUtils.isNotEmpty((CharSequence)noticeInfo.getVersion()) && (null == (tenantEntity = this.tenantService.getTenant(monitorRuleTenantConfig.getTenantId())) || !StringUtils.equals((CharSequence)tenantEntity.getVersion(), (CharSequence)noticeInfo.getVersion())) || !CollectionUtils.isEmpty((Collection)noticeInfo.getLimitedTenantIdList()) && !noticeInfo.getLimitedTenantIdList().contains(monitorRuleTenantConfig.getTenantId()) || !CollectionUtils.isEmpty((Collection)noticeInfo.getExcludedTenantIdList()) && noticeInfo.getExcludedTenantIdList().contains(monitorRuleTenantConfig.getTenantId())) continue;
            if (BooleanUtils.isTrue((Boolean)monitorRuleTenantConfig.getClosed())) {
                log.info((Object)("NoticeWhenMonitorRuleConfigChange tenantId:" + monitorRuleTenantConfig.getTenantId() + ", rule:" + monitorRuleTenantConfig.getMonitorRuleId() + " is closed"));
                continue;
            }
            String newProductName = (String)productChangeInfo.get(monitorRuleTenantConfig.getProductName());
            if (StringUtils.isNotEmpty((CharSequence)newProductName)) {
                log.info((Object)("NoticeWhenMonitorRuleConfigChange modify productName:" + newProductName));
                monitorRuleTenantConfig.setProductName(newProductName);
                this.mongoTemplate.save((Object)monitorRuleTenantConfig);
            }
            Integer status = monitorRuleTenantConfig.getStatus();
            this.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.MODIFIED, status != null ? status == 1 : false, null, "MQ", UUID.randomUUID().toString());
        }
        log.info((Object)"=======NoticeWhenMonitorRuleConfigChangeFinish=======");
        return null;
    }

    private List<String> handleEspTenantProduct(String tenantId) {
        JSONObject result = (JSONObject)this.espUtils.getTenantProduct(tenantId, "data.change.sql.get");
        if (result == null || result.getJSONObject("data").getJSONArray("gateway").size() == 0) {
            return Collections.emptyList();
        }
        JSONArray productArray = result.getJSONObject("data").getJSONArray("gateway").getJSONObject(0).getJSONArray("product");
        if (productArray == null) {
            return Collections.emptyList();
        }
        return productArray.stream().map(o -> ((JSONObject)o).getString("name")).collect(Collectors.toList());
    }

    private String handleScript(String monitorRuleId, String productName, List<String> tenantProductList, String tenantVersion) throws DWBusinessException {
        StringBuffer sb = new StringBuffer();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"productName").is((Object)productName).and("monitorRuleId").is((Object)monitorRuleId).and("version").is((Object)tenantVersion);
        query.addCriteria((CriteriaDefinition)criteria);
        MonitorRuleProductConfig productConfig = this.dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        if (null != productConfig && StringUtils.isNotEmpty((CharSequence)productConfig.getScript())) {
            if (!CollectionUtils.isEmpty(tenantProductList) && tenantProductList.contains(productName)) {
                sb.append(productConfig.getScript());
            } else {
                sb.append("select * from (");
                sb.append(productConfig.getScript());
                sb.append(")  tmp where tmp.tenant_id=@#{tenant_id}");
            }
        }
        return sb.toString();
    }
}

