/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.rule.dao;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.service.OperationUnitService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class MonitorRuleTenantConfigDAO {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    private OperationUnitService operationUnitService;

    public MonitorRuleTenantConfig findTenantConfigByRuleIdAndTenantId(String ruleId, String tenantId) throws DWBusinessException {
        return this.findTenantConfigByRuleIdAndTenantIdWithStatus(ruleId, tenantId, 1);
    }

    public MonitorRuleTenantConfig findTenantConfigByRuleIdAndTenantIdWithStatus(String ruleId, String tenantId, Integer status) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"monitorRuleId").is((Object)ruleId).and("tenantId").is((Object)tenantId).and("status").is((Object)status));
        MonitorRuleTenantConfig monitorRuleTenantConfig = (MonitorRuleTenantConfig)this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if (monitorRuleTenantConfig != null) {
            return monitorRuleTenantConfig;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tenantNotEnable", tenantId, ruleId));
    }

    public MonitorRuleTenantConfig findTenantConfigByRuleTenantEoc(String ruleId, String tenantId, EocMapDTO eocMap) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"monitorRuleId").is((Object)ruleId).and("tenantId").is((Object)tenantId);
        criteria = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(eocMap), criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        MonitorRuleTenantConfig monitorRuleTenantConfig = (MonitorRuleTenantConfig)this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if (monitorRuleTenantConfig != null) {
            return monitorRuleTenantConfig;
        }
        throw new DWBusinessException("P.KG.500.0029", I18nUtils.getValue("knowledgegraph.tenantNotEnableWithEoc", tenantId, JSON.toJSONString((Object)eocMap), ruleId));
    }
}

