/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class OperationUnitService {
    public String getEocLevel(Map<String, String> eocMap) {
        OperationUnit operationUnit = this.transToOperationUnit(eocMap);
        return this.getEocLevel(operationUnit);
    }

    public String getEocLevel(OperationUnit operationUnit) {
        if (operationUnit == null || operationUnit.isEmpty()) {
            return null;
        }
        String level = null;
        if (StringUtils.isNotEmpty((CharSequence)operationUnit.getEoc_region_id()) && StringUtils.isEmpty((CharSequence)operationUnit.getEoc_company_id()) && StringUtils.isEmpty((CharSequence)operationUnit.getEoc_site_id())) {
            level = "region";
        }
        if (StringUtils.isEmpty((CharSequence)operationUnit.getEoc_region_id()) && StringUtils.isNotEmpty((CharSequence)operationUnit.getEoc_company_id()) && StringUtils.isNotEmpty((CharSequence)operationUnit.getEoc_site_id())) {
            level = "site";
        }
        if (StringUtils.isEmpty((CharSequence)operationUnit.getEoc_region_id()) && StringUtils.isNotEmpty((CharSequence)operationUnit.getEoc_company_id()) && StringUtils.isEmpty((CharSequence)operationUnit.getEoc_site_id())) {
            level = "company";
        }
        if (operationUnit.getOperation_unit_v2() != null && StringUtils.isNotEmpty((CharSequence)operationUnit.getOperation_unit_v2().getEoc_mapping_id())) {
            level = operationUnit.isRegion() ? null : operationUnit.getOperation_unit_v2().getEoc_mapping_id();
        }
        return level;
    }

    public boolean isEocMatch(Map fieldEocLevelMap, String eocLevel, String product) {
        if (fieldEocLevelMap == null && eocLevel == null) {
            return true;
        }
        if (fieldEocLevelMap != null && eocLevel != null) {
            Object fieldEocLevelObj = fieldEocLevelMap.get(product);
            if (ObjectUtils.isEmpty(fieldEocLevelObj)) {
                fieldEocLevelObj = fieldEocLevelMap.get("");
            }
            return StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(fieldEocLevelObj), (CharSequence)eocLevel);
        }
        return false;
    }

    public Criteria addOperationToCriteria(OperationUnit operationUnit, Criteria criteria) {
        String companyId = null;
        String siteId = null;
        String regionId = null;
        if (operationUnit != null && !operationUnit.isEmpty()) {
            companyId = operationUnit.getEoc_company_id();
            siteId = operationUnit.getEoc_site_id();
            regionId = operationUnit.getEoc_region_id();
        }
        criteria = StringUtils.isNotEmpty(companyId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"operationUnit.eoc_company_id").is((Object)companyId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"operationUnit.eoc_company_id").is(null)});
        criteria = StringUtils.isNotEmpty((CharSequence)siteId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"operationUnit.eoc_site_id").is((Object)siteId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"operationUnit.eoc_site_id").is(null)});
        criteria = StringUtils.isNotEmpty((CharSequence)regionId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"operationUnit.eoc_region_id").is((Object)regionId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"operationUnit.eoc_region_id").is(null)});
        if (operationUnit != null && operationUnit.getOperation_unit_v2() != null && StringUtils.isNotEmpty((CharSequence)operationUnit.getOperation_unit_v2().getEoc_mapping_id())) {
            criteria = new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"operationUnit.operation_unit_v2.eoc_mapping_id").is((Object)operationUnit.getOperation_unit_v2().getEoc_mapping_id())});
        }
        return criteria;
    }

    public Criteria addEocMapToCriteria(OperationUnit operationUnit, Criteria criteria) {
        String companyId = null;
        String siteId = null;
        String regionId = null;
        if (operationUnit != null && !operationUnit.isEmpty()) {
            companyId = operationUnit.getEoc_company_id();
            siteId = operationUnit.getEoc_site_id();
            regionId = operationUnit.getEoc_region_id();
        }
        criteria = StringUtils.isNotEmpty(companyId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocMap.eocCompanyId").is((Object)companyId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocMap.eocCompanyId").is(null)});
        criteria = StringUtils.isNotEmpty((CharSequence)siteId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocMap.eocSiteId").is((Object)siteId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocMap.eocSiteId").is(null)});
        criteria = StringUtils.isNotEmpty((CharSequence)regionId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocMap.eocRegionId").is((Object)regionId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocMap.eocRegionId").is(null)});
        if (operationUnit != null && operationUnit.getOperation_unit_v2() != null && StringUtils.isNotEmpty((CharSequence)operationUnit.getOperation_unit_v2().getEoc_mapping_id())) {
            criteria = new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocMap.operation_unit_v2.eoc_mapping_id").is((Object)operationUnit.getOperation_unit_v2().getEoc_mapping_id())});
        }
        return criteria;
    }

    public Map<String, Object> transToEocMap(OperationUnit operationUnit) {
        HashMap<String, Object> eocMap = new HashMap<String, Object>();
        if (operationUnit != null) {
            eocMap.put("eocCompanyId", StringUtils.isEmpty((CharSequence)operationUnit.getEoc_company_id()) ? "" : operationUnit.getEoc_company_id());
            eocMap.put("eocSiteId", StringUtils.isEmpty((CharSequence)operationUnit.getEoc_site_id()) ? "" : operationUnit.getEoc_site_id());
            eocMap.put("eocRegionId", StringUtils.isEmpty((CharSequence)operationUnit.getEoc_region_id()) ? "" : operationUnit.getEoc_region_id());
            eocMap.put("operationUnitV2", operationUnit.getOperation_unit_v2());
        }
        return eocMap;
    }

    public EocMapDTO transToEocMapDTO(OperationUnit operationUnit) {
        EocMapDTO eocMapDTO = new EocMapDTO();
        if (operationUnit != null) {
            eocMapDTO.setEocCompanyId(operationUnit.getEoc_company_id());
            eocMapDTO.setEocSiteId(operationUnit.getEoc_site_id());
            eocMapDTO.setEocRegionId(operationUnit.getEoc_region_id());
            eocMapDTO.setOperation_unit_v2(operationUnit.getOperation_unit_v2());
        }
        return eocMapDTO;
    }

    public OperationUnit transToOperationUnit(Map<String, String> eocMap) {
        OperationUnit operationUnit = new OperationUnit();
        if (!ObjectUtils.isEmpty(eocMap)) {
            operationUnit.setEoc_company_id(eocMap.get("eocCompanyId"));
            operationUnit.setEoc_site_id(eocMap.get("eocSiteId"));
            operationUnit.setEoc_region_id(eocMap.get("eocRegionId"));
        }
        return operationUnit;
    }

    public OperationUnit transToOperationUnit(EocMapDTO eocMap) {
        OperationUnit operationUnit = new OperationUnit();
        if (!ObjectUtils.isEmpty((Object)eocMap)) {
            operationUnit.setEoc_company_id(eocMap.getEocCompanyId());
            operationUnit.setEoc_site_id(eocMap.getEocSiteId());
            operationUnit.setEoc_region_id(eocMap.getEocRegionId());
            operationUnit.setOperation_unit_v2(eocMap.getOperation_unit_v2());
        }
        return operationUnit;
    }
}

