/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service;

import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.stereotype.Service;

@Service
public class RedisLock {
    private static final String unlockScript = "if redis.call(\"get\",KEYS[1]) == ARGV[1]\nthen\n    return redis.call(\"del\",KEYS[1])\nelse\n    return 0\nend";
    @Autowired
    private StringRedisTemplate redisTemplate;

    public String lock(String name, long expire, long timeout) throws InterruptedException {
        String token;
        long startTime = System.currentTimeMillis();
        do {
            if ((token = this.tryLock(name, expire)) != null) continue;
            if (System.currentTimeMillis() - startTime > timeout - 50L) break;
            Thread.sleep(50L);
        } while (token == null);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryLock(String name, long expire) {
        String token = UUID.randomUUID().toString();
        RedisConnectionFactory factory = this.redisTemplate.getConnectionFactory();
        RedisConnection conn = factory.getConnection();
        try {
            Boolean result = conn.set(name.getBytes(Charset.forName("UTF-8")), token.getBytes(Charset.forName("UTF-8")), Expiration.from((long)expire, (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.SET_IF_ABSENT);
            if (result != null && result.booleanValue()) {
                String string = token;
                return string;
            }
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)conn, (RedisConnectionFactory)factory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String name, String token) {
        byte[][] keysAndArgs = new byte[][]{name.getBytes(Charset.forName("UTF-8")), token.getBytes(Charset.forName("UTF-8"))};
        RedisConnectionFactory factory = this.redisTemplate.getConnectionFactory();
        RedisConnection conn = factory.getConnection();
        try {
            Long result = (Long)conn.scriptingCommands().eval(unlockScript.getBytes(Charset.forName("UTF-8")), ReturnType.INTEGER, 1, (byte[][])keysAndArgs);
            if (result != null && result > 0L) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)conn, (RedisConnectionFactory)factory);
        }
        return false;
    }
}

