/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.dao.ActivityDAO;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IAgileInteractionService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.model.ActivityTemplate;
import com.digiwin.athena.knowledgegraph.service.model.ActivityTemplateDTO;
import com.digiwin.athena.knowledgegraph.service.model.ActivityTemplateRel;
import com.digiwin.athena.knowledgegraph.service.model.QryTemplateListReq;
import com.digiwin.athena.knowledgegraph.synonym.utils.DateUtil;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.KgHttpUtil;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Lang
@Service
public class AgileInteractionServiceImpl
implements IAgileInteractionService {
    private static final Logger log = LoggerFactory.getLogger(AgileInteractionServiceImpl.class);
    public static final String COPY_CUSTOMIZE = "/abi/copy.rpt.customize";
    public static final String DELETE_CUSTOMIZE = "/abi/delete.customize";
    @Value(value="${abiUrl}")
    private String dapUri;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplateUser;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    private DataMapService dataMapService;
    @Autowired
    private Activity2Repository activityRepository;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    private ActivityDAO activityDAO;

    @Override
    public Object getTemplateList(String application, String activityId, String pattern, String targetId, String client) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Application app = this.dataPickService.tenantAppRelation(application, tenantId);
        boolean individualAll = Optional.ofNullable(app).map(Application::getIndividualAll).orElse(false);
        Query systemRelQuery = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("activityId").is((Object)activityId).and("pattern").is((Object)pattern).and("targetId").is((Object)targetId).and("client").is((Object)client).and("version").is((Object)tenantVersion).and("tenantId").is((Object)(individualAll ? tenantId : "SYSTEM")));
        List activityTemplateRelList = this.mongoTemplate.find(systemRelQuery, ActivityTemplateRel.class, "activityTemplateRel");
        if (CollectionUtil.isEmpty((Collection)activityTemplateRelList)) {
            return new ArrayList();
        }
        List codeList = activityTemplateRelList.stream().map(ActivityTemplateRel::getCode).collect(Collectors.toList());
        List<ActivityTemplate> activityTemplateList = new ArrayList<ActivityTemplate>();
        Query systemQuery = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("activityId").is((Object)activityId).and("pattern").is((Object)pattern).and("code").in(codeList).and("client").is((Object)client).and("version").is((Object)tenantVersion).and("tenantId").is((Object)(individualAll ? tenantId : "SYSTEM")));
        List systemActivityTemplateList = this.mongoTemplate.find(systemQuery, ActivityTemplate.class, "activityTemplate");
        if (CollectionUtil.isEmpty((Collection)systemActivityTemplateList)) {
            return new ArrayList();
        }
        activityTemplateList.addAll(systemActivityTemplateList);
        Query tenantIdQuery = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("application").is((Object)application).and("activityId").is((Object)activityId).and("pattern").is((Object)pattern).and("code").in(codeList).and("client").is((Object)client).and("version").is((Object)tenantVersion));
        List tenantActivityTemplateList = this.mongoTemplateUser.find(tenantIdQuery, ActivityTemplate.class, "activityTemplate");
        if (CollectionUtil.isNotEmpty((Collection)tenantActivityTemplateList)) {
            List systemIds = systemActivityTemplateList.stream().map(ActivityTemplate::getUniqueId).collect(Collectors.toList());
            tenantActivityTemplateList = tenantActivityTemplateList.stream().filter(activityTemplate -> systemIds.contains(activityTemplate.getOriginId())).collect(Collectors.toList());
            activityTemplateList.addAll(tenantActivityTemplateList);
        }
        this.handelActivityTemplate(activityTemplateList);
        activityTemplateList = activityTemplateList.stream().filter(activityTemplate -> activityTemplate.getStatus().equals(1)).collect(Collectors.toList());
        List<ActivityTemplateDTO> activityTemplateDTOS = this.setActionParams(activityTemplateList, activityTemplateRelList);
        LanguageUtil.processLocaleLanguage(activityTemplateDTOS, AthenaUtils.getCurrentLocale());
        return activityTemplateDTOS;
    }

    private List<ActivityTemplateDTO> setActionParams(List<ActivityTemplate> activityTemplateList, List<ActivityTemplateRel> activityTemplateRelList) {
        if (CollectionUtil.isEmpty(activityTemplateList)) {
            return new ArrayList<ActivityTemplateDTO>();
        }
        ArrayList<ActivityTemplateDTO> activityTemplateDTOS = new ArrayList<ActivityTemplateDTO>();
        activityTemplateList.stream().forEach(activityTemplate -> {
            ActivityTemplateDTO activityTemplateDTO = new ActivityTemplateDTO();
            BeanUtil.copyProperties((Object)activityTemplate, (Object)activityTemplateDTO, (String[])new String[0]);
            Optional<ActivityTemplateRel> templateRelOptional = activityTemplateRelList.stream().filter(activityTemplateRel -> activityTemplateRel.getCode().equals(activityTemplate.getCode())).findFirst();
            if (templateRelOptional.isPresent()) {
                activityTemplateDTO.setActionParams(templateRelOptional.get().getActionParams());
            }
            activityTemplateDTOS.add(activityTemplateDTO);
        });
        return activityTemplateDTOS;
    }

    @Override
    public Object postTemplateList(QryTemplateListReq qryTemplateListReq) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Application app = this.dataPickService.tenantAppRelation(qryTemplateListReq.getApplication(), tenantId);
        boolean individualAll = Optional.ofNullable(app).map(Application::getIndividualAll).orElse(false);
        List<ActivityTemplate> activityTemplateList = new ArrayList<ActivityTemplate>();
        List systemActivityTemplateList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)qryTemplateListReq.getApplication()).and("pattern").is((Object)qryTemplateListReq.getPattern()).and("client").is((Object)qryTemplateListReq.getClient()).and("version").is((Object)tenantVersion).and("tenantId").is((Object)(individualAll ? tenantId : "SYSTEM"))), ActivityTemplate.class, "activityTemplate");
        if (CollectionUtil.isEmpty((Collection)systemActivityTemplateList)) {
            return activityTemplateList;
        }
        activityTemplateList.addAll(systemActivityTemplateList);
        List tenantActivityTemplateList = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("application").is((Object)qryTemplateListReq.getApplication()).and("pattern").is((Object)qryTemplateListReq.getPattern()).and("client").is((Object)qryTemplateListReq.getClient()).and("version").is((Object)tenantVersion)), ActivityTemplate.class, "activityTemplate");
        if (CollectionUtil.isNotEmpty((Collection)tenantActivityTemplateList)) {
            List systemIds = systemActivityTemplateList.stream().map(ActivityTemplate::getUniqueId).collect(Collectors.toList());
            tenantActivityTemplateList = tenantActivityTemplateList.stream().filter(activityTemplate -> systemIds.contains(activityTemplate.getOriginId())).collect(Collectors.toList());
            activityTemplateList.addAll(tenantActivityTemplateList);
        }
        this.handelActivityTemplate(activityTemplateList);
        activityTemplateList = this.filterActivityTemplate(qryTemplateListReq, activityTemplateList);
        this.convertDateType(activityTemplateList);
        List<ActivityTemplateDTO> activityTemplateDTOS = this.hanleViewData(activityTemplateList);
        LanguageUtil.processLocaleLanguage(activityTemplateDTOS, AthenaUtils.getCurrentLocale());
        return activityTemplateDTOS;
    }

    private void convertDateType(List<ActivityTemplate> activityTemplate) {
        activityTemplate.stream().forEach(activityTemplateDTO -> {
            activityTemplateDTO.setCreateDate(DateUtil.getStringDate(new Date(Long.parseLong(activityTemplateDTO.getCreateDate()))));
            activityTemplateDTO.setEditDate(DateUtil.getStringDate(new Date(Long.parseLong(activityTemplateDTO.getEditDate()))));
        });
    }

    private List<ActivityTemplateDTO> hanleViewData(List<ActivityTemplate> activityTemplateList) throws Exception {
        List basicActivity;
        if (CollectionUtil.isEmpty(activityTemplateList)) {
            return new ArrayList<ActivityTemplateDTO>();
        }
        List activityTemplateDTOS = BeanUtil.copyToList(activityTemplateList, ActivityTemplateDTO.class);
        List taskActivity = activityTemplateDTOS.stream().filter(activityTemplate -> "BUSINESS_PERFORM".equals(activityTemplate.getPattern()) || "BUSINESS_CHARGE".equals(activityTemplate.getPattern())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(taskActivity)) {
            Set taskCodes = taskActivity.stream().map(ActivityTemplateDTO::getActivityId).collect(Collectors.toSet());
            List activityList = this.dataMapService.batchTasks(new ArrayList<String>(taskCodes));
            HashMap<String, JSONObject> activityMap = new HashMap<String, JSONObject>();
            for (JSONObject activity : activityList) {
                activityMap.put(activity.get((Object)"activityId").toString(), activity);
            }
            activityTemplateDTOS.stream().forEach(activityTemplate -> {
                JSONObject activity = (JSONObject)activityMap.get(activityTemplate.getActivityId());
                activityTemplate.setActivityName(activity.getString("name"));
                Map<String, Map<String, String>> lang = activityTemplate.getLang();
                Map activityLang = (Map)activity.get((Object)"lang");
                if (MapUtil.isNotEmpty((Map)activityLang)) {
                    lang.put("activityName", (Map<String, String>)activityLang.get("name"));
                }
                activityTemplate.setLang(lang);
            });
        }
        if (CollectionUtil.isNotEmpty(basicActivity = activityTemplateDTOS.stream().filter(activityTemplate -> "DATA_ENTRY_PERFORM".equals(activityTemplate.getPattern())).collect(Collectors.toList()))) {
            Set basicCodes = basicActivity.stream().map(ActivityTemplateDTO::getActivityId).collect(Collectors.toSet());
            List<Activity> activitys = this.getActivitysByCodes(new ArrayList<String>(basicCodes));
            activityTemplateDTOS.stream().forEach(activityTemplate -> {
                Optional<Activity> activityOptional = activitys.stream().filter(activityConfig -> activityConfig.getCode().equals(activityTemplate.getActivityId())).findFirst();
                if (activityOptional.isPresent()) {
                    Activity activity = activityOptional.get();
                    activityTemplate.setActivityName(activity.getName());
                    Map<String, Map<String, String>> lang = activityTemplate.getLang();
                    Map activityLang = activity.getLang();
                    if (MapUtil.isNotEmpty((Map)activityLang)) {
                        lang.put("activityName", (Map<String, String>)activityLang.get("name"));
                    }
                    activityTemplate.setLang(lang);
                }
            });
        }
        return activityTemplateDTOS;
    }

    private List<ActivityTemplate> filterActivityTemplate(QryTemplateListReq qryTemplateListReq, List<ActivityTemplate> activityTemplateList) {
        if (CollectionUtil.isNotEmpty(qryTemplateListReq.getLocaleList())) {
            activityTemplateList = activityTemplateList.stream().filter(activityTemplate -> qryTemplateListReq.getLocaleList().contains(activityTemplate.getLocale())).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(qryTemplateListReq.getStatusList())) {
            activityTemplateList = activityTemplateList.stream().filter(activityTemplate -> qryTemplateListReq.getStatusList().contains(activityTemplate.getStatus())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)qryTemplateListReq.getName())) {
            String currentLocale = AthenaUtils.getCurrentLocale();
            activityTemplateList = activityTemplateList.stream().filter(activityTemplate -> String.valueOf(((Map)activityTemplate.getLang().get("name")).get(currentLocale)).contains(qryTemplateListReq.getName())).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(activityTemplateList)) {
            activityTemplateList = activityTemplateList.stream().sorted(Comparator.comparing(ActivityTemplate::getEditDate).reversed()).collect(Collectors.toList());
        }
        ArrayList<ActivityTemplate> activityTemplates = new ArrayList<ActivityTemplate>();
        if (CollectionUtil.isNotEmpty(activityTemplateList)) {
            List systemActivityTemplates = activityTemplateList.stream().filter(activityTemplate -> !"TENANT_COPY".equals(activityTemplate.getType())).sorted(Comparator.comparing(ActivityTemplate::getCreateDate)).collect(Collectors.toList());
            activityTemplates.addAll(systemActivityTemplates);
            List tenantCopyActivityTemplates = activityTemplateList.stream().filter(activityTemplate -> "TENANT_COPY".equals(activityTemplate.getType())).sorted(Comparator.comparing(ActivityTemplate::getCreateDate)).collect(Collectors.toList());
            activityTemplates.addAll(tenantCopyActivityTemplates);
        }
        return activityTemplates;
    }

    private void handelActivityTemplate(List<ActivityTemplate> activityTemplateList) {
        activityTemplateList.stream().forEach(activityTemplate -> {
            Optional<ActivityTemplate> optional;
            if ("SYSTEM_EDIT".equals(activityTemplate.getType()) && (optional = activityTemplateList.stream().filter(template -> activityTemplate.getOriginId().equals(template.getUniqueId())).findFirst()).isPresent()) {
                activityTemplate.setName(optional.get().getName());
                activityTemplate.setLang(optional.get().getLang());
                activityTemplate.setCreateDate(optional.get().getCreateDate());
            }
        });
        List systemEdits = activityTemplateList.stream().filter(activityTemplate -> "SYSTEM_EDIT".equals(activityTemplate.getType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(systemEdits)) {
            List ids = systemEdits.stream().map(ActivityTemplate::getOriginId).collect(Collectors.toList());
            activityTemplateList.removeIf(activityTemplate -> ids.contains(activityTemplate.getUniqueId()));
        }
    }

    @Override
    public Object postCopy(ActivityTemplate template) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)template.getUniqueId()).and("version").is((Object)tenantVersion));
        ActivityTemplate activityTemplate = "SYSTEM".equals(template.getType()) ? this.dataPickService.findOneByCondition(Criteria.where((String)"uniqueId").is((Object)template.getUniqueId()), ActivityTemplate.class, "activityTemplate") : (ActivityTemplate)((Object)this.mongoTemplateUser.findOne(query, ActivityTemplate.class, "activityTemplate"));
        if (null != activityTemplate) {
            JSONObject responseJson = this.copyCustomize(activityTemplate.getTemplateId(), template.getName(), activityTemplate.getCode(), activityTemplate.getApplication());
            if (responseJson == null) {
                return this.returnObj(-1, I18nUtils.getValue("knowledgegraph.copyStatementError", new Object[0]), null);
            }
            if (200 != responseJson.getInteger("status")) {
                return this.returnObj(responseJson.getInteger("status"), responseJson.getString("message"), null);
            }
            String resId = responseJson.getString("data");
            if (StringUtils.isNotEmpty((CharSequence)resId)) {
                activityTemplate.setOriginId("SYSTEM".equals(activityTemplate.getType()) ? activityTemplate.getUniqueId() : activityTemplate.getOriginId());
                activityTemplate.setUniqueId(this.generateUniqueId(tenantId, activityTemplate.getApplication(), activityTemplate.getActivityId(), activityTemplate.getPattern(), activityTemplate.getCode(), activityTemplate.getClient(), resId));
                activityTemplate.setTenantId(tenantId);
                activityTemplate.setTemplateId(resId);
                activityTemplate.setType("TENANT_COPY");
                activityTemplate.setStatus(0);
                activityTemplate.setName(template.getName());
                activityTemplate.setLang(template.getLang());
                activityTemplate.setCreateDate(String.valueOf(System.currentTimeMillis()));
                activityTemplate.setCreateBy(AthenaUtils.getUserId());
                activityTemplate.setEditDate(String.valueOf(System.currentTimeMillis()));
                activityTemplate.setEditBy(AthenaUtils.getUserId());
                this.mongoTemplateUser.insert((Object)activityTemplate, "activityTemplate");
            }
        }
        return this.returnObj(200, I18nUtils.getValue("knowledgegraph.success", new Object[0]), null);
    }

    @Override
    public Object postDelete(ActivityTemplate template) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)template.getUniqueId()).and("version").is((Object)tenantVersion));
        ActivityTemplate activityTemplate = (ActivityTemplate)((Object)this.mongoTemplateUser.findOne(query, ActivityTemplate.class, "activityTemplate"));
        if (null != activityTemplate) {
            JSONObject responseJson = this.deleteCustomize(activityTemplate.getTemplateId(), activityTemplate.getCode(), activityTemplate.getApplication());
            if (responseJson == null) {
                return this.returnObj(-1, I18nUtils.getValue("knowledgegraph.deleteStatementError", new Object[0]), null);
            }
            if (200 != responseJson.getInteger("status")) {
                return this.returnObj(responseJson.getInteger("status"), responseJson.getString("message"), null);
            }
            this.mongoTemplateUser.remove(query, "activityTemplate");
        }
        return this.returnObj(200, I18nUtils.getValue("knowledgegraph.success", new Object[0]), null);
    }

    @Override
    public void postEdit(ActivityTemplate template) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)template.getUniqueId()).and("version").is((Object)tenantVersion));
        if ("SYSTEM".equals(template.getType())) {
            ActivityTemplate activityTemplate = this.dataPickService.findOneByCondition(Criteria.where((String)"uniqueId").is((Object)template.getUniqueId()), ActivityTemplate.class, "activityTemplate");
            this.handelSystemEdit(activityTemplate, template);
        } else {
            ActivityTemplate activityTemplate = (ActivityTemplate)((Object)this.mongoTemplateUser.findOne(query, ActivityTemplate.class, "activityTemplate"));
            this.handelTenantEdit(activityTemplate, template);
        }
    }

    public List<Activity> getActivitysByCodes(List<String> activityCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        return this.activityDAO.getReportActivitiesByCode(activityCode, tenantId, tenantVersion);
    }

    private void handelTenantEdit(ActivityTemplate activityTemplate, ActivityTemplate template) throws DWBusinessException {
        if (null == activityTemplate) {
            return;
        }
        Update update = new Update();
        if (null != template.getStatus()) {
            update.set("status", (Object)template.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)template.getName())) {
            update.set("name", (Object)template.getName());
            update.set("lang", (Object)template.getLang());
        }
        update.set("editDate", (Object)String.valueOf(System.currentTimeMillis()));
        update.set("editBy", (Object)AthenaUtils.getUserId());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)template.getUniqueId()).and("version").is((Object)activityTemplate.getVersion()));
        this.mongoTemplateUser.upsert(query, update, "activityTemplate");
    }

    private void handelSystemEdit(ActivityTemplate activityTemplate, ActivityTemplate template) throws DWBusinessException {
        if (null == activityTemplate) {
            return;
        }
        if (null != template.getStatus()) {
            activityTemplate.setStatus(template.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)template.getName())) {
            activityTemplate.setName(template.getName());
            activityTemplate.setLang(template.getLang());
        }
        activityTemplate.setOriginId(activityTemplate.getUniqueId());
        activityTemplate.setUniqueId(this.generateUniqueId(AthenaUtils.getTenantId(), activityTemplate.getApplication(), activityTemplate.getActivityId(), activityTemplate.getPattern(), activityTemplate.getCode(), activityTemplate.getClient(), activityTemplate.getTemplateId()));
        activityTemplate.setTenantId(AthenaUtils.getTenantId());
        activityTemplate.setType("SYSTEM_EDIT");
        activityTemplate.setEditDate(String.valueOf(System.currentTimeMillis()));
        activityTemplate.setEditBy(AthenaUtils.getUserId());
        this.mongoTemplateUser.insert((Object)activityTemplate, "activityTemplate");
    }

    private JSONObject deleteCustomize(String resId, String code, String appCode) {
        JSONObject paramBody = new JSONObject();
        paramBody.put("resid", (Object)resId);
        paramBody.put("program_id", (Object)code);
        paramBody.put("app_id", (Object)appCode);
        String url = this.dapUri + DELETE_CUSTOMIZE + "?@routerKey=" + this.getTenant();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        url = this.addUrlParamFromHeader(request, url, "@ReportKey", "reportKey");
        String token = request.getHeader("token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", token);
        String response = KgHttpUtil.post(url, paramBody.toJSONString(), headers);
        log.info("response---" + response);
        return JSONObject.parseObject((String)response);
    }

    private JSONObject copyCustomize(String resId, String name, String code, String appCode) {
        JSONObject paramBody = new JSONObject();
        paramBody.put("resid", (Object)resId);
        paramBody.put("rptname", (Object)name);
        paramBody.put("program_id", (Object)code);
        paramBody.put("app_id", (Object)appCode);
        String url = this.dapUri + COPY_CUSTOMIZE + "?@routerKey=" + this.getTenant();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        url = this.addUrlParamFromHeader(request, url, "@ReportKey", "reportKey");
        String token = request.getHeader("token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", token);
        String response = KgHttpUtil.post(url, paramBody.toJSONString(), headers);
        log.info("response---" + response);
        return JSONObject.parseObject((String)response);
    }

    private String addUrlParamFromHeader(HttpServletRequest request, String url, String urlParamKey, String headerKey) {
        String value = request.getHeader(headerKey);
        log.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u53c2\u6570headerKey\uff1a{}\uff0cvalue\uff1a{}", (Object)headerKey, (Object)value);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            url = url + "&" + urlParamKey + "=" + value;
        }
        log.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u53c2\u6570url\uff1a{}", (Object)url);
        return url;
    }

    private String getTenant() {
        Map profile = DWServiceContext.getContext().getProfile();
        return profile.getOrDefault("tenantId", "");
    }

    private String generateUniqueId(String tenantId, String application, String activityId, String pattern, String code, String client, String templateId) {
        String input = tenantId + application + activityId + pattern + code + client + templateId;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                hexString.append(String.format("%02x", b));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object returnObj(Integer code, String message, Object object) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("message", message);
        result.put("list", object);
        return result;
    }
}

