/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.log.operation.annotation.DWIgnoreFileLog;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.domain.ApplicationCustomizedConfig;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.app.LicenseKeyManager;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.SelectVariableOptionSetting;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.domain.application.ApplicationMechanism;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaff;
import com.digiwin.athena.knowledgegraph.domain.task.TaskMonitorRule;
import com.digiwin.athena.knowledgegraph.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.AppRelationBatchPo;
import com.digiwin.athena.knowledgegraph.po.InitMonitorRuleGroup;
import com.digiwin.athena.knowledgegraph.po.dap.RespApplication;
import com.digiwin.athena.knowledgegraph.po.dap.RespApplicationCustomizedConfigList;
import com.digiwin.athena.knowledgegraph.po.dap.RespApplicationList;
import com.digiwin.athena.knowledgegraph.po.dap.RespApplicationRelation;
import com.digiwin.athena.knowledgegraph.po.dap.RespApplicationRelationList;
import com.digiwin.athena.knowledgegraph.po.dap.RespMapApplication;
import com.digiwin.athena.knowledgegraph.po.dap.RespMapApplicationList;
import com.digiwin.athena.knowledgegraph.po.dap.RespMapMapOpenWindowDefinition;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.po.dap.RespString;
import com.digiwin.athena.knowledgegraph.po.dap.RespStringList;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.knowledgegraph.service.IAppService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.RequestBody;

@Lang
@Service
@MyExceptionHandler
public class AppService
implements IAppService {
    private static final Logger log = LoggerFactory.getLogger(AppService.class);
    @Autowired
    private LicenseKeyManager licenseKeyManager;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    private IamService iamService;
    @Autowired
    TenantService tenantService;
    @Autowired
    MongoEntityBaseDAO mongoEntityBaseDAO;
    @Autowired
    private MonitorRuleRepository monitorRuleRepository;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private IMechanismService iMechanismService;
    @Autowired
    private ComponentManager componentManager;
    @Autowired
    ActionRepository actionRepository;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    private ESPUtils espUtils;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    AppMetaCaller appMetaCaller;

    @Override
    public ApplicationRelation getApplicationByTypeAndCode(String type, String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("code", code);
        RespApplicationRelation resp = this.appMetaCaller.call("/app/applicationByTypeAndCode", "get", map, RespApplicationRelation.class);
        return resp.getResponse();
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCode(String type, String code, String lang) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("code", code);
        map.put("lang", lang);
        RespApplicationRelation resp = this.appMetaCaller.call("/app/applicationByTypeAndCodeAndLang1", "get", map, RespApplicationRelation.class);
        return resp.getResponse();
    }

    @Override
    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type, Collection<String> codes, Map<String, Activity> activityMap) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("codes", codes);
        map.put("activityMap", activityMap);
        RespMapApplicationList resp = this.appMetaCaller.call("/app/applicationsMapByTypeAndCodesAndActivityMap", "post", map, RespMapApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type, Collection<String> codes) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("codes", codes);
        RespMapApplicationList resp = this.appMetaCaller.call("/app/applicationsMapByTypeAndCodes", "post", map, RespMapApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationByTypeAndCode(String type, List<String> codeList) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("codes", codeList);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationByTypeAndCodeList", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationByTypeAndCode(String type, String subType, List<String> codeList) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("subType", subType);
        map.put("codes", codeList);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationByTypeAndSubTypeAndCodeList", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationsByTypeAndCode(String type, String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("code", code);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationsByTypeAndCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<Application> getApplicationsByCodes(Collection<String> codes) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("codes", codes);
        RespApplicationList resp = this.appMetaCaller.call("/app/applicationsByCodes", "post", map, RespApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public Application getApplicationByCode(String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return this.getApplicationByCode(code, tenantId);
    }

    @Override
    public Application getApplicationByCode(String code, String tenantId) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").is((Object)code);
        return this.dataPickService.findOneByCondition(criteria, tenantId, Application.class, "application");
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByBizCode(String code) throws DWBusinessException {
        Application application = this.getApplicationByCode(code);
        if (null == application) {
            throw new DWBusinessException("app not found");
        }
        return application.getFunctionCtrl();
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByAppCode(String code) throws DWBusinessException {
        FunctionCtrl functionCtrl = new FunctionCtrl();
        functionCtrl.setProjectCardCustomizeFlag(true);
        functionCtrl.setTaskCardCustomizeFlag(true);
        functionCtrl.setTaskCardMergeCustomizeFlag(true);
        return functionCtrl;
    }

    @Override
    public List<Map> getApplicationRecommendations() throws DWBusinessException {
        RespObject resp = this.appMetaCaller.call("/app/applicationRecommendations", "get", null, RespObject.class);
        return (List)resp.getResponse();
    }

    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type, Collection<String> codes, String lang, Map<String, Activity> activityMap) throws DWBusinessException {
        Map<String, List<ApplicationRelation>> applicationRelationsMap = this.getApplicationsMapByTypeAndCodes(type, codes, activityMap);
        HashSet<String> applicationsCodes = new HashSet<String>();
        applicationRelationsMap.values().forEach(item -> {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = this.getApplicationsByCodes(applicationsCodes);
        Map applicationMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> b));
        applicationRelationsMap.forEach((k, v) -> v.forEach(applicationRelation -> {
            Application application = (Application)applicationMap.get(applicationRelation.getAppCode());
            if (application != null) {
                applicationRelation.setCommonApp(Boolean.valueOf(null == application.getCommonApp() ? false : application.getCommonApp()));
            } else {
                applicationRelation.setCommonApp(Boolean.valueOf(false));
            }
            if (application != null && application.getLang() != null) {
                Map nameLangMap = (Map)application.getLang().get("name");
                String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
                applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            }
        }));
        return applicationRelationsMap;
    }

    @Override
    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type, Collection<String> codes, String lang) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("codes", codes);
        map.put("lang", lang);
        RespMapApplicationList resp = this.appMetaCaller.call("/app/applicationRelationsMapByTypeAndCodesAndLang", "post", map, RespMapApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationsByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("code", code);
        map.put("lang", lang);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelationsByTypeAndCodeAndLang", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("code", code);
        map.put("lang", lang);
        RespApplicationRelation resp = this.appMetaCaller.call("/app/applicationByTypeAndCodeAndLang", "get", map, RespApplicationRelation.class);
        return resp.getResponse();
    }

    @Override
    public Map<String, ApplicationRelation> getApplicationRelationsMapByApplicationAndLang(Collection<String> codes, String localeStr) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("codes", codes);
        map.put("localeStr", localeStr);
        RespMapApplication resp = this.appMetaCaller.call("/app/applicationRelationsMapByApplicationAndLang", "post", map, RespMapApplication.class);
        return resp.getResponse();
    }

    @Override
    public ApplicationRelation getApplicationRelationByApplicationAndLang(String code, String localeStr) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        map.put("localeStr", localeStr);
        RespApplicationRelation resp = this.appMetaCaller.call("/app/applicationRelationByApplicationAndLang", "get", map, RespApplicationRelation.class);
        return resp.getResponse();
    }

    @Override
    public Object getLicenseKey(String tenantId) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("tenantId", tenantId);
        RespObject resp = this.appMetaCaller.call("/app/licenseKey", "get", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getLicenseKey(String tenantId, String requestFrom, String key, long timestamp) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("tenantId", tenantId);
        map.put("requestFrom", requestFrom);
        map.put("key", key);
        map.put("timestamp", timestamp);
        RespObject resp = this.appMetaCaller.call("/app/licenseKeyByTenantIdAndRequestFromAndKeyAndTime", "get", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object postSetLicenseKey() throws Exception {
        RespObject resp = this.appMetaCaller.call("/app/setLicenseKey", "post", null, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object postSetLicenseKey(String tenantId) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("tenantId", tenantId);
        RespObject resp = this.appMetaCaller.call("/app/setLicenseKeyByTenantId", "post", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object get(String code) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespObject resp = this.appMetaCaller.call("/app", "get", map, RespObject.class);
        return resp.getResponse();
    }

    protected void processVariable(Application app) throws DWBusinessException {
        List<String> variableList = this.getVariableCode(app.getCode());
        if (variableList != null && !variableList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String code : variableList) {
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (!p.getCategory().toLowerCase(Locale.ROOT).equals("variable") || !p.getKey().equals(code)) continue;
                        existed = true;
                        break;
                    }
                    if (existed) continue;
                    FieldDescription para = this.createVariableParam(code);
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    this.setFieldDescriptionValue(para);
                    app.getParamDescription().add(para);
                }
            } else {
                ArrayList<FieldDescription> paras = new ArrayList<FieldDescription>();
                int seq = 1000;
                for (String code : variableList) {
                    FieldDescription para = this.createVariableParam(code);
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    this.setFieldDescriptionValue(para);
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createVariableParam(String variableCode) throws DWBusinessException {
        return this.createVariableParam(variableCode, null);
    }

    public FieldDescription createVariableParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("variable");
        para.setDataType("string");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsExecute(Boolean.valueOf(true));
        para.setDisplayType("STRING");
        para.setName(variableCode);
        para.setDescription(variableCode);
        this.handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);
        return para;
    }

    public FieldDescription createDefaultParam(String variableCode) throws DWBusinessException {
        return this.createDefaultParam(variableCode, null);
    }

    public FieldDescription createDefaultParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setDataType("object");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsExecute(Boolean.valueOf(true));
        para.setName(variableCode);
        para.setDescription(variableCode);
        FieldDescription fieldDescription = this.handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);
        return fieldDescription == null ? null : para;
    }

    public FieldDescription createLinkParam(String variableCode) throws DWBusinessException {
        return this.createLinkParam(variableCode, null);
    }

    public FieldDescription createLinkParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("link");
        para.setDataType("object");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsExecute(Boolean.valueOf(true));
        para.setDisplayType("LINK");
        para.setName(variableCode);
        para.setDescription(variableCode);
        this.handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);
        return para;
    }

    protected void processMonitorRule(Application app) throws DWBusinessException {
        List<String> ruleList = this.getMonitorRuleCode(app.getCode());
        if (ruleList != null && !ruleList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para;
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (!p.getCategory().toLowerCase(Locale.ROOT).equals("period") || !p.getExtendData().equals(ruleId)) continue;
                        existed = true;
                        break;
                    }
                    if (existed || null == (para = this.createMonitorRuleParam(ruleId, true))) continue;
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    app.getParamDescription().add(para);
                }
            } else {
                ArrayList<FieldDescription> paras = new ArrayList<FieldDescription>();
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para = this.createMonitorRuleParam(ruleId, true);
                    if (null == para) continue;
                    if (para.getSequence() == null) {
                        para.setSequence(Integer.valueOf(seq));
                        seq += 10;
                    }
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix) throws DWBusinessException {
        return this.createMonitorRuleParam(ruleId, keyPrefix, null);
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();
        List<MonitorRule> monitorRules = this.dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion));
        boolean ucRemoved = this.filterUc(monitorRules, tenantId);
        if (monitorRules == null || monitorRules.size() == 0) {
            if (ucRemoved) {
                return null;
            }
            throw new DWBusinessException("P.KG.500.0030", I18nUtils.getValue("knowledgegraph.monitorNotFound", ruleId));
        }
        MonitorRule monitorRule = monitorRules.get(0);
        if (keyPrefix) {
            para.setKey("executeTime-" + ruleId);
        } else {
            para.setKey(ruleId);
        }
        para.setDataType("string");
        para.setCategory("period");
        para.setDisplayType("PERIODIC");
        para.setFormat("rule;yyyyMMdd HH:mm;switch");
        para.setDefaultValue((Object)"D;20210801 12:00;true");
        para.setRequired(Boolean.valueOf(true));
        para.setReadOnly(false);
        para.setIsDesignerSet(monitorRule.getIsDesignerSet());
        para.setIsExecute(Boolean.valueOf(true));
        para.setExtendData(ruleId);
        para.setName(monitorRule.getName());
        para.setDescription(monitorRule.getDescription());
        para.setLang(monitorRule.getLang());
        if (monitorRule.getExecutable() == null) {
            para.setExecutable(Integer.valueOf(1));
        } else {
            para.setExecutable(monitorRule.getExecutable());
        }
        if (StringUtils.isEmpty((CharSequence)monitorRule.getPeriodEnable())) {
            para.setPeriodEnable("M;W;D;H;F;fixInterval");
        } else {
            para.setPeriodEnable(monitorRule.getPeriodEnable());
        }
        this.setEoc(para, ruleId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"category").is((Object)monitorRule.getCategory()));
        InitMonitorRuleGroup initMonitorRuleGroup = (InitMonitorRuleGroup)this.mongoTemplate.findOne(query, InitMonitorRuleGroup.class);
        if (!Objects.isNull(initMonitorRuleGroup)) {
            para.setFormat(initMonitorRuleGroup.getFormat());
            para.setDefaultValue((Object)initMonitorRuleGroup.getDefaultValue());
            para.setExecutable(initMonitorRuleGroup.getExecutable());
        }
        this.handleParaFromVariD(ruleId, tenantVersion, para, variableDefinitionsMap);
        return para;
    }

    private boolean filterUc(List<MonitorRule> activities, String tenantId) {
        boolean removed = false;
        Iterator<MonitorRule> activityIterator = activities.iterator();
        ArrayList<String> ucCodes = new ArrayList<String>();
        while (activityIterator.hasNext()) {
            MonitorRule activity = activityIterator.next();
            if (null == activity.getInclusionTenant()) continue;
            if (!activity.getInclusionTenant().contains(tenantId)) {
                activityIterator.remove();
                removed = true;
                continue;
            }
            if (!activity.getCode().startsWith("UC_")) continue;
            ucCodes.add(activity.getCode().replace("UC_", ""));
        }
        return removed;
    }

    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para) throws DWBusinessException {
        return this.handleParaFromVariD(code, tenantVersion, para, null);
    }

    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        VariableDefinition def = null;
        if (variableDefinitionsMap == null || !variableDefinitionsMap.containsKey(code)) {
            Query query = new Query();
            Criteria criteria = Criteria.where((String)"code").in(new Object[]{code});
            query.addCriteria((CriteriaDefinition)criteria);
            def = this.dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
        } else {
            def = variableDefinitionsMap.get(code);
        }
        if (def != null) {
            Application application;
            if (StringUtils.isNotEmpty((CharSequence)def.getApplication()) && Boolean.TRUE.equals((application = this.getApplicationByCode(def.getApplication())).getIndividualAll()) && "SYSTEM".equals(def.getTenantId())) {
                return null;
            }
            LoginInfo loginInfo = KgFilter.getLoginInfo();
            if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty((CharSequence)def.getApplication())) {
                loginInfo.setApplication(def.getApplication());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getName())) {
                para.setName(def.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDescription())) {
                para.setDescription(def.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDataType())) {
                para.setDataType(def.getDataType());
            }
            if (!ObjectUtils.isEmpty((Object)def.getDefaultValue())) {
                para.setDefaultValue(def.getDefaultValue());
            }
            if (def.getIsOperation() != null) {
                para.setIsOperation(def.getIsOperation());
            }
            if (def.getEocLevel() != null && !def.getEocLevel().isEmpty()) {
                para.setEocLevel(def.getEocLevel());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getExtendData())) {
                para.setExtendData(def.getExtendData());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDisplayType())) {
                para.setDisplayType(def.getDisplayType());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getDisplayFormat())) {
                para.setDisplayFormat(def.getDisplayFormat());
            }
            if (!ObjectUtils.isEmpty((Object)def.getValueDisplay())) {
                para.setValueDisplay(def.getValueDisplay());
            }
            if (def.getIsSimulation() != null) {
                para.setIsSimulation(def.getIsSimulation());
            }
            if (def.getIsExecute() != null) {
                para.setIsExecute(def.getIsExecute());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getExecuteName())) {
                para.setExecuteName(def.getExecuteName());
            }
            if (def.getReadOnly() != null) {
                para.setReadOnly(def.getReadOnly().booleanValue());
            }
            if (def.getRequired() != null) {
                para.setRequired(def.getRequired());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getPeriodEnable())) {
                para.setPeriodEnable(def.getPeriodEnable());
            }
            if (def.getExecutable() != null) {
                para.setExecutable(def.getExecutable());
            }
            if (def.getSequence() != null) {
                para.setSequence(def.getSequence());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getValidateScript())) {
                para.setValidateScript(def.getValidateScript());
            }
            if (!Objects.isNull(def.getSelectVariableOptionSetting())) {
                para.setOptions(this.getOptionsFromApi(def.getSelectVariableOptionSetting()));
            } else if (!ObjectUtils.isEmpty((Object)def.getOptions())) {
                para.setOptions(def.getOptions());
            }
            if (def.getParamVisble() != null && !def.getParamVisble().isEmpty()) {
                para.setParamVisble(def.getParamVisble());
            }
            if (def.getParamVisbleScope() != null && !def.getParamVisbleScope().isEmpty()) {
                para.setParamVisbleScope(def.getParamVisbleScope());
            }
            if (def.getParamDisable() != null && !def.getParamDisable().isEmpty()) {
                para.setParamDisable(def.getParamDisable());
            }
            if (def.getParamDisableScope() != null && !def.getParamDisableScope().isEmpty()) {
                para.setParamDisableScope(def.getParamDisableScope());
            }
            if (def.getColspan() != null) {
                para.setColspan(def.getColspan().intValue());
            }
            if (!ObjectUtils.isEmpty((Object)def.getDynamicCondition())) {
                para.setDynamicCondition(def.getDynamicCondition());
            }
            if (!ObjectUtils.isEmpty((Object)def.getFieldMappings())) {
                para.setFieldMappings(def.getFieldMappings());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getMechanismCode())) {
                para.setMechanismCode(def.getMechanismCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getCategory())) {
                para.setCategory(def.getCategory());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getGroup())) {
                para.setGroup(def.getGroup());
            }
            if (def.getLang() != null && !def.getLang().isEmpty()) {
                para.setLang(def.getLang());
            }
            if (!ObjectUtils.isEmpty((Object)def.getVisibleCondition())) {
                para.setVisibleCondition(def.getVisibleCondition());
            }
            if (def.getFieldOpenWindowMap() != null && !def.getFieldOpenWindowMap().isEmpty()) {
                para.setFieldOpenWindowMap(def.getFieldOpenWindowMap());
            }
            if (!ObjectUtils.isEmpty((Object)def.getDisplayTypeDefinition())) {
                para.setDisplayTypeDefinition(def.getDisplayTypeDefinition());
            }
            if (!ObjectUtils.isEmpty((Object)def.getForceOpen())) {
                para.setForceOpen(def.getForceOpen());
            }
            if (!ObjectUtils.isEmpty((Object)def.getValue())) {
                para.setValue(def.getValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getFrom())) {
                para.setFrom(def.getFrom());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getTarget())) {
                para.setTarget(def.getTarget());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getFormat())) {
                para.setFormat(def.getFormat());
            }
            if (!ObjectUtils.isEmpty((Object)def.getMax())) {
                para.setMax(def.getMax());
            }
            if (!ObjectUtils.isEmpty((Object)def.getMin())) {
                para.setMin(def.getMin());
            }
            if (!ObjectUtils.isEmpty((Object)def.getStep())) {
                para.setStep(def.getStep());
            }
            if (!ObjectUtils.isEmpty(def.getLinkKey())) {
                para.setLinkKey(def.getLinkKey());
            }
            if (!ObjectUtils.isEmpty((Object)def.getLinkOptions())) {
                para.setLinkOptions(def.getLinkOptions());
            }
            if (StringUtils.isNotEmpty((CharSequence)def.getPrecision())) {
                para.setPrecision(def.getPrecision());
            }
            if (!ObjectUtils.isEmpty(def.getRestrictions())) {
                para.setRestrictions(def.getRestrictions());
            }
            if (!ObjectUtils.isEmpty(def.getFilters())) {
                para.setFilters(def.getFilters());
            }
            if (!ObjectUtils.isEmpty((Object)def.getIsSingleOperation())) {
                para.setIsSingleOperation(def.getIsSingleOperation());
            }
            if (!ObjectUtils.isEmpty((Object)def.getOpenWindowTip())) {
                para.setOpenWindowTip(def.getOpenWindowTip());
            }
            para.setValueComputed(MapUtils.isNotEmpty(def.getValueComputed()) ? def.getValueComputed() : null);
            para.setIsTop(Optional.ofNullable(def.getIsTop()).orElse(false));
            para.setLinkageParamEvent(def.getLinkageParamEvent());
            return para;
        }
        return null;
    }

    private Object getOptionsFromApi(SelectVariableOptionSetting setting) throws DWBusinessException {
        if ("ESP".equalsIgnoreCase(setting.getOptionApiType())) {
            try {
                Map<String, Object> result = this.espUtils.execute(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), setting.getOptionApi(), Optional.ofNullable(setting.getOptionApiParams()).orElse(Collections.emptyMap()));
                Map<String, Object> config = setting.getConfig();
                String label = MapUtils.getString(config, (Object)"label");
                String value = MapUtils.getString(config, (Object)"value");
                String dataKey = MapUtils.getString(config, (Object)"dataKey");
                Object data = result.get(dataKey);
                if (!(data instanceof List)) {
                    return Collections.emptyList();
                }
                JSONArray optionData = (JSONArray)data;
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)optionData)) {
                    return Collections.emptyList();
                }
                List collect = optionData.stream().map(o -> {
                    JSONObject jsonObject = (JSONObject)o;
                    return new JSONObject().fluentPut("label", jsonObject.get((Object)label)).fluentPut("value", jsonObject.get((Object)value));
                }).collect(Collectors.toList());
                String translateStr = this.translateUtils.translateContent(collect);
                return JSONArray.parseArray((String)translateStr);
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u4e0b\u62c9\u63a7\u4ef6\u9009\u9879\u5217\u8868\u51fa\u9519\uff1a{}", (Object)e.getMessage());
                throw new DWBusinessException(e.getMessage());
            }
        }
        return null;
    }

    private void setEoc(FieldDescription para, String ruleId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Criteria criteria = Criteria.where((String)"monitorRuleId").in(new Object[]{ruleId}).and("version").is((Object)tenantVersion);
        List<MonitorRuleProductConfig> configs = this.dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        if (configs != null && !configs.isEmpty()) {
            boolean isOperation = false;
            HashMap<String, String> eoc = new HashMap<String, String>();
            for (MonitorRuleProductConfig c : configs) {
                if (!StringUtils.isNotEmpty((CharSequence)c.getEocLevel())) continue;
                eoc.put(c.getProductName(), c.getEocLevel());
                isOperation = true;
            }
            if (isOperation) {
                para.setEocLevel(eoc);
                para.setIsOperation(Boolean.valueOf(true));
            }
        }
    }

    @Override
    public Object getList(Set<String> applicationCodeList) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("applicationCodeList", applicationCodeList);
        RespObject resp = this.appMetaCaller.call("/app/list", "post", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getByNameAndTags(String applicationName, List<String> tags) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("applicationName", applicationName);
        map.put("tags", tags);
        RespObject resp = this.appMetaCaller.call("/app/byNameAndTags", "post", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getApplicationMechanismByApplicationCode(String applicationCode) throws Exception {
        ArrayList<ApplicationMechanism> result = new ArrayList<ApplicationMechanism>();
        List<String> relations = this.getMechanismCode(applicationCode);
        for (String c : relations) {
            ApplicationMechanism am = new ApplicationMechanism();
            am.setApplicationCode(applicationCode);
            am.setMechanismCode(c);
            result.add(am);
        }
        return result;
    }

    @Override
    public Object postApplicationMechanismByApplicationCodes(List<String> applicationCodes) throws Exception {
        List<String> appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        ArrayList<String> finalAppCodes = new ArrayList<String>(applicationCodes);
        finalAppCodes.retainAll(appCodes);
        StopWatch relationTime = new StopWatch();
        relationTime.start();
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(finalAppCodes, "mechanism", null, null, null);
        relationTime.stop();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(relations)) {
            return null;
        }
        List<String> codeList = relations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        return this.iMechanismService.postQueryMechanismByCode(codeList, null, (Boolean)false);
    }

    @Override
    public Object getApplicationMechanismByMechanismCode(String mechanismCode) throws Exception {
        ArrayList<ApplicationMechanism> result = new ArrayList<ApplicationMechanism>();
        List<ApplicationRelation> relations = this.getAppCodeByMechanismCode(mechanismCode);
        for (ApplicationRelation r : relations) {
            ApplicationMechanism am = new ApplicationMechanism();
            am.setMechanismCode(mechanismCode);
            am.setApplicationCode(r.getAppCode());
            result.add(am);
        }
        return result;
    }

    @Override
    public Application getApplicationInfo(String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespApplication resp = this.appMetaCaller.call("/app/applicationInfo", "get", map, RespApplication.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getTaskCode(String appCode) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("appCode", appCode);
        RespStringList resp = this.appMetaCaller.call("/app/taskCode", "get", map, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getMechanismCode(String appCode) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("appCode", appCode);
        RespStringList resp = this.appMetaCaller.call("/app/mechanismCode", "get", map, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getMonitorRuleCode(String appCode) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("appCode", appCode);
        RespStringList resp = this.appMetaCaller.call("/app/monitorRuleCode", "get", map, RespStringList.class);
        return resp.getResponse();
    }

    public List<String> getMonitorRuleCode(String appCode, String tenantId) throws DWBusinessException {
        tenantId = StringUtils.isEmpty((CharSequence)tenantId) ? AthenaUtils.getTenantId() : tenantId;
        ArrayList<String> codes = new ArrayList<String>();
        List<String> appCodes = this.tenantService.getAppCodes(tenantId);
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "monitorRule", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        Application application = this.getApplicationByCode(appCode, tenantId);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"period", (CharSequence)fieldDescription.getCategory()) || !StringUtils.isNotEmpty((CharSequence)fieldDescription.getExtendData()) || codes.contains(fieldDescription.getExtendData())) continue;
            codes.add(fieldDescription.getExtendData());
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String appCode, String version) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "monitorRule", null, null, version);
        relations.forEach(r -> codes.add(r.getCode()));
        Application application = this.getApplicationByCode(appCode);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"period", (CharSequence)fieldDescription.getCategory()) || !StringUtils.isNotEmpty((CharSequence)fieldDescription.getExtendData()) || codes.contains(fieldDescription.getExtendData())) continue;
            codes.add(fieldDescription.getExtendData());
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String version) throws DWBusinessException {
        List<String> codes = new ArrayList<String>();
        List<MonitorRule> monitorRules = this.monitorRuleRepository.getCommonByVersion(version);
        if (!CollectionUtils.isEmpty(monitorRules)) {
            codes = monitorRules.stream().map(CodedEntity::getCode).collect(Collectors.toList());
        }
        return codes;
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationsByCodesAndType(@RequestBody ApplicationRelationQueryDTO applicationRelationQueryDTO) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("applicationRelationQueryDTO", applicationRelationQueryDTO);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelationsByCodesAndType", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByTaskCode(String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/appCodeByTaskCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMechanismCode(String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/appCodeByMechanismCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMonitorRuleCode(String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/appCodeByMonitorRuleCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    private void proccessAppNameLanguage(List<ApplicationRelation> relations) throws DWBusinessException {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relations)) {
            for (ApplicationRelation i : relations) {
                Application app = this.getApplicationInfo(i.getAppCode());
                if (app == null) continue;
                i.setAppName(app.getName());
                Map appLang = app.getLang();
                if (appLang == null) continue;
                if (i.getLang() != null) {
                    i.getLang().put("appName", appLang.get("name"));
                    continue;
                }
                HashMap lang = new HashMap();
                lang.put("appName", appLang.get("name"));
                i.setLang(lang);
            }
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelation(List<String> codes, String tenantVersion) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("codes", codes);
        map.put("tenantVersion", tenantVersion);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelationByCodesAndTenantVersion", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelation(List<String> appCodes, List<String> codes, String type, String subType) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("appCodes", appCodes);
        map.put("codes", codes);
        map.put("type", type);
        map.put("subType", subType);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelationByAppCodesAndCodesAndTypeAndSubType", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> postApplicationRelation(List<String> appCodes) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("appCodes", appCodes);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelation", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getFlowCode(String appCode) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("appCode", appCode);
        RespStringList resp = this.appMetaCaller.call("/app/flowCode", "get", map, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByFlowCode(String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/appCodeByFlowCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getVariableCode(String appCode) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("appCode", appCode);
        RespStringList resp = this.appMetaCaller.call("/app/variableCode", "get", map, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getAllAppCode() throws DWBusinessException {
        RespStringList resp = this.appMetaCaller.call("/app/allAppCode", "get", null, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getNotCommonAppCode() throws DWBusinessException {
        Query query = new Query();
        query.fields().include("code");
        List app = this.mongoTemplate.find(query, Application.class);
        List<String> collect = app.stream().filter(item -> null == item.getCommonApp() || false == item.getCommonApp()).map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<String> getMonitorRulesRelatedToTask(String appCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        ArrayList<String> result = new ArrayList<String>();
        List<String> taskCodList = this.getTaskCode(appCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(taskCodList)) {
            for (String taskCode : taskCodList) {
                Query query = new Query();
                Criteria criteria = Criteria.where((String)"taskCode").is((Object)taskCode).and("version").is((Object)tenantVersion);
                query.addCriteria((CriteriaDefinition)criteria);
                List taskMechanism = this.mongoTemplate.find(query, TaskMonitorRule.class, "taskMonitorRule");
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)taskMechanism)) continue;
                List collect = taskMechanism.stream().map(TaskMonitorRule::getMonitorRuleCode).collect(Collectors.toList());
                result.addAll(collect);
            }
        }
        return result;
    }

    @Override
    public Map<String, List> postQueryDigitalStaffByCode(Set<String> codeList, Set<String> enhanceCodeList) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        HashMap<String, List> re = new HashMap<String, List>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codeList)) {
            return re;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(enhanceCodeList)) {
            return re;
        }
        Criteria criteria = Criteria.where((String)"code").in(enhanceCodeList).and("extendType").is((Object)"digitalStaff");
        List<Application> enhanceApp = this.dataPickService.find(criteria, Application.class, "application");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(enhanceApp)) {
            return re;
        }
        HashMap<String, String> enhanceStaff = new HashMap<String, String>();
        HashMap<String, String> enhanceName = new HashMap<String, String>();
        ArrayList<String> staffCodeList = new ArrayList<String>();
        for (Application i : enhanceApp) {
            enhanceStaff.put(i.getCode(), i.getExtendData());
            enhanceName.put(i.getCode(), i.getName());
            if (staffCodeList.contains(i.getExtendData())) continue;
            staffCodeList.add(i.getExtendData());
        }
        Query query = new Query();
        query.fields().include("code");
        query.fields().include("name");
        criteria = Criteria.where((String)"code").in(staffCodeList).and("version").is((Object)tenantVersion);
        query.addCriteria((CriteriaDefinition)criteria);
        List digitalStaffs = this.mongoTemplate.find(query, DigitalStaff.class);
        HashMap<String, String> staffName = new HashMap<String, String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)digitalStaffs)) {
            for (DigitalStaff digitalStaff : digitalStaffs) {
                staffName.put(digitalStaff.getCode(), digitalStaff.getName());
            }
        }
        for (Map.Entry entry : enhanceStaff.entrySet()) {
            enhanceStaff.put((String)entry.getKey(), (String)staffName.get(entry.getValue()));
        }
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(new ArrayList<String>(codeList), "enhance", null, null, null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relations)) {
            for (ApplicationRelation i : relations) {
                if (!enhanceCodeList.contains(i.getCode())) continue;
                if (re.containsKey(i.getAppCode())) {
                    HashMap tmp = new HashMap();
                    tmp.put("staff", enhanceStaff.get(i.getCode()));
                    tmp.put("job", enhanceName.get(i.getCode()));
                    ((List)re.get(i.getAppCode())).add(tmp);
                    continue;
                }
                ArrayList lst = new ArrayList();
                HashMap tmp = new HashMap();
                tmp.put("staff", enhanceStaff.get(i.getCode()));
                tmp.put("job", enhanceName.get(i.getCode()));
                lst.add(tmp);
                re.put(i.getAppCode(), lst);
            }
        }
        return re;
    }

    public List<String> getEnhanceCodeByAppCode(String appCode, String version) throws DWBusinessException {
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(appCode, "enhance", null, null, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(relations)) {
            return new ArrayList<String>();
        }
        return relations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
    }

    @Override
    public List<Application> getEnhanceByAppCode(String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<Application> apps = new ArrayList<Application>();
        List<ApplicationRelation> relations = this.dataPickService.applicationRelations(code, "enhance", null, null, null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relations)) {
            HashSet<String> appCode = new HashSet<String>();
            for (ApplicationRelation i : relations) {
                appCode.add(i.getCode());
            }
            Query query = new Query();
            Criteria criteria = Criteria.where((String)"code").in(appCode).and("category").is((Object)"enhance");
            query.addCriteria((CriteriaDefinition)criteria);
            apps = this.dataPickService.find(criteria, Application.class, "application");
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(apps)) {
                HashSet<String> staffCode = new HashSet<String>();
                for (Application i : apps) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"digitalstaff", (CharSequence)i.getExtendType())) continue;
                    staffCode.add(i.getExtendData());
                }
                query = new Query();
                criteria = Criteria.where((String)"code").in(staffCode).and("version").is((Object)tenantVersion);
                query.addCriteria((CriteriaDefinition)criteria);
                List staffs = this.mongoTemplate.find(query, DigitalStaff.class);
                HashMap<String, String> staffName = new HashMap<String, String>();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)staffs)) {
                    for (DigitalStaff digitalStaff : staffs) {
                        staffName.put(digitalStaff.getCode(), digitalStaff.getName());
                    }
                }
                for (Application application : apps) {
                    application.setExtendDisplay((String)staffName.get(application.getExtendData()));
                    HashMap<String, Map<String, String>> openWin = new HashMap<String, Map<String, String>>();
                    for (FieldDescription p : application.getParamDescription()) {
                        if (p.getFieldOpenWindowMap() == null || p.getFieldOpenWindowMap().isEmpty()) continue;
                        HashMap<String, String> map = new HashMap<String, String>();
                        for (FieldOpenWindowSetting setting : p.getFieldOpenWindowMap()) {
                            map.put(setting.getColumn(), setting.getOpenWindowKey());
                        }
                        openWin.put(p.getKey(), map);
                    }
                    Map<String, Map<String, OpenWindowDefinition>> openWinInfo = this.postOpenWinInfo(openWin);
                    for (FieldDescription p : application.getParamDescription()) {
                        Map<String, OpenWindowDefinition> temp = openWinInfo.get(p.getKey());
                        p.setFieldOpenWindowDefinitions(temp);
                    }
                }
            }
        }
        return apps;
    }

    @Override
    public List<Application> getEnhanceByMechanismCode(String code) throws DWBusinessException {
        List<Application> apps = new ArrayList<Application>();
        List<ApplicationRelation> relations = this.getAppCodeByMechanismCode(code);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relations)) {
            String appCode = relations.get(0).getAppCode();
            apps = this.getEnhanceByAppCode(appCode);
        }
        return apps;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByTypeAndCode(String type, String code) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("code", code);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/appCodeByTypeAndCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getParadigmByTypeAndAppCode(String type, String appCode) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("appCode", appCode);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/paradigmByTypeAndAppCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public Map<String, Map<String, OpenWindowDefinition>> postOpenWinInfo(Map<String, Map<String, String>> openWin) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("openWin", openWin);
        RespMapMapOpenWindowDefinition resp = this.appMetaCaller.call("/app/openWinInfo", "post", map, RespMapMapOpenWindowDefinition.class);
        return resp.getResponse();
    }

    @Override
    public String getAppCodeByApplication(String application) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("application", application);
        RespString resp = this.appMetaCaller.call("/app/appCodeByApplication", "get", map, RespString.class);
        return resp.getResponse();
    }

    public Map<String, String> getAppCodeByApplication() throws DWBusinessException {
        Criteria criteria = new Criteria();
        List<ApplicationRelation> applicationRelationList = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return applicationRelationList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getApplication()) && StringUtils.isNotEmpty((CharSequence)e.getAppCode())).collect(Collectors.toMap(TenantObject::getApplication, ApplicationRelation::getAppCode, (a, b) -> a));
    }

    public void checkRelatedAppHasExpired(String type, String code) throws DWBusinessException {
        List<ApplicationRelation> applicationRelations = this.getApplicationRelationsByTypeAndCodeAndLang(type, code, AthenaUtils.getCurrentLocale());
        List<String> appCodes = this.tenantService.getAppCodes();
        List collect = applicationRelations.stream().filter(e -> !appCodes.contains(e.getAppCode())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collect) && collect.size() == applicationRelations.size()) {
            throw new DWBusinessException("RELATED_APP_EXPIRED", ((ApplicationRelation)collect.get(0)).getAppName());
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, String appCode) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("appCode", appCode);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelationByTypeAndAppCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCodeAndVersion(String type, String appCode, String version) throws Exception {
        ArrayList applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, null, null);
        return org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, List<String> appCodes) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("appCodes", appCodes);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelationByTypeAndAppCodes", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> postQueryApplicationRelationByTypeAndAppCode(String type, List<String> appCodes) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("type", type);
        map.put("appCodes", appCodes);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/queryApplicationRelationByTypeAndAppCode", "post", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String tenantId, String type, String appCode) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("tenantId", tenantId);
        map.put("type", type);
        map.put("appCode", appCode);
        RespApplicationRelationList resp = this.appMetaCaller.call("/app/applicationRelationByTenantIdAndTypeAndAppCode", "get", map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public Object postAppRelationUpdate(AppRelationBatchPo request) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("request", request);
        RespObject resp = this.appMetaCaller.call("/app/appRelationUpdate", "post", map, RespObject.class);
        return resp.getResponse();
    }

    public List<String> getNeedUserCheckApp(String tenantId) throws DWBusinessException {
        String tenantVersion = "2.0";
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            try {
                tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
            }
            catch (Exception e2) {
                log.error("getNeedUserCheckApp tenantId:{},e:{}", (Object)tenantId, (Object)e2);
            }
        }
        List<String> appCodes = this.tenantService.getAppCodes(tenantId);
        Set appCodesSet = appCodes.stream().collect(Collectors.toSet());
        Query query = new Query();
        query.fields().include("code").include("feature");
        Criteria criteria = Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(appCodesSet);
        query.addCriteria((CriteriaDefinition)criteria);
        List all = this.mongoTemplate.find(query, Application.class);
        all = this.dataPickService.excludeWithSameCode(all);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(all)) {
            return Collections.emptyList();
        }
        List<String> collect = all.stream().filter(e -> appCodesSet.contains(e.getCode()) && this.needNeedUserCheck((Application)e)).map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        return collect;
    }

    private boolean needNeedUserCheck(Application application) {
        return application.getFeature() == null || application.getFeature().get("userIntegrityCheck") == null || Boolean.parseBoolean(String.valueOf(application.getFeature().get("userIntegrityCheck")));
    }

    public void setFieldDescriptionValue(FieldDescription para) throws DWBusinessException {
        if ("GROUP".equalsIgnoreCase(para.getDisplayType())) {
            ArrayList<FieldDescription> childFieldDescriptions = new ArrayList<FieldDescription>();
            List codeList = (List)para.getDefaultValue();
            for (String code : codeList) {
                FieldDescription childFieldDescription = this.createVariableParam(code);
                childFieldDescriptions.add(childFieldDescription);
            }
            para.setParameters(childFieldDescriptions);
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByType(String type) throws Exception {
        Criteria criteria = Criteria.where((String)"type").is((Object)type);
        List<ApplicationRelation> applicationRelationList = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return org.apache.commons.collections.CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList() : this.dataPickService.filterApplicationRelations(applicationRelationList);
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByApplicationCustomized() {
        RespApplicationCustomizedConfigList resp = this.appMetaCaller.call("/app/configByApplicationCustomized", "post", null, RespApplicationCustomizedConfigList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByGroupApplicationCustomized() {
        RespApplicationCustomizedConfigList resp = this.appMetaCaller.call("/app/configByGroupApplicationCustomized", "post", null, RespApplicationCustomizedConfigList.class);
        return resp.getResponse();
    }

    @Override
    public List<Application> postAllApplications() {
        RespApplicationList resp = this.appMetaCaller.call("/app/allApplications", "post", null, RespApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public Object postApplicationRelationByTypeAndCode(String tenantId, String type, String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("tenantId", tenantId);
        map.put("type", type);
        map.put("code", code);
        RespObject resp = this.appMetaCaller.call("/app/applicationRelationByTypeAndCode", "post", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object postApplicationRelationByDDSM(AppRelationBatchPo request) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("request", request);
        RespObject resp = this.appMetaCaller.call("/app/applicationRelationByDDSM", "post", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public List<Map<String, String>> postQueryApplicationsNameByCodeList(List<String> codes, Integer appType) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").in(codes).and("appType").is((Object)appType);
        List applications = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), Application.class);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applications)) {
            return result;
        }
        applications.forEach(app -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("code", app.getCode());
            data.put("name", app.getName());
            data.put("version", app.getVersion());
            result.add(data);
        });
        return result;
    }

    @Override
    public Application getAppByMechanismCode(String mechanismCode) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("mechanismCode", mechanismCode);
        RespApplication resp = this.appMetaCaller.call("/app/appByMechanismCode", "get", map, RespApplication.class);
        return resp.getResponse();
    }

    @Override
    public Application getAppByActivityId(String activityId) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("activityId", activityId);
        RespApplication resp = this.appMetaCaller.call("/app/appByActivityId", "get", map, RespApplication.class);
        return resp.getResponse();
    }

    @Cache(namespace="knowledgegraph", key="getActivityCode$0", ttlSecs=86400L)
    public List<String> getActivityCode(String tenantId) throws DWBusinessException {
        List<String> appCodes = this.tenantService.getAppCodes(tenantId);
        Criteria criteria = Criteria.where((String)"type").in(new Object[]{"task", "activity"}).and("appCode").in(appCodes);
        List<ApplicationRelation> relations = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return relations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
    }

    @Override
    public Object postQueryApplicationsByCodes(Set<String> codes) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List applications = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(codes)), Map.class, "application");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applications)) {
            return Collections.emptyMap();
        }
        return applications.stream().collect(Collectors.toMap(app -> (String)app.get("code"), app -> app));
    }
}

