/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.authority.ActionVO;
import com.digiwin.athena.kg.authority.AppAuthorizationsResponse;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.kg.authority.AppVO;
import com.digiwin.athena.kg.authority.AuthorityConfigVO;
import com.digiwin.athena.kg.authority.ConditionVO;
import com.digiwin.athena.kg.authority.ModuleVO;
import com.digiwin.athena.kg.authority.SimpleUser;
import com.digiwin.athena.kg.authority.app.AppDetailInfo;
import com.digiwin.athena.kg.authority.app.AuthorityAction;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.clients.GMCService;
import com.digiwin.athena.knowledgegraph.component.dao.TenantAppComponentListDAO;
import com.digiwin.athena.knowledgegraph.dao.ActivityDAO;
import com.digiwin.athena.knowledgegraph.domain.Task;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IAuthorityService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import com.luhuiguo.chinese.ChineseUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Lang
@Service
public class AuthorityService
implements IAuthorityService {
    private static final Logger log = LoggerFactory.getLogger(AuthorityService.class);
    private static final String REPORT_CODE = "report";
    private static final String REPORT_NAME = "\u62a5\u8868";
    private static final String BASIC_DATA_ENTRY_CODE = "basicDataEntry";
    private static final String BASIC_DATA_ENTRY_NAME = "\u4e1a\u52a1\u6570\u636e\u5f55\u5165";
    private static final String START_PROJECT_CODE = "startProject";
    private static final String START_PROJECT_NAME = "\u53d1\u8d77\u9879\u76ee";
    @Autowired
    private GMCService gmcService;
    @Autowired
    private CacService cacService;
    @Autowired
    private IamService iamService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    Activity2Repository activity2Repository;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    private TenantAppComponentListDAO tenantAppComponentListDAO;
    @Autowired
    private ActivityDAO activityDAO;

    @Override
    public Object postStartProjectAuthorityByAppCode(String appCode) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"authorityPrefix").is((Object)(appCode + ":" + START_PROJECT_CODE)));
        List taskList = this.mongoTemplate.find(query, Task.class, "taskConfigs");
        try {
            HashMap<String, String> query1 = new HashMap<String, String>();
            query1.put("authorityPrefix", appCode + ":" + START_PROJECT_CODE);
            List datamapTasks = this.dataMapService.getProjectsByAuthorityPrefix(appCode + ":" + START_PROJECT_CODE);
            if (!CollectionUtils.isEmpty((Collection)datamapTasks)) {
                datamapTasks.forEach(task -> {
                    Task dmtask = (Task)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)task), Task.class)));
                    taskList.add(dmtask);
                });
            }
        }
        catch (Exception query1) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.projectNotFound", new Object[0]));
        }
        AuthorityConfigVO configVO = this.generateToStartProjectAuthorityConfig(appCode, null, taskList);
        Object result = this.postGenerateAuthority(configVO);
        return result;
    }

    @Override
    public Object postStatementAuthorityByAppCode(String appCode) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"authorityPrefix").is((Object)(appCode + ":" + REPORT_CODE)));
        List defaultActivityList = this.mongoTemplate.find(query, Activity.class, "activityConfigs");
        if (CollectionUtils.isEmpty((Collection)defaultActivityList)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.statementNotFound", new Object[0]));
        }
        AuthorityConfigVO configVO = this.generateToAuthorityConfig(appCode, null, REPORT_CODE, REPORT_NAME, defaultActivityList);
        Object result = this.postGenerateAuthority(configVO);
        return result;
    }

    @Override
    public Object postStatementAuthorityByCode(String code) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code));
        Activity defaultActivity = (Activity)this.mongoTemplate.findOne(query, Activity.class, "activityConfigs");
        if (StringUtils.isEmpty((CharSequence)defaultActivity.getAuthorityPrefix())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.statementNotConfig", new Object[0]));
        }
        String[] split = defaultActivity.getAuthorityPrefix().split(":");
        if (split.length != 2 || !REPORT_CODE.equals(split[1])) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.statementConfigError", new Object[0]));
        }
        ArrayList<Activity> defaultActivityList = new ArrayList<Activity>();
        defaultActivityList.add(defaultActivity);
        AuthorityConfigVO configVO = this.generateToAuthorityConfig(split[0], null, split[1], REPORT_NAME, defaultActivityList);
        Object result = this.postGenerateAuthority(configVO);
        return result;
    }

    @Override
    public Object postGenerateBasicDataAuthorityByAppCode(String appCode) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"authorityPrefix").is((Object)(appCode + ":" + BASIC_DATA_ENTRY_CODE)));
        List defaultActivityList = this.mongoTemplate.find(query, Activity.class, "activityConfigs");
        if (CollectionUtils.isEmpty((Collection)defaultActivityList)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.baseDataNotFound", new Object[0]));
        }
        AuthorityConfigVO configVO = this.generateToAuthorityConfig(appCode, null, BASIC_DATA_ENTRY_CODE, BASIC_DATA_ENTRY_NAME, defaultActivityList);
        Object result = this.postGenerateAuthority(configVO);
        return result;
    }

    @Override
    public Object postGenerateBasicDataAuthorityByCode(String code) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code));
        Activity defaultActivity = (Activity)this.mongoTemplate.findOne(query, Activity.class, "activityConfigs");
        if (StringUtils.isEmpty((CharSequence)defaultActivity.getAuthorityPrefix())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.baseDataNotConfig", new Object[0]));
        }
        String[] split = defaultActivity.getAuthorityPrefix().split(":");
        if (split.length != 2 || !BASIC_DATA_ENTRY_CODE.equals(split[1])) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.baseDataConfigError", new Object[0]));
        }
        ArrayList<Activity> defaultActivityList = new ArrayList<Activity>();
        defaultActivityList.add(defaultActivity);
        AuthorityConfigVO configVO = this.generateToAuthorityConfig(split[0], null, split[1], BASIC_DATA_ENTRY_NAME, defaultActivityList);
        Object result = this.postGenerateAuthority(configVO);
        return result;
    }

    private AuthorityConfigVO generateToReportAuthorityConfig(String appCode, String appName, List<Activity> activityList) {
        AuthorityConfigVO configVO = new AuthorityConfigVO();
        AppVO app = new AppVO();
        app.setId(appCode);
        app.setName(StringUtils.isEmpty((CharSequence)appName) ? appCode : appName);
        configVO.setApp(app);
        configVO.setType("UPDATE");
        ArrayList<ModuleVO> moduleVOList = new ArrayList<ModuleVO>();
        ModuleVO moduleVO = new ModuleVO();
        moduleVO.setId(REPORT_CODE);
        moduleVO.setName(REPORT_NAME);
        moduleVOList.add(moduleVO);
        configVO.setModules(moduleVOList);
        ArrayList<ActionVO> actionVOList = new ArrayList<ActionVO>();
        for (Activity activity : activityList) {
            ActionVO actionVO = new ActionVO();
            actionVO.setId(activity.getCode());
            actionVO.setModuleId(REPORT_CODE);
            actionVO.setName(activity.getName());
            ArrayList<ConditionVO> conditionVOList = new ArrayList<ConditionVO>();
            ConditionVO conditionVO = new ConditionVO();
            conditionVO.setKey("enable");
            conditionVO.setName("\u62a5\u8868\u542f\u7528");
            conditionVO.setTypeParameter(this.getTypeParameter());
            conditionVO.setDefaultValue(this.getTypeParameter().get(0));
            conditionVOList.add(conditionVO);
            if (this.isABIReport(activity.getCode())) {
                ConditionVO conditionVO2 = new ConditionVO();
                conditionVO2.setKey("design_report");
                conditionVO2.setName("\u8bbe\u8ba1\u62a5\u8868");
                conditionVO2.setTypeParameter(this.getTypeParameter());
                conditionVO2.setDefaultValue(this.getTypeParameter().get(0));
                conditionVOList.add(conditionVO2);
            }
            actionVO.setCondition(conditionVOList);
            actionVOList.add(actionVO);
        }
        configVO.setActions(actionVOList);
        return configVO;
    }

    private boolean isABIReport(String activityCode) {
        Activity oneByCode = this.activityDAO.findOneByCode(activityCode);
        return oneByCode != null && StringUtils.equals((CharSequence)oneByCode.getCategory(), (CharSequence)"ABI-STATEMENT");
    }

    private AuthorityConfigVO generateToStartProjectAuthorityConfig(String appCode, String appName, List<Task> taskList) {
        AuthorityConfigVO configVO = new AuthorityConfigVO();
        AppVO app = new AppVO();
        app.setId(appCode);
        app.setName(StringUtils.isEmpty((CharSequence)appName) ? appCode : appName);
        configVO.setApp(app);
        configVO.setType("UPDATE");
        ArrayList<ModuleVO> moduleVOList = new ArrayList<ModuleVO>();
        ModuleVO moduleVO = new ModuleVO();
        moduleVO.setId(START_PROJECT_CODE);
        moduleVO.setName(START_PROJECT_NAME);
        moduleVOList.add(moduleVO);
        configVO.setModules(moduleVOList);
        ArrayList<ActionVO> actionVOList = new ArrayList<ActionVO>();
        for (Task task : taskList) {
            ActionVO actionVO = new ActionVO();
            actionVO.setId(task.getCode());
            actionVO.setModuleId(START_PROJECT_CODE);
            actionVO.setName(task.getName());
            ArrayList<ConditionVO> conditionVOList = new ArrayList<ConditionVO>();
            ConditionVO conditionVO = new ConditionVO();
            conditionVO.setKey("enable");
            conditionVO.setName("\u9879\u76ee\u542f\u7528");
            conditionVO.setTypeParameter(this.getTypeParameter());
            conditionVO.setDefaultValue(this.getTypeParameter().get(0));
            conditionVOList.add(conditionVO);
            actionVO.setCondition(conditionVOList);
            actionVOList.add(actionVO);
        }
        configVO.setActions(actionVOList);
        return configVO;
    }

    private AuthorityConfigVO generateToBasicDataEntryAuthorityConfig(String appCode, String appName, List<Activity> activityList) {
        AuthorityConfigVO configVO = new AuthorityConfigVO();
        AppVO app = new AppVO();
        app.setId(appCode);
        app.setName(StringUtils.isEmpty((CharSequence)appName) ? appCode : appName);
        configVO.setApp(app);
        configVO.setType("UPDATE");
        ArrayList<ModuleVO> moduleVOList = new ArrayList<ModuleVO>();
        ModuleVO moduleVO = new ModuleVO();
        moduleVO.setId(BASIC_DATA_ENTRY_CODE);
        moduleVO.setName(BASIC_DATA_ENTRY_NAME);
        moduleVOList.add(moduleVO);
        configVO.setModules(moduleVOList);
        ArrayList<ActionVO> actionVOList = new ArrayList<ActionVO>();
        for (Activity activity : activityList) {
            JSONObject pagesJson;
            JSONObject basicDataJson;
            ActionVO actionVO = new ActionVO();
            actionVO.setId(activity.getCode());
            actionVO.setModuleId(BASIC_DATA_ENTRY_CODE);
            actionVO.setName(activity.getName());
            ArrayList<Object> conditionVOList = new ArrayList<Object>();
            ConditionVO conditionVO = new ConditionVO();
            conditionVO.setKey("enable");
            conditionVO.setName("\u542f\u7528");
            conditionVO.setTypeParameter(this.getTypeParameter());
            conditionVO.setDefaultValue(this.getTypeParameter().get(0));
            conditionVOList.add(conditionVO);
            HashMap<String, ConditionVO> conditionVOMap = new HashMap<String, ConditionVO>();
            Map pages = activity.getPages();
            if (pages != null && (basicDataJson = (pagesJson = new JSONObject(pages)).getJSONObject("basic-data")) != null) {
                JSONArray submitActionsArray;
                JSONArray operationsArray = basicDataJson.getJSONArray("operations");
                if (operationsArray != null) {
                    for (int i = 0; i < operationsArray.size(); ++i) {
                        JSONObject operJson = operationsArray.getJSONObject(i);
                        if (!StringUtils.isNotEmpty((CharSequence)operJson.getString("type"))) continue;
                        this.setConditionVo(operJson.getString("type"), operJson.getString("title"), conditionVOMap);
                    }
                }
                if ((submitActionsArray = basicDataJson.getJSONArray("submitActions")) != null) {
                    for (int j = 0; j < submitActionsArray.size(); ++j) {
                        JSONObject submitActionsObject = submitActionsArray.getJSONObject(j);
                        if (!StringUtils.isNotEmpty((CharSequence)submitActionsObject.getString("actionType"))) continue;
                        this.setConditionVo(submitActionsObject.getString("actionType"), submitActionsObject.getString("title"), conditionVOMap);
                    }
                }
            }
            if (conditionVOMap != null && conditionVOMap.size() > 0) {
                Set entries = conditionVOMap.entrySet();
                for (Map.Entry next : entries) {
                    conditionVOList.add(next.getValue());
                }
            }
            actionVO.setCondition(conditionVOList);
            actionVOList.add(actionVO);
        }
        configVO.setActions(actionVOList);
        return configVO;
    }

    private void setConditionVo(String key, String title, Map<String, ConditionVO> conditionVOMap) {
        if (conditionVOMap.containsKey(key)) {
            ConditionVO conditionVO = conditionVOMap.get(key);
            conditionVO.setName(conditionVO.getName() + "," + title);
            conditionVOMap.put(key, conditionVO);
        } else {
            ConditionVO conditionVO = new ConditionVO();
            conditionVO.setKey(key);
            conditionVO.setName(title);
            conditionVO.setTypeParameter(this.getTypeParameter());
            conditionVO.setDefaultValue(this.getTypeParameter().get(0));
            conditionVOMap.put(key, conditionVO);
        }
    }

    private AuthorityConfigVO generateToAuthorityConfig(String appCode, String appName, String moduleCode, String moduleName, List<Activity> activityList) {
        if (BASIC_DATA_ENTRY_CODE.equals(moduleCode)) {
            return this.generateToBasicDataEntryAuthorityConfig(appCode, appName, activityList);
        }
        if (REPORT_CODE.equals(moduleCode)) {
            return this.generateToReportAuthorityConfig(appCode, appName, activityList);
        }
        return null;
    }

    private List<String> getTypeParameter() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("allow");
        result.add("forbidden");
        return result;
    }

    @Override
    public Object postGenerateAuthority(AuthorityConfigVO config) throws Exception {
        log.info("GenerateAuthority config:{}", (Object)JSON.toJSONString((Object)config));
        this.check(config);
        Object cloudGood = this.gmcService.getCloudGood(config.getApp().getId());
        if (cloudGood == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.goodsNotFound", new Object[0]) + config.getApp().getId());
        }
        JSONObject goodObj = JSON.parseObject((String)JSON.toJSONString((Object)cloudGood));
        log.info("getCloudGood:{}", (Object)goodObj);
        JSONObject modules = goodObj.getJSONObject("modules");
        if (modules == null || StringUtils.isEmpty((CharSequence)modules.getString("appToken")) && StringUtils.isEmpty((CharSequence)config.getAppToken())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appTokenMiss", new Object[0]));
        }
        this.upsertAuthorityConfig(goodObj, config);
        log.info("toUpdateGoodsInfo:{}", (Object)goodObj);
        Object updateCloudGoodModulesRequestObj = this.getUpdateCloudGoodModulesRequestObj(goodObj);
        Object updateCloudGoodModulesResultObj = this.gmcService.updateCloudGoodModules(updateCloudGoodModulesRequestObj);
        JSONObject updateCloudGoodModulesResult = JSON.parseObject((String)JSON.toJSONString((Object)updateCloudGoodModulesResultObj));
        if (!updateCloudGoodModulesResult.getBoolean("success").booleanValue()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.goodsUpdateFail", config.getApp().getId()));
        }
        return "success";
    }

    private Object getUpdateCloudGoodModulesRequestObj(JSONObject goodObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", goodObj.getString("code"));
        ArrayList<Object> multiLanguageResourceList = new ArrayList<Object>();
        multiLanguageResourceList.add(this.generateMultiLanguageRequest(goodObj));
        multiLanguageResourceList.add(this.generateMultiLanguageRequestTW(goodObj));
        result.put("multiLanguageResource", multiLanguageResourceList);
        result.put("modules", goodObj.getJSONObject("modules"));
        return result;
    }

    private Object generateMultiLanguageRequest(JSONObject goodObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataSid", goodObj.getString("id"));
        result.put("language", "zh-CN");
        ArrayList dataList = new ArrayList();
        HashMap<String, String> goodsNameMap = new HashMap<String, String>();
        goodsNameMap.put("fieldName", "goodsName");
        goodsNameMap.put("content", ChineseUtils.toSimplified((String)goodObj.getString("displayName")));
        HashMap<String, String> modulesMap = new HashMap<String, String>();
        modulesMap.put("fieldName", "modules");
        modulesMap.put("content", ChineseUtils.toSimplified((String)JSON.toJSONString((Object)goodObj.getJSONObject("modules"))));
        HashMap<String, String> customunitMap = new HashMap<String, String>();
        customunitMap.put("fieldName", "customunit");
        customunitMap.put("content", ChineseUtils.toSimplified((String)goodObj.getString("customUnit")));
        dataList.add(goodsNameMap);
        dataList.add(modulesMap);
        dataList.add(customunitMap);
        result.put("data", dataList);
        return result;
    }

    private Object generateMultiLanguageRequestTW(JSONObject goodObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataSid", goodObj.getString("id"));
        result.put("language", "zh-TW");
        ArrayList dataList = new ArrayList();
        HashMap<String, String> goodsNameMap = new HashMap<String, String>();
        goodsNameMap.put("fieldName", "goodsName");
        goodsNameMap.put("content", this.translateUtils.translateContentToTw(goodObj.getString("displayName")));
        HashMap<String, String> modulesMap = new HashMap<String, String>();
        modulesMap.put("fieldName", "modules");
        modulesMap.put("content", this.translateUtils.translateContentToTw(goodObj.getJSONObject("modules")));
        HashMap<String, String> customunitMap = new HashMap<String, String>();
        customunitMap.put("fieldName", "customunit");
        customunitMap.put("content", this.translateUtils.translateContentToTw(goodObj.getString("customUnit")));
        dataList.add(goodsNameMap);
        dataList.add(modulesMap);
        dataList.add(customunitMap);
        result.put("data", dataList);
        return result;
    }

    private void upsertAuthorityConfig(JSONObject sourceObj, AuthorityConfigVO config) {
        this.makeUpConfig(config);
        JSONObject modules = sourceObj.getJSONObject("modules");
        if (modules == null) {
            JSONObject configObj = JSON.parseObject((String)JSON.toJSONString((Object)config));
            configObj.remove((Object)"type");
            sourceObj.put("modules", (Object)configObj);
        } else if ("ADD".equals(config.getType())) {
            modules.put("modules", (Object)JSONArray.parseArray((String)JSON.toJSONString((Object)config.getModules())));
            modules.put("actions", (Object)JSONArray.parseArray((String)JSON.toJSONString((Object)config.getActions())));
        } else if ("UPDATE".equals(config.getType())) {
            JSONArray modulesArray = modules.getJSONArray("modules");
            Map<String, List<ModuleVO>> collect = config.getModules().stream().collect(Collectors.groupingBy(e -> e.getId()));
            ArrayList moduleToAddList = new ArrayList();
            for (int i = 0; i < modulesArray.size(); ++i) {
                JSONObject jsonObject = modulesArray.getJSONObject(i);
                String moduleId = jsonObject.getString("id");
                if (!CollectionUtils.isEmpty((Collection)collect.get(moduleId))) {
                    jsonObject.put("name", (Object)collect.get(moduleId).get(0).getName());
                }
                collect.remove(moduleId);
            }
            for (Map.Entry<String, List<ModuleVO>> entry : collect.entrySet()) {
                moduleToAddList.addAll(entry.getValue());
            }
            if (!CollectionUtils.isEmpty(moduleToAddList)) {
                modulesArray.addAll(moduleToAddList);
            }
            JSONArray actionsArray = modules.getJSONArray("actions");
            Map<String, List<ActionVO>> collect1 = config.getActions().stream().collect(Collectors.groupingBy(e -> e.getId() + "###" + e.getModuleId()));
            ArrayList actionsToAddList = new ArrayList();
            for (int i = 0; i < actionsArray.size(); ++i) {
                JSONObject jsonObject = actionsArray.getJSONObject(i);
                String actionBelongModuleId = jsonObject.getString("moduleId");
                String actionId = jsonObject.getString("id");
                List<ActionVO> removeAction = collect1.remove(actionId + "###" + actionBelongModuleId);
                if (CollectionUtils.isEmpty(removeAction)) continue;
                ActionVO actionVo = removeAction.get(0);
                jsonObject.put("name", (Object)actionVo.getName());
                JSONArray conditionArray = jsonObject.getJSONArray("condition");
                ArrayList conditionsToAddList = new ArrayList();
                Map<String, List<ConditionVO>> collect2 = removeAction.get(0).getCondition().stream().collect(Collectors.groupingBy(e -> e.getKey()));
                for (int j = 0; j < conditionArray.size(); ++j) {
                    JSONObject conditionObj = conditionArray.getJSONObject(j);
                    String conditionKey = conditionObj.getString("key");
                    List<ConditionVO> removeCondition = collect2.remove(conditionKey);
                    if (CollectionUtils.isEmpty(removeCondition)) continue;
                    ConditionVO conditionVO = removeCondition.get(0);
                    conditionObj.put("name", (Object)conditionVO.getName());
                    conditionObj.put("type", (Object)conditionVO.getType());
                    conditionObj.put("typeParameter", (Object)conditionVO.getTypeParameter());
                    conditionObj.put("parameter", (Object)conditionVO.getParameter());
                    conditionObj.put("defaultValue", (Object)conditionVO.getDefaultValue());
                }
                for (Map.Entry<String, List<ConditionVO>> entry : collect2.entrySet()) {
                    conditionsToAddList.addAll(entry.getValue());
                }
                if (CollectionUtils.isEmpty(conditionsToAddList)) continue;
                conditionArray.addAll(conditionsToAddList);
            }
            for (Map.Entry<String, List<ActionVO>> entry : collect1.entrySet()) {
                actionsToAddList.addAll(entry.getValue());
            }
            if (!CollectionUtils.isEmpty(actionsToAddList)) {
                actionsArray.addAll(actionsToAddList);
            }
        } else if ("DELETE_MODULE".equals(config.getType())) {
            this.deleteModule(modules, config);
        } else if ("DELETE_ACTION".equals(config.getType())) {
            this.deleteAction(modules, config);
        } else if ("DELETE_CONDITION".equals(config.getType())) {
            this.deleteCondition(modules, config);
        }
    }

    private void deleteModule(JSONObject modules, AuthorityConfigVO config) {
        JSONArray actionsArray;
        List configModules = config.getModules();
        if (CollectionUtils.isEmpty((Collection)configModules)) {
            return;
        }
        Set configModuleIdSet = configModules.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getId())).map(ModuleVO::getId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(configModuleIdSet)) {
            return;
        }
        JSONArray modulesArray = modules.getJSONArray("modules");
        if (!ObjectUtils.isEmpty((Object)modulesArray)) {
            Iterator iterator = modulesArray.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(next));
                if (jsonObject == null || !configModuleIdSet.contains(jsonObject.getString("id"))) continue;
                iterator.remove();
            }
        }
        if (!ObjectUtils.isEmpty((Object)(actionsArray = modules.getJSONArray("actions")))) {
            Iterator iterator = actionsArray.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(next));
                if (jsonObject == null || !configModuleIdSet.contains(jsonObject.getString("moduleId"))) continue;
                iterator.remove();
            }
        }
    }

    private void deleteAction(JSONObject modules, AuthorityConfigVO config) {
        List configActions = config.getActions();
        if (CollectionUtils.isEmpty((Collection)configActions)) {
            return;
        }
        Set configModuleAndActionIdSet = configActions.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getId()) && StringUtils.isNotEmpty((CharSequence)e.getModuleId())).map(e -> e.getModuleId() + "###" + e.getId()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(configModuleAndActionIdSet)) {
            return;
        }
        JSONArray actionsArray = modules.getJSONArray("actions");
        if (!ObjectUtils.isEmpty((Object)actionsArray)) {
            Iterator iterator = actionsArray.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(next));
                if (jsonObject == null || !configModuleAndActionIdSet.contains(jsonObject.getString("moduleId") + "###" + jsonObject.getString("id"))) continue;
                iterator.remove();
            }
        }
    }

    private void deleteCondition(JSONObject modules, AuthorityConfigVO config) {
        List configActions = config.getActions();
        if (CollectionUtils.isEmpty((Collection)configActions)) {
            return;
        }
        Map<String, List<ActionVO>> collect1 = configActions.stream().collect(Collectors.groupingBy(e -> e.getModuleId() + "###" + e.getId()));
        if (CollectionUtils.isEmpty(collect1)) {
            return;
        }
        JSONArray actionsArray = modules.getJSONArray("actions");
        if (!ObjectUtils.isEmpty((Object)actionsArray)) {
            for (int i = 0; i < actionsArray.size(); ++i) {
                JSONObject jsonObject = actionsArray.getJSONObject(i);
                String key = jsonObject.getString("moduleId") + "###" + jsonObject.getString("id");
                List<ActionVO> actionVOList = collect1.get(key);
                if (CollectionUtils.isEmpty(actionVOList)) continue;
                Set collect = actionVOList.get(0).getCondition().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getKey())).map(ConditionVO::getKey).collect(Collectors.toSet());
                JSONArray conditionArray = jsonObject.getJSONArray("condition");
                Iterator iterator = conditionArray.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    JSONObject jsonObject1 = JSON.parseObject((String)JSON.toJSONString(next));
                    if (jsonObject1 == null || !collect.contains(jsonObject1.getString("key"))) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void makeUpConfig(AuthorityConfigVO config) {
        String id = config.getApp().getId();
        config.getApp().setCategoryId(id);
        config.getApp().setIdFirst(id);
        for (ActionVO actionVO : config.getActions()) {
            String name = actionVO.getName();
            String actionVOId = actionVO.getId();
            for (ConditionVO conditionVO : actionVO.getCondition()) {
                conditionVO.setSid(this.getSid());
                conditionVO.setType("single");
                conditionVO.setParameter(JSON.toJSONString((Object)conditionVO.getTypeParameter()));
                conditionVO.setActionName(name);
                conditionVO.setActionId(actionVOId);
            }
        }
    }

    private static String getSid() {
        StringBuilder sb = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        for (int i = 0; i < 16; ++i) {
            sb.append(rd.nextInt(10));
        }
        return sb.toString();
    }

    private void check(AuthorityConfigVO config) throws Exception {
        if (config == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.authConfigMiss", new Object[0]));
        }
        AppVO app = config.getApp();
        if (app == null || StringUtils.isEmpty((CharSequence)app.getId()) || StringUtils.isEmpty((CharSequence)app.getName())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appInfoMiss", new Object[0]));
        }
        if (!("ADD".equals(config.getType()) || "UPDATE".equals(config.getType()) || "DELETE_MODULE".equals(config.getType()) || "DELETE_ACTION".equals(config.getType()) || "DELETE_CONDITION".equals(config.getType()))) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeError", new Object[0]));
        }
        if ("ADD".equals(config.getType()) || "UPDATE".equals(config.getType())) {
            List modules = config.getModules();
            if (CollectionUtils.isEmpty((Collection)modules)) {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.modulesEmpty", new Object[0]));
            }
            for (ModuleVO e : modules) {
                if (!StringUtils.isEmpty((CharSequence)e.getId()) && !StringUtils.isEmpty((CharSequence)e.getName())) continue;
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.moduleInfoMiss", new Object[0]));
            }
            List actions = config.getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionsEmpty", new Object[0]));
            }
            for (ActionVO actionVO : actions) {
                if (StringUtils.isEmpty((CharSequence)actionVO.getId()) || StringUtils.isEmpty((CharSequence)actionVO.getName())) {
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionInfoMiss", new Object[0]));
                }
                if (StringUtils.isEmpty((CharSequence)actionVO.getModuleId())) {
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionModuleEmpty", new Object[0]));
                }
                if (CollectionUtils.isEmpty((Collection)actionVO.getCondition())) {
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionConditionEmpty", new Object[0]));
                }
                for (ConditionVO conditionVO : actionVO.getCondition()) {
                    if (StringUtils.isEmpty((CharSequence)conditionVO.getKey())) {
                        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.conditionKeyEmpty", new Object[0]));
                    }
                    if (StringUtils.isEmpty((CharSequence)conditionVO.getName())) {
                        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.conditionNameEmpty", new Object[0]));
                    }
                    if (StringUtils.isEmpty((CharSequence)conditionVO.getDefaultValue())) {
                        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.conditionDefaultValueEmpty", new Object[0]));
                    }
                    if (CollectionUtils.isEmpty((Collection)conditionVO.getTypeParameter())) {
                        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.conditionTypeParameterEmpty", new Object[0]));
                    }
                    if (conditionVO.getTypeParameter().contains(conditionVO.getDefaultValue())) continue;
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.conditionNotExist", new Object[0]));
                }
            }
        }
    }

    @Override
    public Object postGrantAuthorityToUser(AuthorityConfigVO config) throws Exception {
        log.info("====GrantAuthorityToUser config:{}", (Object)JSON.toJSONString((Object)config));
        this.grantAuthorityCheck(config);
        List<String> needToGrantAuthorityInfoList = this.getNeedToGrantAuthorityInfo(config);
        String appCode = config.getApp().getId();
        AppAuthorizationsResponse allEffectiveTenantAndAppInfo = this.cacService.getAllEffectiveTenantAndAppInfo(appCode);
        log.info("\u901a\u8fc7cac\u67e5\u8be2\u8fd8\u6ca1\u5931\u6548\u7684\u5e94\u7528\uff1a{} \u79df\u6237\u4fe1\u606f\u5171\uff1a{} \u6761", (Object)config.getApp().getId(), (Object)allEffectiveTenantAndAppInfo.getTotal());
        new Thread(() -> {
            for (AppPurchaseInfo appPurchaseInfo : allEffectiveTenantAndAppInfo.getList()) {
                if (!CollectionUtils.isEmpty((Collection)config.getLimitedTenantIdList()) && !config.getLimitedTenantIdList().contains(appPurchaseInfo.getTenantId()) || !CollectionUtils.isEmpty((Collection)config.getExcludedTenantIdList()) && config.getExcludedTenantIdList().contains(appPurchaseInfo.getTenantId())) continue;
                String tenantToken = null;
                List<AuthorityAction> needToGrandAuthorityActionInfo = null;
                List<SimpleUser> userList = null;
                try {
                    log.info("\u5f00\u59cb\u5904\u7406\u79df\u6237\uff1a{}", (Object)appPurchaseInfo.getTenantId());
                    tenantToken = this.iamService.getTenantToken(appPurchaseInfo.getTenantId());
                    AppDetailInfo appDetailInfo = this.iamService.appDetailInfo(appCode, tenantToken);
                    needToGrandAuthorityActionInfo = this.getNeedToGrandAuthorityActionInfo(appDetailInfo, needToGrantAuthorityInfoList);
                    if (CollectionUtils.isEmpty(needToGrandAuthorityActionInfo)) continue;
                    userList = this.iamService.getUser(tenantToken);
                }
                catch (Exception e) {
                    log.error("===\u8c03\u7528iam\u63a5\u53e3\u5f02\u5e38,\u79df\u6237\uff1a{},\u5f02\u5e38\u4fe1\u606f{}", (Object)appPurchaseInfo.getTenantId(), (Object)e.toString());
                }
                if (CollectionUtils.isEmpty(userList)) continue;
                for (SimpleUser simpleUser : userList) {
                    for (AuthorityAction action : needToGrandAuthorityActionInfo) {
                        try {
                            Object policyActionResult = this.iamService.policyAction("user", simpleUser.getSid(), action.getAppSid(), true, action.getSid(), tenantToken);
                            log.info("policyAction=> tenantId:{}, user:{},action:{}, result:{}", new Object[]{appPurchaseInfo.getTenantId(), simpleUser.getName(), action.getId(), policyActionResult});
                        }
                        catch (Exception e) {
                            log.error(e.toString());
                        }
                    }
                }
            }
            log.info("====GrantAuthorityToUser finish====");
        }).start();
        return "\u5df2\u6b63\u5e38\u542f\u52a8\u6267\u884c\u81ea\u52a8\u8d4b\u6743\u64cd\u4f5c";
    }

    private List<AuthorityAction> getNeedToGrandAuthorityActionInfo(AppDetailInfo appDetailInfo, List<String> needToGrantAuthorityInfoList) {
        if (appDetailInfo == null || CollectionUtils.isEmpty((Collection)appDetailInfo.getActions()) || CollectionUtils.isEmpty(needToGrantAuthorityInfoList)) {
            return null;
        }
        List<AuthorityAction> collect = appDetailInfo.getActions().stream().map(action -> needToGrantAuthorityInfoList.stream().filter(e -> StringUtils.equals((CharSequence)action.getModuleId(), (CharSequence)StringUtils.substringBefore((String)e, (String)":")) && StringUtils.equals((CharSequence)action.getId(), (CharSequence)StringUtils.substringAfter((String)e, (String)":"))).findFirst().map(m -> action).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        return collect;
    }

    private List<String> getNeedToGrantAuthorityInfo(AuthorityConfigVO config) {
        List<String> collect = config.getActions().stream().map(e -> e.getModuleId() + ":" + e.getId()).collect(Collectors.toList());
        return collect;
    }

    private void grantAuthorityCheck(AuthorityConfigVO config) throws Exception {
        if (config == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.authConfigMiss", new Object[0]));
        }
        AppVO app = config.getApp();
        if (app == null || StringUtils.isEmpty((CharSequence)app.getId())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appIdMiss", new Object[0]));
        }
        List actions = config.getActions();
        if (CollectionUtils.isEmpty((Collection)actions)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionsEmpty", new Object[0]));
        }
        for (ActionVO actionVO : actions) {
            if (StringUtils.isEmpty((CharSequence)actionVO.getId())) {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionIdEmpty", new Object[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)actionVO.getModuleId())) continue;
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionModuleIdEmpty", new Object[0]));
        }
    }

    @Override
    public Object postGrantGlobalMessageAuthorityToUser(AuthorityConfigVO config) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"variableId").is((Object)"globalMessagePageType"));
        List mechanismVariable = this.mongoTemplateUser.find(query, Map.class, "mechanismVariable");
        if (CollectionUtils.isEmpty((Collection)mechanismVariable)) {
            return "\u6ca1\u627e\u5230\u79df\u6237";
        }
        List tenantIdList = mechanismVariable.stream().map(e -> String.valueOf(e.get("tenantId"))).distinct().collect(Collectors.toList());
        config.setLimitedTenantIdList(tenantIdList);
        return this.postGrantAuthorityToUser(config);
    }

    @Override
    public Object postTenantBasicDataByAppCodeAndId(AuthorityConfigVO config) throws Exception {
        List componentCodeList;
        List<Object> newActions = new ArrayList();
        List actions = config.getActions();
        HashMap<String, List<Object>> filterDataMap = new HashMap<String, List<Object>>();
        TenantAppComponentListBO tenantAppComponentListBo = this.tenantAppComponentListDAO.findTenantAppComponentList(config.getAppId(), config.getTenantId());
        List list = componentCodeList = tenantAppComponentListBo == null ? Collections.emptyList() : tenantAppComponentListBo.getComponents().stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(componentCodeList) && !CollectionUtils.isEmpty((Collection)actions)) {
            newActions = config.getActions().stream().filter(action -> !componentCodeList.contains(action.getId())).collect(Collectors.toList());
        }
        filterDataMap.put("actions", newActions);
        filterDataMap.put("modules", Collections.emptyList());
        return filterDataMap;
    }
}

