/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.component.ComponentInitManager;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.service.IComponentService;
import com.digiwin.athena.knowledgegraph.support.SignOffAppHolder;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Lang
@Service
public class ComponentService
implements IComponentService {
    private static final Logger log = LoggerFactory.getLogger(ComponentService.class);
    @Autowired
    ComponentManager componentManager;
    @Autowired
    ComponentInitManager componentInitManager;
    @Autowired
    OperationRecordUtil recordUtil;

    @Override
    public Object getBaseFunctionComponentStructuredList(String appCode, String paradigm) throws Exception {
        return this.componentManager.findBaseFunctionComponentStructuredList(appCode, paradigm, "2.0", null);
    }

    @Override
    public Object getBaseFunctionComponentStructuredList(String appCode, String paradigm, String version) throws Exception {
        return this.componentManager.findBaseFunctionComponentStructuredList(appCode, paradigm, version, null);
    }

    @Override
    public Object getMechanismComponentStructuredList(String mechanismCode) throws Exception {
        return this.componentManager.findMechanismComponentStructuredList(mechanismCode);
    }

    @Override
    public Object getTenantApplicationComponentList(String appCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return this.componentManager.findTenantComponentList(appCode, tenantId);
    }

    @Override
    public void postInitializeTenantApplicationComponentList(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigm, mechanismCodes);
    }

    @Override
    public void postInitializeTenantApplicationComponentList(String appCode, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigms, mechanismCodes);
    }

    @Override
    public void postUpdateTenantApplicationComponentListByMechanism(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        this.componentManager.UpdateTenantApplicationComponentListByMechanism(appCode, tenantId, paradigm, mechanismCodes, null);
    }

    @Override
    public void postUpdateTenantApplicationComponentListByMechanism(String appCode, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        this.componentManager.UpdateTenantApplicationComponentListByMechanism(appCode, tenantId, paradigms, mechanismCodes, null);
    }

    @Override
    public void postInitializeApplicationComponentList(String appCode, String paradigm, String version) throws DWBusinessException {
        this.componentInitManager.initializeApplicationComponentList(appCode, paradigm, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object postQueryComponent(String tenantId, String appCode, String eventType, List<String> component) throws DWBusinessException {
        Map<String, Object> map = new HashMap<String, String>();
        try {
            log.info("queryComponentRequest tenantId:{}, appCode:{}, eventType:{}, component:{}", new Object[]{tenantId, appCode, eventType, component});
            if (StringUtils.isEmpty((CharSequence)tenantId) || StringUtils.isEmpty((CharSequence)appCode) || StringUtils.isEmpty((CharSequence)eventType)) {
                throw new DWBusinessException("tenantId or appCode or eventType can not be null");
            }
            if (!("renew".equals(eventType) || "clean".equals(eventType) || "expire".equals(eventType))) {
                throw new DWBusinessException("eventType error");
            }
            SignOffAppHolder.setSignOffAppFlag(appCode);
            map = this.componentInitManager.queryComponent(tenantId, appCode, eventType, component);
        }
        catch (Exception e) {
            map.put("errorMessage", e.toString());
        }
        finally {
            this.recordUtil.recordInfo(OperationRecord.builder().type(OperationRecordType.CALLBACK + "-" + eventType).tenantId(tenantId).application(appCode).supplementaryContent((Object)ImmutableMap.of((Object)"request", component, (Object)"response", map)).build());
            SignOffAppHolder.removeSignOffAppFlag();
        }
        return map;
    }

    @Override
    public void postClearTenantApplicationComponentListByMechanism(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        this.componentManager.clearTenantApplicationComponentListByMechanism(appCode, tenantId, paradigm, mechanismCodes);
    }

    @Override
    public void postUpdateApplicationComponentList(String appCode, String version) throws DWBusinessException {
        log.info("postUpdateApplicationComponentList appCode:{}, version:{},", (Object)appCode, (Object)version);
        this.componentInitManager.updateApplicationComponentList(appCode, version, null);
    }

    @Override
    public void postUpdateApplicationComponentList(String appCode, List<String> tenantIds, String version) throws DWBusinessException {
        log.info("postUpdateApplicationComponentList appCode:{}, tenantIds:{}, version:{},", new Object[]{appCode, JSON.toJSONString(tenantIds), version});
        this.componentInitManager.updateApplicationComponentList(appCode, tenantIds, version);
    }
}

