/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.report.hz.model.dataCollectGroup.DelConfigDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.dto.report.dataBoard.DataBoardGroupConfig;
import com.digiwin.athena.knowledgegraph.service.IDataBoardGroupService;
import com.digiwin.athena.knowledgegraph.service.impl.DataBoardService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import io.seata.common.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class DataBoardGroupService
implements IDataBoardGroupService {
    private static final Logger log = LoggerFactory.getLogger(DataBoardGroupService.class);
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataBoardService dataBoardService;
    @Autowired
    SceneService sceneService;
    public static final String FAIL_MSG = "fail";
    public static final String SUCCESS_MSG = "success";
    private static final int MAX_SAVED_QUESTIONS = 8;

    @Override
    public Object postAddDataBoardGroupConfig(List<DataBoardGroupConfig> configs) throws DWException {
        if (CollectionUtils.isEmpty(configs)) {
            return FAIL_MSG;
        }
        Query queryCount = this.queryCriteria(new DataBoardGroupConfig());
        long groupListCount = this.mongoTemplateUser.count(queryCount, DataBoardGroupConfig.class);
        if (groupListCount + (long)configs.size() > 8L) {
            String currentLocale = AthenaUtils.getCurrentLocale();
            if (Objects.equals("zh_TW", currentLocale)) {
                throw new DWException("P.KG.500.99999", "\u76ee\u524d\u50c5\u652f\u6301\u6700\u591a8\u500b\u6536\u85cf\u593e\uff0c\u6bcf\u500b\u6536\u85cf\u593e\u6700\u591a\u6536\u85cf8\u500b\u6578\u64da");
            }
            throw new DWException("P.KG.500.99999", "\u76ee\u524d\u4ec5\u652f\u6301\u6700\u591a8\u4e2a\u6536\u85cf\u5939\uff0c\u6bcf\u4e2a\u6536\u85cf\u5939\u6700\u591a\u6536\u85cf8\u4e2a\u6570\u636e");
        }
        BulkOperations bulkOperations = this.mongoTemplateUser.bulkOps(BulkOperations.BulkMode.UNORDERED, DataBoardGroupConfig.class);
        for (DataBoardGroupConfig config : configs) {
            if (StringUtils.isEmpty((CharSequence)config.getGroupId())) {
                config.setGroupId("group_" + UUID.randomUUID().toString().replace("-", ""));
            }
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)config.getTenantId()).and("groupId").is((Object)config.getGroupId()).and("userId").is((Object)config.getUserId()));
            Update update = new Update().set("groupValue", (Object)config.getGroupValue()).set("userName", (Object)config.getUserName());
            bulkOperations.upsert(query, update);
        }
        bulkOperations.execute();
        return SUCCESS_MSG;
    }

    @Override
    public Object postRemoveDataBoardGroupConfig(DelConfigDTO delConfig) throws Exception {
        if (CollectionUtils.isEmpty((Collection)delConfig.getGroupIds())) {
            return FAIL_MSG;
        }
        this.dataBoardService.postRemoveDataBoardConfig(delConfig.getGroupIds());
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"groupId").in((Collection)delConfig.getGroupIds())), DataBoardGroupConfig.class);
        return SUCCESS_MSG;
    }

    @Override
    public Object getQueryDataBoardGroupConfig() throws DWBusinessException, NoSuchFieldException, IllegalAccessException, Exception {
        Query query = this.queryCriteria(new DataBoardGroupConfig());
        List groupList = this.mongoTemplateUser.find(query, DataBoardGroupConfig.class);
        return this.sceneService.getTranslateContent(groupList);
    }

    private Query queryCriteria(DataBoardGroupConfig config) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        if (StringUtils.isNotEmpty((CharSequence)config.getGroupId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"groupId").is((Object)config.getGroupId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)config.getGroupValue())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"groupValue").is((Object)config.getGroupValue()));
        }
        return query;
    }
}

