/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.report.hz.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.dto.report.dataBoard.DataBoardConfig;
import com.digiwin.athena.knowledgegraph.service.IDataBoardService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import io.seata.common.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
@MyExceptionHandler
public class DataBoardService
implements IDataBoardService {
    private static final Logger log = LoggerFactory.getLogger(DataBoardService.class);
    public static final String FAIL_MSG = "fail";
    public static final String SUCCESS_MSG = "success";
    private static final int MAX_SAVED_QUESTIONS = 8;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    SceneService sceneService;

    @Override
    public Object postAddDataBoardConfig(DataBoardConfig config) throws Exception {
        Object configs;
        if (StringUtils.isEmpty((CharSequence)config.getTenantId()) || StringUtils.isEmpty((CharSequence)config.getUserId()) || CollectionUtils.isEmpty(config.getDataBoardQuestions())) {
            return FAIL_MSG;
        }
        String boardId = config.getBoardId();
        String currentLocale = AthenaUtils.getCurrentLocale();
        if (!StringUtils.isEmpty((CharSequence)boardId) && !CollectionUtils.isEmpty((Collection)(configs = this.getQueryDataBoardConfig(config.getAsaCode())))) {
            Iterator<Object> iterator = configs.iterator();
            while (iterator.hasNext()) {
                DataBoardConfig oldConfig = (DataBoardConfig)iterator.next();
                if (Objects.equals(oldConfig.getBoardId(), boardId) || !Objects.equals(config.getBoardName(), oldConfig.getBoardName())) continue;
                if (Objects.equals("zh_TW", currentLocale)) {
                    throw new DWException("P.KG.500.99999", "\u6578\u64da\u770b\u677f\u540d\u7a31\u4e0d\u80fd\u91cd\u5fa9\uff0c\u8acb\u4fee\u6539");
                }
                throw new DWException("P.KG.500.99999", "\u6570\u636e\u770b\u677f\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539");
            }
        }
        if (StringUtils.isEmpty((CharSequence)boardId)) {
            boardId = "board_" + UUID.randomUUID().toString().replace("-", "");
            config.setBoardId(boardId);
            DataBoardConfig.DataBoardQuestions boardQuestion = config.getDataBoardQuestions().get(0);
            boardQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
            config.setDataBoardQuestions(Collections.singletonList(boardQuestion));
            this.mongoTemplateUser.save((Object)config);
        } else {
            List<DataBoardConfig.DataBoardQuestions> dataBoardQuestions = config.getDataBoardQuestions();
            if (dataBoardQuestions.size() > 8) {
                if (Objects.equals("zh_TW", currentLocale)) {
                    throw new DWException("P.KG.500.99999", "\u7576\u524d\u6578\u64da\u770b\u677f\u6700\u591a\u6536\u85cf8\u500b\u554f\u984c");
                }
                throw new DWException("P.KG.500.99999", "\u5f53\u524d\u6570\u636e\u770b\u677f\u6700\u591a\u6536\u85cf8\u4e2a\u95ee\u9898");
            }
            for (DataBoardConfig.DataBoardQuestions boardQuestion : dataBoardQuestions) {
                if (!StringUtils.isEmpty((CharSequence)boardQuestion.getQuestionId())) continue;
                boardQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
            }
            this.updateDataBoardConfig(boardId, config, dataBoardQuestions);
        }
        return SUCCESS_MSG;
    }

    @Override
    public List<DataBoardConfig> getQueryDataBoardConfig() throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        return this.mongoTemplateUser.find(query, DataBoardConfig.class);
    }

    @Override
    public List<DataBoardConfig> getQueryDataBoardConfig(String asaCode) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId).and("asaCode").is((Object)asaCode));
        return this.mongoTemplateUser.find(query, DataBoardConfig.class);
    }

    @Override
    public Object postQueryBoardStep(String questionId) {
        DataBoardConfig dataCollectConfigs = (DataBoardConfig)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"dataBoardQuestions.questionId").is((Object)questionId)), DataBoardConfig.class);
        if (ObjectUtils.isEmpty((Object)dataCollectConfigs)) {
            return Collections.emptyMap();
        }
        List<DataBoardConfig.DataBoardQuestions> collectConfigs = dataCollectConfigs.getDataBoardQuestions();
        if (CollectionUtils.isEmpty(collectConfigs)) {
            return Collections.emptyMap();
        }
        List filteredList = collectConfigs.stream().filter(collectConfig -> Objects.equals(questionId, collectConfig.getQuestionId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredList) || filteredList.get(0) == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("questionId", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getQuestionId());
        map.put("solutionStep", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getSolutionStep());
        map.put("question", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getQuestion());
        map.put("snapshotId", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getSnapshotId());
        map.put("showType", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getShowType());
        map.put("boardId", dataCollectConfigs.getBoardId());
        map.put("appCode", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getAppCode());
        return map;
    }

    @Override
    public Object postQueryBoardById(String boardId) throws Exception {
        return this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)boardId)), DataBoardConfig.class);
    }

    @Override
    public Object postQueryDataBoardConfig(QueryConfigDTO queryConfig) throws Exception {
        Object dataCollectConfigs = this.getQueryDataBoardConfig(queryConfig.getAsaCode());
        if (StringUtils.isEmpty((CharSequence)queryConfig.getGroupId()) || CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return dataCollectConfigs;
        }
        List<DataBoardConfig.DataBoardQuestions> collectConfigs = ((DataBoardConfig)dataCollectConfigs.get(0)).getDataBoardQuestions();
        if (null != collectConfigs) {
            ((DataBoardConfig)dataCollectConfigs.get(0)).setDataBoardQuestions(collectConfigs);
        }
        return this.sceneService.getTranslateContent(dataCollectConfigs);
    }

    @Override
    public Object postRemoveDataBoardConfig(String boardId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)boardId)) {
            return SUCCESS_MSG;
        }
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)boardId)), DataBoardConfig.class);
        return SUCCESS_MSG;
    }

    public void updateDataBoardConfig(String boardId, DataBoardConfig config, List<DataBoardConfig.DataBoardQuestions> dataBoardQuestions) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)config.getTenantId()).and("boardId").is((Object)boardId).and("userId").is((Object)config.getUserId()));
        Update update = new Update();
        update.set("dataBoardQuestions", dataBoardQuestions);
        update.set("boardName", (Object)config.getBoardName());
        update.set("asaCode", (Object)config.getAsaCode());
        this.mongoTemplateUser.updateMulti(query, update, DataBoardConfig.class);
    }

    public void postRemoveDataBoardConfig(List<String> groupIds) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        List dataCollectConfigs = this.mongoTemplateUser.find(query, DataBoardConfig.class);
        if (CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return;
        }
        List<DataBoardConfig.DataBoardQuestions> dataCollectQuestions = ((DataBoardConfig)dataCollectConfigs.get(0)).getDataBoardQuestions();
        if (CollectionUtils.isEmpty(dataCollectQuestions)) {
            return;
        }
        this.updateDataBoardConfig(((DataBoardConfig)dataCollectConfigs.get(0)).getBoardId(), (DataBoardConfig)dataCollectConfigs.get(0), dataCollectQuestions);
    }

    @Override
    public Object postRemoveDataBoardQuestion(String questionId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)questionId)) {
            return SUCCESS_MSG;
        }
        DataBoardConfig configs = (DataBoardConfig)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"dataBoardQuestions.questionId").is((Object)questionId)), DataBoardConfig.class);
        if (Objects.isNull(configs)) {
            return SUCCESS_MSG;
        }
        List<DataBoardConfig.DataBoardQuestions> questions = configs.getDataBoardQuestions();
        if (CollectionUtils.isEmpty(questions)) {
            return SUCCESS_MSG;
        }
        configs.getDataBoardQuestions().removeIf(dataBoardQuestion -> Objects.equals(questionId, dataBoardQuestion.getQuestionId()));
        this.updateDataBoardConfig(configs.getBoardId(), configs, configs.getDataBoardQuestions());
        return SUCCESS_MSG;
    }
}

