/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.inference.InferenceEntity;
import com.digiwin.athena.knowledgegraph.domain.inference.InferenceParamVO;
import com.digiwin.athena.knowledgegraph.domain.inference.InferenceReqVO;
import com.digiwin.athena.knowledgegraph.service.IPocInferenceService;
import com.digiwin.athena.repository.neo4j.InferenceRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Lang
@Service
public class InferenceService
implements IPocInferenceService {
    private static final Logger log = LoggerFactory.getLogger(InferenceService.class);
    @Autowired
    InferenceRepository inferenceRepository;
    @Autowired
    SessionFactory neo4jSessionFactory;

    @Override
    public Object postQueryInference(InferenceReqVO inferenceParams) throws Exception {
        List<InferenceParamVO> inferenceParamsList = inferenceParams.getInferenceParams();
        ConcurrentHashMap<String, List<InferenceEntity>> map = new ConcurrentHashMap<String, List<InferenceEntity>>();
        for (InferenceParamVO iPVO : inferenceParamsList) {
            StringBuffer sql = new StringBuffer();
            sql.append("MATCH (source:").append(iPVO.getSource().getLabel()).append("{code: '").append(iPVO.getSource().getCode()).append("'})-[:").append(iPVO.getRelationship());
            if (iPVO.getDepth() == -1) {
                sql.append("*]->(target:");
            } else {
                sql.append("*").append(iPVO.getDepth()).append("]->(target:");
            }
            sql.append(iPVO.getTarget().getLabel());
            if (StringUtils.isEmpty((CharSequence)iPVO.getTarget().getCode())) {
                sql.append(")");
            } else {
                sql.append("{code: '").append(iPVO.getTarget().getCode()).append("'})");
            }
            sql.append("RETURN id(target) as id,target.code as code,target.name as name,target.value as value,target.language as language,target.version as version");
            String querySql = sql.toString();
            ArrayList<InferenceEntity> inferenceEntity = new ArrayList<InferenceEntity>();
            Result query = this.neo4jSessionFactory.openSession().query(querySql, new HashMap());
            for (Map next : query) {
                InferenceEntity inference = new InferenceEntity();
                inference.setId(Long.parseLong(String.valueOf(next.get("id"))));
                inference.setCode(String.valueOf(next.get("code")));
                inference.setName(String.valueOf(next.get("name")));
                inference.setLanguage((Map)next.get("language"));
                inference.setValue(String.valueOf(next.get("value")));
                inference.setLabel(iPVO.getTarget().getLabel());
                inferenceEntity.add(inference);
            }
            map.put(iPVO.toString(), inferenceEntity);
        }
        switch (inferenceParams.getMergeStrategy()) {
            case intersection: {
                if (inferenceParamsList.size() > 1) {
                    return InferenceService.findDuplicateEntities(map);
                }
                ArrayList<InferenceEntity> resultList = new ArrayList<InferenceEntity>();
                for (List<InferenceEntity> value : map.values()) {
                    resultList.addAll(value);
                }
                return resultList;
            }
        }
        throw new RuntimeException("postQueryInference.mergeStrategy not exist");
    }

    public static List<InferenceEntity> findDuplicateEntities(Map<String, List<InferenceEntity>> map) {
        ArrayList<InferenceEntity> resultList = new ArrayList<InferenceEntity>();
        HashMap<String, Integer> idCountMap = new HashMap<String, Integer>();
        for (List<InferenceEntity> entities : map.values()) {
            for (InferenceEntity entity : entities) {
                idCountMap.put(entity.getLabel() + "-" + entity.getCode(), idCountMap.getOrDefault(entity.getLabel() + "-" + entity.getCode(), 0) + 1);
            }
        }
        for (List<InferenceEntity> entities : map.values()) {
            for (InferenceEntity entity : entities) {
                int count = (Integer)idCountMap.get(entity.getLabel() + "-" + entity.getCode());
                if (count != map.size() || resultList.contains(entity)) continue;
                resultList.add(entity);
            }
        }
        return resultList;
    }
}

