/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.Product;
import com.digiwin.athena.knowledgegraph.service.IProductService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
public class KgProductService
implements IProductService {
    private static final Logger log = LoggerFactory.getLogger(KgProductService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplate;

    @Override
    public Object getAllSteadyProduct() throws DWBusinessException {
        Query query = new Query();
        query.fields().include("product");
        List products = this.mongoTemplate.find(query, Product.class);
        return products.stream().map(Product::getProduct).distinct().collect(Collectors.toList());
    }

    @Override
    public Object getSteadyProduct(String productCode) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"product").is((Object)productCode);
        query.addCriteria((CriteriaDefinition)criteria);
        Product product = (Product)this.mongoTemplate.findOne(query, Product.class);
        return product;
    }
}

