/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.action.StartDataEventAction;
import com.digiwin.athena.kg.monitorRule.MonitorRuleConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.po.InitMonitorRuleGroup;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMonitorRuleService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.ScheduleRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.model.EocMapAndProductDTO;
import com.digiwin.athena.knowledgegraph.service.model.OmMapDTO;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@MyExceptionHandler
@Service
public class MonitorRuleService
implements IMonitorRuleService {
    private static Log log = LogFactory.getLog(ScheduleRuleConfigService.class);
    @Autowired
    private MonitorRuleManager monitorRuleManager;
    @Autowired
    TenantService tenantService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private ESPUtils espUtils;
    @Autowired
    ActionRepository actionRepository;
    @Autowired
    private DataMapService dataMapService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private AppService appService;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object getQuery(Map<String, Object> conditions, int count, String language) throws Exception {
        return null;
    }

    @Override
    public Object getList(String language) throws Exception {
        return null;
    }

    @Override
    public Object get(String ruleId, String tenantId) throws Exception {
        return this.get(ruleId, tenantId, "zh_CN");
    }

    @Override
    public Object get(String ruleId, String tenantId, String language) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        return this.monitorRuleManager.get2(ruleId, tenantId, tenantVersion);
    }

    @Override
    public Object postQuery(Map<String, Object> config) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        return this.monitorRuleManager.getMonitorRule(config, tenantVersion);
    }

    @Override
    public List<Map> postOmSiteInfo(EocMapAndProductDTO eocMapAndProduct) throws Exception {
        ArrayList<Map> factoriesList = new ArrayList<Map>();
        String tenantId = AthenaUtils.getTenantId();
        OmMapDTO omMap = this.monitorRuleManager.getOM(tenantId, eocMapAndProduct.getProductName(), eocMapAndProduct.getEocMap());
        String omCompanyId = omMap.getOmCompanyId() != null ? omMap.getOmCompanyId() : "";
        Map re = this.espUtils.getTenantProductOperationList(tenantId, eocMapAndProduct.getProductName(), false);
        String uid = (String)re.get("uid");
        Map<String, Object> omOperation = this.espUtils.getOMOperationInfo(tenantId, eocMapAndProduct.getProductName(), uid);
        Object companyInfo = JSONPath.eval(omOperation, (String)"intg_info.org_type_company");
        if (ObjectUtils.isEmpty((Object)companyInfo)) {
            return factoriesList;
        }
        List companyInfoList = (List)companyInfo;
        companyInfoList.forEach(cil -> {
            if (omCompanyId.equals(cil.get("company_no"))) {
                Object siteInfo = cil.get("org_type_site");
                this.factoriesKeyMapping(siteInfo, factoriesList);
            }
        });
        return factoriesList;
    }

    @Override
    public Object getDataMapMonitorConfig(String actionId) throws Exception {
        StartDataEventAction action = (StartDataEventAction)this.dataPickService.chooseOneWithSameCode(this.actionRepository.getDataMapAction(actionId));
        if (null != action && null != action.getDataEventId()) {
            return this.dataMapService.geMonitorConfig(action.getDataEventId());
        }
        return null;
    }

    private void factoriesKeyMapping(Object siteInfo, List<Map> factoriesList) {
        if (!ObjectUtils.isEmpty((Object)siteInfo)) {
            List siteList = (List)siteInfo;
            siteList.forEach(s -> {
                HashMap factoryInfo = new HashMap();
                factoryInfo.put("id", s.get("site_no"));
                factoryInfo.put("name", s.get("site_name"));
                factoriesList.add(factoryInfo);
            });
        }
    }

    @Override
    public Object getTenantMonitor() throws Exception {
        return this.monitorRuleManager.queryAllMonitor();
    }

    @Override
    public Object getAllTenantMonitorRule() throws Exception {
        return this.monitorRuleManager.getAllTenantMonitorRule();
    }

    @Override
    public Object postInitMonitorRuleGroup(List<InitMonitorRuleGroup> dataList) {
        if (CollectionUtils.isNotEmpty(dataList)) {
            dataList.forEach(item -> {
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"category").is((Object)item.getCategory()));
                this.mongoTemplateSystem.remove(query, InitMonitorRuleGroup.class);
                this.mongoTemplateSystem.save(item);
            });
        }
        return dataList;
    }

    @Override
    public Object getTenantMonitorRuleByApp(String appCode) throws Exception {
        List<ApplicationRelation> relations = this.appService.getParadigmByTypeAndAppCode("monitorRule", appCode);
        if (CollectionUtils.isEmpty(relations)) {
            return Collections.emptyList();
        }
        List ruleIds = relations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("monitorRuleId").in(ruleIds));
        List monitorRuleTenantConfigs = this.mongoTemplateUser.find(query, MonitorRuleTenantConfig.class);
        if (CollectionUtils.isEmpty((Collection)monitorRuleTenantConfigs)) {
            return Collections.emptyList();
        }
        Map<String, List<MonitorRuleTenantConfig>> monitorRuleTenantConfigMap = monitorRuleTenantConfigs.stream().collect(Collectors.groupingBy(MonitorRuleConfig::getMonitorRuleId));
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantName = MapUtils.getString((Map)profile, (Object)"tenantName", (String)"");
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (ApplicationRelation relation : relations) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.fluentPut("appCode", (Object)appCode).fluentPut("appName", (Object)relation.getAppName()).fluentPut("ruleId", (Object)relation.getCode()).fluentPut("monitorRuleName", (Object)relation.getName()).fluentPut("tenantId", (Object)tenantId).fluentPut("tenantName", (Object)tenantName);
            if (monitorRuleTenantConfigMap.containsKey(relation.getCode())) {
                List<MonitorRuleTenantConfig> configs = monitorRuleTenantConfigMap.get(relation.getCode());
                for (MonitorRuleTenantConfig monitorRuleTenantConfig : configs) {
                    JSONObject configObj = JSONObject.parseObject((String)jsonObject.toJSONString());
                    configObj.fluentPut("status", (Object)monitorRuleTenantConfig.getStatus()).fluentPut("productName", (Object)monitorRuleTenantConfig.getProductName()).fluentPut("standardPollingRule", monitorRuleTenantConfig.getStandardPollingRule()).fluentPut("standardPollingRules", monitorRuleTenantConfig.getStandardPollingRules());
                    if (monitorRuleTenantConfig.getEocMap() != null) {
                        configObj.fluentPut("eocCompanyId", (Object)monitorRuleTenantConfig.getEocMap().getEocCompanyId()).fluentPut("eocSiteId", (Object)monitorRuleTenantConfig.getEocMap().getEocSiteId());
                    }
                    result.add(configObj);
                }
                continue;
            }
            jsonObject.fluentPut("status", (Object)2).fluentPut("productName", null).fluentPut("eocMap", null).fluentPut("standardPollingRule", null).fluentPut("standardPollingRules", null);
            result.add(jsonObject);
        }
        return result;
    }
}

