/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.dto.queryCondition.ReportConditionSetting;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.knowledgegraph.service.IReportConditionService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
@MyExceptionHandler
public class ReportConditionService
implements IReportConditionService {
    private static final Logger log = LoggerFactory.getLogger(ReportConditionService.class);
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    Activity2Repository activityRepository;
    @Autowired
    TaskService taskService;
    @Autowired
    private AppService applicationService;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    AppMetaCaller appMetaCaller;

    @Override
    public Object getQueryConditionSetting(String code) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespObject respObject = this.appMetaCaller.call("/reportCondition/queryConditionSetting", "get", map, RespObject.class);
        return respObject.getResponse();
    }

    private void buildRules(List<Map<String, Object>> rules, Object rulesObj) {
        List rulesList;
        Map rulesMap = (Map)rulesObj;
        if (rulesMap != null && rulesMap.get("rules") != null && CollectionUtils.isNotEmpty((Collection)(rulesList = (List)rulesMap.get("rules")))) {
            for (Map rule : rulesList) {
                rule.forEach((k, v) -> {
                    if ("content".equals(k)) {
                        rules.add((Map)v);
                    }
                });
            }
        }
    }

    @Override
    public void postSaveConditionSetting(ReportConditionSetting setting) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("setting", setting);
        RespObject respObject = this.appMetaCaller.call("/reportCondition/saveConditionSetting", "post", map, RespObject.class);
    }

    private List<Rule> buildRuleList(ReportConditionSetting setting) {
        List hiddenData = setting.getHiddenData();
        if (CollectionUtils.isEmpty((Collection)hiddenData)) {
            return new ArrayList<Rule>();
        }
        ArrayList<Rule> resultList = new ArrayList<Rule>();
        for (Map map : hiddenData) {
            List hiddenFields;
            if (!map.containsKey("hiddenField") || map.get("hiddenField") == null || !CollectionUtils.isNotEmpty((Collection)(hiddenFields = (List)map.get("hiddenField")))) continue;
            for (String str : hiddenFields) {
                String[] strArr = str.split(";");
                Rule rule = this.buildRule(setting.getTenantId(), setting.getVersion(), setting.getCode(), strArr);
                resultList.add(rule);
            }
        }
        return resultList;
    }

    private Rule buildRule(String tenantId, String version, String code, String[] strArr) {
        Rule rule = new Rule();
        rule.setVersion(version);
        rule.setTenantId(tenantId);
        rule.setDomainId(code);
        rule.setDomain(PresetDomainEnum.ACTIVITY);
        rule.setPluginId(code + "_" + tenantId + "_hiddenCondition");
        JSONObject content = new JSONObject();
        content.put("schema", (Object)strArr[1]);
        content.put("path", (Object)strArr[0]);
        content.put("linkageSchemas", (Object)new JSONArray());
        content.put("key", (Object)"hidden");
        JSONObject trigger = new JSONObject();
        trigger.put("condition", (Object)"true");
        trigger.put("point", (Object)"default");
        content.put("trigger", (Object)trigger);
        rule.setContent((Object)content);
        return rule;
    }

    @Override
    public void postResetConditionSetting(String code) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespObject respObject = this.appMetaCaller.call("/reportCondition/resetConditionSetting", "post", map, RespObject.class);
    }

    private void setSort(List<Map<String, Object>> buildResult, List<Map<String, Object>> sortData) {
        if (CollectionUtils.isEmpty(buildResult) || CollectionUtils.isEmpty(sortData)) {
            return;
        }
        for (Map<String, Object> map : buildResult) {
            String id = (String)map.getOrDefault("id", "");
            Optional<Map> sortItemOpt = sortData.stream().filter(item -> id.equals(item.get("id"))).findFirst();
            if (!sortItemOpt.isPresent() || map.get("group") == null) continue;
            List groupResult = (List)map.get("group");
            Map<String, Integer> sortIndexMap = TaskService.createSortIndexMap(sortItemOpt.get());
            groupResult.sort(Comparator.comparingInt(item -> {
                String pathSchema = (String)item.get("path") + ";" + item.get("schema");
                return sortIndexMap.getOrDefault(pathSchema, 99999);
            }));
        }
    }

    private void setHidden(List<Map<String, Object>> buildResult, List<Map<String, Object>> hiddenData) {
        String id;
        if (CollectionUtils.isEmpty(buildResult) || CollectionUtils.isEmpty(hiddenData)) {
            return;
        }
        HashMap<String, List> hiddenDataMap = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(hiddenData)) {
            for (Map<String, Object> entry : hiddenData) {
                id = (String)entry.get("id");
                List hiddens = (List)entry.get("hiddenField");
                hiddenDataMap.put(id, hiddens);
            }
        }
        for (Map<String, Object> map : buildResult) {
            id = (String)map.getOrDefault("id", "");
            if (!hiddenDataMap.containsKey(id) || !CollectionUtils.isNotEmpty((Collection)((List)hiddenDataMap.get(id))) || map.get("group") == null) continue;
            List hiddenFieldList = (List)hiddenDataMap.get(id);
            List groupResult = (List)map.get("group");
            for (Map groupMap : groupResult) {
                String grouPath = groupMap.getOrDefault("path", "");
                String grouSchema = groupMap.getOrDefault("schema", "");
                if (!hiddenFieldList.contains(grouPath + ";" + grouSchema)) continue;
                groupMap.put("hidden", true);
            }
        }
    }

    private void buildFormList(List<Map<String, Object>> buildResult, Map<String, Object> map) {
        String type = (String)map.getOrDefault("type", "");
        String schema = (String)map.getOrDefault("schema", "");
        String id = (String)map.getOrDefault("id", "");
        if ("FORM_LIST".equals(type)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> groupResult = new ArrayList<Map<String, Object>>();
            if (null != map.get("group") && CollectionUtils.isNotEmpty((Collection)((List)map.get("group")))) {
                List group = (List)map.get("group");
                for (Map groupMap : group) {
                    String groupType = groupMap.getOrDefault("type", "");
                    if (!"FORM_LIST".equals(groupType)) {
                        Map<String, Object> resultMap = this.buildMap(groupMap);
                        groupResult.add(resultMap);
                        continue;
                    }
                    this.buildFormList(buildResult, groupMap);
                }
            }
            if (CollectionUtils.isNotEmpty(groupResult)) {
                result.put("schema", schema);
                result.put("id", id);
                result.put("group", groupResult);
                buildResult.add(result);
            }
        }
    }

    private Map<String, Object> buildMap(Map<String, Object> groupMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("schema", groupMap.getOrDefault("schema", ""));
        resultMap.put("path", groupMap.getOrDefault("path", ""));
        resultMap.put("headerName", groupMap.getOrDefault("headerName", ""));
        resultMap.put("placeholder", groupMap.getOrDefault("placeholder", ""));
        resultMap.put("type", groupMap.getOrDefault("type", ""));
        resultMap.put("hidden", false);
        return resultMap;
    }

    public ReportConditionSetting findQueryConditionSetting(String tenantId, String activityCode, String activityVersion) throws DWBusinessException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)activityCode).and("version").is((Object)activityVersion).and("tenantId").is((Object)tenantId));
        ReportConditionSetting setting = (ReportConditionSetting)this.mongoTemplateUser.findOne(query, ReportConditionSetting.class, "reportConditionSetting");
        return setting;
    }
}

