/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.ReminderRule;
import com.digiwin.athena.dto.TenantSummaryFieldsDto;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.activity.ActivityBaseInfoVO;
import com.digiwin.athena.kg.activity.ActivityComposition;
import com.digiwin.athena.kg.activity.ActivityCompositionItem;
import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.kg.activity.ActivitySet;
import com.digiwin.athena.kg.activity.ApproveItem;
import com.digiwin.athena.kg.activity.ExpectedDurationDTO;
import com.digiwin.athena.kg.activity.Language;
import com.digiwin.athena.kg.activity.SolvePlan;
import com.digiwin.athena.kg.activity.SolvePlanData;
import com.digiwin.athena.kg.activity.TenantCardTitleDefinition;
import com.digiwin.athena.kg.domain.TenantSummaryField;
import com.digiwin.athena.kg.domain.TenantSummaryFields;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.support.MergePolicyBuilder;
import com.digiwin.athena.knowledgegraph.cache.CacheService;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.component.ComponentInitManager;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.dao.ActivityDAO;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.domain.AppSubscription;
import com.digiwin.athena.knowledgegraph.domain.BizRelatedReport;
import com.digiwin.athena.knowledgegraph.domain.Task;
import com.digiwin.athena.knowledgegraph.domain.WorkbenchSetting;
import com.digiwin.athena.knowledgegraph.domain.activity.ExportAndImportConfig;
import com.digiwin.athena.knowledgegraph.domain.application.AppTaskRel;
import com.digiwin.athena.knowledgegraph.domain.application.ApplicationGroup;
import com.digiwin.athena.knowledgegraph.domain.application.ApplicationPreNamespace;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.config.MergeRule;
import com.digiwin.athena.knowledgegraph.domain.qr.DynamicTaskAndActivities;
import com.digiwin.athena.knowledgegraph.domain.task.AppRelationVO;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroup;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupApplication;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupGroup;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupTask;
import com.digiwin.athena.knowledgegraph.domain.task.CardLabel;
import com.digiwin.athena.knowledgegraph.domain.task.CardOrder;
import com.digiwin.athena.knowledgegraph.domain.task.DataMapTaskVO;
import com.digiwin.athena.knowledgegraph.domain.task.LabelVO;
import com.digiwin.athena.knowledgegraph.domain.task.ReturnFieldVO;
import com.digiwin.athena.knowledgegraph.domain.task.SystemGroup;
import com.digiwin.athena.knowledgegraph.domain.task.TBBReportReplacer;
import com.digiwin.athena.knowledgegraph.domain.task.TaskMonitorRule;
import com.digiwin.athena.knowledgegraph.domain.task.TaskTypeOrder;
import com.digiwin.athena.knowledgegraph.domain.task.TaskVO;
import com.digiwin.athena.knowledgegraph.domain.valueobject.ActivityDataEntryVO;
import com.digiwin.athena.knowledgegraph.dto.CardConfigDTO;
import com.digiwin.athena.knowledgegraph.dto.GroupAndLabelDto;
import com.digiwin.athena.knowledgegraph.dto.TaskDTO;
import com.digiwin.athena.knowledgegraph.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.knowledgegraph.enums.SourceType;
import com.digiwin.athena.knowledgegraph.enums.WSConfigType;
import com.digiwin.athena.knowledgegraph.enums.WSPageCode;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.repo.DecisionRuleRepository;
import com.digiwin.athena.knowledgegraph.repoSystem.ActivityCompositionRepository;
import com.digiwin.athena.knowledgegraph.service.ATMCService;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.ITaskService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.knowledgegraph.service.impl.ReportConditionService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskFieldService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.impl.WorkbenchSettingService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.task.model.ActivityExecuteTypeEnum;
import com.digiwin.athena.knowledgegraph.task.model.ActivityInfoDTO;
import com.digiwin.athena.knowledgegraph.task.model.CardConditionQueryDTO;
import com.digiwin.athena.knowledgegraph.task.model.CardConfigQueryDTO;
import com.digiwin.athena.knowledgegraph.task.model.TaskActivitiesDTO;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.knowledgegraph.utils.SpringUtil;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.knowledgegraph.vo.DataMapFindTaskResp;
import com.digiwin.athena.knowledgegraph.vo.FindTaskFromUserRequest;
import com.digiwin.athena.knowledgegraph.vo.FindTaskFromUserResp;
import com.digiwin.athena.knowledgegraph.vo.FindTaskFromUserVO;
import com.digiwin.athena.knowledgegraph.vo.SemcDictOption;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldRequest;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.ConditionScopeVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WSConditionVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WorkbenchSettingVO;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.digiwin.athena.repository.neo4j.DynamicTaskRepository;
import com.digiwin.athena.repository.neo4j.SolvePlanRepository;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Lang
@Service
@MyExceptionHandler
public class TaskService
implements ITaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskService.class);
    public static final String SUMMARY = "summary";
    public static final String BUSINESS_INFO = "businessInfo";
    public static final String SEARCH_KEY = "searchKey";
    public static final String PROJECT_INFO = "projectInfo";
    @Autowired
    TaskFieldService taskFieldService;
    @Autowired
    TaskRepository taskRepository;
    @Autowired
    Activity2Repository activityRepository;
    @Autowired
    ActivityRepository activityRepo;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    private DecisionRuleRepository decisionRuleRepository;
    @Autowired
    SolvePlanRepository solvePlanRepository;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    ActivityCompositionRepository activityCompositionRepository;
    @Autowired
    DynamicTaskRepository dynamicTaskRepository;
    @Autowired
    private CACUtils cacUtils;
    @Autowired
    private AppService applicationService;
    @Autowired
    TenantService tenantService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private MechanismService mechanismService;
    @Autowired
    private ComponentManager componentManager;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private ESPUtils espUtils;
    @Autowired
    private ComponentInitManager componentInitManager;
    @Autowired
    private MongoEntityBaseDAO mongoEntityBaseDAO;
    @Autowired
    private EocService eocService;
    @Autowired
    private AppService appService;
    @Autowired
    private CacheService cacheService;
    @Autowired
    private ATMCService atmcService;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    @Qualifier(value="baseExecutor")
    ThreadPoolTaskExecutor executor;
    @Autowired
    WorkbenchSettingService workbenchSettingService;
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    ReportConditionService reportConditionService;
    @Autowired
    private ActionService actionService;
    @Autowired
    AppMetaCaller appMetaCaller;
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    IamService iamService;

    @Override
    @Deprecated
    public Object getDefinition(String taskId) throws Exception {
        return this.getDefinitionWithMultiLanguage(taskId);
    }

    @Override
    public Object getDefinitionWithMultiLanguage(String taskId, String pageCode) throws Exception {
        return this.dataMapService.getDefinitionWithMultiLanguage(taskId, pageCode);
    }

    @Override
    public Object getDefinitionWithMultiLanguage(String taskId) throws Exception {
        return this.dataMapService.getDefinitionByTaskId(taskId);
    }

    @Override
    public Object postDefinitionWithMultiLanguage(String taskId, OperationUnit operationUnit) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("taskId", taskId);
        query.put("operationUnit", operationUnit);
        return this.dataMapService.postDefinitionByTaskIdAndOperationUnit(query);
    }

    @Override
    @Deprecated
    public Object getActivities(String taskId) throws Exception {
        return this.getActivitiesWithMultiLanguage(taskId);
    }

    @Override
    public Object getActivitiesWithMultiLanguage(String taskId) throws Exception {
        return this.dataMapService.getTasks(taskId);
    }

    private static Object processLanguage(String defVal, String propName, Map<String, Map<String, String>> langMap) {
        if (langMap.get(propName) != null) {
            Map<String, String> propLangMap = langMap.get(propName);
            propLangMap.put("zh_CN", defVal);
            langMap.remove(propName);
            return propLangMap;
        }
        return defVal;
    }

    @Override
    public Object getQueryItem(String condition) throws Exception {
        condition = Pattern.quote(condition);
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        List<String> appCodes = this.cacUtils.getAppAuth();
        List<ApplicationRelation> task = this.applicationService.getApplicationRelationByTypeAndAppCode("task", appCodes);
        List taskCodes = task.stream().map(e -> e.getCode()).distinct().collect(Collectors.toList());
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("manualAble", true);
        query.put("name", condition);
        query.put("code", taskCodes);
        List projectInDataMap = new LinkedList();
        try {
            projectInDataMap = this.dataMapService.getProjects(query);
            this.filterProject(projectInDataMap, appCodes, tenantId);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6dataMap\u4e2d\u7684project\u5f02\u5e38", (Throwable)e2);
        }
        List<Object> dataEntry = this.dataPickService.excludeWithSameCode(this.activityDAO.getActivitiesByPatternCondition("DATA_ENTRY", condition, tenantId, tenantVersion));
        this.filterUc(dataEntry, tenantId);
        List<Object> commonDataEntry = this.dataPickService.excludeWithSameCode(this.activityDAO.getActivitiesByPatternCondition("DATA_ENTRY", condition, tenantId, tenantVersion));
        this.filterUc(commonDataEntry, tenantId);
        List<Object> statements = this.dataPickService.excludeWithSameCode(this.activityDAO.getActivitiesByPatternCondition("STATEMENT", condition, tenantId, tenantVersion));
        this.filterUc(statements, tenantId);
        List<Object> commonStatements = this.dataPickService.excludeWithSameCode(this.activityDAO.getActivitiesByPatternCondition("STATEMENT", condition, tenantId, tenantVersion));
        this.filterUc(commonStatements, tenantId);
        condition = ".*" + condition + ".*";
        List<Task> manualProject = this.taskRepository.getManualProjectsByName(condition, tenantId, tenantVersion);
        Map<String, Activity> activityMap = commonDataEntry.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> b));
        List<String> commonDataEntryCodes = commonDataEntry.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> commonDataEntryCodesRelations = this.appService.getApplicationRelation(appCodes, commonDataEntryCodes, "activity", null);
        Map<String, List<String>> commonDataEntryListCodes = commonDataEntryCodesRelations.stream().collect(Collectors.groupingBy(BaseEntity::getCode, Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        if (!org.springframework.util.CollectionUtils.isEmpty(commonDataEntryCodes)) {
            Map<String, List<ApplicationRelation>> applicationRelationsMap = this.applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity", commonDataEntryCodes, localeStr, activityMap);
            Set<String> appsIncludedItems = this.getCommonAppsIncludedItems(applicationRelationsMap);
            commonDataEntry = commonDataEntry.stream().filter(activity -> appsIncludedItems.contains(activity.getCode())).collect(Collectors.toList());
        }
        Map<String, Activity> activityStatementMap = commonStatements.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> b));
        List<String> commonStatementsCodes = commonStatements.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> commonStatementsCodesRelations = this.appService.getApplicationRelation(appCodes, commonStatementsCodes, "activity", null);
        Map<String, List<String>> commonStatementsListCodes = commonStatementsCodesRelations.stream().collect(Collectors.groupingBy(BaseEntity::getCode, Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        if (!org.springframework.util.CollectionUtils.isEmpty(commonStatementsCodes)) {
            Map<String, List<ApplicationRelation>> applicationRelationsMap = this.applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity", commonStatementsCodes, localeStr, activityStatementMap);
            Set<String> appsIncludedItems = this.getCommonAppsIncludedItems(applicationRelationsMap);
            commonStatements = commonStatements.stream().filter(activity -> appsIncludedItems.contains(activity.getCode())).collect(Collectors.toList());
        }
        List dataEntryCodes = dataEntry.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> dataEntryCodesRelations = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(dataEntryCodes).and("appCode").in(appCodes).and("version").is((Object)tenantVersion).and("type").is((Object)"activity").and("commonApp").ne((Object)true)), ApplicationRelation.class);
        dataEntryCodesRelations = this.dataPickService.filterApplicationRelations(dataEntryCodesRelations);
        Map<String, List<String>> dataEntryListCodes = dataEntryCodesRelations.stream().collect(Collectors.groupingBy(BaseEntity::getCode, Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        dataEntry = dataEntry.stream().filter(activity -> dataEntryListCodes.containsKey(activity.getCode())).collect(Collectors.toList());
        List statementsCodes = statements.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> statementsCodesRelations = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(statementsCodes).and("appCode").in(appCodes).and("version").is((Object)tenantVersion).and("type").is((Object)"activity").and("commonApp").ne((Object)true)), ApplicationRelation.class);
        statementsCodesRelations = this.dataPickService.filterApplicationRelations(statementsCodesRelations);
        Map<String, List<String>> statementsListCodes = statementsCodesRelations.stream().collect(Collectors.groupingBy(BaseEntity::getCode, Collectors.mapping(ApplicationRelation::getAppCode, Collectors.toList())));
        statements = statements.stream().filter(activity -> statementsListCodes.containsKey(activity.getCode())).collect(Collectors.toList());
        List<String> manualProjectCodes = dataEntry.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<ApplicationRelation> manualProjectCodesRelations = this.appService.getApplicationRelation(appCodes, manualProjectCodes, "task", null);
        List manualProjectCodesRelationsListCodes = manualProjectCodesRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        manualProject = manualProject.stream().filter(activity -> manualProjectCodesRelationsListCodes.contains(activity.getCode())).collect(Collectors.toList());
        HashMap<String, String> tbbCodeApplicationMap = new HashMap<String, String>();
        this.handleTBBTenantReports("STATEMENT", tenantId, tenantVersion, statements, tbbCodeApplicationMap);
        List<String> tbbIfCustom = statements.stream().map(BaseEntity::getCode).filter(code -> !StringUtils.isEmpty((CharSequence)((CharSequence)tbbCodeApplicationMap.get(code)))).collect(Collectors.toList());
        List<Map> dataEntryMapList = this.castActivityToItemMap(dataEntry, localeStr, dataEntryListCodes);
        List<Map> commonDataEntryMapList = this.castActivityToItemMap(commonDataEntry, localeStr, commonDataEntryListCodes);
        List<Map> statementsMapList = this.castActivityToItemMap(statements, localeStr, statementsListCodes, tbbIfCustom);
        List<Map> commonStatementsMapList = this.castActivityToItemMap(commonStatements, localeStr, commonStatementsListCodes);
        List<Map> manualProjectMapList = this.castTaskToItemMap(manualProject, localeStr);
        List<Map> manualProjectDataMapMapList = this.castDataMapTaskToItemMap(projectInDataMap, localeStr);
        if (!org.springframework.util.CollectionUtils.isEmpty(commonDataEntryMapList)) {
            dataEntryMapList.addAll(commonDataEntryMapList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(commonStatementsMapList)) {
            dataEntryMapList.addAll(commonStatementsMapList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(statementsMapList)) {
            dataEntryMapList.addAll(statementsMapList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(manualProjectMapList)) {
            dataEntryMapList.addAll(manualProjectMapList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(manualProjectDataMapMapList)) {
            dataEntryMapList.addAll(manualProjectDataMapMapList);
        }
        return dataEntryMapList;
    }

    private List<Map> castActivityToItemMap(List<Activity> dataEntry, String localeStr, Map<String, List<String>> appCodeMap) {
        if (org.springframework.util.CollectionUtils.isEmpty(dataEntry)) {
            return new LinkedList<Map>();
        }
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        dataEntry.forEach(item -> {
            List appCodeList = (List)appCodeMap.get(item.getCode());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)appCodeList)) {
                for (String appCode : appCodeList) {
                    HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                    itemMap.put("name", org.springframework.util.CollectionUtils.isEmpty((Map)item.getLang()) || org.springframework.util.CollectionUtils.isEmpty((Map)((Map)item.getLang().get("name"))) || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : ((Map)item.getLang().get("name")).get(localeStr));
                    itemMap.put("type", "Activity");
                    itemMap.put("code", item.getCode());
                    itemMap.put("pattern", item.getPattern());
                    itemMap.put("subReport", BooleanUtils.toBoolean((Boolean)item.getSubReport()));
                    itemMap.put("ifCommon", "false");
                    itemMap.put("category", item.getCategory());
                    itemMap.put("appCode", appCode);
                    itemMap.put("ifCustom", false);
                    dataEntryMapList.add(itemMap);
                }
            }
        });
        return dataEntryMapList;
    }

    private List<Map> castActivityToItemMap(List<Activity> dataEntry, String localeStr, Map<String, List<String>> appCodeMap, List<String> tbbIfCustom) {
        if (org.springframework.util.CollectionUtils.isEmpty(dataEntry)) {
            return new LinkedList<Map>();
        }
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        dataEntry.forEach(item -> {
            List appCodeList = (List)appCodeMap.get(item.getCode());
            for (String appCode : appCodeList) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                itemMap.put("name", null == item.getLang() || item.getLang().isEmpty() || null == item.getLang().get("name") || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : ((Map)item.getLang().get("name")).get(localeStr));
                itemMap.put("type", "Activity");
                itemMap.put("code", item.getCode());
                itemMap.put("pattern", item.getPattern());
                itemMap.put("subReport", BooleanUtils.toBoolean((Boolean)item.getSubReport()));
                itemMap.put("ifCommon", "false");
                itemMap.put("category", item.getCategory());
                itemMap.put("appCode", appCode);
                itemMap.put("ifCustom", tbbIfCustom.contains(item.getCode()));
                dataEntryMapList.add(itemMap);
            }
        });
        return dataEntryMapList;
    }

    private List<Map> castDataMapTaskToItemMap(List manualDataMapProject, String localeStr) {
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)manualDataMapProject)) {
            return Collections.EMPTY_LIST;
        }
        List originalMap = JSON.parseArray((String)JSON.toJSONString((Object)manualDataMapProject), Map.class);
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        originalMap.forEach(item -> {
            HashMap<String, String> itemMap = new HashMap<String, String>(8);
            itemMap.put("name", (String)item.get("name"));
            itemMap.put("type", "Task");
            itemMap.put("code", (String)item.get("code"));
            itemMap.put("pattern", null == item.get("pattern") ? null : (String)item.get("pattern"));
            dataEntryMapList.add(itemMap);
        });
        return dataEntryMapList;
    }

    private List<Map> castTaskToItemMap(List<Task> manualProject, String localeStr) {
        if (org.springframework.util.CollectionUtils.isEmpty(manualProject)) {
            return Collections.emptyList();
        }
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        manualProject.forEach(item -> {
            HashMap<String, String> itemMap = new HashMap<String, String>(8);
            itemMap.put("name", null == item.getLang() || item.getLang().isEmpty() || null == item.getLang().get("name") || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : (String)((Map)item.getLang().get("name")).get(localeStr));
            itemMap.put("type", "Task");
            itemMap.put("code", item.getCode());
            itemMap.put("pattern", item.getPattern());
            dataEntryMapList.add(itemMap);
        });
        return dataEntryMapList;
    }

    @Override
    public Object getActivityNamesByCode(String activityCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String loc_zh_CN = "zh_CN";
        String loc_zh_TW = "zh_TW";
        String loc_en_US = "en_US";
        String loc_default = "default";
        String key = "name";
        Activity activity = this.dataPickService.chooseOneWithSameCode(this.activityDAO.getActivityByCodeAndVersion(activityCode, tenantVersion, tenantId));
        HashMap<String, String> lang = new HashMap<String, String>();
        if (null == activity) {
            return lang;
        }
        lang.put("default", activity.getName());
        if (null != activity.getLang() && !activity.getLang().isEmpty()) {
            String en_US = (String)((Map)activity.getLang().get("name")).get("en_US");
            String zh_TW = (String)((Map)activity.getLang().get("name")).get("zh_TW");
            String zh_CN = (String)((Map)activity.getLang().get("name")).get("zh_CN");
            if (!StringUtils.isEmpty((CharSequence)en_US)) {
                lang.put("en_US", en_US);
            }
            if (!StringUtils.isEmpty((CharSequence)zh_TW)) {
                lang.put("zh_TW", zh_TW);
            }
            if (!StringUtils.isEmpty((CharSequence)zh_CN)) {
                lang.put("zh_CN", zh_CN);
            }
        }
        return lang;
    }

    @Override
    public Object postTenantTBBReportsByProductCode(TBBReportReplacer reportReplacer) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("reportReplacer", reportReplacer);
        RespObject resp = this.appMetaCaller.call("/record/tenantTBBReportsByProductCode", "post", map, RespObject.class);
        return resp.getResponse();
    }

    private void clearTenantTBBReportsByProductCode(String productCode, String tenantId, String tenantVersion) throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion).and("productCode").is((Object)productCode);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        this.mongoTemplateUser.remove(queryUser, "tbbReports");
    }

    private void writeNewReportToDB(TBBReportReplacer reportReplaceDO) {
        this.mongoTemplateUser.insert((Object)reportReplaceDO, "tbbReports");
    }

    @Override
    public Object getTBBReports(String mode, String productCode) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("mode", mode);
        map.put("productCode", productCode);
        RespObject resp = this.appMetaCaller.call("/record/tBBReports", "get", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getBaseDataApplication() throws Exception {
        RespObject resp = this.appMetaCaller.call("/record/baseDataApplication", "get", null, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getActivitiesInfoByPattern() throws Exception {
        RespObject resp = this.appMetaCaller.call("/record/activitiesInfoByPattern", "get", null, RespObject.class);
        return resp.getResponse();
    }

    private void filterUc(List<Activity> activities, String tenantId) {
        Iterator<Activity> activityIterator = activities.iterator();
        ArrayList<String> ucCodes = new ArrayList<String>();
        while (activityIterator.hasNext()) {
            Activity activity = activityIterator.next();
            if (null == activity.getInclusionTenant()) continue;
            if (!activity.getInclusionTenant().contains(tenantId)) {
                activityIterator.remove();
                continue;
            }
            if (!activity.getCode().startsWith("UC_")) continue;
            ucCodes.add(activity.getCode().replace("UC_", ""));
        }
    }

    @Override
    public Object getActivitiesByPattern(String pattern) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("pattern", pattern);
        RespObject resp = this.appMetaCaller.call("/record/activitiesByPattern", "get", map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public List<ExportAndImportConfig> getExportAndImportConfig() throws Exception {
        List exportAndImportConfigs;
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        String hasGroundEnd = null;
        try {
            Object hasGroundEndObj = this.mechanismService.getVariable("hasGroundEnd", tenantId);
            if (hasGroundEndObj != null) {
                Map hasGroundEndMap = (Map)hasGroundEndObj;
                hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
            }
        }
        catch (Exception e) {
            log.error("Route==>TaskService method=getExportAndImportConfig get hasGroundEnd error:", (Throwable)e);
        }
        List<String> appCodes = this.cacUtils.getAppAuth();
        List<String> activityCodes = this.dataPickService.tenantProductCodes("activity", appCodes);
        List<Activity> activities = this.activityDAO.getActivitiesByPattern(tenantId, "DATA_ENTRY", tenantVersion, activityCodes);
        this.filterUc(activities, tenantId);
        Map<String, Boolean> activityHasGroundEndMap = this.getActivityHasGroundEnd(activities);
        String hasGroundEndTemp = hasGroundEnd;
        if (org.springframework.util.CollectionUtils.isEmpty(activities)) {
            return new ArrayList<ExportAndImportConfig>();
        }
        Map<String, Activity> activityMap = activities.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> b));
        ArrayList codeList = new ArrayList();
        List<String> normalActivityCodes = activities.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(normalActivityCodes)) {
            Map<String, List<ApplicationRelation>> applicationRelationsMap = this.applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity", normalActivityCodes, localeStr, activityMap);
            Set<String> finalCommonAppsIncludedItems = this.getCommonAppsIncludedItems(applicationRelationsMap);
            normalActivityCodes.forEach(item -> {
                List applicationRelations;
                if (!(StringUtils.equals((CharSequence)hasGroundEndTemp, (CharSequence)"N") && activityHasGroundEndMap.get(item) != null && ((Boolean)activityHasGroundEndMap.get(item)).booleanValue() || org.springframework.util.CollectionUtils.isEmpty((Collection)(applicationRelations = (List)applicationRelationsMap.get(item))))) {
                    applicationRelations.forEach(applicationRelation -> {
                        if (appCodes.contains(applicationRelation.getAppCode())) {
                            Activity activityItem = (Activity)activityMap.get(item);
                            if (applicationRelation.getCommonApp().booleanValue()) {
                                if (finalCommonAppsIncludedItems.contains(activityItem.getCode())) {
                                    codeList.add(activityItem.getCode());
                                }
                            } else {
                                codeList.add(activityItem.getCode());
                            }
                        }
                    });
                }
            });
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(exportAndImportConfigs = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(codeList).and("version").is((Object)tenantVersion)), ExportAndImportConfig.class)))) {
            exportAndImportConfigs.forEach(exportAndImportConfig -> exportAndImportConfig.setName(exportAndImportConfig.getLang().isEmpty() || null == exportAndImportConfig.getLang().get("name").get(localeStr) ? exportAndImportConfig.getName() : exportAndImportConfig.getLang().get("name").get(localeStr)));
        }
        return exportAndImportConfigs;
    }

    private Set<String> getCommonAppsIncludedItems(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        Set<String> appIdSet = this.getCommonAppIds(applicationRelationsMap);
        Set<String> commonAppsIncludedItems = Collections.emptySet();
        if (!org.springframework.util.CollectionUtils.isEmpty(appIdSet)) {
            commonAppsIncludedItems = new HashSet<String>(this.iamService.appItems(new ArrayList<String>(appIdSet)));
        }
        Set<String> finalCommonAppsIncludedItems = commonAppsIncludedItems;
        return finalCommonAppsIncludedItems;
    }

    private Set<String> getCommonAppIds(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        HashSet<String> commonAppIds = new HashSet<String>();
        applicationRelationsMap.forEach((k, v) -> {
            ApplicationRelation applicationRelation = (ApplicationRelation)v.get(0);
            if (applicationRelation.getCommonApp().booleanValue()) {
                commonAppIds.add(applicationRelation.getAppCode());
            }
        });
        return commonAppIds;
    }

    @Override
    public Object getActivitiesByPatternAndAppCode(String pattern, String appCode) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("pattern", pattern);
        map.put("appCode", appCode);
        RespObject resp = this.appMetaCaller.call("/record/activitiesByPatternAndAppCode", "get", map, RespObject.class);
        return resp.getResponse();
    }

    private void handleTBBTenantReports(String pattern, String tenantId, String tenantVersion, List<Activity> activities, Map<String, String> tbbCodeApplicationMap) {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        List tbbReportReplacers = this.mongoTemplateUser.find(queryUser, TBBReportReplacer.class, "tbbReports");
        LinkedList tbbActivities = new LinkedList();
        HashSet replaceIdSet = new HashSet();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tbbReportReplacers)) {
            tbbReportReplacers.forEach(item -> item.getReports().forEach(itemj -> {
                if (pattern.equals("STATEMENT") && itemj.getMode().equals("pc") || pattern.equals("MOBI-STATEMENT") && itemj.getMode().equals("mobile")) {
                    Activity activity = new Activity();
                    activity.setCode(itemj.getId());
                    HashMap<String, Map<String, String>> langMap = new HashMap<String, Map<String, String>>();
                    langMap.put("name", itemj.getName());
                    activity.setLang(langMap);
                    tbbCodeApplicationMap.put(itemj.getId(), item.getProductCode());
                    if (!StringUtils.isEmpty((CharSequence)itemj.getReplaceId())) {
                        replaceIdSet.add(itemj.getReplaceId());
                    }
                    tbbActivities.add(activity);
                }
            }));
        }
        activities = !org.springframework.util.CollectionUtils.isEmpty(activities) ? activities.stream().filter(activity -> !replaceIdSet.contains(activity.getCode())).collect(Collectors.toList()) : new LinkedList<Activity>();
        if (!org.springframework.util.CollectionUtils.isEmpty(tbbActivities)) {
            tbbActivities.forEach(tbbActivity -> tbbActivity.setCategory("STATEMENT"));
            activities.addAll(tbbActivities);
        }
    }

    @Override
    public Object getActivitiesAndSortByPattern(String pattern) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("pattern", pattern);
        RespObject resp = this.appMetaCaller.call("/record/activitiesAndSortByPattern", "get", map, RespObject.class);
        return resp.getResponse();
    }

    private void filterComponentByCode(List<ActivityDataEntryVO> activitiesByPattern, String pattern) throws DWBusinessException {
        if (org.springframework.util.CollectionUtils.isEmpty(activitiesByPattern)) {
            return;
        }
        List appCodeList = activitiesByPattern.stream().map(ActivityDataEntryVO::getAppCode).distinct().collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").in(appCodeList).and("tenantId").is((Object)AthenaUtils.getTenantId()));
        List tenantAppComponentListBOS = this.mongoTemplateUser.find(query, TenantAppComponentListBO.class);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tenantAppComponentListBOS)) {
            Map<String, List> map = tenantAppComponentListBOS.stream().collect(Collectors.toMap(TenantAppComponentListBO::getAppCode, vo -> {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)vo.getComponents())) {
                    return new ArrayList();
                }
                return vo.getComponents().stream().filter(v -> v.getType().equals((Object)this.transformPattern(pattern)) && !v.isDisabled()).map(ComponentBaseInfoBO::getCode).distinct().collect(Collectors.toList());
            }, (a, b) -> a));
            Iterator<ActivityDataEntryVO> iterator = activitiesByPattern.iterator();
            while (iterator.hasNext()) {
                List codeList;
                ActivityDataEntryVO next = iterator.next();
                if (!map.containsKey(next.getAppCode()) || org.springframework.util.CollectionUtils.isEmpty((Collection)(codeList = map.get(next.getAppCode()))) || codeList.contains(next.getCode())) continue;
                iterator.remove();
            }
        }
    }

    private ComponentTypeEnum transformPattern(String pattern) {
        if ("DATA_ENTRY".equals(pattern)) {
            return ComponentTypeEnum.BaseDataEntry;
        }
        if ("STATEMENT".equals(pattern) || "MOBI-STATEMENT".equals(pattern)) {
            return ComponentTypeEnum.Report;
        }
        log.error("not found pattern:{}", (Object)pattern);
        return null;
    }

    public List<ActivityDataEntryVO> postActivitiesGroup(List<ActivityDataEntryVO> requestList) throws Exception {
        log.info("start postActivitiesGroup:{}", (Object)System.currentTimeMillis());
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String lang = locale.toString();
        for (ActivityDataEntryVO vo : requestList) {
            ApplicationGroup applicationGroup;
            Criteria criteria;
            if (!StringUtils.isEmpty((CharSequence)vo.getGroupCode())) {
                criteria = new Criteria();
                criteria.and("appCode").exists(false).and("groupCode").is((Object)vo.getGroupCode()).and("version").is((Object)tenantVersion);
                applicationGroup = (ApplicationGroup)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), ApplicationGroup.class);
            } else {
                criteria = new Criteria();
                criteria.and("appCode").is((Object)vo.getAppCode()).and("activityCode").is((Object)vo.getCode()).and("version").is((Object)tenantVersion);
                applicationGroup = (ApplicationGroup)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), ApplicationGroup.class);
                if (null != applicationGroup) {
                    vo.setGroupCode(applicationGroup.getGroupCode());
                }
            }
            if (null == applicationGroup || null == applicationGroup.getLang()) continue;
            vo.setGroupSort(StringUtils.isEmpty((CharSequence)applicationGroup.getGroupSort()) ? null : applicationGroup.getGroupSort());
            Map<String, String> nameLangMap = applicationGroup.getLang().get("groupName");
            if (null == nameLangMap) {
                nameLangMap = applicationGroup.getLang().get("name") == null ? new HashMap<String, String>() : applicationGroup.getLang().get("name");
            }
            String language = null == nameLangMap.get(lang) ? applicationGroup.getGroupName() : nameLangMap.get(lang);
            vo.setGroupName(null == language ? applicationGroup.getGroupName() : language);
        }
        log.info("end postActivitiesGroup:{}", (Object)System.currentTimeMillis());
        return requestList;
    }

    private Map<String, Boolean> getActivityHasGroundEnd(List<Activity> activities) {
        if (org.springframework.util.CollectionUtils.isEmpty(activities)) {
            return new HashMap<String, Boolean>();
        }
        ArrayList allActivityList = new ArrayList();
        Map<String, List<Activity>> groupByVersionActivityMap = activities.stream().collect(Collectors.groupingBy(e -> e.getVersion() == null ? "" : e.getVersion()));
        Set<Map.Entry<String, List<Activity>>> entries = groupByVersionActivityMap.entrySet();
        for (Map.Entry<String, List<Activity>> entry : entries) {
            List<Activity> value = entry.getValue();
            List activityCodeList = value.stream().map(BaseEntity::getCode).collect(Collectors.toList());
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(activityCodeList).and("version").is((Object)entry.getKey()));
            query.fields().include("code").include("dependOnGroundEnd");
            List activityConfig = this.mongoTemplate.find(query, Activity.class, "activityConfigs");
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)activityConfig)) continue;
            allActivityList.addAll(activityConfig);
        }
        Map<String, Boolean> resultMap = allActivityList.stream().collect(Collectors.toMap(BaseEntity::getCode, e -> BooleanUtils.toBoolean((Boolean)e.getDependOnGroundEnd()), (a, b) -> a));
        return resultMap;
    }

    private boolean isCardCustom(FunctionCtrl functionCtrl) {
        return functionCtrl != null && (functionCtrl.isProjectCardCustomizeFlag() || functionCtrl.isTaskCardCustomizeFlag());
    }

    @Override
    public Object getActivityDefinition(String activityId, String pageCode) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("activityId", activityId);
        map.put("pageCode", pageCode);
        RespObject resp = this.appMetaCaller.call("/record/activityDefinition", "get", map, RespObject.class);
        return resp.getResponse();
    }

    private void dealReportSort(Activity activity, List<Map<String, Object>> sortData) {
        Map pages;
        if (activity != null && null != (pages = activity.getPages()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)((List)pages.get("layout")))) {
            List layoutList = (List)pages.get("layout");
            for (Map layout : layoutList) {
                if (!"FORM_LIST".equals(layout.get("type"))) continue;
                TaskService.processGroup(layout, sortData);
            }
        }
    }

    private static void processGroup(Map<String, Object> layout, List<Map<String, Object>> sortData) {
        List group = (List)layout.get("group");
        if (group != null) {
            Optional<Map> sortItemOpt = sortData.stream().filter(item -> ((String)layout.get("id")).equals(item.get("id"))).findFirst();
            if (sortItemOpt.isPresent()) {
                Map<String, Integer> sortIndexMap = TaskService.createSortIndexMap(sortItemOpt.get());
                group.sort(Comparator.comparingInt(item -> {
                    String pathSchema = (String)item.get("path") + ";" + item.get("schema");
                    return sortIndexMap.getOrDefault(pathSchema, 99999);
                }));
            }
            group.forEach(subItem -> {
                if ("FORM_LIST".equals(subItem.get("type"))) {
                    TaskService.processGroup(subItem, sortData);
                }
            });
        }
    }

    public static Map<String, Integer> createSortIndexMap(Map<String, Object> sortItem) {
        List sortFields = (List)sortItem.get("sortField");
        if (sortFields == null) {
            return new HashMap<String, Integer>();
        }
        return sortFields.stream().collect(Collectors.toMap(field -> field, field -> sortFields.indexOf(field), (existingValue, newValue) -> existingValue));
    }

    private void processSysSummaryFields(Activity activity) {
        Map pages;
        if (null != activity && !org.springframework.util.CollectionUtils.isEmpty((Map)(pages = activity.getPages()))) {
            List dataStates = (List)pages.get("dataStates");
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dataStates)) {
                dataStates.forEach(dataState -> {
                    if (SUMMARY.equals(dataState.get("type"))) {
                        activity.setSummary(dataState);
                        activity.setSummaryFields((List)dataState.get("fieldMappings"));
                    }
                    if (BUSINESS_INFO.equals(dataState.get("type"))) {
                        activity.setBusinessInfo(dataState);
                    }
                    if (SEARCH_KEY.equals(dataState.get("type"))) {
                        activity.setSearchKey(dataState);
                    }
                    if (PROJECT_INFO.equals(dataState.get("type"))) {
                        activity.setProjectInfo(dataState);
                    }
                });
                if (!this.checkNewSummary(activity)) {
                    List summaryFields = (List)((Map)dataStates.get(0)).get("summaryFields");
                    activity.setSummaryFields(summaryFields);
                }
            } else {
                List summaryFieldsCandidate = (List)pages.get("summaryFields");
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)summaryFieldsCandidate)) {
                    activity.setSummaryFields(summaryFieldsCandidate);
                }
            }
        }
    }

    private boolean checkNewSummary(Activity activity) {
        return !org.springframework.util.CollectionUtils.isEmpty((Map)activity.getSummary()) || !org.springframework.util.CollectionUtils.isEmpty((Map)activity.getBusinessInfo()) || !org.springframework.util.CollectionUtils.isEmpty((Map)activity.getSearchKey()) || !org.springframework.util.CollectionUtils.isEmpty((Map)activity.getProjectInfo());
    }

    private void processApplication(String activityId, Activity activity) throws DWBusinessException {
        if (null != activity) {
            ApplicationRelation applicationRelation = this.applicationService.getApplicationByTypeAndCode("activity", activityId, AthenaUtils.getCurrentLocale());
            if (null != applicationRelation) {
                activity.setApplication(applicationRelation.getAppCode());
                activity.setAppName(applicationRelation.getAppName());
            }
            activity.setActivityId(activityId);
            activity.setActivityName((Object)activity.getName());
            activity.getLang().put("activityName", activity.getLang().get("name"));
        }
    }

    private void processTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String type;
            String application = activity.getApplication();
            String code = activity.getCode();
            switch (pageCode) {
                case "project-card": {
                    type = "project";
                    break;
                }
                case "task-card": {
                    type = "task";
                    break;
                }
                default: {
                    type = null;
                }
            }
            if (this.checkNewSummary(activity)) {
                this.newProcessTenantSummaryFields(activity, pageCode);
            } else {
                activity.setCanSelectedSummaryFields((List)ObjectUtil.cloneByStream((Object)activity.getSummaryFields()));
                if (type != null && null != application) {
                    TenantSummaryFields tenantSummaryFields = this.queryTenantSummaryFields(application, type, code);
                    if (null != tenantSummaryFields) {
                        boolean ifUseTenantSummaryFields = this.judgeIfUseTenantSummaryFields(tenantSummaryFields, activity.getSummaryFields());
                        boolean ifUseTenantTitle = this.judgeIfUseTenantTitle(tenantSummaryFields);
                        if (ifUseTenantSummaryFields) {
                            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tenantSummaryFields.getSummaryFields())) {
                                List<Map<String, Object>> transformedTenantSummaryFields = this.transformTenantFieldsToSys(tenantSummaryFields, activity.getSummaryFields());
                                List<Map<String, Object>> mergedSummaryFields = this.mergeSummaryFields(activity.getSummaryFields(), transformedTenantSummaryFields);
                                Map pages = activity.getPages();
                                if (null != pages.get("dataStates") && !org.springframework.util.CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                                    List dataStates = (List)pages.get("dataStates");
                                    Map dataState = (Map)dataStates.get(0);
                                    dataState.put("summaryFields", mergedSummaryFields);
                                } else {
                                    pages.put("summaryFields", mergedSummaryFields);
                                }
                                activity.setSummaryFields(mergedSummaryFields);
                            }
                            activity.setUsedTenantSummaryFields(Boolean.valueOf(true));
                        } else {
                            activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                        }
                        if (ifUseTenantTitle && activity.getUsedTenantSummaryFields().booleanValue()) {
                            TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                            tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                            tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                            activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                        }
                        activity.setTenantSummaryFields(this.transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                    } else {
                        activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                    }
                } else {
                    activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                }
                this.filterSummaryFields(activity);
            }
        }
    }

    private void newProcessTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String type;
            String application = activity.getApplication();
            String code = activity.getCode();
            switch (pageCode) {
                case "project-card": {
                    type = "project";
                    break;
                }
                case "task-card": {
                    type = "task";
                    break;
                }
                default: {
                    type = null;
                }
            }
            List newSummaryFieldes = (List)activity.getSummary().get("fieldMappings");
            activity.setCanSelectedSummaryFields((List)ObjectUtil.cloneByStream((Object)newSummaryFieldes));
            if (type != null && null != application) {
                TenantSummaryFields tenantSummaryFields = this.queryTenantSummaryFields(application, type, code);
                if (null != tenantSummaryFields) {
                    boolean ifUseTenantSummaryFields = this.judgeIfUseTenantSummaryFields(tenantSummaryFields, newSummaryFieldes);
                    boolean ifUseTenantTitle = this.judgeIfUseTenantTitle(tenantSummaryFields);
                    if (ifUseTenantSummaryFields) {
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tenantSummaryFields.getSummaryFields())) {
                            List<Map<String, Object>> transformedTenantSummaryFields;
                            List<Map<String, Object>> mergedSummaryFields = transformedTenantSummaryFields = this.transformTenantFieldsToSys(tenantSummaryFields, newSummaryFieldes);
                            Map pages = activity.getPages();
                            if (null != pages.get("dataStates") && !org.springframework.util.CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                                for (Map dataState : (List)pages.get("dataStates")) {
                                    if (!SUMMARY.equals(dataState.get("type"))) continue;
                                    dataState.put("fieldMappings", mergedSummaryFields);
                                }
                            }
                            activity.setSummaryFields(mergedSummaryFields);
                        }
                        activity.setUsedTenantSummaryFields(Boolean.valueOf(true));
                    } else {
                        activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                    }
                    if (ifUseTenantTitle && activity.getUsedTenantSummaryFields().booleanValue()) {
                        TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                        tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                        tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                        activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                    }
                    activity.setTenantSummaryFields(this.transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                } else {
                    activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
                }
            } else {
                activity.setUsedTenantSummaryFields(Boolean.valueOf(false));
            }
            this.newFilterSummaryFields(activity);
        }
    }

    private List<Map<String, Object>> mergeSummaryFields(List<Map<String, Object>> summaryFields, List<Map<String, Object>> transformedTenantSummaryFields) {
        if (org.springframework.util.CollectionUtils.isEmpty(summaryFields)) {
            return transformedTenantSummaryFields;
        }
        ArrayList<Map<String, Object>> mergedSummaryFields = new ArrayList<Map<String, Object>>();
        mergedSummaryFields.addAll(transformedTenantSummaryFields);
        mergedSummaryFields.addAll(summaryFields.stream().filter(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false).collect(Collectors.toList()));
        return mergedSummaryFields;
    }

    private void filterSummaryFields(Activity activity) throws DWBusinessException {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields().booleanValue()) {
            activity.getSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)"defaultEffective", (Boolean)true) == false && MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) != false);
            Map pages = activity.getPages();
            if (null != pages.get("dataStates") && !org.springframework.util.CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                List dataStates = (List)pages.get("dataStates");
                Map dataState = (Map)dataStates.get(0);
                dataState.put("summaryFields", activity.getSummaryFields());
            } else {
                pages.put("summaryFields", activity.getSummaryFields());
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            activity.getCanSelectedSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            List canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString((Map)((Map)activity.getCanSelectedSummaryFields().get(0)), (Object)"actionId");
            List fields = null;
            if (StringUtils.isNotEmpty((CharSequence)actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO)this.actionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                }
                catch (Exception e) {
                    throw new DWBusinessException("\u67e5\u8be2\u5143\u6570\u636e\u5b9a\u4e49\u51fa\u9519\uff0cactionId\uff1a{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"description"))) {
                    Object title = JSONPath.eval((Object)field, (String)"$.tags[0].title");
                    Object localeTitle = JSONPath.eval((Object)field, (String)("$.tags[0].lang.title." + locale));
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_name"))) {
                    String value = MapUtils.getString((Map)field, (Object)"value", (String)"");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map tenantSummaryField : tenantSummaryFieldList) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString((Map)map, (Object)"value", (String)"").equals(MapUtils.getString((Map)tenantSummaryField, (Object)"value", (String)"")));
                if (!b || !MapUtils.getBoolean((Map)tenantSummaryField, (Object)SUMMARY, (Boolean)true).booleanValue()) continue;
                if (null != fields && !fields.isEmpty()) {
                    Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString((Map)tenantSummaryField, (Object)"data_name", (String)""))).findFirst();
                    dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                }
                canSelectedSummaryFields.add(tenantSummaryField);
            }
        }
    }

    private void newFilterSummaryFields(Activity activity) throws DWBusinessException {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields().booleanValue()) {
            activity.getSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)"defaultEffective", (Boolean)true) == false);
            Map pages = activity.getPages();
            if (null != pages.get("dataStates") && !org.springframework.util.CollectionUtils.isEmpty((Collection)((List)pages.get("dataStates")))) {
                for (Map dataState : (List)pages.get("dataStates")) {
                    if (!SUMMARY.equals(dataState.get("type"))) continue;
                    dataState.put("fieldMappings", activity.getSummaryFields());
                }
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            activity.getCanSelectedSummaryFields().removeIf(map -> MapUtils.getBoolean((Map)map, (Object)SUMMARY, (Boolean)true) == false);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)activity.getCanSelectedSummaryFields())) {
            List canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString((Map)((Map)activity.getCanSelectedSummaryFields().get(0)), (Object)"actionId");
            List fields = null;
            if (StringUtils.isNotEmpty((CharSequence)actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO)this.actionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                }
                catch (Exception e) {
                    throw new DWBusinessException("\u67e5\u8be2\u5143\u6570\u636e\u5b9a\u4e49\u51fa\u9519\uff0cactionId\uff1a{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"description"))) {
                    Object title = JSONPath.eval((Object)field, (String)"$.tags[0].title");
                    Object localeTitle = JSONPath.eval((Object)field, (String)("$.tags[0].lang.title." + locale));
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_name"))) {
                    String value = MapUtils.getString((Map)field, (Object)"value", (String)"");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)field, (Object)"data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map tenantSummaryField : tenantSummaryFieldList) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString((Map)map, (Object)"value", (String)"").equals(MapUtils.getString((Map)tenantSummaryField, (Object)"value", (String)"")));
                if (!b || !MapUtils.getBoolean((Map)tenantSummaryField, (Object)SUMMARY, (Boolean)true).booleanValue()) continue;
                if (fields != null && fields.size() > 0) {
                    Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString((Map)tenantSummaryField, (Object)"data_name", (String)""))).findFirst();
                    dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                }
                canSelectedSummaryFields.add(tenantSummaryField);
            }
        }
    }

    private List<Map<String, Object>> transformTenantFieldsToSys(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        List tenantSummaryFieldList = tenantSummaryFields.getSummaryFields();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tenantSummaryFieldList)) {
            ArrayList<Map<String, Object>> sysSummaryFields = new ArrayList<Map<String, Object>>(6);
            for (int i = 0; i < tenantSummaryFieldList.size(); ++i) {
                List values = ((TenantSummaryField)tenantSummaryFieldList.get(i)).getValue();
                for (int j = 0; j < values.size(); ++j) {
                    String fieldPath = (String)values.get(j);
                    Optional<Map> first = summaryFields.stream().filter(map -> fieldPath.equals(MapUtil.getStr((Map)map, (Object)"value"))).findFirst();
                    Map sysSummaryField = Maps.newHashMap();
                    if (first.isPresent()) {
                        sysSummaryField = first.get();
                    }
                    Map sysSummaryFieldCopy = (Map)ObjectUtil.cloneByStream((Object)sysSummaryField);
                    sysSummaryFieldCopy.put(SUMMARY, true);
                    sysSummaryFieldCopy.put("actionId", tenantSummaryFields.getActionId());
                    sysSummaryFieldCopy.put("value", fieldPath);
                    ArrayList tagList = new ArrayList(1);
                    HashMap<String, Object> tag = new HashMap<String, Object>();
                    tag.put("code", "group_" + i);
                    tag.put("title", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                    tag.put("customTitle", true);
                    if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)sysSummaryFieldCopy, (Object)"description"))) {
                        sysSummaryFieldCopy.put("description", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        sysSummaryFieldCopy.put("data_type", "string");
                        sysSummaryFieldCopy.put("data_name", fieldPath.contains(".") ? fieldPath.split("\\.")[1] : fieldPath);
                    }
                    if (!tag.containsKey("lang")) {
                        JSONObject lang = new JSONObject();
                        JSONObject titleLang = new JSONObject();
                        titleLang.fluentPut("zh_CN", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("zh_TW", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("en_US", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        lang.put("title", (Object)titleLang);
                        tag.put("lang", lang);
                    }
                    tagList.add(tag);
                    sysSummaryFieldCopy.put("tags", tagList);
                    sysSummaryFields.add(sysSummaryFieldCopy);
                }
            }
            return sysSummaryFields;
        }
        return summaryFields;
    }

    private TenantSummaryFieldsDto transformToTenantSummaryFieldsDTO(TenantSummaryFields tenantSummaryFields) {
        return (TenantSummaryFieldsDto)JSON.parseObject((String)JSON.toJSONString((Object)tenantSummaryFields), TenantSummaryFieldsDto.class);
    }

    private boolean judgeIfUseTenantSummaryFields(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        if (org.springframework.util.CollectionUtils.isEmpty(summaryFields)) {
            return false;
        }
        return summaryFields.get(0).get("actionId").equals(tenantSummaryFields.getActionId());
    }

    private boolean judgeIfUseTenantTitle(TenantSummaryFields tenantSummaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        String titlePrefix = tenantSummaryFields.getTitlePrefix();
        List title = tenantSummaryFields.getTitle();
        return !org.springframework.util.CollectionUtils.isEmpty((Collection)title) || !StringUtils.isEmpty((CharSequence)titlePrefix);
    }

    @Override
    @DWLogOperation(desc="\u83b7\u53d6\u4efb\u52a1")
    public Object getActivityDefinition(String taskId, String activityId, String pageCode) throws Exception {
        return this.dataMapService.getActivityDefinitionWithMergeRule(taskId, activityId, pageCode);
    }

    private void handleReminderRule(Activity activity) {
        ReminderRule reminderRule = activity.getReminderRule();
        if (reminderRule != null && org.springframework.util.CollectionUtils.isEmpty((Collection)reminderRule.getRules())) {
            String currentLocale = AthenaUtils.getCurrentLocale();
            String titlePrefix = "\u89c4\u5219";
            if ("zh_TW".equals(currentLocale)) {
                titlePrefix = "\u898f\u5247";
            } else if ("en_US".equals(currentLocale)) {
                titlePrefix = "rule";
            }
            HashMap<String, Object> rule = new HashMap<String, Object>();
            rule.put("aheadTime", reminderRule.getAheadTime());
            rule.put("notices", reminderRule.getNotices());
            rule.put("rule", reminderRule.getRule());
            rule.put("title", titlePrefix + "1");
            rule.put("identities", Collections.emptyList());
            reminderRule.setRules(Collections.singletonList(rule));
            reminderRule.setRule(null);
            reminderRule.setNotices(null);
            reminderRule.setAheadTime(null);
        }
        if (reminderRule != null && !org.springframework.util.CollectionUtils.isEmpty((Collection)reminderRule.getRules())) {
            for (Map ruleItem : reminderRule.getRules()) {
                Map map = MapUtils.getMap((Map)ruleItem, (Object)"rule", Collections.emptyMap());
                String ruleType = MapUtils.getString((Map)map, (Object)"rule");
                if ("count".equals(ruleType)) {
                    map.put("interval", null);
                    continue;
                }
                map.put("count", null);
            }
        }
    }

    private void processMergeRule(Activity activity, String taskId, String activityId, FunctionCtrl functionCtrl) throws Exception {
        boolean enableCustomize;
        boolean bl = enableCustomize = null == functionCtrl ? false : functionCtrl.isTaskCardMergeCustomizeFlag();
        if (!enableCustomize) {
            return;
        }
        Map activityConfig = (Map)this.getActivityConfig(taskId, activityId);
        MergeRule mergeRule = (MergeRule)this.getTenantMergeConfig("task", activityId);
        if (null == mergeRule || mergeRule.getDelete().booleanValue()) {
            return;
        }
        activity.setMerge(mergeRule.getMerge());
        Map<String, Object> mergeConfig = MergeRule.convertToMergeConfig(mergeRule.getMergeRules(), activityConfig);
        activity.getConfig().put("mergeConfig", mergeConfig);
    }

    private boolean judgeUseMergeAbility(Map<String, Object> config, Boolean merge) {
        boolean mergeB = merge;
        Map mergeConfig = (Map)config.get("mergeConfig");
        if (!org.springframework.util.CollectionUtils.isEmpty((Map)mergeConfig)) {
            List fieldMeta = (List)mergeConfig.get("fieldMeta");
            if (mergeB && !org.springframework.util.CollectionUtils.isEmpty((Collection)fieldMeta)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getActivityConfig(String taskId, String activityId) throws Exception {
        return this.dataMapService.getActivityConfig(taskId, activityId);
    }

    @Override
    public Object getTenantMergeConfig(String type, String code) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"type").is((Object)type).and("code").is((Object)code).and("tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        MergeRule mergeRule = (MergeRule)this.mongoTemplateUser.findOne(queryUser, MergeRule.class);
        return mergeRule;
    }

    @Override
    public Object postTenantMergeRule(MergeRule mergeRule) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"type").is((Object)mergeRule.getType()).and("code").is((Object)mergeRule.getCode()).and("tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("merge", (Object)mergeRule.getMerge());
        update.set("delete", (Object)mergeRule.getDelete());
        update.set("mergeRules", mergeRule.getMergeRules());
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, update, MergeRule.class);
        long count = updateResult.getModifiedCount();
        if (count > 0L) {
            String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":*";
            try {
                this.cacheService.deleteWithPattern(cacheKey);
            }
            catch (Exception e) {
                log.error("delete redis fail:", (Throwable)e);
            }
        }
        return count;
    }

    @Override
    public Object postDeleteTenantMergeRule(String type, String code, String application) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"type").is((Object)type).and("code").is((Object)code).and("tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("delete", (Object)true);
        UpdateResult updateResult = this.mongoTemplateUser.updateFirst(queryUser, update, MergeRule.class);
        long count = updateResult.getModifiedCount();
        if (count > 0L) {
            String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":*";
            try {
                this.cacheService.deleteWithPattern(cacheKey);
            }
            catch (Exception e) {
                log.error("delete redis fail:", (Throwable)e);
            }
        }
        return count;
    }

    @Override
    @DWLogOperation(desc="\u83b7\u53d6\u4efb\u52a1")
    public Object postActivityDefinition(String taskId, String activityId, String pageCode, OperationUnit operationUnit) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("taskId", taskId);
        query.put("activityId", activityId);
        query.put("pageCode", pageCode);
        query.put("operationUnit", operationUnit);
        return this.dataMapService.postActivityDefinition(query);
    }

    @Override
    public Object getActivityStartTargetCode(String taskId, String activityId, String pageCode) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("projectCode", taskId);
        param.put("taskCode", activityId);
        Object obj = this.dataMapService.postActivityStartTargetCode(param);
        return obj;
    }

    @Override
    public Object getTaskInfoFromDataMap(String activityId) {
        return this.getTaskInfoFromDataMap(null, activityId, null, null);
    }

    public Object getTaskInfoFromDataMap(String taskId, String activityId, String pageCode, String tenantId) {
        return this.getTaskInfoFromDataMap(taskId, activityId, pageCode, tenantId, null);
    }

    private Object getTaskInfoFromDataMap(String taskId, String activityId, String pageCode, String tenantId, OperationUnit operationUnit) {
        Object dm = this.dataMapService.getTask(taskId, activityId, pageCode, operationUnit);
        if (null != dm) {
            try {
                Map dueDateRule;
                Map json = (Map)dm;
                Map dataSources = (Map)json.get("dataSources");
                Map pages = (Map)json.get("pages");
                this.batchSetProductInfo(dataSources, tenantId);
                this.batchSetProductInfo(pages, tenantId);
                Map expectedDuration = (Map)json.get("expectedDuration");
                if (null != expectedDuration && null != (dueDateRule = (Map)expectedDuration.get("dueDateRule"))) {
                    Map getDateAction = (Map)dueDateRule.get("getDateAction");
                    this.batchSetProductInfo(getDateAction, tenantId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dm;
    }

    private Object getPageUIElementFromDataMap(String taskId, String activityId, String pageCode, String tenantId) {
        List dm = (List)this.dataMapService.getPageUIElement(taskId, activityId, pageCode);
        return dm;
    }

    private Object getSystemHooksFromDataMap(List<String> activityIds, List<String> pageCodes) {
        List dm = (List)this.dataMapService.getSystemHooks(activityIds, pageCodes);
        return dm;
    }

    private void doApproveItemProductInfo(List<? extends ApproveItem> items, String tenantId) {
        if (null == items) {
            return;
        }
        List<Action> actions1 = items.stream().filter(approve -> null != approve.getSubmits()).flatMap(approve -> approve.getSubmits().stream()).filter(Objects::nonNull).collect(Collectors.toList());
        List actions2 = items.stream().filter(approve -> null != approve.getSubmits()).flatMap(approve -> approve.getSubmits().stream()).filter(Objects::nonNull).filter(action -> null != action.getAttachActions()).flatMap(action -> action.getAttachActions().stream()).filter(Objects::nonNull).collect(Collectors.toList());
        actions1.addAll(actions2);
        try {
            this.batchSetDataActionProductInfo2(actions1, tenantId);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6productName\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Object getActivityDefinitionWithMultiLanguage(String taskId, String activityId, String tenantId) throws Exception {
        return null;
    }

    @Override
    public Object getManualList() throws DWBusinessException {
        System.out.println(Thread.currentThread().getName() + " kg getManualList...");
        return this.dataMapService.getManualListMobile();
    }

    public Object getManualListBasic() throws DWBusinessException {
        return this.dataMapService.getManualList();
    }

    private String getTaskCode(Object object) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)object));
        String code = jsonObject.getString("code");
        return code;
    }

    private void filterProject(List projectInDataMap, List<String> appCodes, String tenantId) throws DWBusinessException {
        if (null != projectInDataMap) {
            try {
                String projectCode;
                JSONObject project;
                if (appCodes == null) {
                    appCodes = this.cacUtils.getAppAuth();
                }
                HashMap<String, List> componentListByAppCode = new HashMap<String, List>();
                ArrayList<String> taskCodeList = new ArrayList<String>();
                projectInDataMap.forEach(e -> {
                    String taskCode = this.getTaskCode(e);
                    taskCodeList.add(taskCode);
                });
                List<ApplicationRelation> applicationRelationList = this.applicationService.getApplicationByTypeAndCode("task", taskCodeList);
                Map<String, String> collect1 = applicationRelationList.stream().collect(Collectors.toMap(BaseEntity::getCode, ApplicationRelation::getAppCode, (a, b) -> a));
                ArrayList remainProjectCodes = new ArrayList();
                ArrayList checkedProjectCodes = new ArrayList();
                for (Object projectObj : projectInDataMap) {
                    project = (JSONObject)projectObj;
                    projectCode = project.getString("code");
                    String appCode2 = collect1.get(projectCode);
                    if (!componentListByAppCode.containsKey(appCode2)) {
                        componentListByAppCode.put(appCode2, new ArrayList());
                    }
                    ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
                    componentInfo.setCode(projectCode);
                    componentInfo.setType(ComponentTypeEnum.Project);
                    ((List)componentListByAppCode.get(appCode2)).add(componentInfo);
                }
                componentListByAppCode.forEach((appCode, componentList) -> {
                    try {
                        List<ComponentBaseInfoBO> filteredBaseInfos = this.componentManager.FilterByTenantApplicationComponentList((String)appCode, tenantId, (List<ComponentBaseInfoBO>)componentList);
                        componentList.forEach(component -> checkedProjectCodes.add(component.getCode()));
                        filteredBaseInfos.forEach(component -> remainProjectCodes.add(component.getCode()));
                    }
                    catch (Exception e) {
                        log.error("process app componentList exception:", (Throwable)e);
                        log.error("process app componentList error:appCode[{}],componentList[{}]", appCode, componentList);
                    }
                });
                Iterator iterator = projectInDataMap.iterator();
                while (iterator.hasNext()) {
                    Object projectObj;
                    projectObj = iterator.next();
                    project = (JSONObject)projectObj;
                    projectCode = project.getString("code");
                    if (checkedProjectCodes.contains(projectCode) && !remainProjectCodes.contains(projectCode)) {
                        iterator.remove();
                        continue;
                    }
                    if (!collect1.containsKey(projectCode) || appCodes.contains(collect1.get(projectCode))) continue;
                    iterator.remove();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getDetail(String taskId) throws DWBusinessException {
        return this.dataMapService.getDetail(taskId);
    }

    @Override
    public Object getInputData(String taskId) throws DWBusinessException {
        Object obj2 = this.dataMapService.projectInputData(taskId);
        return obj2;
    }

    @Override
    public Object getSolvePlan(String taskId, String activityId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<SolvePlan> plans = this.solvePlanRepository.getByActivity(tenantId, taskId, activityId, tenantVersion);
        return plans;
    }

    @Override
    public Object getSolvePlan(String activityId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<SolvePlan> plans = this.solvePlanRepository.getByActivity(tenantId, activityId, tenantVersion);
        return plans;
    }

    @Override
    public Object getSolvePlanByData(String dataName) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<SolvePlanData> plans = this.solvePlanRepository.getByData(dataName, locale.toString(), tenantVersion);
        try {
            plans.sort(Comparator.comparing(e -> e.getSolvePlan().getPlanId()));
        }
        catch (Exception e2) {
            log.error("SolvePlanList sort error:{}", (Object)e2.getMessage());
        }
        ArrayList res = new ArrayList(plans.size());
        for (SolvePlanData p : plans) {
            Language lang = p.getLanguage();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("planId", p.getSolvePlan().getPlanId());
            if (lang == null || lang.getName() == null) {
                map.put("name", p.getSolvePlan().getName());
            } else {
                map.put("name", lang.getName());
            }
            map.put("enableApprove", this.enableApprove(p.getActivitySet()));
            if (null != p.getSolvePlan().getLang()) {
                map.put("lang", p.getSolvePlan().getLang());
            }
            res.add(map);
        }
        return res;
    }

    private boolean enableApprove(ActivitySet activitySet) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        if (activitySet == null) {
            return false;
        }
        String activities = activitySet.getActivities();
        if (StringUtils.isEmpty((CharSequence)activities)) {
            return false;
        }
        JSONArray ja = JSON.parseArray((String)activities);
        ArrayList<String> activityIdList = new ArrayList<String>();
        for (int i = 0; i < ja.size(); ++i) {
            activityIdList.add(ja.getJSONObject(i).getString("activityId"));
        }
        List<ActivityBaseInfoVO> activityList = this.activityDAO.getApproveActivityListByActivityIds(activityIdList, tenantId, tenantVersion);
        if (org.springframework.util.CollectionUtils.isEmpty(activityList)) {
            HashMap<String, Object> query = new HashMap<String, Object>();
            query.put("category", "APPROVAL");
            query.put("code", activityIdList);
            List taskList = this.dataMapService.getTaskList(query);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)taskList)) {
                return false;
            }
            Object o = taskList.get(0);
            Activity activity = (Activity)JSON.parseObject((String)JSON.toJSONString(o), Activity.class);
            Object task = this.dataMapService.getTask("", activity.getCode(), null);
            if (task != null) {
                Map json = (Map)task;
                Object approveObj = json.get("approve");
                if (approveObj == null) {
                    return true;
                }
                Map approve = (Map)approveObj;
                if (approve == null || "Y".equals(String.valueOf(approve.get("enableApprove")))) {
                    return true;
                }
            }
            return false;
        }
        ActivityBaseInfoVO activityBaseInfoVO = activityList.get(0);
        Activity betterActivity = this.findBetterActivity(AthenaUtils.getTenantId(), activityBaseInfoVO.getActivityId(), activityBaseInfoVO.getActivityVersion());
        if (betterActivity == null) {
            return false;
        }
        return betterActivity.getApprove() == null || StringUtils.equals((CharSequence)"Y", (CharSequence)betterActivity.getApprove().getEnableApprove());
    }

    @Override
    public Object getActivitiesWithMultiLanguage(String taskId, String compositionId) throws Exception {
        if (compositionId == null || compositionId.isEmpty()) {
            return this.getActivitiesWithMultiLanguage(taskId);
        }
        Object re = null;
        try {
            ActivityComposition composition = this.activityCompositionRepository.findOneByCompositionId(compositionId);
            if (composition != null && composition.getCompositionCodes() != null && !composition.getCompositionCodes().isEmpty()) {
                String tenantId = AthenaUtils.getTenantId();
                String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                DynamicTaskAndActivities tt = this.dynamicTaskRepository.findTaskAndActivities(tenantId, taskId, composition.getCompositionCodes(), tenantVersion);
                Assert.notNull((Object)tt, (String)("can not find task by code:" + taskId + " and tenantId:" + tenantId));
                if (log.isInfoEnabled()) {
                    log.info("neo4j find task by code:{} and tenantId:{},result={}", new Object[]{taskId, tenantId, tt});
                }
                Task task = tt.getTask();
                task.setActivities(tt.getActivities());
                task.setTaskId(task.getCode());
                task.setTaskName(task.getName());
                if (null != task.getLang().get("name")) {
                    task.setTaskName(task.getLang().get("name"));
                    task.getLang().remove("name");
                }
                if (null != task.getActivities()) {
                    Collections.sort(task.getActivities());
                    task.getActivities().forEach(a -> {
                        a.setActivityId(a.getCode());
                        if (null != a.getLang().get("name")) {
                            a.setActivityName(a.getLang().get("name"));
                        }
                    });
                }
                TaskActivitiesDTO activitiesDTO = new TaskActivitiesDTO();
                activitiesDTO.setTaskId(task.getCode());
                activitiesDTO.setTaskName(task.getTaskName());
                activitiesDTO.setEmergency(task.getEmergency());
                HashMap<String, ActivityInfoDTO> dynamicActivities = new HashMap<String, ActivityInfoDTO>();
                for (Activity activity : task.getActivities()) {
                    ActivityInfoDTO activityInfoDTO = new ActivityInfoDTO();
                    activityInfoDTO.setActivityId(activity.getActivityId());
                    activityInfoDTO.setActivityName(activity.getActivityName());
                    activityInfoDTO.setExecuteType(ActivityExecuteTypeEnum.valueOf(activity.getExecuteType()));
                    activityInfoDTO.setSequence(activity.getSequence());
                    activityInfoDTO.setEmergency(activity.getEmergency());
                    activityInfoDTO.setMilestone(activity.getMilestone());
                    activityInfoDTO.setShowFlow(activity.getShowFlow());
                    activityInfoDTO.setCategory(activity.getCategory());
                    activityInfoDTO.setPattern(activity.getPattern());
                    activityInfoDTO.setMerge(activity.getMerge());
                    dynamicActivities.put(activity.getActivityId(), activityInfoDTO);
                }
                ArrayList<ActivityInfoDTO> activities = new ArrayList<ActivityInfoDTO>();
                for (ActivityCompositionItem item : composition.getActivities()) {
                    String dynCode = item.getDynamicActivityCode();
                    ActivityInfoDTO define = (ActivityInfoDTO)dynamicActivities.get(dynCode);
                    ActivityInfoDTO activity = (ActivityInfoDTO)define.clone();
                    activity.setActivityId(item.getActivityId());
                    activity.setSequence(item.getSequence());
                    activity.setActivityName(item.getName());
                    ExpectedDurationDTO expDurDate = new ExpectedDurationDTO();
                    expDurDate.setDueDateType(Integer.valueOf(2));
                    expDurDate.setConstantValue(item.getDueDate());
                    activity.setExpectedDuration(expDurDate);
                    activities.add(activity);
                }
                activitiesDTO.setActivities(activities);
                re = activitiesDTO;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (re == null) {
            re = this.getActivitiesWithMultiLanguage(taskId);
        }
        return re;
    }

    @Override
    public Object getAllTasks() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> codes = this.dataPickService.tenantApplicationRelationCodes("task");
        List<Task> tasks = this.taskRepository.allTask(tenantId, tenantVersion, codes);
        return tasks;
    }

    @Override
    public Object getAppSubscription(String taskId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List<ApplicationRelation> relations = this.applicationService.getAppCodeByTaskCode(taskId);
        AppSubscription appSubscription = new AppSubscription();
        if (relations.size() > 0) {
            ApplicationRelation first = relations.get(0);
            appSubscription.setAppId(first.getAppCode());
            appSubscription.setName(first.getAppName());
            appSubscription.setTenantId(tenantId);
            appSubscription.setTaskId(taskId);
        }
        return appSubscription;
    }

    private void batchSetProductInfo(Map<String, Object> data, String tenantId) throws Exception {
        if (org.springframework.util.CollectionUtils.isEmpty(data)) {
            return;
        }
        ArrayList<Map<String, Object>> actionMap = new ArrayList<Map<String, Object>>();
        this.batchMapSetActionMap(data, tenantId, actionMap);
        this.batchSetDataActionProductInfo(actionMap, tenantId);
    }

    private void batchMapSetActionMap(Map<String, Object> data, String tenantId, List<Map<String, Object>> actionMap) {
        if (org.springframework.util.CollectionUtils.isEmpty(data)) {
            return;
        }
        actionMap.add(data);
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                this.batchMapSetActionMap((Map)value, tenantId, actionMap);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.batchListSetActionMap((List)value, tenantId, actionMap);
        }
    }

    private void batchListSetActionMap(List data, String tenantId, List<Map<String, Object>> actionMap) {
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        for (Object item : data) {
            if (item instanceof Map) {
                this.batchMapSetActionMap((Map)item, tenantId, actionMap);
                continue;
            }
            if (!(item instanceof List)) continue;
            this.batchListSetActionMap((List)item, tenantId, actionMap);
        }
    }

    private void batchSetDataActionProductInfo(List<Map<String, Object>> actions, String tenantId) throws Exception {
        if (org.springframework.util.CollectionUtils.isEmpty(actions)) {
            return;
        }
        if (org.springframework.util.CollectionUtils.isEmpty(actions = actions.stream().filter(action -> ObjectUtils.isEmpty(action.get("productName")) && "ESP".equalsIgnoreCase(String.valueOf(action.get("type"))) && StringUtils.isNotEmpty((CharSequence)String.valueOf(action.get("serviceName")))).collect(Collectors.toList()))) {
            return;
        }
        List serviceNames = actions.stream().map(action -> String.valueOf(action.get("serviceName"))).distinct().collect(Collectors.toList());
        Map serviceNameMap = this.productNameResolver.getProductNameMap(tenantId, serviceNames);
        for (Map<String, Object> action2 : actions) {
            action2.put("productName", serviceNameMap.get(String.valueOf(action2.get("serviceName"))));
        }
    }

    private void setDataActionProductInfo2(Action action, String tenantId) throws Exception {
        if (action == null || !ObjectUtils.isEmpty((Object)action.getProductName()) || !"ESP".equalsIgnoreCase(action.getType())) {
            return;
        }
        String url = action.getUrl();
        String serviceName = action.getServiceName();
        if ((url == null || url.isEmpty()) && (serviceName == null || serviceName.isEmpty())) {
            return;
        }
        action.setProductName(this.productNameResolver.getProductName(serviceName, tenantId));
    }

    private void batchSetDataActionProductInfo2(List<Action> actions, String tenantId) throws Exception {
        if (org.springframework.util.CollectionUtils.isEmpty(actions)) {
            return;
        }
        if (org.springframework.util.CollectionUtils.isEmpty(actions = actions.stream().filter(action -> ObjectUtils.isEmpty((Object)action.getProductName()) && "ESP".equalsIgnoreCase(action.getType()) && StringUtils.isNotEmpty((CharSequence)action.getServiceName())).collect(Collectors.toList()))) {
            return;
        }
        List serviceNames = actions.stream().map(Action::getServiceName).distinct().collect(Collectors.toList());
        Map serviceNameMap = this.productNameResolver.getProductNameMap(tenantId, serviceNames);
        for (Action action2 : actions) {
            action2.setProductName((String)serviceNameMap.get(action2.getServiceName()));
        }
    }

    public Activity findBetterActivity(String tenantId, String activityCode, String activityVersion) throws DWBusinessException {
        HashMap<String, Object> keyConditions = new HashMap<String, Object>();
        keyConditions.put("code", activityCode);
        Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)activityCode).and("version").is((Object)activityVersion).and("tenantId").is((Object)tenantId));
        Activity defaultActivity = this.mongoEntityBaseDAO.findOne(keyConditions, activityVersion, Activity.class, "activityConfigs");
        Activity tenantActivity = (Activity)this.mongoTemplateUser.findOne(query2, Activity.class, "activityConfigs");
        if (null != tenantActivity) {
            AthenaUtils.mergeObject(tenantActivity, defaultActivity, MergePolicyBuilder.getPolicy((String)Activity.class.getName()));
        }
        return defaultActivity;
    }

    private Task findTaskConfig(String tenantId, String taskCode, String taskVersion) {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)taskCode).and("version").is((Object)taskVersion));
        Task defTask = (Task)((Object)this.mongoTemplate.findOne(query, Task.class, "taskConfigs"));
        Query query1 = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)taskCode).and("version").is((Object)taskVersion).and("tenantId").is((Object)tenantId));
        Task tenantTask = (Task)((Object)this.mongoTemplateUser.findOne(query1, Task.class, "taskConfigs"));
        if (defTask != null) {
            if (tenantTask != null) {
                AthenaUtils.mergeObject((Object)tenantTask, (Object)defTask);
            }
            return defTask;
        }
        return tenantTask;
    }

    @Override
    @Deprecated
    public Object postUpdateTaskConfig(Task data) throws DWBusinessException {
        String col = "taskConfigs";
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Task task = this.taskRepository.findTask(tenantId, data.getCode(), tenantVersion);
        if (task == null) {
            this.dataMapService.updateProject((Object)data);
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)data.getCode()).and("version").is((Object)data.getVersion()).and("tenantId").is((Object)tenantId));
            Task indb2 = (Task)((Object)this.mongoTemplateUser.findOne(query, Task.class, col));
            if (null != indb2) {
                data.setId(null);
                AthenaUtils.mergeObject((Object)data, (Object)indb2);
                this.mongoTemplateUser.save((Object)indb2, col);
            } else {
                data.setTenantId(tenantId);
                data.setId(null);
                this.mongoTemplateUser.save((Object)data, col);
            }
        }
        return "success";
    }

    @Override
    public Object postUpdateTaskConfig(Task data, OperationUnit operationUnit) throws DWBusinessException {
        String col = "taskConfigs";
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Task task = this.taskRepository.findTask(tenantId, data.getCode(), tenantVersion);
        if (task == null) {
            this.dataMapService.updateProject((Object)data, operationUnit);
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)data.getCode()).and("version").is((Object)data.getVersion()).and("tenantId").is((Object)tenantId));
            Task indb2 = (Task)((Object)this.mongoTemplateUser.findOne(query, Task.class, col));
            if (null != indb2) {
                data.setId(null);
                AthenaUtils.mergeObject((Object)data, (Object)indb2);
                this.mongoTemplateUser.save((Object)indb2, col);
            } else {
                data.setTenantId(tenantId);
                data.setId(null);
                this.mongoTemplateUser.save((Object)data, col);
            }
        }
        return "success";
    }

    @Override
    public Object postQueryRelatedTask(String tenantId, String activityId) throws Exception {
        Map app;
        String appId;
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tenantIdEmpty", new Object[0]));
        }
        if (activityId == null || activityId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.activityIdEmpty", new Object[0]));
        }
        HashMap<String, String> keyConditions = new HashMap<String, String>();
        keyConditions.put("code", activityId);
        ActivityConfig config = this.dataPickService.findByCode(activityId, ActivityConfig.class, "activityConfigs");
        if (config.getRelatedTasks() != null && config.getRelatedTasks().size() > 0 && StringUtils.isNotEmpty((CharSequence)(appId = (String)(app = (Map)config.getRelatedTasks().get(0)).get("appId"))) && this.cacUtils.getAppAuth(tenantId, appId).booleanValue()) {
            return app.get("taskCode");
        }
        return null;
    }

    @Override
    public Object getTaskByApp(String applicationCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        ArrayList<TaskDTO> result = new ArrayList<TaskDTO>();
        List<String> taskIdList = this.applicationService.getTaskCode(applicationCode);
        taskIdList = this.filterProjectByComponent(applicationCode, tenantId, taskIdList);
        for (String taskId : taskIdList) {
            JSONObject jsonObject;
            TaskDTO taskDTO = new TaskDTO();
            Object definitionWithMultiLanguage = this.getDefinitionWithMultiLanguage(taskId);
            if (null == definitionWithMultiLanguage || definitionWithMultiLanguage instanceof String || (jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)definitionWithMultiLanguage))) != null && jsonObject.getBooleanValue("hideDeliverySetting") || jsonObject != null && jsonObject.getJSONObject("config") != null && jsonObject.getJSONObject("config").getBooleanValue("hideDeliverySetting")) continue;
            taskDTO.setTask(definitionWithMultiLanguage);
            List taskDataGroupAction = this.dataPickService.excludeWithSameCode(this.actionRepository.getTaskDataGroupAction(taskId));
            if (!org.springframework.util.CollectionUtils.isEmpty(taskDataGroupAction)) {
                taskDTO.setHasDataGroupAction(true);
            }
            Query query = new Query();
            Criteria criteria = Criteria.where((String)"taskCode").is((Object)taskId).and("version").is((Object)tenantVersion);
            query.addCriteria((CriteriaDefinition)criteria);
            List taskMechanism = this.mongoTemplate.find(query, TaskMonitorRule.class, "taskMonitorRule");
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)taskMechanism)) {
                List<String> collect = taskMechanism.stream().map(TaskMonitorRule::getMonitorRuleCode).collect(Collectors.toList());
                taskDTO.setRelatedMonitorRules(collect);
            }
            result.add(taskDTO);
        }
        return result;
    }

    @Override
    public Object postTaskByApp(String applicationCode, OperationUnit operationUnit) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("applicationCode", applicationCode);
        query.put("operationUnit", operationUnit);
        return this.dataMapService.postTaskByApp(query);
    }

    @Override
    public Object postFixTask(String taskId, OperationUnit operationUnit) throws Exception {
        log.info("fix Project:{}", (Object)taskId);
        this.dataMapService.postFixProject(taskId);
        return null;
    }

    private List<String> filterProjectByComponent(String appCode, String tenantId, List<String> taskIdList) {
        if (org.springframework.util.CollectionUtils.isEmpty(taskIdList)) {
            return null;
        }
        ArrayList<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<ComponentBaseInfoBO>();
        for (String taskId : taskIdList) {
            ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
            componentInfo.setCode(taskId);
            componentInfo.setType(ComponentTypeEnum.Project);
            componentBaseInfos.add(componentInfo);
        }
        try {
            List<ComponentBaseInfoBO> filteredBaseInfos = this.componentManager.FilterByTenantApplicationComponentList(appCode, tenantId, componentBaseInfos);
            if (!org.springframework.util.CollectionUtils.isEmpty(filteredBaseInfos) && filteredBaseInfos.size() != componentBaseInfos.size()) {
                List<String> collect = filteredBaseInfos.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
                return collect;
            }
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return taskIdList;
    }

    @Override
    public Object getReportsByBizCodeNType(String bizCode, Integer type) throws Exception {
        return this.getReportsByBizCodeNType(bizCode, type, null);
    }

    @Override
    public Object getReportsByBizCodeNType(String bizCode, Integer type, String userId) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid", new Object[0]));
        }
        List<BizRelatedReport> relatedReports = this.dataPickService.find(Criteria.where((String)"bizCode").is((Object)bizCode).and("type").is((Object)type), BizRelatedReport.class, "bizRelatedReports");
        try {
            this.filterBizReportByVisibleCondition(relatedReports, tenantId);
        }
        catch (Exception e) {
            log.error("filterBizReportByVisibleCondition error:{}", (Object)e.getMessage());
        }
        if (org.springframework.util.CollectionUtils.isEmpty(relatedReports)) {
            return Collections.EMPTY_LIST;
        }
        Map<String, BizRelatedReport> relatedReportMap = relatedReports.stream().collect(Collectors.toMap(BizRelatedReport::getReportCode, a -> a));
        List<String> reportCodes = relatedReports.stream().map(BizRelatedReport::getReportCode).collect(Collectors.toList());
        List<Object> appCodes = new ArrayList();
        appCodes = StringUtils.isNotEmpty((CharSequence)userId) ? this.cacUtils.getAppAuth(userId) : this.cacUtils.getAppAuth();
        List<ApplicationRelation> relations = this.appService.getApplicationRelation(appCodes, reportCodes, "activity", null);
        reportCodes = relations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<Activity> reportList = this.dataPickService.excludeWithSameCode(this.activityDAO.getReportActivitiesByCode(reportCodes, tenantId, tenantVersion));
        if (org.springframework.util.CollectionUtils.isEmpty(reportList)) {
            return Collections.EMPTY_LIST;
        }
        this.filterUc(reportList, tenantId);
        LinkedList relatedReportResultList = new LinkedList();
        reportList.forEach(item -> {
            BizRelatedReport bizRelatedReportItem = (BizRelatedReport)((Object)((Object)relatedReportMap.get(item.getCode())));
            bizRelatedReportItem.setParamsMapping(null);
            bizRelatedReportItem.setReportName(item.getLang().isEmpty() || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : (String)((Map)item.getLang().get("name")).get(localeStr));
            relatedReportResultList.add(bizRelatedReportItem);
        });
        return relatedReportResultList;
    }

    @Override
    @Deprecated
    public Object getDataEntryByBizCodeNType(String code, Integer type) throws Exception {
        String application;
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid", new Object[0]));
        }
        switch (type) {
            case 1: {
                Task task = this.taskRepository.findTaskNoTenantId(code);
                if (null == task) {
                    return Collections.EMPTY_LIST;
                }
                application = task.getNameSpace();
                break;
            }
            case 2: {
                Activity activity = this.activityDAO.findActivityNoTenantId(code);
                if (null == activity) {
                    return Collections.EMPTY_LIST;
                }
                application = activity.getNameSpace();
                break;
            }
            default: {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeNotSupport2", new Object[0]));
            }
        }
        List<Activity> reportList = this.activityDAO.getDataEntryByNameSpace(application);
        if (org.springframework.util.CollectionUtils.isEmpty(reportList)) {
            return Collections.EMPTY_LIST;
        }
        return reportList;
    }

    private boolean filterActivityByHasGroundEnd(String code, String tenantId) {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code).and("version").is((Object)tenantVersion));
        Activity activityConfig = (Activity)this.mongoTemplate.findOne(query, Activity.class, "activityConfigs");
        if (BooleanUtils.isTrue((Boolean)activityConfig.getDependOnGroundEnd())) {
            Object hasGroundEndObj = null;
            String hasGroundEnd = null;
            try {
                hasGroundEndObj = this.mechanismService.getVariable("hasGroundEnd", tenantId);
                if (hasGroundEndObj != null) {
                    Map hasGroundEndMap = (Map)hasGroundEndObj;
                    hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.equals(hasGroundEnd, (CharSequence)"N")) {
                return true;
            }
        }
        return false;
    }

    protected void filterBizReportByVisibleCondition(List<BizRelatedReport> relatedReports, String tenantId) throws Exception {
        if (org.springframework.util.CollectionUtils.isEmpty(relatedReports)) {
            return;
        }
        HashMap<String, Map<String, Object>> apiResponseMap = new HashMap<String, Map<String, Object>>();
        HashMap queryedVariableMap = new HashMap();
        Iterator<BizRelatedReport> iterator = relatedReports.iterator();
        while (iterator.hasNext()) {
            Object apiQueryField;
            BizRelatedReport next = iterator.next();
            if (this.filterActivityByHasGroundEnd(next.getReportCode(), tenantId)) {
                iterator.remove();
                continue;
            }
            if (next.getVisibleCondition() == null) continue;
            LoginInfo loginInfo = KgFilter.getLoginInfo();
            if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty((CharSequence)next.getApplication())) {
                loginInfo.setApplication(next.getApplication());
            }
            Map<String, Object> visibleCondition = next.getVisibleCondition();
            String from = String.valueOf(visibleCondition.get("from"));
            String key = String.valueOf(visibleCondition.get("key"));
            String visibleValue = String.valueOf(visibleCondition.get("visibleValue"));
            String api = String.valueOf(visibleCondition.get("api"));
            if (StringUtils.equalsIgnoreCase((CharSequence)from, (CharSequence)"variable")) {
                Object mechanismVariableValue = queryedVariableMap.get(key);
                if (mechanismVariableValue == null) {
                    Object variable = this.mechanismService.getVariable(key, tenantId);
                    Map variableMap = (Map)variable;
                    mechanismVariableValue = variableMap.get(key);
                    queryedVariableMap.put(key, mechanismVariableValue);
                }
                if (StringUtils.equals((CharSequence)visibleValue, (CharSequence)String.valueOf(mechanismVariableValue))) continue;
                iterator.remove();
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)from, (CharSequence)"esp")) continue;
            Map<String, Object> queryResult = (Map<String, Object>)apiResponseMap.get(api);
            if (queryResult == null) {
                queryResult = this.espUtils.query(DWServiceContext.getContext().getToken(), tenantId, api);
                apiResponseMap.put(api, queryResult);
            }
            if (queryResult == null || StringUtils.equals((CharSequence)visibleValue, (CharSequence)String.valueOf(apiQueryField = queryResult.get(key)))) continue;
            iterator.remove();
        }
    }

    @Override
    public Object getReportByBizCodeNTypeNReportCode(String bizCode, Integer type, String reportCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid", new Object[0]));
        }
        Criteria criteria = Criteria.where((String)"bizCode").is((Object)bizCode).and("type").is((Object)type).and("reportCode").is((Object)reportCode);
        BizRelatedReport relatedReport = this.dataPickService.findOneByCondition(criteria, BizRelatedReport.class, "bizRelatedReports");
        if (null == relatedReport) {
            throw new DWBusinessException("P.KG.500.0036", I18nUtils.getValue("knowledgegraph.relationStatementNotFound", new Object[0]));
        }
        switch (type) {
            case 1: {
                Task task = null;
                HashMap<String, Object> dmp = new HashMap<String, Object>();
                dmp.put("code", bizCode);
                List datamapProjects = this.dataMapService.getProjectsBasic(dmp);
                if (null != datamapProjects && datamapProjects.size() > 0) {
                    List tasks2 = JSON.parseArray((String)JSON.toJSONString((Object)datamapProjects), Task.class);
                    task = (Task)((Object)tasks2.get(0));
                }
                if (null == task) {
                    throw new DWBusinessException("P.KG.500.0037", I18nUtils.getValue("knowledgegraph.tenantNotFoundProject", new Object[0]));
                }
                relatedReport.setBizName(task.getLang().isEmpty() || null == ((Map)task.getLang().get("name")).get(localeStr) ? task.getName() : (String)((Map)task.getLang().get("name")).get(localeStr));
                break;
            }
            case 2: {
                Activity activity = null;
                HashMap<String, Object> dmp2 = new HashMap<String, Object>();
                dmp2.put("code", bizCode);
                List datamapTasks = this.dataMapService.getTaskList(dmp2);
                if (null != datamapTasks && datamapTasks.size() > 0) {
                    List activities2 = JSON.parseArray((String)JSON.toJSONString((Object)datamapTasks), Activity.class);
                    activity = (Activity)activities2.get(0);
                }
                if (null == activity) {
                    throw new DWBusinessException("P.KG.500.0037", I18nUtils.getValue("knowledgegraph.tenantNotFoundProject", new Object[0]));
                }
                relatedReport.setBizName(activity.getLang().isEmpty() || null == ((Map)activity.getLang().get("name")).get(localeStr) ? activity.getName() : (String)((Map)activity.getLang().get("name")).get(localeStr));
                break;
            }
            default: {
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeNotSupport2", new Object[0]));
            }
        }
        Activity report = this.dataPickService.chooseOneWithSameCode(this.activityDAO.getReportActivitiesByCode(Collections.singletonList(reportCode), tenantId, tenantVersion));
        if (null == report) {
            throw new DWBusinessException("P.KG.500.0038", I18nUtils.getValue("knowledgegraph.tenantNotFoundStatement", new Object[0]));
        }
        relatedReport.setReportName(report.getLang().isEmpty() || null == ((Map)report.getLang().get("name")).get(localeStr) ? report.getName() : (String)((Map)report.getLang().get("name")).get(localeStr));
        return relatedReport;
    }

    @Override
    public Object getBizsByReportCodeNType(String reportCode, Integer type) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        if (null == type || type == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeInvalid", new Object[0]));
        }
        List<BizRelatedReport> relatedReports = this.dataPickService.find(Criteria.where((String)"reportCode").is((Object)reportCode).and("type").is((Object)type), BizRelatedReport.class, "bizRelatedReports");
        Map<String, BizRelatedReport> relatedReportMap = relatedReports.stream().collect(Collectors.toMap(BizRelatedReport::getBizCode, a -> a));
        List bizCodes = relatedReports.stream().map(BizRelatedReport::getBizCode).collect(Collectors.toList());
        LinkedList resultList = new LinkedList();
        switch (type) {
            case 1: {
                ArrayList tasks = new ArrayList();
                HashMap<String, Object> dmp = new HashMap<String, Object>();
                dmp.put("code", bizCodes);
                List datamapProjects = this.dataMapService.getProjectsBasic(dmp);
                if (null != datamapProjects && datamapProjects.size() > 0) {
                    List tasks2 = JSON.parseArray((String)JSON.toJSONString((Object)datamapProjects), Task.class);
                    tasks.addAll(tasks2);
                }
                if (org.springframework.util.CollectionUtils.isEmpty(tasks)) {
                    return Collections.EMPTY_LIST;
                }
                tasks.forEach(item -> {
                    BizRelatedReport bizRelatedReportItem = (BizRelatedReport)((Object)((Object)relatedReportMap.get(item.getCode())));
                    if (null != bizRelatedReportItem) {
                        if (null != item.getLang() && null != item.getLang().get("name")) {
                            bizRelatedReportItem.setBizName(item.getLang().isEmpty() || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : (String)((Map)item.getLang().get("name")).get(localeStr));
                        }
                        bizRelatedReportItem.setParamsMapping(null);
                        resultList.add(bizRelatedReportItem);
                    }
                });
                return resultList;
            }
            case 2: {
                ArrayList activities = new ArrayList();
                HashMap<String, Object> dmp2 = new HashMap<String, Object>();
                dmp2.put("code", bizCodes);
                List datamapTasks = this.dataMapService.getTaskList(dmp2);
                if (null != datamapTasks && datamapTasks.size() > 0) {
                    List activities2 = JSON.parseArray((String)JSON.toJSONString((Object)datamapTasks), Activity.class);
                    activities.addAll(activities2);
                }
                if (org.springframework.util.CollectionUtils.isEmpty(activities)) {
                    return Collections.EMPTY_LIST;
                }
                activities.forEach(item -> {
                    BizRelatedReport bizRelatedReportItem = (BizRelatedReport)((Object)((Object)relatedReportMap.get(item.getCode())));
                    if (null != bizRelatedReportItem) {
                        if (null != item.getLang() && null != item.getLang().get("name")) {
                            bizRelatedReportItem.setBizName(item.getLang().isEmpty() || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : (String)((Map)item.getLang().get("name")).get(localeStr));
                        }
                        bizRelatedReportItem.setParamsMapping(null);
                        resultList.add(bizRelatedReportItem);
                    }
                });
                return resultList;
            }
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.typeNotSupport2", new Object[0]));
    }

    @Override
    public Object postAuthorityConfigs(List<String> taskIdList) throws Exception {
        HashMap<String, Object> query1 = new HashMap<String, Object>();
        query1.put("code", taskIdList);
        List datamapTasks = this.dataMapService.getProjectsBasic(query1);
        return datamapTasks;
    }

    @Override
    public Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode) throws Exception {
        return this.postActivityDefinitionList(taskId, activityIds, pageCode, null);
    }

    @Override
    public Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode, OperationUnit operationUnit) throws Exception {
        if (org.springframework.util.CollectionUtils.isEmpty(activityIds)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.activityIdEmpty", new Object[0]));
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        DWServiceContext context = DWServiceContext.getContext();
        ConcurrentHashMap re = new ConcurrentHashMap();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        CompletableFuture.allOf((CompletableFuture[])activityIds.stream().map(activityId -> {
            CompletableFuture.completedFuture(activityId);
            return CompletableFuture.runAsync(() -> {
                DWServiceContext.setContext((DWServiceContext)context);
                try {
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                    Object o = SpringUtil.getBean(TaskService.class).postActivityDefinition(taskId, (String)activityId, pageCode, operationUnit);
                    if (!ObjectUtils.isEmpty((Object)o)) {
                        re.put(activityId, o);
                    }
                }
                catch (Exception e) {
                    log.error("getActivityDefinition error:{}", (Object)e.getMessage());
                }
                finally {
                    RequestContextHolder.resetRequestAttributes();
                }
            }, Constants.APP_EXECUTE_POOL);
        }).toArray(CompletableFuture[]::new)).join();
        stopWatch.stop();
        return re;
    }

    @Override
    public Object postQueryTaskAndActivityInfo() throws Exception {
        ArrayList<Map> result = new ArrayList<Map>();
        List<Application> applications = this.appService.postAllApplications();
        Map<String, Application> appEntityMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, t -> t, (v1, v2) -> v2));
        List<Map> allTask = this.taskRepository.getAllTask();
        for (Map map : allTask) {
            String nameSpace = String.valueOf(map.get("nameSpace"));
            Application appEntity = appEntityMap.get(nameSpace);
            map.put("type", "task");
            if (appEntity == null) continue;
            map.put("appCode", appEntity.getCode());
            map.put("appName", appEntity.getName());
        }
        List<Map> allActivity = this.activityDAO.getAllActivity();
        for (Map map : allActivity) {
            String nameSpace = String.valueOf(map.get("nameSpace"));
            Application appEntity = appEntityMap.get(nameSpace);
            map.put("type", "activity");
            if (appEntity == null) continue;
            map.put("appCode", appEntity.getCode());
            map.put("appName", appEntity.getName());
        }
        result.addAll(allTask);
        result.addAll(allActivity);
        return result;
    }

    @Override
    public Object postQueryAllProjectAndTaskInfo() {
        List<Application> applications;
        CopyOnWriteArrayList result = new CopyOnWriteArrayList();
        HashMap<String, String> appOldNameSpaceMap = new HashMap<String, String>();
        appOldNameSpaceMap.put("PWD", "purchaseWithDiagram");
        appOldNameSpaceMap.put("DCP", "designChangeProject");
        appOldNameSpaceMap.put("PCM", "projectCostManagement");
        List all1 = this.mongoTemplate.findAll(ApplicationPreNamespace.class);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)all1)) {
            Map<String, String> collect = all1.stream().collect(Collectors.toMap(ApplicationPreNamespace::getCode, ApplicationPreNamespace::getPreNamespace, (a, b) -> a));
            appOldNameSpaceMap.putAll(collect);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(applications = this.appService.postAllApplications())) {
            return result;
        }
        CopyOnWriteArraySet taskSet = new CopyOnWriteArraySet();
        CopyOnWriteArraySet projectSet = new CopyOnWriteArraySet();
        CopyOnWriteArraySet reportSet = new CopyOnWriteArraySet();
        CopyOnWriteArraySet baseDataSet = new CopyOnWriteArraySet();
        List all = this.mongoTemplate.findAll(Application.class);
        Map collect = all.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        DWServiceContext context = DWServiceContext.getContext();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        CompletableFuture.allOf((CompletableFuture[])applications.stream().map(appEntity -> {
            CompletableFuture.completedFuture(appEntity);
            return CompletableFuture.runAsync(() -> {
                try {
                    List<ComponentBO> baseDataEntryComponent1;
                    Object reportComponent1;
                    Object taskComponent1;
                    Object projectComponent1;
                    DWServiceContext.setContext((DWServiceContext)context);
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                    Application application = (Application)collect.get(appEntity.getCode());
                    List<ComponentBO> projectComponent = this.componentInitManager.getProjectComponent(appEntity.getCode(), appEntity.getCode(), appEntity.getVersion(), null);
                    if (appOldNameSpaceMap.containsKey(appEntity.getCode()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(projectComponent1 = this.componentInitManager.getProjectComponent((String)appOldNameSpaceMap.get(appEntity.getCode()), appEntity.getCode(), appEntity.getVersion(), null)))) {
                        projectComponent.addAll((Collection<ComponentBO>)projectComponent1);
                    }
                    for (ComponentBO componentBO : projectComponent) {
                        if (projectSet.contains(componentBO.getCode())) continue;
                        projectSet.add(componentBO.getCode());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("code", componentBO.getCode());
                        map.put("name", componentBO.getName());
                        map.put("type", componentBO.getType());
                        map.put("appCode", appEntity.getCode());
                        map.put("appName", application != null ? application.getName() : appEntity.getName());
                        HashMap<String, Map> lang = componentBO.getLang();
                        Map appNameLang = null;
                        if (application != null && application.getLang() != null) {
                            appNameLang = (Map)application.getLang().get("name");
                        }
                        if (lang == null) {
                            lang = new HashMap<String, Map>();
                        }
                        lang.put("appName", appNameLang);
                        map.put("lang", lang);
                        result.add(map);
                    }
                    List<ComponentBO> taskComponent = this.componentInitManager.getTaskComponent(appEntity.getCode(), appEntity.getCode(), appEntity.getVersion(), null);
                    if (appOldNameSpaceMap.containsKey(appEntity.getCode()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(taskComponent1 = this.componentInitManager.getTaskComponent((String)appOldNameSpaceMap.get(appEntity.getCode()), appEntity.getCode(), appEntity.getVersion(), null)))) {
                        taskComponent.addAll((Collection<ComponentBO>)taskComponent1);
                    }
                    for (ComponentBO componentBO : taskComponent) {
                        if (taskSet.contains(componentBO.getCode())) continue;
                        taskSet.add(componentBO.getCode());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("code", componentBO.getCode());
                        map.put("name", componentBO.getName());
                        map.put("type", componentBO.getType());
                        map.put("appCode", appEntity.getCode());
                        map.put("appName", application != null ? application.getName() : appEntity.getName());
                        HashMap<String, Map> lang = componentBO.getLang();
                        Map appNameLang = null;
                        if (application != null && application.getLang() != null) {
                            appNameLang = (Map)application.getLang().get("name");
                        }
                        if (lang == null) {
                            lang = new HashMap<String, Map>();
                        }
                        lang.put("appName", appNameLang);
                        map.put("lang", lang);
                        result.add(map);
                    }
                    List<ComponentBO> reportComponent = this.componentInitManager.getReportComponent(appEntity.getCode(), appEntity.getCode(), appEntity.getVersion(), null);
                    if (appOldNameSpaceMap.containsKey(appEntity.getCode()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(reportComponent1 = this.componentInitManager.getReportComponent((String)appOldNameSpaceMap.get(appEntity.getCode()), appEntity.getCode(), appEntity.getVersion(), null)))) {
                        reportComponent.addAll((Collection<ComponentBO>)reportComponent1);
                    }
                    for (ComponentBO componentBO : reportComponent) {
                        if (reportSet.contains(componentBO.getCode() + "#" + appEntity.getCode())) continue;
                        reportSet.add(componentBO.getCode() + "#" + appEntity.getCode());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("code", componentBO.getCode());
                        map.put("name", componentBO.getName());
                        map.put("type", componentBO.getType());
                        map.put("appCode", appEntity.getCode());
                        map.put("appName", application != null ? application.getName() : appEntity.getName());
                        HashMap<String, Map> lang = componentBO.getLang();
                        Map appNameLang = null;
                        if (application != null && application.getLang() != null) {
                            appNameLang = (Map)application.getLang().get("name");
                        }
                        if (lang == null) {
                            lang = new HashMap<String, Map>();
                        }
                        lang.put("appName", appNameLang);
                        map.put("lang", lang);
                        result.add(map);
                    }
                    List<ComponentBO> baseDataEntryComponent = this.componentInitManager.getBaseDataEntryComponent(appEntity.getCode(), appEntity.getCode(), appEntity.getVersion(), null);
                    if (appOldNameSpaceMap.containsKey(appEntity.getCode()) && !org.springframework.util.CollectionUtils.isEmpty(baseDataEntryComponent1 = this.componentInitManager.getBaseDataEntryComponent((String)appOldNameSpaceMap.get(appEntity.getCode()), appEntity.getCode(), appEntity.getVersion(), null))) {
                        baseDataEntryComponent.addAll(baseDataEntryComponent1);
                    }
                    for (ComponentBO componentBO : baseDataEntryComponent) {
                        if (baseDataSet.contains(componentBO.getCode() + "#" + appEntity.getCode())) continue;
                        baseDataSet.add(componentBO.getCode() + "#" + appEntity.getCode());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("code", componentBO.getCode());
                        map.put("name", componentBO.getName());
                        map.put("type", componentBO.getType());
                        map.put("appCode", appEntity.getCode());
                        map.put("appName", application != null ? application.getName() : appEntity.getName());
                        HashMap<String, Map> lang = componentBO.getLang();
                        Map appNameLang = null;
                        if (application != null && application.getLang() != null) {
                            appNameLang = (Map)application.getLang().get("name");
                        }
                        if (lang == null) {
                            lang = new HashMap<String, Map>();
                        }
                        lang.put("appName", appNameLang);
                        map.put("lang", lang);
                        result.add(map);
                    }
                }
                catch (Exception e) {
                    log.error("postQueryAllProjectAndTaskInfo error:{}", (Object)e.getMessage());
                }
                finally {
                    DWServiceContext.setContext(null);
                }
            }, Constants.APP_EXECUTE_POOL);
        }).toArray(CompletableFuture[]::new)).join();
        return result;
    }

    @Override
    public Object postTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception {
        log.info("postTenantSummaryFields start");
        String tenantId = AthenaUtils.getTenantId();
        this.deleteTenantSummaryFields(tenantSummaryFields);
        TenantSummaryFields tenantSummaryFieldsPO = this.transformToTenantSummaryFieldsPO(tenantSummaryFields);
        tenantSummaryFieldsPO.setTenantId(tenantId);
        this.mongoTemplateUser.insert((Object)tenantSummaryFieldsPO);
        this.cacheService.deleteWithPattern("knowledgegraph:SYSTEM:" + tenantId + "*");
        return null;
    }

    private TenantSummaryFields transformToTenantSummaryFieldsPO(TenantSummaryFieldsDto tenantSummaryFields) {
        return (TenantSummaryFields)JSON.parseObject((String)JSON.toJSONString((Object)tenantSummaryFields), TenantSummaryFields.class);
    }

    @Override
    public Object deleteTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)tenantSummaryFields.getType()).and("code").is((Object)tenantSummaryFields.getCode()).and("application").is((Object)tenantSummaryFields.getApplication());
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        DeleteResult deleteResult = this.mongoTemplateUser.remove(queryUser, TenantSummaryFields.class);
        this.cacheService.deleteWithPattern("knowledgegraph:SYSTEM:" + tenantId + "*");
        return deleteResult.getDeletedCount();
    }

    private TenantSummaryFields queryTenantSummaryFields(String application, String type, String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)type).and("code").is((Object)code).and("application").is((Object)application);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        TenantSummaryFields result = (TenantSummaryFields)this.mongoTemplateUser.findOne(queryUser, TenantSummaryFields.class);
        return result;
    }

    @Override
    public Object postApplicationRelation(String type, Set<String> codes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        HashMap<String, String> convertType = new HashMap<String, String>();
        convertType.put("project", "task");
        convertType.put("task", "activity");
        Map<String, List<ApplicationRelation>> relationsMap = this.getApplicationRelationsMapByTypeAndCodesAndLang((String)convertType.get(type), codes, AthenaUtils.getCurrentLocale());
        List relations = relationsMap.entrySet().stream().map(Map.Entry::getValue).filter(list -> !org.springframework.util.CollectionUtils.isEmpty((Collection)list)).filter(Objects::nonNull).flatMap(Collection::stream).filter(relation -> tenantVersion.equals(relation.getVersion())).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(relations) && relations.get(0) != null) {
            return relations;
        }
        return Collections.emptyList();
    }

    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type, Collection<String> codes, String lang) throws DWBusinessException {
        Map<String, List<ApplicationRelation>> applicationRelationsMap = this.getApplicationsMapByTypeAndCodes(type, codes);
        HashSet<String> applicationsCodes = new HashSet<String>();
        applicationRelationsMap.values().forEach(item -> {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = this.appService.getApplicationsByCodes(applicationsCodes);
        Map applicationMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (v1, v2) -> v1));
        applicationRelationsMap.forEach((k, v) -> v.forEach(applicationRelation -> {
            Application application = (Application)applicationMap.get(applicationRelation.getAppCode());
            if (application != null && application.getLang() != null) {
                Map nameLangMap = (Map)application.getLang().get("name");
                String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
                applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            }
        }));
        return applicationRelationsMap;
    }

    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type, Collection<String> codes) throws DWBusinessException {
        HashMap<String, List<ApplicationRelation>> applicationRelationsMap = new HashMap<String, List<ApplicationRelation>>();
        for (String code : codes) {
            Query queryUser = new Query();
            Criteria criteriaUser = Criteria.where((String)"type").is((Object)type).and("code").is((Object)code);
            queryUser.addCriteria((CriteriaDefinition)criteriaUser);
            List<ApplicationRelation> applicationRelations = this.dataPickService.find(Criteria.where((String)"type").is((Object)type).and("code").is((Object)code), ApplicationRelation.class, "applicationRelation");
            applicationRelationsMap.put(code, applicationRelations);
        }
        return applicationRelationsMap;
    }

    @Override
    public Object postDataViewList(List<String> viewCodes) throws NoSuchFieldException, IllegalAccessException, DWBusinessException {
        HashMap<String, List> dataMap = new HashMap<String, List>();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List dataViews = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(viewCodes).and("version").is((Object)tenantVersion)), Object.class, "dataView");
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dataViews)) {
            Locale locale = DWResourceBundleUtils.getCurrentLocale();
            String localeStr = locale.toString();
            String dataViewsStr = this.translateUtils.translateContent(dataViews);
            dataViews = JSON.parseArray((String)dataViewsStr, Object.class);
            LanguageUtil.processLocaleLanguage(dataViews, localeStr);
        }
        dataMap.put("dataViews", dataViews);
        return dataMap;
    }

    private void addPageCodeCriteria(String pageCode, Criteria criteria) {
        if ("project-card".equals(pageCode)) {
            criteria.and("pageCode").is((Object)pageCode);
        } else {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"pageCode").is((Object)pageCode), Criteria.where((String)"pageCode").exists(false)});
        }
    }

    @Override
    public Object getCardLabel(String code, String pageCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("taskCode").is((Object)code);
        Query query = new Query();
        this.addPageCodeCriteria(pageCode, criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        CardLabel cardLabel = (CardLabel)this.mongoTemplateUser.findOne(query, CardLabel.class);
        if (null == cardLabel) {
            cardLabel = new CardLabel();
            cardLabel.setTaskCode(code);
            HashMap query1 = MapUtil.of((Object)"code", (Object)code);
            List tasks = this.dataMapService.postCardConfig(query1, pageCode);
            if (null != tasks && tasks.size() > 0) {
                Object task = tasks.get(0);
                Object labels = JSONPath.eval(task, (String)"$.fieldConfig.taskCardField.labels");
                cardLabel.setLabels(JSON.parseArray((String)JSON.toJSONString((Object)labels), LabelVO.class));
            }
        }
        if (null != cardLabel.getLabels()) {
            cardLabel.getLabels().forEach(labelVO -> {
                if (null == labelVO.getOriginName()) {
                    labelVO.setOriginName(labelVO.getName());
                }
                if (null != labelVO.getLang() && null == labelVO.getLang().get("originName")) {
                    labelVO.getLang().put("originName", labelVO.getLang().get("name"));
                }
            });
        }
        return cardLabel;
    }

    @Override
    public Object getCardLabel(String code) throws DWBusinessException {
        return this.getCardLabel(code, "task-card");
    }

    @Override
    public Object postSaveCardLabel(CardLabel cardLabel) throws Exception {
        String pageCode = cardLabel.getPageCode();
        if (StringUtils.isBlank((CharSequence)pageCode)) {
            cardLabel.setPageCode("task-card");
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String locale = AthenaUtils.getCurrentLocale();
        cardLabel.setTenantId(tenantId);
        cardLabel.setVersion(tenantId);
        if (null != cardLabel.getLabels() && null != locale) {
            cardLabel.getLabels().forEach(labelVO -> {
                if (null != labelVO.getLang()) {
                    labelVO.getLang().remove("name");
                }
            });
        }
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"taskCode").is((Object)cardLabel.getTaskCode()).and("tenantId").is((Object)tenantId);
        this.addPageCodeCriteria(cardLabel.getPageCode(), criteria);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("labels", cardLabel.getLabels());
        update.set("delete", (Object)cardLabel.isDelete());
        update.set("ifTenant", (Object)true);
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, update, CardLabel.class);
        long count = updateResult.getModifiedCount();
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":*";
        try {
            this.cacheService.deleteWithPattern(cacheKey);
        }
        catch (Exception e) {
            log.error("delete redis fail:", (Throwable)e);
        }
        return count;
    }

    @Override
    public Object getDeleteCardLabel(String code, String pageCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"taskCode").is((Object)code).and("tenantId").is((Object)tenantId);
        this.addPageCodeCriteria(pageCode, criteria);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("delete", (Object)true);
        DeleteResult updateResult = this.mongoTemplateUser.remove(queryUser, CardLabel.class);
        long count = updateResult.getDeletedCount();
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":*";
        try {
            this.cacheService.deleteWithPattern(cacheKey);
        }
        catch (Exception e) {
            log.error("delete redis fail:", (Throwable)e);
        }
        return this.getCardLabel(code, pageCode);
    }

    @Override
    public Object getDeleteCardLabel(String code) throws Exception {
        return this.getDeleteCardLabel(code, "task-card");
    }

    @Override
    public Object getCardGroup() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        CardGroup cardLabel = (CardGroup)this.mongoTemplateUser.findOne(query, CardGroup.class);
        Boolean enable = null;
        if (null != cardLabel && null != cardLabel.getEnabled()) {
            enable = cardLabel.getEnabled();
        }
        if (null == cardLabel || null == cardLabel.getSystem()) {
            cardLabel = new CardGroup();
            List<CardGroupGroup> sysCardGroups = this.taskFieldService.sysCardGroups(tenantId);
            GroupAndLabelDto groupAndLabelDto = this.taskFieldService.applicationGroupAndCard();
            cardLabel.setSystem(new SystemGroup());
            cardLabel.getSystem().setGroups(sysCardGroups);
            cardLabel.setApplications(groupAndLabelDto.getCardGroupApplications());
            cardLabel.setTenantId(tenantId);
            if (null != enable) {
                cardLabel.setEnabled(enable);
            }
        }
        boolean hasDefault = false;
        if (null != cardLabel.getSystem() && null != cardLabel.getSystem().getGroups()) {
            for (CardGroupGroup cardGroup : cardLabel.getSystem().getGroups()) {
                if (hasDefault) {
                    cardGroup.setDefaultEffective(false);
                }
                if (!cardGroup.isDefaultEffective()) continue;
                hasDefault = true;
            }
        }
        if (!hasDefault && null != cardLabel.getApplications()) {
            for (CardGroupApplication application : cardLabel.getApplications()) {
                if (null == application.getTasks()) continue;
                for (CardGroupTask task : application.getTasks()) {
                    if (hasDefault) {
                        task.setDefaultEffective(false);
                    }
                    if (!task.isDefaultEffective()) continue;
                    hasDefault = true;
                }
            }
        }
        return cardLabel;
    }

    @Override
    public Object postSaveCardGroup(CardGroup cardGroup) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        cardGroup.setTenantId(tenantId);
        cardGroup.setVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        if (CollectionUtil.isNotEmpty(cardGroup.getApplications())) {
            for (CardGroupApplication application : cardGroup.getApplications()) {
                for (CardGroupTask task : application.getTasks()) {
                    task.setEnabled(task.getGroups().stream().anyMatch(v -> Boolean.TRUE.equals(v.isEnabled())));
                    task.setDefaultEffective(task.getGroups().stream().anyMatch(v -> Boolean.TRUE.equals(v.getDefaultGroup())));
                    for (CardGroupGroup group : task.getGroups()) {
                        group.setDefaultEffective(group.isEnabled());
                    }
                }
            }
            update.set("applications", cardGroup.getApplications());
        }
        if (null != cardGroup.getSystem()) {
            update.set("system", (Object)cardGroup.getSystem());
        }
        update.set("enabled", (Object)true);
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, update, CardGroup.class);
        long count = updateResult.getModifiedCount();
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":*";
        try {
            this.cacheService.deleteWithPattern(cacheKey);
        }
        catch (Exception e) {
            log.error("delete redis fail:", (Throwable)e);
        }
        return count;
    }

    @Override
    public Object getCardGroupStatus() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria orderCriteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query orderQry = new Query();
        orderQry.addCriteria((CriteriaDefinition)orderCriteria);
        CardGroup cardGroup = (CardGroup)this.mongoTemplateUser.findOne(orderQry, CardGroup.class);
        if (null == cardGroup) {
            return false;
        }
        return cardGroup.getEnabled();
    }

    @Override
    public Object getDeleteCardGroup() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        DeleteResult deleteResult = this.mongoTemplateUser.remove(queryUser, CardGroup.class);
        long count = deleteResult.getDeletedCount();
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":*";
        try {
            this.cacheService.deleteWithPattern(cacheKey);
        }
        catch (Exception e) {
            log.error("delete redis fail:", (Throwable)e);
        }
        CardGroup cardGroup = (CardGroup)this.getCardGroup();
        cardGroup.setEnabled(true);
        this.postSaveCardGroup(cardGroup);
        return cardGroup;
    }

    @Override
    @Cache(namespace="knowledgegraph", key="getCardConfig", tenant=true, ttlSecs=86400L, loadEmpty=true, language=true)
    public Object getCardConfig() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> groupRule = new HashMap<String, Object>();
        List<Object> sysCardGroups = new ArrayList();
        HashMap groupType = new HashMap();
        ArrayList businessKey = new ArrayList();
        GroupAndLabelDto groupAndLabelDto = this.taskFieldService.applicationGroupAndCard();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        CardGroup cardGroup = (CardGroup)this.mongoTemplateUser.findOne(query, CardGroup.class);
        if (null != cardGroup && cardGroup.getEnabled().booleanValue()) {
            if (!org.springframework.util.CollectionUtils.isEmpty(cardGroup.getApplications())) {
                List authApps = cardGroup.getApplications().stream().map(CardGroupApplication::getAppCode).collect(Collectors.toList());
                List<Application> apps = this.dataPickService.find(Criteria.where((String)"code").in(authApps), Application.class, "application");
                LanguageUtil.processLocaleLanguage(apps, AthenaUtils.getCurrentLocale());
                Map<String, String> appsNameMap = apps.stream().collect(Collectors.toMap(BaseEntity::getCode, BaseEntity::getName, (existing, replacement) -> existing));
                for (CardGroupApplication groupApplication : cardGroup.getApplications()) {
                    if (null == groupApplication.getTasks()) continue;
                    block1: for (CardGroupTask task : groupApplication.getTasks()) {
                        log.info("cardGroupTask:{}", (Object)JSON.toJSONString((Object)((Object)task)));
                        log.info("groupAndLabelDto:{}", (Object)JSON.toJSONString((Object)groupAndLabelDto));
                        if (task.getGroups() == null || !task.isEnabled()) continue;
                        ApplicationRelation applicationRelation = groupAndLabelDto.getTaskRelationsMap().get(task.getCode());
                        if (null == applicationRelation) {
                            log.warn("getCardConfig CardGroupTask has no application  task code=" + task.getCode() + ",tenantId=" + tenantId);
                            continue;
                        }
                        String appCode = applicationRelation.getAppCode();
                        for (CardGroupGroup cardGroupGroup : task.getGroups()) {
                            if (!cardGroupGroup.isDefaultEffective()) continue;
                            HashMap<String, String> item = new HashMap<String, String>();
                            item.put("taskCode", task.getCode());
                            item.put("name", cardGroupGroup.getName());
                            item.put("bkCode", cardGroupGroup.getCode());
                            item.put("appName", appsNameMap.get(groupApplication.getAppCode()));
                            businessKey.add(item);
                            cardGroupGroup.setType("businessKey");
                            cardGroupGroup.setCode(appCode + "-" + cardGroupGroup.getCode());
                            cardGroupGroup.setEnabled(true);
                            cardGroupGroup.setAppName(appsNameMap.get(groupApplication.getAppCode()));
                            cardGroupGroup.setDefaultEffective(task.isDefaultEffective());
                            sysCardGroups.add((Object)cardGroupGroup);
                            continue block1;
                        }
                    }
                }
            }
            if (null != cardGroup.getSystem()) {
                sysCardGroups.addAll(cardGroup.getSystem().getGroups());
            }
        } else {
            sysCardGroups = this.taskFieldService.sysCardGroups(tenantId);
        }
        HashSet codesisDefaultEffective = new HashSet();
        sysCardGroups.forEach(group -> {
            if (group.isDefaultEffective()) {
                codesisDefaultEffective.add(group.getCode());
            }
        });
        HashSet<String> codes = new HashSet<String>();
        Iterator<Object> groups = sysCardGroups.iterator();
        boolean hasDefault = false;
        while (groups.hasNext()) {
            CardGroupGroup group2 = (CardGroupGroup)((Object)groups.next());
            if (!group2.isEnabled() || codes.contains(group2.getCode()) || codesisDefaultEffective.contains(group2.getCode()) && !group2.isDefaultEffective()) {
                groups.remove();
                continue;
            }
            if (hasDefault) {
                group2.setDefaultEffective(false);
            }
            if (group2.isDefaultEffective()) {
                hasDefault = true;
            }
            codes.add(group2.getCode());
        }
        Criteria labelCriteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        this.addPageCodeCriteria("task-card", labelCriteria);
        List labels = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)labelCriteria), CardLabel.class);
        List tenantLabelCodes = labels.stream().map(CardLabel::getTaskCode).collect(Collectors.toList());
        for (CardLabel label : groupAndLabelDto.getCardLabels()) {
            if (tenantLabelCodes.contains(label.getTaskCode())) continue;
            labels.add(label);
        }
        Criteria orderCriteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query orderQry = new Query();
        orderQry.addCriteria((CriteriaDefinition)orderCriteria);
        CardOrder cardOrder = (CardOrder)this.mongoTemplateUser.findOne(orderQry, CardOrder.class);
        List<Object> taskTypeOrders = new ArrayList();
        if (null != cardOrder && !CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            taskTypeOrders = cardOrder.getTaskTypeOrders();
        }
        this.handleCardConfigByBusinessMessageSourceMethod(cardGroup, cardOrder, labels, groupAndLabelDto);
        groupType.put("businessKey", businessKey);
        groupRule.put("groupType", groupType);
        groupRule.put("showGroup", sysCardGroups);
        result.put("groupRule", groupRule);
        result.put("labelRule", labels);
        result.put("orderRule", taskTypeOrders);
        result.put("columnRule", groupAndLabelDto.getColumns());
        result.put("businessMessageSourceMethodMap", groupAndLabelDto.getBusinessMessageSourceMethodMap());
        return result;
    }

    private void handleCardConfigByBusinessMessageSourceMethod(CardGroup cardGroup, CardOrder cardOrder, List<CardLabel> labels, GroupAndLabelDto groupAndLabelDto) throws DWBusinessException {
        Map<String, Object> businessMessageSourceMethodMap = groupAndLabelDto.getBusinessMessageSourceMethodMap();
        Set<String> taskCodes = businessMessageSourceMethodMap.keySet();
        Object o = this.postCardConfigByType(new CardConfigQueryDTO().setCodes(new ArrayList<String>(taskCodes)).setPageCode("task-card").setCardOrder(cardOrder).setNeedQueryCardOrder(false));
        JSONObject config = (JSONObject)o;
        taskCodes.forEach(c -> businessMessageSourceMethodMap.put((String)c, config.getJSONObject(c).get((Object)"config")));
    }

    @Override
    @Cache(namespace="knowledgegraph", key="getTenantTask", tenant=true, ttlSecs=86400L, loadEmpty=true, language=true)
    public Object getTenantTask() throws Exception {
        List<TaskTypeOrder> taskTypeOrders;
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> authApps = this.tenantService.getAppCodes();
        if (CollectionUtil.isEmpty(authApps)) {
            return null;
        }
        List<Application> apps = this.dataPickService.find(Criteria.where((String)"code").in(authApps), Application.class, "application");
        HashMap applicationMap = new HashMap();
        apps.forEach(app -> applicationMap.put(app.getCode(), app));
        List<ApplicationRelation> taskRelations = this.appService.getApplicationRelationByTypeAndAppCode("activity", authApps);
        if (CollectionUtil.isEmpty(taskRelations)) {
            return null;
        }
        HashMap taskRelationsMap = new HashMap();
        taskRelations.forEach(applicationRelation -> taskRelationsMap.put(applicationRelation.getCode(), applicationRelation));
        List taskCodes = taskRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        HashMap query = MapUtil.of((Object)"code", taskCodes);
        List tasks = this.dataMapService.postCardConfig4Order(query);
        for (Map task : tasks) {
            task.put("appCode", ((ApplicationRelation)taskRelationsMap.get(task.get("code").toString())).getAppCode());
        }
        Map<String, List<Map>> appTaskRelMap = tasks.stream().collect(Collectors.groupingBy(i -> i.get("appCode").toString()));
        ArrayList<Object> appTaskRelList = new ArrayList<Object>();
        for (String appCode : appTaskRelMap.keySet()) {
            AppTaskRel appTaskRel = new AppTaskRel();
            appTaskRel.setCode(appCode);
            appTaskRel.setName(((Application)applicationMap.get(appCode)).getName());
            appTaskRel.setLang(((Application)applicationMap.get(appCode)).getLang());
            ArrayList<TaskVO> arrayList = new ArrayList<TaskVO>();
            appTaskRel.setTaskList(arrayList);
            List<Map> taskMapList = appTaskRelMap.get(appCode);
            for (Map task : taskMapList) {
                TaskVO taskVO = new TaskVO();
                taskVO.setCode(task.get("code").toString());
                taskVO.setName(task.get("name").toString());
                taskVO.setLang((Map)task.get("lang"));
                arrayList.add(taskVO);
            }
            appTaskRelList.add(appTaskRel);
        }
        LanguageUtil.processLocaleLanguage(appTaskRelList, AthenaUtils.getCurrentLocale());
        Map<Object, Object> codeNameRelMap = new HashMap();
        if (CollectionUtil.isNotEmpty(appTaskRelList)) {
            ArrayList<TaskVO> taskList = new ArrayList<TaskVO>();
            for (AppTaskRel appTaskRel : appTaskRelList) {
                taskList.addAll(appTaskRel.getTaskList());
            }
            codeNameRelMap = taskList.stream().collect(Collectors.toMap(TaskVO::getCode, TaskVO::getName));
        }
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        CardOrder cardOrder = (CardOrder)this.mongoTemplateUser.findOne(queryUser, CardOrder.class);
        LanguageUtil.processLocaleLanguage(cardOrder, AthenaUtils.getCurrentLocale());
        if (null != cardOrder && CollectionUtil.isNotEmpty(taskTypeOrders = cardOrder.getTaskTypeOrders())) {
            for (TaskTypeOrder taskTypeOrder : taskTypeOrders) {
                taskTypeOrder.setEffective(true);
                if (!taskCodes.contains(taskTypeOrder.getTaskCode())) {
                    taskTypeOrder.setEffective(false);
                }
                if (taskTypeOrder.getTaskName().equals(codeNameRelMap.get(taskTypeOrder.getTaskCode()))) continue;
                taskTypeOrder.setEffective(false);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("appTaskRelList", appTaskRelList);
        result.put("cardOrder", cardOrder);
        return result;
    }

    @Override
    public Object postSaveTaskOrder(CardOrder cardOrder) throws DWBusinessException {
        if (null == cardOrder.getEnabled() && CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        if (null != cardOrder.getEnabled()) {
            update.set("enabled", (Object)cardOrder.getEnabled());
        }
        if (CollectionUtil.isNotEmpty(cardOrder.getTaskTypeOrders())) {
            update.set("taskTypeOrders", cardOrder.getTaskTypeOrders());
        }
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, update, CardOrder.class);
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":*";
        try {
            this.cacheService.deleteWithPattern(cacheKey);
        }
        catch (Exception e) {
            log.error("delete redis fail:", (Throwable)e);
        }
        return updateResult.getModifiedCount();
    }

    @Override
    public Object getDeleteTaskOrder() throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId());
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("taskTypeOrders", new ArrayList());
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, update, CardOrder.class);
        String cacheKey = "knowledgegraph:SYSTEM:" + AthenaUtils.getTenantId() + ":*";
        try {
            this.cacheService.deleteWithPattern(cacheKey);
        }
        catch (Exception e) {
            log.error("delete redis fail:", (Throwable)e);
        }
        return updateResult.getModifiedCount();
    }

    @Override
    public Object getTaskOrderStatus() throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId());
        queryUser.addCriteria((CriteriaDefinition)criteria);
        CardOrder cardOrder = (CardOrder)this.mongoTemplateUser.findOne(queryUser, CardOrder.class);
        if (null == cardOrder) {
            return false;
        }
        return cardOrder.getEnabled();
    }

    @Override
    public Object getTaskOrder() throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId());
        queryUser.addCriteria((CriteriaDefinition)criteria);
        CardOrder cardOrder = (CardOrder)this.mongoTemplateUser.findOne(queryUser, CardOrder.class);
        if (null == cardOrder || CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            return null;
        }
        return cardOrder.getTaskTypeOrders();
    }

    @Override
    public Object getTenantApplications() throws Exception {
        AppRelationVO appRelationVO = new AppRelationVO();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> authApps = this.tenantService.getAppCodes();
        if (CollectionUtil.isNotEmpty(authApps)) {
            List<Application> apps = this.dataPickService.find(Criteria.where((String)"code").in(authApps), Application.class, "application");
            ArrayList<AppTaskRel> appTaskRelList = new ArrayList<AppTaskRel>();
            apps.forEach(e -> {
                AppTaskRel appTaskRel = new AppTaskRel();
                appTaskRel.setCode(e.getCode());
                appTaskRel.setName(e.getName());
                appTaskRel.setLang(e.getLang());
                appTaskRelList.add(appTaskRel);
            });
            LanguageUtil.processLocaleLanguage(appTaskRelList, AthenaUtils.getCurrentLocale());
            appRelationVO.setAppTaskRelList(appTaskRelList);
        }
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        CardOrder cardOrder = (CardOrder)this.mongoTemplateUser.findOne(queryUser, CardOrder.class);
        if (cardOrder != null && CollectionUtil.isNotEmpty(cardOrder.getTaskTypeOrders())) {
            List<String> customTaskCodes = cardOrder.getTaskTypeOrders().stream().map(e -> e.getTaskCode()).collect(Collectors.toList());
            LanguageUtil.processLocaleLanguage(cardOrder, AthenaUtils.getCurrentLocale());
            List<ApplicationRelation> taskRelations = this.appService.getApplicationByTypeAndCode("task", customTaskCodes);
            List relationTaskCodes = taskRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
            cardOrder.getTaskTypeOrders().forEach(e -> {
                e.setEffective(true);
                if (!relationTaskCodes.contains(e.getTaskCode())) {
                    e.setEffective(false);
                }
            });
        }
        appRelationVO.setCardOrder(cardOrder);
        return appRelationVO;
    }

    @Override
    public Object getTenantTasksByAppCode(String code) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> authApps = this.tenantService.getAppCodes();
        if (CollectionUtil.isEmpty(authApps)) {
            return null;
        }
        if (authApps.contains(code)) {
            Application app = new Application();
            List apps = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(new Object[]{code}).and("version").is((Object)tenantVersion)), Application.class);
            if (apps.isEmpty()) {
                return null;
            }
            app = (Application)apps.get(0);
            List<ApplicationRelation> taskRelations = this.appService.getApplicationRelationByTypeAndAppCode(tenantId, "activity", code);
            if (CollectionUtil.isEmpty(taskRelations)) {
                return null;
            }
            List taskCodes = taskRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
            HashMap query = MapUtil.of((Object)"code", taskCodes);
            List tasks = this.dataMapService.postCardConfig4Order(query);
            HashMap taskRelationsMap = new HashMap();
            taskRelations.forEach(applicationRelation -> taskRelationsMap.put(applicationRelation.getCode(), applicationRelation));
            if (!tasks.isEmpty()) {
                AppTaskRel appTaskRel = new AppTaskRel();
                appTaskRel.setCode(app.getCode());
                appTaskRel.setName(app.getName());
                appTaskRel.setLang(app.getLang());
                ArrayList<TaskVO> taskList = new ArrayList<TaskVO>();
                appTaskRel.setTaskList(taskList);
                for (Map task : tasks) {
                    TaskVO taskVO = new TaskVO();
                    taskVO.setCode(task.get("code").toString());
                    taskVO.setName(task.get("name").toString());
                    taskVO.setLang((Map)task.get("lang"));
                    taskList.add(taskVO);
                }
                LanguageUtil.processLocaleLanguage(appTaskRel, AthenaUtils.getCurrentLocale());
                return appTaskRel;
            }
        }
        return null;
    }

    @Override
    public Object postCardConfigByType(CardConfigQueryDTO cardConfigQueryDTO) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> codes = cardConfigQueryDTO.getCodes();
        WSPageCode wsPageCode = this.getWsPageCode(cardConfigQueryDTO.getPageCode());
        if (wsPageCode == null) {
            return null;
        }
        JSONArray jsonArray = this.callAppCardConfig(wsPageCode, codes);
        List<WorkbenchSettingVO> tenantSetting = this.getTenantIdSetting(wsPageCode);
        Map<WSConfigType, List<WorkbenchSettingVO>> configTypeListMap = tenantSetting.stream().collect(Collectors.groupingBy(WorkbenchSettingVO::getConfigType));
        LinkedList<WSConfigType> needAppConfig = new LinkedList<WSConfigType>();
        Map<String, CardConfigDTO> orderTenantMap = this.doHandleTenantConfig(configTypeListMap, needAppConfig, WSConfigType.order);
        Map<String, CardConfigDTO> groupTenantMap = this.doHandleTenantConfig(configTypeListMap, needAppConfig, WSConfigType.groups);
        Map<String, CardConfigDTO> filterTenantMap = this.doHandleTenantConfig(configTypeListMap, needAppConfig, WSConfigType.filter);
        Map<String, Map<String, CardConfigDTO.Config.Label>> cardLabelInfo = this.labelInfo(cardConfigQueryDTO.getPageCode(), tenantId, tenantVersion);
        LinkedHashMap summaryFieldsMap = new LinkedHashMap();
        HashMap businessMessageSourceMethodMap = new HashMap();
        jsonArray.forEach(o -> {
            PageView pageView = (PageView)JSON.parseObject((String)JSON.toJSONString((Object)o), PageView.class);
            ArrayList<CardConfigDTO> cardConfig = new ArrayList<CardConfigDTO>();
            this.parseTaskOrProject(orderTenantMap, groupTenantMap, filterTenantMap, cardConfigQueryDTO.getPageCode(), needAppConfig, cardConfig, businessMessageSourceMethodMap, pageView, cardLabelInfo, wsPageCode);
            List configByCode = (List)summaryFieldsMap.get(pageView.getCode());
            if (configByCode == null) {
                summaryFieldsMap.put(pageView.getCode(), new ArrayList());
                configByCode = (List)summaryFieldsMap.get(pageView.getCode());
            }
            configByCode.addAll(cardConfig);
        });
        JSONObject result = new JSONObject();
        for (String code : codes) {
            JSONObject summaryFieldsAndColumns = new JSONObject();
            summaryFieldsAndColumns.put("config", summaryFieldsMap.get(code));
            result.put(code, (Object)summaryFieldsAndColumns);
        }
        CardOrder cardOrder = cardConfigQueryDTO.getCardOrder();
        if (cardConfigQueryDTO.isNeedQueryCardOrder()) {
            Criteria orderCriteria = Criteria.where((String)"tenantId").is((Object)tenantId);
            Query orderQry = new Query();
            orderQry.addCriteria((CriteriaDefinition)orderCriteria);
            cardOrder = (CardOrder)this.mongoTemplateUser.findOne(orderQry, CardOrder.class);
        }
        List<Object> taskTypeOrders = new ArrayList();
        if (null != cardOrder && !CollectionUtil.isEmpty(cardOrder.getTaskTypeOrders())) {
            taskTypeOrders = cardOrder.getTaskTypeOrders();
        }
        result.put("orderRule", taskTypeOrders);
        result.put("businessMessageSourceMethodMap", businessMessageSourceMethodMap);
        return result;
    }

    private void parseTaskOrProject(Map<String, CardConfigDTO> orderTenantMap, Map<String, CardConfigDTO> groupTenantMap, Map<String, CardConfigDTO> filterTenantMap, String pageCode, List<WSConfigType> configTypes, List<CardConfigDTO> cardConfigDTOS, Map<String, String> businessMessageSourceMethodMap, PageView pageView, Map<String, Map<String, CardConfigDTO.Config.Label>> labelInfo, WSPageCode wsPageCode) {
        Map taskcard;
        List dataStates;
        if (null != pageView.getPages() && null != pageView.getPages().get(pageCode) && null != (dataStates = (List)(taskcard = (Map)pageView.getPages().get(pageCode)).get("dataStates"))) {
            CardConfigDTO empty = new CardConfigDTO();
            empty.setConfig(new CardConfigDTO.Config());
            for (Map map : dataStates) {
                if (!"all".equals(map.get("type"))) continue;
                Object taskCardFields = map.get("taskCardFields");
                String code = pageView.getCode();
                String businessMessageSourceMethod = ((JSONObject)JSON.parseObject((String)JSON.toJSONString(taskCardFields), JSONObject.class)).getString("businessMessageSourceMethod");
                if ("NON_REAL_TIME".equals(businessMessageSourceMethod)) {
                    businessMessageSourceMethodMap.put(code, businessMessageSourceMethod);
                }
                List<CardConfigDTO> parse = this.taskFieldService.taskCardFieldToCardConfig(taskCardFields);
                HashSet tenantCode = new HashSet();
                filterTenantMap.forEach((k, v) -> {
                    if (v.getConfig().getFilter().getScope().contains(code)) {
                        tenantCode.add(k);
                    }
                });
                groupTenantMap.forEach((k, v) -> {
                    if (v.getConfig().getGroup().getScope().contains(code)) {
                        tenantCode.add(k);
                    }
                });
                orderTenantMap.forEach((k, v) -> {
                    if (v.getConfig().getOrder().getScope().contains(code)) {
                        tenantCode.add(k);
                    }
                });
                parse.forEach(o -> {
                    CardConfigDTO.Config.Label label;
                    CardConfigDTO.Config config = o.getConfig();
                    if (config == null) {
                        config = new CardConfigDTO.Config();
                    }
                    boolean contains = tenantCode.remove(o.getAliasField());
                    if (!configTypes.contains((Object)WSConfigType.filter)) {
                        CardConfigDTO.Config.Data tenantFilter;
                        CardConfigDTO.Config.Data filter = null;
                        if (contains && (tenantFilter = filterTenantMap.getOrDefault(o.getAliasField(), empty).getConfig().getFilter()) != null && tenantFilter.getScope().contains(code)) {
                            filter = tenantFilter;
                        }
                        config.setFilter(filter);
                    }
                    if (!configTypes.contains((Object)WSConfigType.order)) {
                        CardConfigDTO.Config.Data tenantOrder;
                        CardConfigDTO.Config.Data order = null;
                        if (contains && (tenantOrder = orderTenantMap.getOrDefault(o.getAliasField(), empty).getConfig().getOrder()) != null && tenantOrder.getScope().contains(code)) {
                            order = tenantOrder;
                        }
                        config.setOrder(order);
                    }
                    if (!configTypes.contains((Object)WSConfigType.groups)) {
                        CardConfigDTO.Config.Data tenantGroup;
                        CardConfigDTO.Config.Data group = null;
                        if (contains && (tenantGroup = groupTenantMap.getOrDefault(o.getAliasField(), empty).getConfig().getGroup()) != null && tenantGroup.getScope().contains(code)) {
                            group = tenantGroup;
                        }
                        config.setGroup(group);
                    }
                    if ((label = (CardConfigDTO.Config.Label)((Map)labelInfo.getOrDefault(pageView.getCode(), new HashMap())).get(o.getAliasField())) != null) {
                        config.setLabel(label);
                    }
                    if (config.getOrder() != null || config.getFilter() != null || config.getColumn() != null || config.getGroup() != null || config.getLabel() != null) {
                        cardConfigDTOS.add((CardConfigDTO)o);
                    }
                });
                if (tenantCode.isEmpty()) break;
                tenantCode.forEach(o -> {
                    CardConfigDTO cardConfigDTO = new CardConfigDTO();
                    String aliasField = "";
                    if (orderTenantMap.containsKey(o)) {
                        aliasField = ((CardConfigDTO)orderTenantMap.get(o)).getAliasField();
                    }
                    if (StringUtils.isBlank((CharSequence)aliasField) && groupTenantMap.containsKey(o)) {
                        aliasField = ((CardConfigDTO)groupTenantMap.get(o)).getAliasField();
                    }
                    if (StringUtils.isBlank((CharSequence)aliasField) && filterTenantMap.containsKey(o)) {
                        aliasField = ((CardConfigDTO)filterTenantMap.get(o)).getAliasField();
                    }
                    cardConfigDTO.setAliasField(aliasField);
                    CardConfigDTO.Config config = new CardConfigDTO.Config();
                    cardConfigDTO.setConfig(config);
                    if (orderTenantMap.containsKey(o) && ((CardConfigDTO)orderTenantMap.get(o)).getConfig() != null) {
                        config.setOrder(((CardConfigDTO)orderTenantMap.get(o)).getConfig().getOrder());
                    }
                    if (groupTenantMap.containsKey(o) && ((CardConfigDTO)groupTenantMap.get(o)).getConfig() != null) {
                        config.setGroup(((CardConfigDTO)groupTenantMap.get(o)).getConfig().getGroup());
                    }
                    if (filterTenantMap.containsKey(o) && ((CardConfigDTO)filterTenantMap.get(o)).getConfig() != null) {
                        config.setFilter(((CardConfigDTO)filterTenantMap.get(o)).getConfig().getFilter());
                    }
                    cardConfigDTOS.add(cardConfigDTO);
                });
                break;
            }
        }
    }

    private Map<String, Map<String, CardConfigDTO.Config.Label>> labelInfo(String pageCode, String tenantId, String tenantVersion) {
        String locale = AthenaUtils.getCurrentLocale();
        Criteria mainCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)"SYSTEM").and("version").is((Object)tenantVersion), Criteria.where((String)"tenantId").is((Object)tenantId)});
        Criteria criteria = new Criteria();
        this.addPageCodeCriteria(pageCode, criteria);
        Criteria param = new Criteria();
        param.andOperator(new Criteria[]{mainCriteria, criteria});
        Query query = Query.query((CriteriaDefinition)param);
        List cardLabels = this.mongoTemplateUser.find(query, CardLabel.class);
        HashMap<String, Map<String, CardConfigDTO.Config.Label>> result = new HashMap<String, Map<String, CardConfigDTO.Config.Label>>();
        for (CardLabel cardLabel : cardLabels) {
            List<LabelVO> labels;
            HashMap<String, CardConfigDTO.Config.Label> labelMap = (HashMap<String, CardConfigDTO.Config.Label>)result.get(cardLabel.getTaskCode());
            if (labelMap == null) {
                labelMap = new HashMap<String, CardConfigDTO.Config.Label>();
                result.put(cardLabel.getTaskCode(), labelMap);
            }
            if (!CollectionUtils.isNotEmpty(labels = cardLabel.getLabels())) continue;
            for (LabelVO label : labels) {
                Optional<CardConfigDTO.Config.Label.Style> styleOptional;
                String code = label.getCode();
                List<ReturnFieldVO> returnFields = label.getReturnFields();
                if (!CollectionUtils.isNotEmpty(returnFields) || !(styleOptional = returnFields.stream().map(o -> {
                    CardConfigDTO.Config.Label.Style style1 = new CardConfigDTO.Config.Label.Style();
                    if (o.getStyle() != null) {
                        style1.setColor(o.getStyle().getColor());
                    }
                    return style1;
                }).findFirst()).isPresent()) continue;
                CardConfigDTO.Config.Label.Style style1 = styleOptional.get();
                try {
                    LanguageUtil.processLocaleLanguage((Object)label, locale);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    log.error("processLocaleLanguage error, " + (Object)((Object)label));
                }
                CardConfigDTO.Config.Label label1 = new CardConfigDTO.Config.Label();
                label1.setDefaultEffective(label.isDefaultEffective() ? "true" : "false");
                CardConfigDTO.Config.Label.Style style = new CardConfigDTO.Config.Label.Style();
                label1.setStyle(style);
                label1.setAliasName(label.getName());
                label1.setLang(label.getLang());
                style.setColor(style1.getColor());
                labelMap.put(code, label1);
            }
        }
        return result;
    }

    private Map<String, CardConfigDTO> doHandleTenantConfig(Map<WSConfigType, List<WorkbenchSettingVO>> configTypeListMap, List<WSConfigType> needAppConfig, WSConfigType wsConfigType) {
        List<WorkbenchSettingVO> tenantSetting = configTypeListMap.remove((Object)wsConfigType);
        if (CollectionUtils.isNotEmpty(tenantSetting)) {
            ArrayList cardConfigList = new ArrayList();
            tenantSetting.forEach(o -> {
                List<WSConditionVO> condition = o.getCondition();
                if (CollectionUtils.isNotEmpty(condition)) {
                    for (WSConditionVO wsCondition : condition) {
                        this.convertWsCondition(cardConfigList, wsConfigType, wsCondition);
                    }
                }
            });
            return cardConfigList.stream().collect(Collectors.toMap(CardConfigDTO::getAliasField, o -> o, (o1, o2) -> o1));
        }
        needAppConfig.add(wsConfigType);
        return new HashMap<String, CardConfigDTO>();
    }

    private void convertWsCondition(List<CardConfigDTO> cardConfigDTOS, WSConfigType wsConfigType, WSConditionVO wsCondition) {
        if (Boolean.TRUE.equals(wsCondition.getEnable()) && SourceType.customer.equals((Object)wsCondition.getSourceType())) {
            String locale = AthenaUtils.getCurrentLocale();
            CardConfigDTO cardConfigDTO = new CardConfigDTO();
            String aliasCode = wsCondition.getAliasCode();
            cardConfigDTO.setAliasField(aliasCode);
            CardConfigDTO.Config config = new CardConfigDTO.Config();
            cardConfigDTO.setConfig(config);
            List<ConditionScopeVO> conditionScope = wsCondition.getConditionScope();
            ArrayList<String> scopes = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty(conditionScope)) {
                scopes.addAll(conditionScope.stream().map(ConditionScopeVO::getCode).collect(Collectors.toList()));
            }
            try {
                LanguageUtil.processLocaleLanguage(wsCondition, locale);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                log.error("processLocaleLanguage error, " + wsCondition);
            }
            if (WSConfigType.filter.equals((Object)wsConfigType)) {
                CardConfigDTO.Config.Data filter = new CardConfigDTO.Config.Data();
                config.setFilter(filter);
                filter.setDefaultEffective("true");
                filter.setDataType(wsCondition.getDataType());
                filter.setAliasName(wsCondition.getAliasName());
                filter.setScope(scopes);
                filter.setLang(wsCondition.getLang());
            } else if (WSConfigType.groups.equals((Object)wsConfigType)) {
                CardConfigDTO.Config.Data group = new CardConfigDTO.Config.Data();
                config.setGroup(group);
                group.setDefaultEffective("true");
                group.setAliasName(wsCondition.getAliasName());
                group.setScope(scopes);
                group.setLang(wsCondition.getLang());
            } else if (WSConfigType.order.equals((Object)wsConfigType)) {
                CardConfigDTO.Config.Data order = new CardConfigDTO.Config.Data();
                config.setOrder(order);
                order.setDefaultEffective("true");
                order.setAliasName(wsCondition.getAliasName());
                order.setScope(scopes);
                order.setLang(wsCondition.getLang());
            }
            cardConfigDTOS.add(cardConfigDTO);
        }
    }

    private WSPageCode getWsPageCode(String pageCode) {
        WSPageCode wsPageCode = null;
        switch (pageCode) {
            case "project-card": {
                wsPageCode = WSPageCode.project;
                break;
            }
            case "task-card": {
                wsPageCode = WSPageCode.task;
            }
        }
        return wsPageCode;
    }

    private List<WorkbenchSettingVO> getTenantIdSetting(WSPageCode wsPageCode) throws DWBusinessException {
        String o2;
        String tenantId = AthenaUtils.getTenantId();
        String cacheKey = "knowledgegraph:" + tenantId + ":" + "workbenchsetting" + ":" + (Object)((Object)wsPageCode);
        if (this.stringRedisTemplate != null && (o2 = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey)) != null) {
            List workbenchSettings = (List)JSONObject.parseObject((String)o2, (TypeReference)new TypeReference<List<WorkbenchSettingVO>>(){}, (Feature[])new Feature[0]);
            try {
                String currentLocale = AthenaUtils.getCurrentLocale();
                for (WorkbenchSettingVO workbenchSetting : workbenchSettings) {
                    LanguageUtil.processLocaleLanguage(workbenchSetting.getCondition(), currentLocale);
                    LanguageUtil.processLocaleLanguage(workbenchSetting.getDefaultCondition(), currentLocale);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                log.error("processLocaleLanguage error,", (Throwable)e);
            }
            return workbenchSettings;
        }
        LinkedList<WSConfigType> configTypes = new LinkedList<WSConfigType>();
        configTypes.add(WSConfigType.order);
        configTypes.add(WSConfigType.groups);
        configTypes.add(WSConfigType.filter);
        List<WorkbenchSetting> workbenchTenantSetting = this.workbenchSettingService.getWorkbenchTenantSetting(wsPageCode, configTypes);
        ArrayList<WorkbenchSettingVO> settingVOS = new ArrayList<WorkbenchSettingVO>();
        settingVOS.addAll(workbenchTenantSetting.stream().map(o -> (WorkbenchSettingVO)JSON.parseObject((String)JSON.toJSONString((Object)o), WorkbenchSettingVO.class)).collect(Collectors.toList()));
        if (WSPageCode.task == wsPageCode) {
            Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)criteria);
            CardGroup cardGroup = (CardGroup)this.mongoTemplateUser.findOne(query, CardGroup.class);
            if (cardGroup != null) {
                settingVOS.add(this.workbenchSettingService.cardGroupToWSConditionVO(cardGroup));
            }
        }
        if (this.stringRedisTemplate != null) {
            this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)JSON.toJSONString(settingVOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), 86400L, TimeUnit.SECONDS);
        }
        return settingVOS;
    }

    private JSONArray callAppCardConfig(WSPageCode pageCode, List<String> codes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", codes);
        params.put("pageCode", (Object)pageCode);
        DapResponse dapResponse = this.dataMapService.requestDataMap("/view/workbenchSetting/configTypes", "post", params);
        JSONArray response = (JSONArray)dapResponse.getResponse();
        if (response == null) {
            return new JSONArray();
        }
        return response;
    }

    @Override
    public Object postQueryCondition(CardConditionQueryDTO cardConditionQueryDTO) {
        WSConfigType configType;
        WSPageCode wsPageCode = this.getWsPageCode(cardConditionQueryDTO.getPageCode());
        WorkbenchSettingVO workbenchSettingVO = this.workbenchSettingService.getWorkbenchSetting(wsPageCode, configType = cardConditionQueryDTO.getConfigType(), false);
        if (workbenchSettingVO != null && wsPageCode == WSPageCode.task && configType == WSConfigType.groups) {
            List<WSConditionVO> defaultCondition;
            List<WSConditionVO> condition = workbenchSettingVO.getCondition();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(condition)) {
                for (WSConditionVO wsConditionVO : condition) {
                    String aliasCode = wsConditionVO.getAliasCode();
                    if (StringUtils.isNotBlank((CharSequence)aliasCode)) {
                        aliasCode = aliasCode.replaceAll("\\.", "#");
                        wsConditionVO.setAliasCode(aliasCode);
                    }
                    if (BusinessMessageSourceMethod.NON_REAL_TIME == wsConditionVO.getBusinessMessageSourceMethod() || !StringUtils.isNotBlank((CharSequence)wsConditionVO.getAppCode())) continue;
                    wsConditionVO.setAliasCode(wsConditionVO.getAppCode() + "-" + aliasCode);
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(defaultCondition = workbenchSettingVO.getDefaultCondition())) {
                for (WSConditionVO wsConditionVO : defaultCondition) {
                    String aliasCode = wsConditionVO.getAliasCode();
                    if (StringUtils.isNotBlank((CharSequence)aliasCode)) {
                        aliasCode = aliasCode.replaceAll("\\.", "#");
                        wsConditionVO.setAliasCode(aliasCode);
                    }
                    if (BusinessMessageSourceMethod.NON_REAL_TIME == wsConditionVO.getBusinessMessageSourceMethod() || !StringUtils.isNotBlank((CharSequence)wsConditionVO.getAppCode())) continue;
                    wsConditionVO.setAliasCode(wsConditionVO.getAppCode() + "-" + aliasCode);
                }
            }
        }
        return workbenchSettingVO;
    }

    @Override
    @DWLogOperation(desc="\u83b7\u53d6\u9875\u9762UI\u5143\u7d20")
    @Cache(namespace="knowledgegraph", key="pageUIElement$0$1$2", language=true, tenant=true, ttlSecs=86400L)
    public Object getPageUIElement(String code, String activityId, String pageCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        return this.getPageUIElementFromDataMap(code, activityId, pageCode, tenantId);
    }

    @Override
    @DWLogOperation(desc="\u6839\u636etenantId\u83b7\u53d6SystemHooks\u5143\u7d20")
    @Cache(namespace="knowledgegraph", key="systemHooksByTenantId$0$1", language=true, tenant=true, ttlSecs=86400L)
    public Object postSystemHooksByTenantId(String tenantId, List<String> pageCodes) throws Exception {
        List<String> activityIds = this.appService.getActivityCode(tenantId);
        return this.getSystemHooksFromDataMap(activityIds, pageCodes);
    }

    @Override
    @DWLogOperation(desc="\u83b7\u53d6SystemHooks\u5143\u7d20")
    @Cache(namespace="knowledgegraph", key="systemHooks$0$2", language=true, tenant=true, ttlSecs=86400L)
    public Object postSystemHooks(String md5, List<String> activityIds, List<String> pageCodes) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        return this.getSystemHooksFromDataMap(activityIds, pageCodes);
    }

    @Override
    public List<TaskCardFieldVO> postViewTaskCardField(TaskCardFieldRequest taskCardFieldRequest) {
        return this.dataMapService.postViewTaskCardField(taskCardFieldRequest);
    }

    @Override
    @DWLogOperation(desc="\u83b7\u53d6\u4efb\u52a1\u9879\u76ee\u7684\u7f16\u7801\u548c\u540d\u79f0")
    @Cache(namespace="knowledgegraph", key="codeOptions$0", tenant=true, ttlSecs=86400L)
    public List<SemcDictOption> getCodeOptions(String type) throws Exception {
        List<String> authApps = this.tenantService.getAppCodes();
        ArrayList dictOptionList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(authApps)) {
            return dictOptionList;
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<Object> taskRelations = null;
        boolean isTask = false;
        if ("groupByTaskType".equals(type)) {
            isTask = true;
            taskRelations = this.appService.getApplicationRelationByTypeAndAppCode("task", authApps);
            taskRelations.addAll(this.appService.getApplicationRelationByTypeAndAppCode("activity", authApps));
        } else if ("groupByProjectType".equals(type)) {
            taskRelations = this.appService.getApplicationRelationByTypeAndAppCode("task", authApps);
        }
        if (null == taskRelations || taskRelations.isEmpty()) {
            return dictOptionList;
        }
        HashSet<String> set = new HashSet<String>();
        if (isTask) {
            Map<String, List<ApplicationRelation>> typeToRelationsMap = taskRelations.stream().collect(Collectors.groupingBy(ApplicationRelation::getType));
            List<ApplicationRelation> task = typeToRelationsMap.get("task");
            if (!org.springframework.util.CollectionUtils.isEmpty(task)) {
                List<Map<String, Object>> taskList = this.getTaskAndActivityData(isTask, task, tenantId, tenantVersion);
                this.addDictOptionList(taskList, dictOptionList, set);
            }
            taskRelations = typeToRelationsMap.get("activity");
        } else {
            List<Map<String, Object>> taskList = this.getTaskAndActivityData(isTask, taskRelations, tenantId, tenantVersion);
            this.addDictOptionList(taskList, dictOptionList, set);
            taskRelations = taskRelations.stream().filter(e -> !set.contains(e.getCode())).collect(Collectors.toList());
        }
        if (taskRelations == null || org.springframework.util.CollectionUtils.isEmpty(taskRelations)) {
            return dictOptionList;
        }
        List codeNameList = this.dataMapService.getCodeNames(taskRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList()), isTask);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)codeNameList)) {
            this.addDictOptionList(codeNameList, dictOptionList, set);
        }
        return dictOptionList;
    }

    private List<Map<String, Object>> getTaskAndActivityData(boolean isTask, List<ApplicationRelation> applicationRelationList, String tenantId, String tenantVersion) {
        if (null == applicationRelationList || applicationRelationList.isEmpty()) {
            return Collections.emptyList();
        }
        List codes = applicationRelationList.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List lists = Utils.spliceArrays(codes, 500);
        ArrayList taskList = Lists.newArrayListWithExpectedSize((int)codes.size());
        for (List<String> list : lists) {
            List<Map<String, Object>> splitTaskData = isTask ? this.taskRepository.getTaskByProjectCodes(tenantId, tenantVersion, list) : this.taskRepository.getProjectByProjectCodes(tenantId, tenantVersion, list);
            if (org.springframework.util.CollectionUtils.isEmpty(splitTaskData)) continue;
            taskList.addAll(splitTaskData);
        }
        return taskList;
    }

    private void addDictOptionList(List<Map<String, Object>> dataList, List<SemcDictOption> dictOptionList, Set<String> codes) {
        dataList.forEach(e -> {
            SemcDictOption option = new SemcDictOption();
            String code = MapUtils.getString((Map)e, (Object)"code");
            if (codes.add(code)) {
                Map nameMap;
                Map lang = (Map)e.get("lang");
                if (lang != null && MapUtils.isNotEmpty((Map)(nameMap = (Map)lang.get("name")))) {
                    HashMap<String, Map<String, String>> nameLang = new HashMap<String, Map<String, String>>();
                    nameLang.put("name", nameMap);
                    option.setLang(nameLang);
                }
                option.setName(MapUtils.getString((Map)e, (Object)"name"));
                option.setCode(MapUtils.getString((Map)e, (Object)"code"));
                dictOptionList.add(option);
            }
        });
    }

    @Override
    public List<SemcDictOption> getTenantGroupConfigCode() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        CardGroup cardLabel = (CardGroup)this.mongoTemplateUser.findOne(query, CardGroup.class);
        if (cardLabel == null) {
            return null;
        }
        if (BooleanUtils.isTrue((Boolean)cardLabel.getEnabled())) {
            List<CardGroupGroup> groups;
            SystemGroup system = cardLabel.getSystem();
            ArrayList codes = Lists.newArrayList();
            if (system != null && !org.springframework.util.CollectionUtils.isEmpty(groups = system.getGroups())) {
                groups.forEach(e -> {
                    Boolean commonEnable = e.getCommonEnable();
                    boolean isAdd = commonEnable != null ? commonEnable != false && e.isEnabled() : e.isEnabled();
                    if (isAdd) {
                        SemcDictOption semcDictOption = new SemcDictOption();
                        semcDictOption.setName(e.getName());
                        Map lang = e.getLang();
                        if (lang != null) {
                            lang.put("name", lang.get("aliasName"));
                        }
                        semcDictOption.setType("system");
                        semcDictOption.setLang(lang);
                        semcDictOption.setCode(e.getCode());
                        semcDictOption.setName(e.getName());
                        codes.add(semcDictOption);
                    }
                });
            }
            return codes;
        }
        return null;
    }

    @Override
    public Object postDataEntryAndReportByAppCode(String appCode, String pattern) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> activityCodes = this.dataPickService.tenantProductCodes("activity", Lists.newArrayList((Object[])new String[]{appCode}));
        List<Activity> activities = this.activityDAO.getActivitiesByPattern(tenantId, pattern, tenantVersion, activityCodes);
        activities = this.dataPickService.excludeWithSameCode(activities);
        if ("DATA_ENTRY".equals(pattern) && org.apache.commons.collections.CollectionUtils.isNotEmpty(activities)) {
            for (Activity activity : activities) {
                Boolean isCustomize;
                Object activityDefinition = this.getActivityDefinition(activity.getCode(), "basic-data");
                if (activityDefinition == null) {
                    log.error("postDataEntryAndReportByAppCode not found Definition appCode:" + appCode + " ,code:" + activity.getCode());
                    continue;
                }
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)activityDefinition));
                JSONObject pages = jsonObject.getJSONObject("pages");
                Boolean bl = isCustomize = Objects.nonNull(pages) ? pages.getBoolean("isCustomize") : null;
                if (Objects.isNull(isCustomize) && "CUSTOM".equals(jsonObject.getString("pattern"))) {
                    isCustomize = true;
                }
                activity.setIsCustomize(isCustomize);
            }
        }
        return activities;
    }

    @Override
    public Object postTaskList(Map<String, Object> query) throws Exception {
        List taskList = this.dataMapService.getTaskList(query);
        return taskList;
    }

    @Override
    public Object postProjectExcludeMainlineByAppCode(String appCode) {
        return this.dataMapService.projectExcludeMainlineByAppCode(appCode);
    }

    @Override
    public Object postProjectListBasic(Map<String, Object> query) {
        return this.dataMapService.getProjectsBasic(query);
    }

    @Override
    public Object postProjectList(Map<String, Object> query) {
        return this.dataMapService.getProjects(query);
    }

    @Override
    public Object postFindTaskFromUser(FindTaskFromUserRequest request) throws Exception {
        log.info("TaskService.postFindTaskFromUser request param={}", (Object)JSONObject.toJSONString((Object)request));
        if (Objects.isNull(request) || StringUtils.isEmpty((CharSequence)request.getUserId())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.httpRequestError", new Object[0]));
        }
        List<String> appCodes = this.cacUtils.getAppAuth(request.getUserId());
        if (org.springframework.util.CollectionUtils.isEmpty(appCodes)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appCodesEmpty", new Object[0]));
        }
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("tenantId", request.getTenantId());
        query.put("taskDefName", request.getTaskDefName());
        query.put("applicationList", appCodes);
        query.put("executeType", "manual");
        query.put("pageNum", request.getPageNum());
        query.put("pageSize", request.getPageSize());
        this.handleRequestCategory(query, request.getCategory());
        Object taskFromUser = this.dataMapService.findTaskFromUser(query);
        String currentLocale = AthenaUtils.getCurrentLocale();
        return this.handleFindTaskRespParam(taskFromUser, request, currentLocale);
    }

    private void handleRequestCategory(Map<String, Object> query, List<String> category) {
        if (org.springframework.util.CollectionUtils.isEmpty(category)) {
            return;
        }
        List<String> categoryList = Stream.of("APPROVAL", "SOLVE", "REPLY", "PROCESS", "DATA_ENTRY").collect(Collectors.toList());
        ArrayList<String> drivenCategory = new ArrayList<String>();
        if (category.contains("OTHER")) {
            categoryList.removeAll(category);
            query.put("excludeCategoryList", categoryList);
            this.handleDrivenCategory(drivenCategory, categoryList);
        } else {
            query.put("includeCategoryList", category);
            this.handleDrivenCategory(drivenCategory, category);
        }
        query.put("drivenCategory", drivenCategory);
    }

    private FindTaskFromUserResp handleFindTaskRespParam(Object taskFromUser, FindTaskFromUserRequest request, String currentLocale) {
        if (Objects.isNull(taskFromUser)) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), 0L);
        }
        DataMapFindTaskResp dataMapFindTaskResp = (DataMapFindTaskResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)taskFromUser), DataMapFindTaskResp.class);
        if (Objects.isNull(dataMapFindTaskResp)) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), 0L);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(dataMapFindTaskResp.getData())) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), dataMapFindTaskResp.getTotal());
        }
        ArrayList<FindTaskFromUserVO> data = new ArrayList<FindTaskFromUserVO>();
        for (DataMapTaskVO dataMapTaskVO : dataMapFindTaskResp.getData()) {
            FindTaskFromUserVO vo = new FindTaskFromUserVO();
            vo.setTaskDefName(dataMapTaskVO, currentLocale);
            vo.setTaskDefCode(dataMapTaskVO.getCode());
            vo.setApplication(dataMapTaskVO.getApplication());
            vo.setCategory(Objects.equals("DATA_ENTRY_DRIVEN", dataMapTaskVO.getCategory()) ? dataMapTaskVO.getDrivenCategory() : dataMapTaskVO.getCategory());
            data.add(vo);
        }
        return new FindTaskFromUserResp(data, request.getPageNum(), request.getPageSize(), dataMapFindTaskResp.getTotal());
    }

    private void handleDrivenCategory(List<String> drivenCategory, List<String> category) {
        if (category.contains("APPROVAL")) {
            drivenCategory.add("ManualApprove");
        }
        if (category.contains("PROCESS")) {
            drivenCategory.add("ManualExecution");
        }
    }
}

