/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.authority.AppAuthorizationsResponse;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.kg.monitorRule.MonitorRuleConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kg.report.hz.model.sence.BigScreenViewDTO;
import com.digiwin.athena.kg.report.hz.model.sence.PermissionSceneDTO;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.knowledgegraph.action.dao.TenantServiceConfigDAO;
import com.digiwin.athena.knowledgegraph.app.LicenseKeyManager;
import com.digiwin.athena.knowledgegraph.cache.CacheService;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.component.ComponentInitManager;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.TenantAppRelation;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.domain.config.ProductTemplateTenant;
import com.digiwin.athena.knowledgegraph.domain.mechanism.ParadigmInitConfig;
import com.digiwin.athena.knowledgegraph.domain.rule.TenantServiceConfig;
import com.digiwin.athena.knowledgegraph.domain.valueobject.VirtualTenantParams;
import com.digiwin.athena.knowledgegraph.dto.TenantAppNoticeDTO;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.knowledgegraph.po.InitMonitorRuleParam;
import com.digiwin.athena.knowledgegraph.po.TenantInitParam;
import com.digiwin.athena.knowledgegraph.po.TenantInitResp;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.po.dap.RespStringList;
import com.digiwin.athena.knowledgegraph.po.dap.RespTenantEntity;
import com.digiwin.athena.knowledgegraph.po.dap.RespTenantEntityList;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.knowledgegraph.service.ATMCService;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IIMService;
import com.digiwin.athena.knowledgegraph.service.ILevelService;
import com.digiwin.athena.knowledgegraph.service.IScreenService;
import com.digiwin.athena.knowledgegraph.service.ITenantService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.OperationUnitService;
import com.digiwin.athena.knowledgegraph.service.RedisLock;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.ConfigChangeTypeEnum;
import com.digiwin.athena.knowledgegraph.service.impl.DataSubscriptionService;
import com.digiwin.athena.knowledgegraph.service.impl.DutyService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.impl.KgProductService;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.service.impl.ScreenService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import com.digiwin.athena.knowledgegraph.utils.TenantInitResultUtil;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
public class TenantService
implements ITenantService {
    private static final Logger log = LoggerFactory.getLogger(TenantService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactoryDomain2;
    @Autowired
    private AppService applicationService;
    @Autowired
    DutyService dutyService;
    @Autowired
    MechanismService mechanismService;
    @Autowired
    CacService cacService;
    @Autowired
    TaskService taskService;
    @Autowired
    TaskRepository taskRepository;
    @Autowired
    AppService appService;
    @Autowired
    LicenseKeyManager licenseKeyManager;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    IamService iamService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    OperationUnitService operationUnitService;
    @Autowired
    RedisLock redisLock;
    @Autowired
    CacheService cacheService;
    @Autowired
    ILevelService levelService;
    @Autowired
    ComponentInitManager componentInitManager;
    @Autowired
    IAMUtils iamUtils;
    @Autowired
    @Qualifier(value="kgrabbitTemplate")
    RabbitTemplate rabbitTemplate;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    EocService eocService;
    @Autowired
    ATMCService atmcService;
    @Autowired
    IIMService imService;
    @Autowired
    KgProductService productService;
    @Autowired
    OperationRecordUtil recordUtil;
    @Autowired
    DataSubscriptionService dataSubscriptionService;
    @Autowired
    CACUtils cacUtils;
    @Autowired
    private TenantServiceConfigDAO tenantServiceConfigDAO;
    @Autowired
    SceneService sceneService;
    @Autowired
    IScreenService iScreenService;
    @Autowired
    MonitorRuleManager monitorRuleManager;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    AppMetaCaller appMetaCaller;
    @Autowired
    private ScreenService screenService;

    @Override
    public List<TenantEntity> getAllTenant() {
        RespTenantEntityList respTenantEntity = this.appMetaCaller.call("/tenant/allTenant", "get", null, RespTenantEntityList.class);
        return respTenantEntity.getResponse();
    }

    @Override
    public TenantEntity getTenant(String tenantId) {
        RespTenantEntity respTenantEntity = this.appMetaCaller.call("/tenant/tenant", "get", AppMetaCaller.of("tenantId", tenantId), RespTenantEntity.class);
        return respTenantEntity.getResponse();
    }

    @Override
    public String getTenantVersion(String tenantId) {
        return this.kgInnerService.getTenantVersion(tenantId);
    }

    @Override
    public Object postConnectVirtualTenantToNodes(VirtualTenantParams virtualTenantParams) throws DWArgumentException {
        return null;
    }

    private Application getApplication(String appCode) throws DWBusinessException {
        Application application;
        if ("espCommon".equals(appCode)) {
            application = new Application();
            application.setCode("espCommon");
            application.setCommonApp(Boolean.valueOf(true));
        } else {
            application = this.appService.getApplicationByCode(appCode);
        }
        if (application == null || null == application.getCommonApp() || !application.getCommonApp().booleanValue()) {
            log.error("appEntity\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005appEntity\u8282\u70b9\u4e2dnameSpace\u4e3a\u7a7a\uff0c\u6216\u975e\u516c\u5171\u5e94\u7528\uff0c\u8bf7\u5148\u521b\u5efa\u540e\u518d\u521d\u59cb\u5316!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist", new Object[0]));
        }
        return application;
    }

    private void createVirtualRelation(SessionFactory sessionFactory, String appNameSpace, String application, String appVersion, String tenantVersion) throws DWArgumentException {
        if (sessionFactory == null) {
            return;
        }
        List tenantEntities = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("ifCommon").in(new Object[]{null, false})), TenantEntity.class);
        Session session = sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        try {
            session.query("match (te:TenantEntity{ifCommon:true,version:'" + tenantVersion + "'}) match (monitorRule:MonitorRule) where monitorRule.version='" + appVersion + "' and (monitorRule.nameSpace='" + appNameSpace + "' or monitorRule.athena_namespace = '" + application + "' or monitorRule.relation_namespace = '" + appNameSpace + "') and (monitorRule.inclusionTenant is null and monitorRule.notInclusionTenant is null) merge (te)-[:USE]->(monitorRule)", new HashMap());
            session.query("match (te:TenantEntity{ifCommon:true,version:'" + tenantVersion + "'}) match (activity:Activity) where activity.version='" + appVersion + "' and (activity.nameSpace='" + appNameSpace + "' or activity.athena_namespace = '" + application + "' or activity.relation_namespace = '" + appNameSpace + "') and (activity.inclusionTenant is null and activity.notInclusionTenant is null) merge (te)-[:ACTIVITY]->(activity)", new HashMap());
            session.query("match (te:TenantEntity{ifCommon:true,version:'" + tenantVersion + "'}) match (action:Action) where action.version='" + appVersion + "' and (action.nameSpace='" + appNameSpace + "' or action.athena_namespace = '" + application + "' or action.relation_namespace = '" + appNameSpace + "') and (action.inclusionTenant is null and action.notInclusionTenant is null) merge (te)-[:ACTION]->(action)", new HashMap());
            List tenantIdList = tenantEntities.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getTenantId())).map(HierarchicalEntity::getTenantId).distinct().collect(Collectors.toList());
            HashMap params = new HashMap();
            params.put("tenantIdList", tenantIdList);
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'}) where te.tenantId in $tenantIdList  match (monitorRule:MonitorRule) where monitorRule.version='" + appVersion + "' and (monitorRule.nameSpace='" + appNameSpace + "' or monitorRule.athena_namespace = '" + application + "' or monitorRule.relation_namespace = '" + appNameSpace + "') and ((monitorRule.inclusionTenant is not null and te.tenantId in monitorRule.inclusionTenant) or (monitorRule.notInclusionTenant is not null and not te.tenantId in monitorRule.notInclusionTenant)) merge (te)-[:USE]->(monitorRule)", params);
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'}) where te.tenantId in $tenantIdList match (activity:Activity) where activity.version='" + appVersion + "' and (activity.nameSpace='" + appNameSpace + "' or activity.athena_namespace = '" + application + "' or activity.relation_namespace = '" + appNameSpace + "') and ((activity.inclusionTenant is not null and te.tenantId in activity.inclusionTenant) or (activity.notInclusionTenant is not null and not te.tenantId in activity.notInclusionTenant)) merge (te)-[:ACTIVITY]->(activity)", params);
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'}) where te.tenantId in $tenantIdList match (action:Action) where action.version='" + appVersion + "' and (action.nameSpace='" + appNameSpace + "' or action.athena_namespace = '" + application + "' or action.relation_namespace = '" + appNameSpace + "') and ((action.inclusionTenant is not null and te.tenantId in action.inclusionTenant) or (action.notInclusionTenant is not null and not te.tenantId in action.notInclusionTenant)) merge (te)-[:ACTION]->(action)", params);
            transaction.commit();
        }
        catch (Exception e2) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e2;
        }
        finally {
            session.clear();
        }
    }

    @Override
    public Object postDeleteVirtualTenantToNodes(VirtualTenantParams virtualTenantParams) throws DWBusinessException {
        String appCode = virtualTenantParams.getApplication();
        String appVersion = virtualTenantParams.getAppVersion();
        String tenantVersion = virtualTenantParams.getTenantVersion();
        Application application = this.getApplication(appCode);
        String appNameSpace = application.getCode();
        this.deleteVirtualRelation(this.sessionFactoryDomain1, appNameSpace, appCode, appVersion, tenantVersion);
        this.deleteVirtualRelation(this.sessionFactoryDomain2, appNameSpace, appCode, appVersion, tenantVersion);
        return null;
    }

    private void deleteVirtualRelation(SessionFactory sessionFactory, String appNameSpace, String application, String appVersion, String tenantVersion) {
        if (sessionFactory == null) {
            return;
        }
        Session session = sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        try {
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'})-[r:USE]->(monitorRule:MonitorRule) where monitorRule.version='" + appVersion + "' and (monitorRule.nameSpace='" + appNameSpace + "' or monitorRule.athena_namespace = '" + application + "' or monitorRule.relation_namespace = '" + appNameSpace + "') DELETE r", new HashMap());
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'})-[r:ACTIVITY]->(activity:Activity) where activity.version='" + appVersion + "' and (activity.nameSpace='" + appNameSpace + "' or activity.athena_namespace = '" + application + "' or activity.relation_namespace = '" + appNameSpace + "') DELETE r", new HashMap());
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'})-[r:ACTION]->(action:Action) where action.version='" + appVersion + "' and (action.nameSpace='" + appNameSpace + "' or action.athena_namespace = '" + application + "' or action.relation_namespace = '" + appNameSpace + "') DELETE r", new HashMap());
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            session.clear();
        }
    }

    private List<String> findTemplateTenant(List<String> products, String appCode) {
        log.info("findTemplateTenant appCode:{}, products:{}", (Object)appCode, products);
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        HashSet<String> existTenant = new HashSet<String>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"app").is((Object)appCode));
        List templateTenants = this.mongoTemplate.find(query, ProductTemplateTenant.class);
        if (CollectionUtils.isEmpty((Collection)templateTenants)) {
            return null;
        }
        Map<String, String> collect = templateTenants.stream().collect(Collectors.toMap(ProductTemplateTenant::getProduct, ProductTemplateTenant::getTenantId));
        for (String str : products) {
            String s = collect.get(str);
            if (!StringUtils.isNotEmpty((CharSequence)s) || existTenant.contains(s)) continue;
            resultList.add(s);
            existTenant.add(s);
        }
        return resultList;
    }

    private List<String> findTemplateTenant(String product, String appCode) {
        log.info("findTemplateTenant appCode:{}, product:{}", (Object)appCode, (Object)product);
        if (StringUtils.isEmpty((CharSequence)product)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"app").is((Object)appCode).and("product").is((Object)product));
        List templateTenants = this.mongoTemplate.find(query, ProductTemplateTenant.class);
        if (CollectionUtils.isEmpty((Collection)templateTenants)) {
            return null;
        }
        resultList.add(((ProductTemplateTenant)templateTenants.get(0)).getTenantId());
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object postInitTenantInfoV2(TenantInitParam param) throws DWBusinessException {
        Short initPartFlag;
        TenantInitResp resp;
        block35: {
            resp = new TenantInitResp();
            if (StringUtils.isEmpty((CharSequence)param.getTenantId()) || StringUtils.isEmpty((CharSequence)param.getAppCode())) {
                throw new DWBusinessException("param", I18nUtils.getValue("knowledgegraph.tenantOrAppCodeEmpty", new Object[0]));
            }
            String initType = param.getInitType();
            initPartFlag = param.getInitPartFlag() == null ? (short)1 : param.getInitPartFlag();
            String tenantId = param.getTenantId();
            String tenantInitLockKey = "knowledgegraph:tenantInitLock:" + tenantId;
            String tenantInitLock = null;
            try {
                while ((tenantInitLock = this.redisLock.tryLock(tenantInitLockKey, 120000L)) == null) {
                    log.info("\u5f53\u524d\u79df\u6237:{}\u6b63\u5728\u521d\u59cb\u5316\u5176\u4ed6\u5e94\u7528\u7684\u6570\u636e\uff0c\u7b49\u5f85...", (Object)tenantId);
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        log.error("\u79df\u6237\u521d\u59cb\u5316\u7b49\u5f85\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        Thread.currentThread().interrupt();
                    }
                }
                List<String> initializedApps = this.dataPickService.tenantInitializedAppCodes(tenantId);
                boolean isFirstInit = CollectionUtils.isEmpty(initializedApps);
                log.info("\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u79df\u6237:" + tenantId);
                String appCode = param.getAppCode();
                Application application = this.appService.getApplicationByCode(appCode, tenantId);
                if (application == null) {
                    log.error("appEntity\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005appEntity\u8282\u70b9\u4e2dnameSpace\u4e3a\u7a7a\uff0c\u8bf7\u5148\u521b\u5efa\u540e\u518d\u521d\u59cb\u5316!");
                    throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist", new Object[0]));
                }
                String appNameSpace = application.getCode();
                String version = null;
                TenantEntity tenant = this.getTenant(tenantId);
                version = tenant == null ? "2.0" : tenant.getVersion();
                Object loginResponse = null;
                String tenantToken = null;
                try {
                    loginResponse = this.iamService.login(tenantId);
                    tenantToken = this.iamService.getTenantToken(tenantId, loginResponse);
                }
                catch (Exception e) {
                    log.error("\u521d\u59cb\u5316\u79df\u6237:{}\u83b7\u53d6token\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.toString());
                }
                log.info("\u901a\u8fc7\u5e94\u7528\u5730\u7aef\u4ea7\u54c1\u67e5\u627e\u6a21\u677f\u79df\u6237\u4fe1\u606f");
                List<String> templateTenant = null;
                List<String> cloudProductNamesWithRetry = null;
                if (StringUtils.isEmpty((CharSequence)param.getProduct())) {
                    try {
                        DWServiceContext.getContext().getRequestHeader().put("token", tenantToken);
                        cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetry(tenantId, 3);
                    }
                    catch (Exception e) {
                        log.error(e.toString());
                        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.searchProductFail", new Object[0]));
                    }
                    templateTenant = this.findTemplateTenant(cloudProductNamesWithRetry, param.getAppCode());
                } else {
                    templateTenant = this.findTemplateTenant(param.getProduct(), param.getAppCode());
                    cloudProductNamesWithRetry = Arrays.asList(param.getProduct());
                }
                log.info("\u901a\u8fc7\u5e94\u7528\u5730\u7aef\u4ea7\u54c1\u67e5\u627e\u6a21\u677f\u79df\u6237\u4fe1\u606f:{}", templateTenant);
                resp.setTemplateTenantIds(templateTenant);
                initPartFlag = CollectionUtils.isEmpty(templateTenant) || templateTenant.size() > 1 ? Short.valueOf(TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_NO_FLOW_TEMPLATE)) : Short.valueOf(TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_NO_FLOW_TEMPLATE));
                this.createTenantAppRelation(tenantId, param.getTenantName(), version, appCode, param.getCustomerServiceCode());
                if (StringUtils.equals((CharSequence)param.getInitType(), (CharSequence)"RENEW")) {
                    this.deleteTenantAppCodeCache(tenantId);
                    log.info("==========create neo4j entity==========");
                    String directLicenseKey = this.licenseKeyManager.getDirectLicenseKeyCanNull(tenantId);
                    if (StringUtils.isEmpty((CharSequence)directLicenseKey)) {
                        log.info("\u521d\u59cb\u5316\u79df\u6237:{}\u7684licenseKey\u4fe1\u606f", (Object)tenantId);
                        try {
                            this.appService.postSetLicenseKey(tenantId);
                        }
                        catch (Exception e) {
                            log.error("set LicenseKey error:{}", (Throwable)e);
                        }
                    }
                    this.initTenantParadigm(appCode, tenantId);
                }
                if (TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE)) {
                    try {
                        int initMonitorRuleResult = this.initMonitorRule(cloudProductNamesWithRetry, param.getAppCode(), param.getTenantId(), version);
                        initPartFlag = initMonitorRuleResult < 0 ? Short.valueOf(TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE)) : Short.valueOf(TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE));
                    }
                    catch (Exception e) {
                        initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE);
                        log.error("\u521d\u59cb\u5316\u79df\u6237:{}\u4fa6\u6d4b\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0:{}", (Object)tenantId, (Object)e.toString());
                    }
                }
                if (TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_SYNC_DUTY)) {
                    try {
                        log.info("\u521d\u59cb\u5316\u79df\u6237:{}\u7684\u5171\u901a\u804c\u80fd\u4fe1\u606f", (Object)tenantId);
                        this.dutyService.syncAllDuty(tenantToken, appCode, tenantId);
                        initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_DUTY);
                    }
                    catch (Exception e) {
                        log.error("\u521d\u59cb\u5316\u79df\u6237:{}\u7684\u5171\u901a\u804c\u80fd\u4fe1\u606f\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.toString());
                        initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_DUTY);
                    }
                }
                if (TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_SYNC_LEVEL)) {
                    try {
                        if (isFirstInit) {
                            this.levelService.syncDefaultLevel(tenantToken);
                            initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_LEVEL);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u521d\u59cb\u5316\u79df\u6237:{}\u7684\u6838\u51b3\u5c42\u7ea7\u4fe1\u606f\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.toString());
                        initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_LEVEL);
                    }
                }
                if (TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP)) {
                    try {
                        log.info("\u521d\u59cb\u5316\u79df\u6237:{}\u4efb\u52a1\u5f15\u64ce\u4fe1\u606fapp:{}", (Object)tenantId, (Object)appNameSpace);
                        Object dataMapResponse = StringUtils.isEmpty((CharSequence)param.getRouterKey()) ? this.dataMapService.initTenantInfo(tenantId, appNameSpace, null, appCode) : this.dataMapService.initTenantInfo(tenantId, appNameSpace, param.getRouterKey(), appCode);
                        log.info("\u521d\u59cb\u5316\u79df\u6237:{}\u4efb\u52a1\u5f15\u64ce\u4fe1\u606fapp:{},result:{}", new Object[]{tenantId, appNameSpace, dataMapResponse});
                        initPartFlag = dataMapResponse == null ? Short.valueOf(TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP)) : Short.valueOf(TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP));
                    }
                    catch (Exception e) {
                        initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP);
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (!TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_START_ENTERPRISE_OPERATION)) break block35;
                try {
                    String tenantType = this.iamService.getTenantType(tenantId, loginResponse);
                    if (StringUtils.isNotEmpty((CharSequence)tenantType) && !StringUtils.equals((CharSequence)tenantType, (CharSequence)"0")) {
                        log.info("\u521d\u59cb\u5316\u79df\u6237:{}\u5f00\u542f\u4f01\u4e1a\u8fd0\u8425", (Object)tenantId);
                        this.iamService.startEnterpriseOperation(tenantToken);
                        initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_START_ENTERPRISE_OPERATION);
                    }
                }
                catch (Exception e) {
                    log.error("\u521d\u59cb\u5316\u79df\u6237:{}\u5f00\u542f\u4f01\u4e1a\u8fd0\u8425\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.toString());
                    initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_START_ENTERPRISE_OPERATION);
                }
            }
            finally {
                if (tenantInitLock != null) {
                    log.info("\u91ca\u653e\u9501kgTenantInitLock\uff1a{}", (Object)tenantInitLock);
                    this.redisLock.unlock(tenantInitLockKey, tenantInitLock);
                }
            }
        }
        resp.setFlag(initPartFlag);
        return resp;
    }

    private boolean judgeIfPersonalTenant(String token) {
        try {
            Integer type = this.iamUtils.getTenantType(token);
            return 0 == type;
        }
        catch (IOException e) {
            return true;
        }
    }

    private void createTenantAppRelation(String tenantId, String tenantName, String version, String appCode, String customerServiceCode) {
        com.digiwin.athena.domain.core.tenant.TenantEntity entity = (com.digiwin.athena.domain.core.tenant.TenantEntity)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), com.digiwin.athena.domain.core.tenant.TenantEntity.class);
        TenantAppRelation tenantAppRelation = (TenantAppRelation)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("appCode").is((Object)appCode)), TenantAppRelation.class);
        if (null == entity) {
            entity = new com.digiwin.athena.domain.core.tenant.TenantEntity();
            entity.setTenantId(tenantId);
            entity.setTenantName(tenantName);
            entity.setVersion(version);
            entity.setCustomerServiceCode(customerServiceCode);
            this.mongoTemplate.save((Object)entity);
        } else if (null != customerServiceCode) {
            entity.setCustomerServiceCode(customerServiceCode);
            this.mongoTemplate.save((Object)entity);
        }
        if (null == tenantAppRelation) {
            TenantAppRelation relation = new TenantAppRelation();
            relation.setTenantId(tenantId);
            relation.setAppCode(appCode);
            this.mongoTemplate.save((Object)relation);
        }
    }

    private void removeTenantAppRelation(String tenantId, String appCode) {
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("appCode").is((Object)appCode)), TenantAppRelation.class);
    }

    private void createNeo4jEntity(SessionFactory sessionFactory, String tenantId, String version, String appNameSpace, String appCode, String tenantName, String customerServiceCode) {
        if (sessionFactory == null) {
            return;
        }
        log.info("=========createNeo4jEntity=========");
        Session session = sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        if (StringUtils.isEmpty((CharSequence)customerServiceCode)) {
            session.query("merge (te:TenantEntity{tenantId:'" + tenantId + "'}) set te.tenantName = '" + tenantName + "', te.version='" + version + "'", new HashMap());
        } else {
            session.query("merge (te:TenantEntity{tenantId:'" + tenantId + "'}) set te.tenantName = '" + tenantName + "', te.version='" + version + "', te.customerServiceCode='" + customerServiceCode + "'", new HashMap());
        }
        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match (app:AppEntity{code:'" + appCode + "'}) merge (te)-[:USE]->(app)", new HashMap());
        transaction.commit();
        session.clear();
    }

    private void statAfterCreateNeo4jEntity(Session session, String tenantId, String version, String appNameSpace, String appCode) {
        try {
            Integer cntActivity = (Integer)session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:ACTIVITY]->(activity:Activity) where activity.nameSpace = '" + appNameSpace + "' or activity.athena_namespace = '" + appCode + "' or activity.relation_namespace = '" + appNameSpace + "' and activity.version='" + version + "' return count(activity)", new HashMap());
            Integer cntTask = (Integer)session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:TASK]->(task:Task) where task.nameSpace = '" + appNameSpace + "' or task.athena_namespace = '" + appCode + "' or task.relation_namespace = '" + appNameSpace + "' and task.version='" + version + "' return count(task)", new HashMap());
            Integer cntMR = (Integer)session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:USE]->(mr:MonitorRule) where mr.nameSpace = '" + appNameSpace + "' or mr.athena_namespace = '" + appCode + "' or mr.relation_namespace = '" + appNameSpace + "' and mr.version='" + version + "' return count(mr)", new HashMap());
            Integer cntAction = (Integer)session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:ACTION]->(action:Action) where action.nameSpace = '" + appNameSpace + "' or action.athena_namespace = '" + appCode + "' or action.relation_namespace = '" + appNameSpace + "' and action.version='" + version + "' return count(action)", new HashMap());
            log.info("statAfterCreateNeo4jEntity:{} , activityCnt:{}, TaskCnt:{}, MonitorRuleCnt:{}, ActionCnt:{}", new Object[]{tenantId, cntActivity, cntTask, cntMR, cntAction});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initTenantParadigm(String appCode, String tenantId) throws DWBusinessException {
        log.info("initTenantParadigm appCode:{},tenantId:{}", (Object)appCode, (Object)tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode));
        List paradigmInitConfigList = this.mongoTemplate.find(query, ParadigmInitConfig.class, "paradigmInitConfig");
        if (CollectionUtils.isNotEmpty((Collection)paradigmInitConfigList)) {
            for (ParadigmInitConfig paradigmInitConfig : paradigmInitConfigList) {
                if (StringUtils.isEmpty((CharSequence)paradigmInitConfig.getParadigmCode())) continue;
                Boolean onlyInitAppComponent = paradigmInitConfig.getOnlyInitAppComponent();
                if (BooleanUtils.isTrue((Boolean)onlyInitAppComponent)) {
                    try {
                        this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigmInitConfig.getParadigmCode(), new ArrayList<String>());
                    }
                    catch (DWBusinessException e2) {
                        log.error("postInitializeTenantApplicationComponentList error:{}", (Object)e2.getMessage());
                    }
                    continue;
                }
                Query query2 = new Query();
                Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("paradigm").is((Object)paradigmInitConfig.getParadigmCode()).and("type").is((Object)ComponentStructuredListType.Mechanism);
                query2.addCriteria((CriteriaDefinition)criteria);
                List<ComponentStructuredList> componentStructuredList = this.dataPickService.find(criteria, tenantId, ComponentStructuredList.class, "componentStructuredList");
                if (CollectionUtils.isNotEmpty(componentStructuredList)) {
                    List<String> mechanismList = componentStructuredList.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getMechanismCode())).map(ComponentStructuredList::getMechanismCode).collect(Collectors.toList());
                    try {
                        this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigmInitConfig.getParadigmCode(), mechanismList);
                    }
                    catch (DWBusinessException e3) {
                        log.error("postInitializeTenantApplicationComponentList error:{}", (Object)e3.getMessage());
                    }
                    continue;
                }
                try {
                    this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigmInitConfig.getParadigmCode(), new ArrayList<String>());
                }
                catch (DWBusinessException e4) {
                    log.error("postInitializeTenantApplicationComponentList error:{}", (Object)e4.getMessage());
                }
            }
        }
    }

    @Override
    public Object postCleanTenantInfo(TenantInitParam param) throws DWBusinessException {
        RespObject respTenantEntity = this.appMetaCaller.call("/tenant/cleanTenantInfo", "post", AppMetaCaller.of("param", param), RespObject.class);
        return respTenantEntity.getResponse();
    }

    @Override
    public List<String> getAppCodes() throws DWBusinessException {
        RespStringList respTenantEntity = this.appMetaCaller.call("/tenant/appCodes", "get", null, RespStringList.class);
        return respTenantEntity.getResponse();
    }

    @Cache(namespace="knowledgegraph", key="getAppCodes$0", ttlSecs=86400L)
    public List<String> getAppCodes(String tenantId) throws DWBusinessException {
        return this.cacService.getAuthorizationsApplication(tenantId);
    }

    private void deleteTenantAppCodeCache(String tenantId) {
        log.info("deleteTenantAppCodeCache tenantId:{}", (Object)tenantId);
        String key = "knowledgegraph:SYSTEM:SYSTEM:zh_CN:getAppCodes$" + tenantId;
        try {
            Object o = this.cacheService.deleteKeys(Collections.singletonList(key));
            log.info("deleteTenantAppCodeCache tenantId:{}, result:{}", (Object)tenantId, o);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    @Override
    public Object getApps() throws DWBusinessException {
        RespObject respTenantEntity = this.appMetaCaller.call("/tenant/apps", "get", null, RespObject.class);
        return respTenantEntity.getResponse();
    }

    @Override
    public Map<String, Object> getAllTaskAndActivity() throws Exception {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> appCodes = this.cacService.getAuthorizationsApplication(tenantId);
        List<ApplicationRelation> relations = this.applicationService.postApplicationRelation(appCodes);
        ArrayList<String> codes = new ArrayList<String>();
        for (ApplicationRelation applicationRelation : relations) {
            if (!"task".equals(applicationRelation.getType())) continue;
            codes.add(applicationRelation.getCode());
        }
        ArrayList<Object> tasks = new ArrayList<Object>();
        for (String code : codes) {
            Object t = this.taskService.getDefinitionWithMultiLanguage(code);
            tasks.add(t);
        }
        resp.put("tasks", tasks);
        List<Activity> list = this.taskRepository.findManualActivities(codes, tenantVersion);
        for (Activity a : list) {
            Activity ba = this.taskService.findBetterActivity(tenantId, a.getCode(), a.getVersion());
            AthenaUtils.mergeObject(ba, a);
        }
        resp.put("activities", list);
        return resp;
    }

    public int initMonitorRule(List<String> products, String appCode, String tenantId, String version) throws Exception {
        log.info("initMonitorRule appCode:{}, products:{}, tenantId:{}", new Object[]{appCode, products, tenantId});
        ArrayList<String> allMonitorRuleList = new ArrayList<String>();
        HashSet<String> commonAotoRunMonitorRules = new HashSet<String>();
        List<String> monitorRuleCode = this.appService.getMonitorRuleCode(appCode, tenantId);
        List<ComponentBO> appComponent = this.componentInitManager.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.MonitorRule);
        List<String> appCollect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        monitorRuleCode = this.mergeAndDistinctLists(monitorRuleCode, appCollect);
        List<String> common = this.appService.getMonitorRuleCodeByAppAndVersion(version);
        List<ComponentBO> commonComponent = this.componentInitManager.getCommonComponentList(version, tenantId, ComponentTypeEnum.MonitorRule);
        List<String> collect = commonComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        common = this.mergeAndDistinctLists(common, collect);
        if (CollectionUtils.isEmpty(monitorRuleCode) && CollectionUtils.isEmpty(common)) {
            return 0;
        }
        if (!CollectionUtils.isEmpty(monitorRuleCode)) {
            allMonitorRuleList.addAll(monitorRuleCode);
        }
        if (!CollectionUtils.isEmpty(common)) {
            allMonitorRuleList.addAll(common);
            commonAotoRunMonitorRules.addAll(common);
        }
        List<MonitorRule> monitorRules = this.dataPickService.excludeWithSameCode(this.monitorRuleRepository.queryAutoRunMonitorRuleList(allMonitorRuleList, version, tenantId));
        int i = this.initMonitorRuleProcess(products, monitorRules, tenantId, version, commonAotoRunMonitorRules);
        return i;
    }

    public List<String> mergeAndDistinctLists(List<String> aList, List<String> bList) {
        HashSet<String> mergedSet = new HashSet<String>(aList);
        mergedSet.addAll(bList);
        return new ArrayList<String>(mergedSet);
    }

    private int initMonitorRuleProcess(List<String> products, List<MonitorRule> monitorRules, String tenantId, String version, Set<String> commonMonitorRules) throws Exception {
        if (CollectionUtils.isEmpty(monitorRules)) {
            return 0;
        }
        List<String> autoRunMonitorRuleCodes = monitorRules.stream().map(CodedEntity::getCode).collect(Collectors.toList());
        int hasSuccessInitAutoRunMonitorRuleCnt = 0;
        List<MonitorRuleProductConfig> monitorRuleProductConfigs = this.monitorRuleManager.getMonitorRuleProductConfigsById(autoRunMonitorRuleCodes, tenantId, version);
        Map<String, List<MonitorRuleProductConfig>> monitorProductMap = monitorRuleProductConfigs.stream().collect(Collectors.toMap(MonitorRuleConfig::getMonitorRuleId, p -> {
            ArrayList<MonitorRuleProductConfig> productConfigList = new ArrayList<MonitorRuleProductConfig>();
            productConfigList.add((MonitorRuleProductConfig)p);
            return productConfigList;
        }, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
        Object loginResponse = null;
        String tenantToken = null;
        try {
            loginResponse = this.iamService.login(tenantId);
            tenantToken = this.iamService.getTenantToken(tenantId, loginResponse);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u79df\u6237:{}\u83b7\u53d6token\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.toString());
        }
        ArrayList<MonitorRuleTenantConfig> monitorRuleTenantConfigList = new ArrayList<MonitorRuleTenantConfig>();
        boolean hasProductError = false;
        for (MonitorRule monitorRule : monitorRules) {
            MonitorRuleProductConfig productConfig = null;
            try {
                productConfig = this.getProductConfig(monitorRule.getCode(), monitorProductMap, tenantId, products, commonMonitorRules);
            }
            catch (Exception e) {
                hasProductError = true;
                log.error(e.getMessage());
                continue;
            }
            Query query1 = new Query();
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"monitorRuleId").is((Object)monitorRule.getCode()).and("tenantId").is((Object)tenantId));
            List tenantConfigList = this.mongoTemplateUser.find(query1, MonitorRuleTenantConfig.class);
            String tenantOperationUnitVersion = this.iamUtils.getTenantOperationUnitVersion(tenantToken);
            boolean tenantOperationUnitV2 = "v2".equals(tenantOperationUnitVersion);
            if (StringUtils.isNotEmpty((CharSequence)productConfig.getEocLevel())) {
                List<EocMapDTO> eocMap;
                if (tenantOperationUnitV2 || CollectionUtils.isEmpty(eocMap = this.monitorRuleConfigService.getEocMapWithOutProduct(productConfig.getEocLevel(), tenantId, tenantToken))) continue;
                ++hasSuccessInitAutoRunMonitorRuleCnt;
                if (CollectionUtils.isNotEmpty((Collection)tenantConfigList)) continue;
                for (EocMapDTO eocMapDTO : eocMap) {
                    MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
                    monitorRuleTenantConfig.setTenantId(tenantId);
                    monitorRuleTenantConfig.setMonitorRuleId(monitorRule.getCode());
                    monitorRuleTenantConfig.setProductName(productConfig.getProductName());
                    TriggerDTO triggerDTO = null;
                    if (monitorRule.getStandardPollingRule() == null) {
                        triggerDTO = new TriggerDTO();
                        triggerDTO.setFrequency(Integer.valueOf(1));
                        triggerDTO.setRepeat_type(Integer.valueOf(3));
                    } else {
                        triggerDTO = (TriggerDTO)JSON.parseObject((String)monitorRule.getStandardPollingRule(), TriggerDTO.class);
                    }
                    if (StringUtils.isEmpty((CharSequence)triggerDTO.getStart_time())) {
                        String format = LocalDateTime.now().plusMinutes(2L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                        triggerDTO.setStart_time(format);
                    }
                    monitorRuleTenantConfig.setStandardPollingRule((Object)triggerDTO);
                    monitorRuleTenantConfig.setStatus(Integer.valueOf(1));
                    if (StringUtils.isNotEmpty((CharSequence)monitorRule.getBacktrackDate())) {
                        monitorRuleTenantConfig.setBacktrackDate(monitorRule.getBacktrackDate());
                    }
                    monitorRuleTenantConfig.setTransactionId(UUID.randomUUID().toString());
                    monitorRuleTenantConfig.setEocMap(eocMapDTO);
                    monitorRuleTenantConfigList.add(monitorRuleTenantConfig);
                }
                continue;
            }
            ++hasSuccessInitAutoRunMonitorRuleCnt;
            if (CollectionUtils.isNotEmpty((Collection)tenantConfigList)) continue;
            MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
            monitorRuleTenantConfig.setTenantId(tenantId);
            monitorRuleTenantConfig.setMonitorRuleId(monitorRule.getCode());
            monitorRuleTenantConfig.setProductName(productConfig.getProductName());
            if (tenantOperationUnitV2) {
                EocMapDTO eocMap = this.monitorRuleConfigService.getRootEocMapWithOutProductV2(tenantToken);
                if (eocMap == null) continue;
                monitorRuleTenantConfig.setEocMap(eocMap);
            }
            TriggerDTO triggerDTO = null;
            if (monitorRule.getStandardPollingRule() == null) {
                triggerDTO = new TriggerDTO();
                triggerDTO.setFrequency(Integer.valueOf(1));
                triggerDTO.setRepeat_type(Integer.valueOf(3));
            } else {
                triggerDTO = (TriggerDTO)JSON.parseObject((String)monitorRule.getStandardPollingRule(), TriggerDTO.class);
            }
            if (StringUtils.isEmpty((CharSequence)triggerDTO.getStart_time())) {
                String format = LocalDateTime.now().plusMinutes(2L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                triggerDTO.setStart_time(format);
            }
            monitorRuleTenantConfig.setStandardPollingRule((Object)triggerDTO);
            monitorRuleTenantConfig.setStatus(Integer.valueOf(1));
            if (StringUtils.isNotEmpty((CharSequence)monitorRule.getBacktrackDate())) {
                monitorRuleTenantConfig.setBacktrackDate(monitorRule.getBacktrackDate());
            }
            monitorRuleTenantConfig.setTransactionId(UUID.randomUUID().toString());
            monitorRuleTenantConfigList.add(monitorRuleTenantConfig);
        }
        if (CollectionUtils.isEmpty(monitorRuleTenantConfigList)) {
            return hasProductError ? -1 : hasSuccessInitAutoRunMonitorRuleCnt - autoRunMonitorRuleCodes.size();
        }
        this.mongoTemplateUser.insert(monitorRuleTenantConfigList, "monitorRuleTenantConfig");
        TimeUnit.SECONDS.sleep(1L);
        for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
            String msg = this.monitorRuleConfigService.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.CREATED, null, monitorRuleTenantConfig.getBacktrackDate(), null, monitorRuleTenantConfig.getTransactionId());
            this.monitorRuleConfigService.recordPreMonitorRuleTenantConfig(monitorRuleTenantConfig.getTransactionId(), "MQ", msg, false, null, monitorRuleTenantConfig.getMonitorRuleId());
        }
        return hasSuccessInitAutoRunMonitorRuleCnt - autoRunMonitorRuleCodes.size();
    }

    private MonitorRuleProductConfig getProductConfig(String ruleId, Map<String, List<MonitorRuleProductConfig>> monitorProductMap, String tenantId, List<String> cloudProductNames, Set<String> commonMonitorRules) throws Exception {
        List<MonitorRuleProductConfig> productConfigList;
        if (cloudProductNames == null) {
            cloudProductNames = new ArrayList<String>();
        }
        if (CollectionUtils.isEmpty(productConfigList = monitorProductMap.get(ruleId))) {
            throw new Exception(I18nUtils.getValue("knowledgegraph.ruleNotFoundInMonitorRuleProductConfigs", ruleId));
        }
        List products = (List)this.productService.getAllSteadyProduct();
        if (!commonMonitorRules.contains(ruleId) && productConfigList.size() == 1 && !products.contains(productConfigList.get(0).getProductName())) {
            return productConfigList.get(0);
        }
        for (MonitorRuleProductConfig ruleProduct : productConfigList) {
            for (String cloudProduct : cloudProductNames) {
                if (!StringUtils.equals((CharSequence)ruleProduct.getProductName(), (CharSequence)cloudProduct)) continue;
                return ruleProduct;
            }
        }
        throw new Exception(I18nUtils.getValue("knowledgegraph.tenantNotMatchRule", tenantId, ruleId));
    }

    @Override
    public Object postInitMonitorRuleForExistsTenant(InitMonitorRuleParam param) throws Exception {
        log.info("startInitMonitorRuleForExistsTenant:{}", (Object)JSON.toJSONString((Object)param));
        if (StringUtils.isEmpty((CharSequence)param.getAppCode())) {
            throw new Exception(I18nUtils.getValue("knowledgegraph.appCodeEmpty", new Object[0]));
        }
        if (CollectionUtils.isEmpty(param.getRuleIdList())) {
            throw new Exception(I18nUtils.getValue("knowledgegraph.ruleIdListEmpty", new Object[0]));
        }
        HashSet<String> commonAotoRunMonitorRules = new HashSet<String>();
        ArrayList allAppPurchaseInfoList = new ArrayList();
        if (StringUtils.equalsIgnoreCase((CharSequence)param.getAppCode(), (CharSequence)"common")) {
            List<String> allAppCode = this.appService.getNotCommonAppCode();
            if (CollectionUtils.isNotEmpty(allAppCode)) {
                for (String appCode : allAppCode) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"common", (CharSequence)appCode)) continue;
                    AppAuthorizationsResponse allEffectiveTenantAndAppInfo = this.cacService.getAllEffectiveTenantAndAppInfo(appCode);
                    log.info("\u901a\u8fc7cac\u67e5\u8be2\u8fd8\u6ca1\u5931\u6548\u7684\u5e94\u7528\uff1a{} \u79df\u6237\u4fe1\u606f\u5171\uff1a{} \u6761", (Object)appCode, (Object)allEffectiveTenantAndAppInfo.getTotal());
                    if (!CollectionUtils.isNotEmpty((Collection)allEffectiveTenantAndAppInfo.getList())) continue;
                    allAppPurchaseInfoList.addAll(allEffectiveTenantAndAppInfo.getList());
                }
            }
            commonAotoRunMonitorRules.addAll(param.getRuleIdList());
        } else {
            AppAuthorizationsResponse allEffectiveTenantAndAppInfo = this.cacService.getAllEffectiveTenantAndAppInfo(param.getAppCode());
            log.info("\u901a\u8fc7cac\u67e5\u8be2\u8fd8\u6ca1\u5931\u6548\u7684\u5e94\u7528\uff1a{} \u79df\u6237\u4fe1\u606f\u5171\uff1a{} \u6761", (Object)param.getAppCode(), (Object)allEffectiveTenantAndAppInfo.getTotal());
            if (CollectionUtils.isNotEmpty((Collection)allEffectiveTenantAndAppInfo.getList())) {
                allAppPurchaseInfoList.addAll(allEffectiveTenantAndAppInfo.getList());
            }
        }
        HashSet<String> tenantHasInitSet = new HashSet<String>();
        HashMap<String, List<MonitorRule>> versionMonitorRuleMap = new HashMap<String, List<MonitorRule>>();
        for (AppPurchaseInfo appPurchaseInfo : allAppPurchaseInfoList) {
            String tenantId = appPurchaseInfo.getTenantId();
            if (tenantHasInitSet.contains(tenantId) || CollectionUtils.isNotEmpty(param.getTenantIds()) && !param.getTenantIds().contains(tenantId)) continue;
            try {
                String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                List<MonitorRule> monitorRules = (List<MonitorRule>)versionMonitorRuleMap.get(tenantVersion);
                if (CollectionUtils.isEmpty((Collection)monitorRules)) {
                    monitorRules = this.dataPickService.excludeWithSameCode(this.monitorRuleRepository.queryAutoRunMonitorRuleList(param.getRuleIdList(), tenantVersion, tenantId));
                }
                if (CollectionUtils.isEmpty((Collection)monitorRules)) continue;
                versionMonitorRuleMap.put(tenantVersion, monitorRules);
                ArrayList<String> cloudProductNamesWithRetry = new ArrayList();
                try {
                    cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetry(tenantId, 3);
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u79df\u6237:{}\u7684\u5730\u7aef\u4ea7\u54c1\u4fe1\u606f\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.getMessage());
                }
                int i = this.initMonitorRuleProcess(cloudProductNamesWithRetry, monitorRules, tenantId, tenantVersion, commonAotoRunMonitorRules);
                log.info("\u79df\u6237\uff1a{}\u521d\u59cb\u5316\u4fa6\u6d4b\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)(i == 0 ? "SUCCESS" : "FAILURE"));
            }
            catch (Exception e) {
                log.error("\u79df\u6237\uff1a{}\u521d\u59cb\u5316\u4fa6\u6d4b\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.getMessage());
            }
            tenantHasInitSet.add(tenantId);
        }
        log.info("finishInitMonitorRuleForExistsTenant:{}", (Object)JSON.toJSONString((Object)param));
        return null;
    }

    @Override
    public Object postHandleTenantAppExpire(TenantInitParam param) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)param.getTenantId()) && CollectionUtils.isEmpty(param.getTenantIdList())) {
            log.error("postHandleTenantAppExpire\u6ca1\u6709\u79df\u6237\u4fe1\u606f");
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getTenantId())) {
            List<String> tenantIdList = param.getTenantIdList();
            if (CollectionUtils.isEmpty(tenantIdList)) {
                tenantIdList = new ArrayList<String>();
                param.setTenantIdList(tenantIdList);
            }
            tenantIdList.add(param.getTenantId());
        }
        HashMap appVersionMonitorRuleMap = new HashMap();
        for (String tenantId : param.getTenantIdList()) {
            log.info("=========startHandleTenantAppExpire tenantId:{}, appCode:{}", (Object)tenantId, (Object)param.getAppCode());
            String appCode = param.getAppCode();
            List monitorCodes = new ArrayList();
            Map<String, Object> queryComponent = null;
            try {
                queryComponent = this.componentInitManager.queryComponent(tenantId, appCode, "expire", Arrays.asList(ComponentTypeEnum.MonitorRule.toString()));
                Object monitorRuleObj = queryComponent.get(ComponentTypeEnum.MonitorRule.toString());
                if (!ObjectUtils.isEmpty((Object)monitorRuleObj)) {
                    monitorCodes = (List)monitorRuleObj;
                }
            }
            catch (DWBusinessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (CollectionUtils.isEmpty(monitorCodes)) {
                log.info("=========startHandleTenantAppExpire appCode:{} tenantId:{}\u6ca1\u6709\u4fa6\u6d4b", (Object)appCode, (Object)tenantId);
                return null;
            }
            Query query = new Query();
            Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("monitorRuleId").in(monitorCodes).and("closed").ne((Object)true);
            query.addCriteria((CriteriaDefinition)criteria);
            List monitorRuleTenantConfigList = this.mongoTemplateUser.find(query, MonitorRuleTenantConfig.class);
            if (CollectionUtils.isEmpty((Collection)monitorRuleTenantConfigList)) {
                return null;
            }
            for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
                try {
                    String uuid = UUID.randomUUID().toString();
                    log.info("HandleTenantAppExpire tenantId:{}, monitorRuleId:{}, eocMap:{}", new Object[]{monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), JSON.toJSONString((Object)monitorRuleTenantConfig.getEocMap())});
                    Query query2 = new Query();
                    Criteria criteria2 = Criteria.where((String)"tenantId").is((Object)tenantId).and("monitorRuleId").is((Object)monitorRuleTenantConfig.getMonitorRuleId());
                    criteria2 = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(monitorRuleTenantConfig.getEocMap()), criteria2);
                    query2.addCriteria((CriteriaDefinition)criteria2);
                    Update update = new Update();
                    update.set("status", (Object)0).set("transactionId", (Object)uuid).set("closed", (Object)true).set("beforeClosedStatus", (Object)monitorRuleTenantConfig.getStatus());
                    this.mongoTemplateUser.updateMulti(query2, update, "monitorRuleTenantConfig");
                }
                catch (Exception e) {
                    log.error("HandleTenantAppExpireError tenantId:{}, monitorRuleId:{}, eocMap:{}, error:{}", new Object[]{monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), JSON.toJSONString((Object)monitorRuleTenantConfig.getEocMap()), e.getMessage()});
                }
            }
            log.info("=========finishHandleTenantAppExpire tenantId:{}, appCode:{}", (Object)tenantId, (Object)param.getAppCode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postHandleTenantAppExpire() {
        block13: {
            String handleTenantAppExpireLock = null;
            int dayBeforeNow = 2;
            String kgHandleTenantAppExpireLock = "knowledgegraph:handleTenantAppExpireLock";
            try {
                handleTenantAppExpireLock = this.redisLock.tryLock(kgHandleTenantAppExpireLock, 300000L);
                if (handleTenantAppExpireLock != null) {
                    log.info("=======\u62ff\u5230\u5904\u7406\u79df\u6237\u5e94\u7528\u8fc7\u671f\u7684\u9501{}:{}=======", (Object)kgHandleTenantAppExpireLock, (Object)handleTenantAppExpireLock);
                    log.info("===========\u5f00\u59cbHandleTenantAppExpire\u8fc7\u7a0b==========");
                    List<String> allAppCodes = this.applicationService.getAllAppCode();
                    for (String appCode : allAppCodes) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)"common", (CharSequence)appCode)) continue;
                        try {
                            AppAuthorizationsResponse allExpiredTenantAndAppInfo = this.cacService.getAllExpiredTenantAndAppInfo(appCode, 1, 1);
                            log.info("\u901a\u8fc7cac\u67e5\u8be2{}\u5929\u5185\u5931\u6548\u7684\u5e94\u7528\uff1a{} \u79df\u6237\u4fe1\u606f\u5171\uff1a{} \u6761", new Object[]{dayBeforeNow, appCode, allExpiredTenantAndAppInfo.getTotal()});
                            if (!CollectionUtils.isNotEmpty((Collection)allExpiredTenantAndAppInfo.getList())) continue;
                            List<String> collectTenantIds = allExpiredTenantAndAppInfo.getList().stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
                            for (String tenantId : collectTenantIds) {
                                String appExpireChangeMessage = this.getAppExpireChangeMessage(appCode, tenantId, "expire");
                                log.info("appExpireChangeMessage:{}", (Object)appExpireChangeMessage);
                                this.rabbitTemplate.convertAndSend("appExpireChange", null, (Object)appExpireChangeMessage);
                                this.recordUtil.recordInfo(OperationRecord.builder().type(OperationRecordType.MQ + "-" + "expire").tenantId(tenantId).application(appCode).path(this.getClass().getName()).supplementaryContent((Object)ImmutableMap.of((Object)"message", (Object)appExpireChangeMessage, (Object)"exchange", (Object)"appExpireChange")).build());
                                try {
                                    this.imService.noticeAppExpired(tenantId, appCode);
                                }
                                catch (Exception e) {
                                    log.error("send im message failed for tenant-[{}] appCode-[{}]", (Object)tenantId, (Object)appCode);
                                }
                                this.deleteTenantAppCodeCache(tenantId);
                                List<DataSubscriptionRule> dataSubscriptionRules = this.dataSubscriptionService.postQueryExpireDataSubscriptionConfig(tenantId, "", "", appCode);
                                if (!CollectionUtils.isNotEmpty(dataSubscriptionRules)) continue;
                                this.dataSubscriptionService.postRemoveDataSubscription(dataSubscriptionRules, "update");
                            }
                            TenantInitParam param = new TenantInitParam();
                            param.setAppCode(appCode);
                            param.setTenantIdList(collectTenantIds);
                            this.postHandleTenantAppExpire(param);
                        }
                        catch (Exception e) {
                            log.error(e.toString());
                        }
                    }
                    log.info("===========\u7ed3\u675fHandleTenantAppExpire\u8fc7\u7a0b==========");
                    break block13;
                }
                log.info("=======\u6ca1\u6709\u62ff\u5230\u5904\u7406\u79df\u6237\u5e94\u7528\u8fc7\u671f\u7684\u9501{}\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u5904\u7406=======", (Object)kgHandleTenantAppExpireLock);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            finally {
                if (handleTenantAppExpireLock != null) {
                    log.info("\u91ca\u653e\u9501{}\uff1a{}", (Object)kgHandleTenantAppExpireLock, (Object)handleTenantAppExpireLock);
                    this.redisLock.unlock(kgHandleTenantAppExpireLock, handleTenantAppExpireLock);
                }
            }
        }
    }

    @Override
    public Object postAppRenewNotice(TenantInitParam param) throws DWBusinessException {
        log.info("postAppRenewNotice\uff1a{}", (Object)param);
        if (StringUtils.isEmpty((CharSequence)param.getAppCode()) || StringUtils.isEmpty((CharSequence)param.getTenantId())) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appCodeOrTenantEmpty", new Object[0]));
        }
        this.deleteTenantAppCodeCache(param.getTenantId());
        String appExpireChangeMessage = this.getAppExpireChangeMessage(param.getAppCode(), param.getTenantId(), "renew");
        log.info("appExpireChangeMessage:{}", (Object)appExpireChangeMessage);
        this.rabbitTemplate.convertAndSend("appExpireChange", null, (Object)appExpireChangeMessage);
        this.recordUtil.recordInfo(OperationRecord.builder().type(OperationRecordType.MQ + "-" + "renew").tenantId(param.getTenantId()).application(param.getAppCode()).supplementaryContent((Object)ImmutableMap.of((Object)"message", (Object)appExpireChangeMessage, (Object)"exchange", (Object)"appExpireChange")).build());
        String startTime = param.getEffectiveTime();
        List<DataSubscriptionRule> dataSubscriptionRules = this.dataSubscriptionService.postQueryExpireDataSubscriptionConfig(param.getTenantId(), "", "", param.getAppCode());
        if (CollectionUtils.isNotEmpty(dataSubscriptionRules)) {
            this.dataSubscriptionService.postAppRenewDataSubscription(dataSubscriptionRules);
        }
        List monitorCodes = new ArrayList();
        Map<String, Object> queryComponent = null;
        try {
            queryComponent = this.componentInitManager.queryComponent(param.getTenantId(), param.getAppCode(), "renew", Arrays.asList(ComponentTypeEnum.MonitorRule.toString()));
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Object monitorRuleObj = queryComponent.get(ComponentTypeEnum.MonitorRule.toString());
        if (!ObjectUtils.isEmpty(monitorRuleObj)) {
            monitorCodes = (List)monitorRuleObj;
        }
        if (CollectionUtils.isEmpty(monitorCodes)) {
            log.info("postAppRenewNotice not find monitor rule in app:{}", (Object)param.getAppCode());
            return 1;
        }
        Query query = new Query();
        Criteria in = Criteria.where((String)"tenantId").is((Object)param.getTenantId()).and("closed").is((Object)true).and("monitorRuleId").in(monitorCodes);
        query.addCriteria((CriteriaDefinition)in);
        List monitorRuleTenantConfigList = this.mongoTemplateUser.find(query, MonitorRuleTenantConfig.class);
        HashSet<String> hasDeal = new HashSet<String>();
        for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
            try {
                if (hasDeal.contains(this.getTenantMonitorRuleKey(monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap()))) continue;
                String uuid = UUID.randomUUID().toString();
                Query query2 = new Query();
                Criteria criteria2 = Criteria.where((String)"tenantId").is((Object)param.getTenantId()).and("monitorRuleId").is((Object)monitorRuleTenantConfig.getMonitorRuleId());
                criteria2 = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(monitorRuleTenantConfig.getEocMap()), criteria2);
                query2.addCriteria((CriteriaDefinition)criteria2);
                Integer beforeClosedStatus = monitorRuleTenantConfig.getBeforeClosedStatus();
                if (beforeClosedStatus == null) {
                    beforeClosedStatus = 1;
                }
                Update update = new Update();
                update.set("status", (Object)beforeClosedStatus).set("transactionId", (Object)uuid).set("closed", (Object)false).set("beforeClosedStatus", null);
                Object tenantConfigStandardPollingRule = monitorRuleTenantConfig.getStandardPollingRule();
                if (StringUtils.isNotEmpty((CharSequence)startTime) && !ObjectUtils.isEmpty((Object)tenantConfigStandardPollingRule)) {
                    TriggerDTO triggerDTO = (TriggerDTO)JSON.parseObject((String)JSON.toJSONString((Object)tenantConfigStandardPollingRule), TriggerDTO.class);
                    triggerDTO.setStart_time(this.getNewStartTime(startTime, triggerDTO.getStart_time()));
                    update.set("standardPollingRule", (Object)triggerDTO);
                }
                Object standardPollingRules = monitorRuleTenantConfig.getStandardPollingRules();
                if (StringUtils.isNotEmpty((CharSequence)startTime) && !ObjectUtils.isEmpty((Object)standardPollingRules)) {
                    List triggerDTOS = JSON.parseArray((String)JSON.toJSONString((Object)standardPollingRules), TriggerDTO.class);
                    for (TriggerDTO triggerDTO : triggerDTOS) {
                        triggerDTO.setStart_time(this.getNewStartTime(startTime, triggerDTO.getStart_time()));
                    }
                    update.set("standardPollingRules", (Object)triggerDTOS);
                }
                boolean enableStatus = beforeClosedStatus == 1;
                UpdateResult updateResult = this.mongoTemplateUser.updateMulti(query2, update, "monitorRuleTenantConfig");
                log.info("postAppRenewNotice monitorRuleId:{} , updateResult:{}", (Object)monitorRuleTenantConfig.getMonitorRuleId(), (Object)updateResult.getModifiedCount());
                String msg = this.monitorRuleConfigService.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.CREATED, enableStatus, startTime, "MQ", uuid);
                this.monitorRuleConfigService.recordPreMonitorRuleTenantConfig(uuid, "MQ", msg, false, monitorRuleTenantConfig, monitorRuleTenantConfig.getMonitorRuleId());
                hasDeal.add(this.getTenantMonitorRuleKey(monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap()));
            }
            catch (Exception e) {
                log.error("postAppRenewNoticeError tenantId:{}, monitorRuleId:{}, eocMap:{}, error:{}", new Object[]{monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), JSON.toJSONString((Object)monitorRuleTenantConfig.getEocMap()), e.getMessage()});
            }
        }
        return 1;
    }

    @Override
    public Object postAppAddPurchaseNotice(String tenantId, String appCode) {
        log.info("postAppAddPurchaseNotice tenantId:{},appCode:{}", (Object)tenantId, (Object)appCode);
        try {
            this.imService.noticeAppRenew(tenantId, appCode);
        }
        catch (Exception e) {
            log.error("send im message failed for tenant-[{}] appCode-[{}] error:{}", new Object[]{tenantId, appCode, e.getMessage()});
            return 500;
        }
        return 0;
    }

    @Override
    public Object postTenantExpiredNotice(TenantAppNoticeDTO param) throws Exception {
        this.imService.noticeAppRestricted(param.getTenantId(), param.getAppCode());
        return null;
    }

    @Override
    public Object postTenantAppMaterialRemainNotice(TenantAppNoticeDTO param) throws Exception {
        this.imService.noticeAppExpired(param.getTenantId(), param.getAppCode());
        return null;
    }

    @Override
    public Object postTenantAppRenewNotice(TenantAppNoticeDTO param) throws Exception {
        this.imService.noticeAppRenew(param.getTenantId(), param.getAppCode());
        return null;
    }

    private String getTenantMonitorRuleKey(String monitorRuleId, EocMapDTO eocMap) {
        if (eocMap == null) {
            return monitorRuleId;
        }
        return monitorRuleId + eocMap.toString();
    }

    private String getNewStartTime(String startTime, String oldStartTime) {
        if (StringUtils.isEmpty((CharSequence)oldStartTime)) {
            return startTime;
        }
        String[] s = oldStartTime.split(" ");
        if (s.length != 2) {
            return startTime;
        }
        if (StringUtils.isEmpty((CharSequence)startTime)) {
            return oldStartTime;
        }
        String startDate = startTime.split(" ")[0];
        return startDate + " " + s[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postHandleTenantAppExpireRetainDaysAfter() {
        String handleTenantAppExpireRetainDaysAfterLock = null;
        String kgHandleTenantAppExpireRetainDaysAfterLock = "knowledgegraph:handleTenantAppExpireRetainDaysAfterLock";
        try {
            handleTenantAppExpireRetainDaysAfterLock = this.redisLock.tryLock(kgHandleTenantAppExpireRetainDaysAfterLock, 300000L);
            if (handleTenantAppExpireRetainDaysAfterLock != null) {
                log.info("=======\u62ff\u5230\u5904\u7406\u79df\u6237\u5e94\u7528\u8fc7\u671f\u7684\u9501{}:{}=======", (Object)kgHandleTenantAppExpireRetainDaysAfterLock, (Object)handleTenantAppExpireRetainDaysAfterLock);
                log.info("===========\u5f00\u59cbHandleTenantAppExpire\u8fc7\u7a0b==========");
                List<String> allAppCodes = this.applicationService.getAllAppCode();
                for (String appCode : allAppCodes) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"common", (CharSequence)appCode)) continue;
                    try {
                        AppAuthorizationsResponse allExpiredTenantAndAppInfo = this.cacService.getAllExpiredTenantAndAppInfo(appCode, 91, 91);
                        log.info("\u901a\u8fc7cac\u67e5\u8be2\u5df2\u5931\u6548\uff1a{}\u5929\u7684\u5e94\u7528\uff1a{} \u79df\u6237\u4fe1\u606f\u5171\uff1a{} \u6761", new Object[]{90, appCode, allExpiredTenantAndAppInfo.getTotal()});
                        if (!CollectionUtils.isNotEmpty((Collection)allExpiredTenantAndAppInfo.getList())) continue;
                        for (AppPurchaseInfo appPurchaseInfo : allExpiredTenantAndAppInfo.getList()) {
                            try {
                                String appExpireChangeMessage = this.getAppExpireChangeMessage(appCode, appPurchaseInfo.getTenantId(), "clean");
                                log.info("appExpireChangeMessage:{}", (Object)appExpireChangeMessage);
                                this.rabbitTemplate.convertAndSend("appExpireChange", null, (Object)appExpireChangeMessage);
                                this.recordUtil.recordInfo(OperationRecord.builder().type(OperationRecordType.MQ + "-" + "clean").tenantId(appPurchaseInfo.getTenantId()).application(appCode).supplementaryContent((Object)ImmutableMap.of((Object)"message", (Object)appExpireChangeMessage, (Object)"exchange", (Object)"appExpireChange")).build());
                                this.doClean(appPurchaseInfo.getTenantId(), appCode);
                            }
                            catch (Exception e) {
                                log.error("postHandleTenantAppExpireRetainDaysAfter error:{}", (Object)e.getMessage());
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("postHandleTenantAppExpireRetainDaysAfter error:{}", (Object)e.getMessage());
                    }
                }
                log.info("===========\u7ed3\u675fHandleTenantAppExpire\u8fc7\u7a0b==========");
            } else {
                log.info("=======\u6ca1\u6709\u62ff\u5230\u5904\u7406\u79df\u6237\u5e94\u7528\u8fc7\u671f\u7684\u9501{}\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u5904\u7406=======", (Object)kgHandleTenantAppExpireRetainDaysAfterLock);
            }
        }
        catch (Exception e) {
            log.error("postHandleTenantAppExpireRetainDaysAfter error:{}", (Object)e.getMessage());
        }
        finally {
            if (handleTenantAppExpireRetainDaysAfterLock != null) {
                log.info("\u91ca\u653e\u9501{}\uff1a{}", (Object)kgHandleTenantAppExpireRetainDaysAfterLock, (Object)handleTenantAppExpireRetainDaysAfterLock);
                this.redisLock.unlock(kgHandleTenantAppExpireRetainDaysAfterLock, handleTenantAppExpireRetainDaysAfterLock);
            }
        }
    }

    private void doClean(String tenantId, String appCode) {
        List<DataSubscriptionRule> dataSubscriptionRules;
        List<ApplicationRelation> mechanismList;
        Query query;
        Object monitorRuleObj;
        log.info("doClean...tenantId:{}, appCode:{}", (Object)tenantId, (Object)appCode);
        this.deleteTenantAppCodeCache(tenantId);
        Map<String, Object> queryComponent = null;
        try {
            queryComponent = this.componentInitManager.queryComponent(tenantId, appCode, "clean", Arrays.asList(ComponentTypeEnum.MonitorRule.toString()));
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (queryComponent != null && !ObjectUtils.isEmpty(monitorRuleObj = queryComponent.get(ComponentTypeEnum.MonitorRule.toString()))) {
            log.info("delete monitorRule:{}, tenantId:{}", monitorRuleObj, (Object)tenantId);
            List monitorRuleCodeList = (List)monitorRuleObj;
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("monitorRuleId").in((Collection)monitorRuleCodeList).and("closed").is((Object)true));
            DeleteResult monitorRuleTenantConfig = this.mongoTemplateUser.remove(query, "monitorRuleTenantConfig");
            log.info("delete monitorRule:{}, tenantId:{}, count:{}", new Object[]{monitorRuleCodeList, tenantId, monitorRuleTenantConfig.getDeletedCount()});
        }
        try {
            this.removeTenantAppRelation(tenantId, appCode);
        }
        catch (Exception e) {
            log.error("delete tenantEntityAndAppRelation error:{}", (Object)e.getMessage());
        }
        List<ApplicationRelation> paradigmList = this.getApplicationRelation("paradigm", appCode);
        if (CollectionUtils.isNotEmpty(paradigmList)) {
            List collect = paradigmList.stream().map(BaseEntity::getCode).collect(Collectors.toList());
            query = new Query();
            Criteria criteria = Criteria.where((String)"paradigmCode").in(collect).and("tenantId").is((Object)tenantId);
            query.addCriteria((CriteriaDefinition)criteria);
            DeleteResult paradigmCondition = this.mongoTemplateUser.remove(query, "paradigmCondition");
            log.info("delete paradigmCondition:{}, tenantId:{}, count:{}", new Object[]{collect, tenantId, paradigmCondition.getDeletedCount()});
        }
        if (CollectionUtils.isNotEmpty(mechanismList = this.getApplicationRelation("mechanism", appCode))) {
            List collect = paradigmList.stream().map(BaseEntity::getCode).collect(Collectors.toList());
            Query query2 = new Query();
            Criteria criteria = Criteria.where((String)"code").in(collect).and("tenantId").is((Object)tenantId);
            query2.addCriteria((CriteriaDefinition)criteria);
            DeleteResult mechanism = this.mongoTemplateUser.remove(query2, "mechanism");
            log.info("delete mechanismList:{},  tenantId:{},count:{}", new Object[]{collect, tenantId, mechanism.getDeletedCount()});
        }
        if (CollectionUtils.isNotEmpty(dataSubscriptionRules = this.dataSubscriptionService.postQueryExpireDataSubscriptionConfig(tenantId, "", "", appCode))) {
            this.dataSubscriptionService.postRemoveDataSubscription(dataSubscriptionRules, "delete");
        }
    }

    private List<ApplicationRelation> getApplicationRelation(String type, String appCode) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"type").is((Object)type).and("appCode").is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        List applicationRelationList = this.mongoTemplate.find(query, ApplicationRelation.class);
        return applicationRelationList;
    }

    public boolean checkAllAppExpired(String tenantId, String appCode, String eventType) {
        try {
            List<String> aithorizationsApplication = this.cacService.getAuthorizationsApplication(tenantId);
            if ("renew".equalsIgnoreCase(eventType)) {
                List<String> appCodes = this.dataPickService.tenantInitializedAppCodes(AthenaUtils.getTenantId());
                if (CollectionUtils.isEmpty(appCodes) || appCodes.size() == 1 && appCodes.get(0).equalsIgnoreCase(appCode)) {
                    return true;
                }
                for (String tenantAppCode : appCodes) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)appCode, (CharSequence)tenantAppCode) || !aithorizationsApplication.contains(tenantAppCode)) continue;
                    return false;
                }
                return true;
            }
            List<String> allAppCode = this.appService.getNotCommonAppCode();
            List intersection = (List)CollectionUtils.intersection(allAppCode, aithorizationsApplication);
            if (!ObjectUtils.isEmpty((Object)intersection)) {
                return false;
            }
            if ("clean".equalsIgnoreCase(eventType)) {
                String tenantToken = this.iamService.getTenantToken(tenantId);
                Object o = this.iamService.listAllTenantApplications(tenantToken);
                JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)o));
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String id = jsonObject.getString("id");
                    if (!allAppCode.contains(id)) continue;
                    String expiredTime = jsonObject.getString("expiredTime");
                    LocalDate expireTimeLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    long cha = LocalDate.now().toEpochDay() - expireTimeLocalDate.toEpochDay();
                    if (cha >= 91L) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.error("checkAllAppExpired error:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private void executeCypher(List<String> cypherList, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(cypherList)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session1 = sessionFactory.openSession();
        Transaction transaction1 = session1.beginTransaction();
        cypherList.forEach(cypher -> session1.query(cypher, new HashMap()));
        transaction1.commit();
        session1.clear();
    }

    public String getAppExpireChangeMessage(String appCode, String tenantId, String eventType) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("tenantId", tenantId);
        result.put("appCode", appCode);
        result.put("eventType", eventType);
        return JSON.toJSONString(result);
    }

    @Override
    public Object getUserIntegrityCheck() throws DWBusinessException {
        String userIntegrityCheck = DWApplicationConfigUtils.getProperty((String)"userIntegrityCheck");
        log.info("userIntegrityCheck:{}", (Object)userIntegrityCheck);
        if (StringUtils.equalsIgnoreCase((CharSequence)userIntegrityCheck, (CharSequence)"false")) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("userRole", "common");
            result.put("userIntegrity", true);
            return result;
        }
        ArrayList<String> dutyList = new ArrayList<String>();
        List<String> needUserCheckApp = this.applicationService.getNeedUserCheckApp(AthenaUtils.getTenantId());
        if (CollectionUtils.isEmpty(needUserCheckApp)) {
            log.info("userIntegrityCheck needUserCheckApp is empty:{}", (Object)AthenaUtils.getTenantId());
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("userRole", "common");
            result.put("userIntegrity", true);
            return result;
        }
        log.info("call checkByUser tenantId:{}, userId:{}, duty:{}, appIds:{}", new Object[]{AthenaUtils.getTenantId(), AthenaUtils.getUserId(), dutyList, needUserCheckApp});
        Object response = this.eocService.checkByUser(AthenaUtils.getHeaderToken(), dutyList, needUserCheckApp);
        JSONObject checkByUserResp = JSON.parseObject((String)JSON.toJSONString((Object)response));
        JSONObject data = checkByUserResp.getJSONObject("data");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userRole", data != null && data.getBooleanValue("superadmin") ? "super" : "common");
        result.put("userIntegrity", StringUtils.equals((CharSequence)checkByUserResp.getString("code"), (CharSequence)"200"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTenantUsersIntegrityCheck() {
        String userIntegrityCheck = DWApplicationConfigUtils.getProperty((String)"userIntegrityCheck");
        log.info("scheduleUserIntegrityCheck:{}", (Object)userIntegrityCheck);
        if (StringUtils.equalsIgnoreCase((CharSequence)userIntegrityCheck, (CharSequence)"false")) {
            return;
        }
        String kgTenantUsersIntegrityCheckLock = "knowledgegraph:tenantUsersIntegrityCheckLock";
        String tenantUsersIntegrityCheckLock = null;
        try {
            tenantUsersIntegrityCheckLock = this.redisLock.tryLock(kgTenantUsersIntegrityCheckLock, 300000L);
            if (tenantUsersIntegrityCheckLock != null) {
                log.info("=======\u62ff\u5230\u68c0\u67e5\u7528\u6237\u5b8c\u6574\u6027\u7684\u9501{}:{}=======", (Object)kgTenantUsersIntegrityCheckLock, (Object)tenantUsersIntegrityCheckLock);
                log.info("===========\u5f00\u59cbTenantUsersIntegrityCheck\u8fc7\u7a0b==========");
                List<TenantEntity> tenantEntities = this.getAllTenant();
                List tenantIdList = tenantEntities.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getTenantId())).map(HierarchicalEntity::getTenantId).distinct().collect(Collectors.toList());
                log.info("===========tenantIdList count:{}", (Object)tenantIdList.size());
                ArrayList requestParamList = new ArrayList();
                for (String tenantId : tenantIdList) {
                    try {
                        List<String> appCodes = this.appService.getNeedUserCheckApp(tenantId);
                        if (CollectionUtils.isEmpty(appCodes)) {
                            log.info("tenantHasNoEffectiveApp:{}", (Object)tenantId);
                            continue;
                        }
                        Query query = new Query();
                        Criteria criteria = Criteria.where((String)"type").is((Object)"duty").and("appCode").in(appCodes);
                        query.addCriteria((CriteriaDefinition)criteria);
                        List applicationRelationList = this.mongoTemplate.find(query, ApplicationRelation.class);
                        List dutyList = applicationRelationList.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("tenantId", tenantId);
                        map.put("dutyIds", dutyList);
                        map.put("appIds", appCodes);
                        map.put("version", "v2");
                        requestParamList.add(map);
                    }
                    catch (DWBusinessException e2) {
                        log.error("generate userCheckParam error:{}", (Object)e2.getMessage());
                    }
                }
                List partitions = Lists.partition(requestParamList, (int)10);
                for (List partition : partitions) {
                    try {
                        JSONArray data;
                        String tenantToken = null;
                        for (int tryTimes = 0; tenantToken == null && tryTimes < 3; ++tryTimes) {
                            tenantToken = this.iamService.getTenantToken(String.valueOf(((Map)partition.get(0)).get("tenantId")));
                        }
                        if (StringUtils.isEmpty(tenantToken)) {
                            log.error("tenantTokenIsEmpty:{}, params:{}", ((Map)partition.get(0)).get("tenantId"), (Object)partition);
                            continue;
                        }
                        Object o = this.eocService.checkByUsers(tenantToken, partition);
                        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)o));
                        if (StringUtils.equals((CharSequence)jsonObject.getString("code"), (CharSequence)"200") || (data = jsonObject.getJSONArray("data")) == null) continue;
                        for (int i = 0; i < data.size(); ++i) {
                            JSONObject jsonObject1 = data.getJSONObject(i);
                            this.atmcService.noticeSuperAdminUserIntegrityCheckResult(jsonObject1);
                        }
                    }
                    catch (Exception e3) {
                        log.error("call checkByUsers error:{}", (Object)e3.getMessage());
                    }
                }
                log.info("===========\u7ed3\u675fTenantUsersIntegrityCheck\u8fc7\u7a0b==========");
            } else {
                log.info("=======\u6ca1\u6709\u62ff\u5230\u68c0\u67e5\u7528\u6237\u5b8c\u6574\u6027\u7684\u9501{}\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u5904\u7406=======", (Object)kgTenantUsersIntegrityCheckLock);
            }
        }
        catch (Exception e4) {
            log.error("tenantUsersIntegrityCheck error:{}", (Object)e4.getMessage());
        }
        finally {
            if (tenantUsersIntegrityCheckLock != null) {
                log.info("\u91ca\u653e\u9501{}\uff1a{}", (Object)kgTenantUsersIntegrityCheckLock, (Object)tenantUsersIntegrityCheckLock);
                this.redisLock.unlock(kgTenantUsersIntegrityCheckLock, tenantUsersIntegrityCheckLock);
            }
        }
    }

    @Override
    public void postMockNoticeSuperAdminUserIntegrityCheckResult(JSONObject param) throws DWBusinessException {
        this.atmcService.noticeSuperAdminUserIntegrityCheckResult(param);
    }

    @Override
    public Object getAppsInfo() throws DWBusinessException {
        RespObject respTenantEntity = this.appMetaCaller.call("/tenant/appsInfo", "get", null, RespObject.class);
        return respTenantEntity.getResponse();
    }

    @Override
    public Object getUserAppAuth() throws DWBusinessException {
        RespObject respTenantEntity = this.appMetaCaller.call("/tenant/userAppAuth", "get", null, RespObject.class);
        Object res = respTenantEntity.getResponse();
        if (Objects.nonNull(res) && res instanceof JSONObject) {
            JSONObject resObj = (JSONObject)res;
            JSONArray appCodes = resObj.getJSONArray("appCodes");
            if (CollectionUtils.isNotEmpty((Collection)appCodes)) {
                List applications = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in((Collection)appCodes)), Map.class, "application");
                resObj.put("applications", (Object)applications);
            }
            return resObj;
        }
        return res;
    }

    @Override
    public Object getUserAppAuth(String userId) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        HashMap<String, Object> tenantAppInfos = new HashMap<String, Object>();
        List<String> appCodes = this.cacUtils.getAppAuth(userId);
        tenantAppInfos.put("appCodes", this.cacUtils.getAppAuth(userId));
        tenantAppInfos.put("tenantVersion", this.kgInnerService.currentTenantVersion());
        tenantAppInfos.put("tenantId", AthenaUtils.getTenantId());
        tenantAppInfos.put("userId", userId);
        if (CollectionUtils.isNotEmpty(appCodes)) {
            List applications = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(appCodes)), Map.class, "application");
            tenantAppInfos.put("applications", applications);
        }
        return tenantAppInfos;
    }

    @Override
    public List<Application> getUserMetricApplication() throws DWBusinessException {
        return this.getUserMetricApplication("1");
    }

    @Override
    public List<Application> getUserMetricApplication(String type) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        return this.getUserMetricApplication(type, userId);
    }

    @Override
    public List<Application> getUserMetricApplication(String type, String userId) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List<String> appCodes = this.cacUtils.getAppAuth(userId);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(appCodes).and("appType").in(new Object[]{6, 12})), Application.class);
        }
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(appCodes)), Application.class);
    }

    @Override
    public List<Application> getTenantMetricApplication() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List<String> appCodes = this.cacService.getAuthorizationsApplication(tenantId);
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(appCodes).and("appType").in(new Object[]{6, 12})), Application.class);
    }

    @Override
    public List<BigScreenViewDTO> getQuerySceneByTenant() throws Exception {
        List<Object> reportScenes = new ArrayList<BigScreenViewDTO>();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List<String> bigScreenCodes = this.iScreenService.getUserPermissionScreen(Collections.singletonList("bigScreen"));
        if (CollectionUtils.isEmpty(bigScreenCodes)) {
            return reportScenes;
        }
        List<ReportSceneDTO> sceneResults = this.sceneService.querySceneByCodeAndTag(bigScreenCodes, tenantVersion);
        reportScenes = sceneResults.stream().map(scene -> BigScreenViewDTO.builder().screenCode(scene.getCode()).screenName(scene.getSceneTitle()).flashFrequency(Integer.valueOf(5)).pageTurningFrequency(Integer.valueOf(30)).type("system").build()).collect(Collectors.toList());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)AthenaUtils.getUserId()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        List userScreenList = this.mongoTemplateUser.find(query, UserScreenConfig.class);
        reportScenes.addAll(0, userScreenList.stream().map(scene -> BigScreenViewDTO.builder().screenCode(scene.getCode()).screenName(scene.getName()).flashFrequency(Integer.valueOf(5)).pageTurningFrequency(Integer.valueOf(30)).type("user").build()).collect(Collectors.toList()));
        List appBigScreenViewConfigs = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"bigScreenCode").in(bigScreenCodes).and("tenantId").is((Object)tenantId)), BigScreenViewConfig.class);
        Map configMap = appBigScreenViewConfigs.stream().filter(config -> Objects.nonNull(config) && StringUtils.isNotEmpty((CharSequence)config.getBigScreenCode())).collect(Collectors.toMap(BigScreenViewConfig::getBigScreenCode, Function.identity()));
        for (BigScreenViewDTO bigScreenViewDTO : reportScenes) {
            BigScreenViewConfig appConfig = (BigScreenViewConfig)configMap.get(bigScreenViewDTO.getScreenCode());
            if (appConfig == null) continue;
            bigScreenViewDTO.setScreenName(StringUtils.isNotEmpty((CharSequence)appConfig.getBigScreenTitle()) ? appConfig.getBigScreenTitle() : bigScreenViewDTO.getScreenName());
            bigScreenViewDTO.setFlashFrequency(Optional.ofNullable(appConfig.getFlashFrequency()).orElse(5));
            bigScreenViewDTO.setPageTurningFrequency(Optional.ofNullable(appConfig.getPageTurningFrequency()).orElse(30));
        }
        return reportScenes;
    }

    @Override
    public Object getSystemTenantServiceConfig(String tenantId, String serviceName) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)tenantId) || StringUtils.isEmpty((CharSequence)serviceName)) {
            return Collections.emptyMap();
        }
        TenantServiceConfig tenantServiceConfig = this.tenantServiceConfigDAO.findTenantServiceConfig(tenantId, serviceName);
        String[] systemServiceConfig = this.productNameResolver.getPrioritizedProductList(serviceName);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("tenantServiceConfig", tenantServiceConfig);
        resultMap.put("systemServiceConfig", systemServiceConfig);
        return resultMap;
    }

    @Override
    public Object postQueryPermissionSceneByCode(List<String> codes) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        String userId = AthenaUtils.getUserId();
        List dataSets = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(codes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        List<Object> reportScenes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dataSets)) {
            List<String> applicationCodes = dataSets.stream().map(ReportSceneDTOs::getAppCode).distinct().collect(Collectors.toList());
            List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList<String>(), applicationCodes);
            reportScenes = dataSets.stream().map(scene -> {
                boolean isAuthorized = permissionCodes.contains(scene.getCode());
                PermissionSceneDTO dto = new PermissionSceneDTO();
                dto.setCode(scene.getCode());
                dto.setSceneTitle(scene.getName());
                dto.setIsAuthorized(Boolean.valueOf(isAuthorized));
                return dto;
            }).collect(Collectors.toList());
            return this.sceneService.getTranslateContent(reportScenes);
        }
        List<ReportSceneDTO> scenes = this.sceneService.querySceneMapsData(codes, tenantVersion);
        if (CollectionUtils.isEmpty(scenes)) {
            return this.sceneService.getTranslateContent(reportScenes);
        }
        List<String> applicationCodes = scenes.stream().map(ReportSceneDTO::getAppCode).distinct().collect(Collectors.toList());
        List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList<String>(), applicationCodes);
        List reportSceneLists = scenes.stream().map(scene -> {
            boolean isAuthorized = permissionCodes.contains(scene.getCode());
            PermissionSceneDTO dto = new PermissionSceneDTO();
            dto.setCode(scene.getCode());
            dto.setSceneTitle(scene.getSceneTitle());
            dto.setIsAuthorized(Boolean.valueOf(isAuthorized));
            return dto;
        }).collect(Collectors.toList());
        return this.sceneService.getTranslateContent(reportSceneLists);
    }

    @Override
    public Object postQueryPermissionSceneByCode(List<String> codes, String userId) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List dataSets = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(codes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        List<Object> reportScenes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dataSets)) {
            List<String> applicationCodes = dataSets.stream().map(ReportSceneDTOs::getAppCode).distinct().collect(Collectors.toList());
            List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList<String>(), applicationCodes);
            reportScenes = dataSets.stream().map(scene -> {
                boolean isAuthorized = permissionCodes.contains(scene.getCode());
                PermissionSceneDTO dto = new PermissionSceneDTO();
                dto.setCode(scene.getCode());
                dto.setSceneTitle(scene.getName());
                dto.setIsAuthorized(Boolean.valueOf(isAuthorized));
                return dto;
            }).collect(Collectors.toList());
            return this.sceneService.getTranslateContent(reportScenes);
        }
        List<ReportSceneDTO> scenes = this.sceneService.querySceneMapsData(codes, tenantVersion);
        if (CollectionUtils.isEmpty(scenes)) {
            return this.sceneService.getTranslateContent(reportScenes);
        }
        List<String> applicationCodes = scenes.stream().map(ReportSceneDTO::getAppCode).distinct().collect(Collectors.toList());
        List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList<String>(), applicationCodes);
        List reportSceneLists = scenes.stream().map(scene -> {
            boolean isAuthorized = permissionCodes.contains(scene.getCode());
            PermissionSceneDTO dto = new PermissionSceneDTO();
            dto.setCode(scene.getCode());
            dto.setSceneTitle(scene.getSceneTitle());
            dto.setIsAuthorized(Boolean.valueOf(isAuthorized));
            return dto;
        }).collect(Collectors.toList());
        return this.sceneService.getTranslateContent(reportSceneLists);
    }

    @Override
    public Object postQueryPermissionSceneByCode(String userId, List<String> appCodes, List<String> codes) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes) || CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        List<String> permissionCodes = this.iScreenService.getUserPermissionScreen(userId, Arrays.asList("scene", "metric"), appCodes);
        if (CollectionUtils.isEmpty(permissionCodes)) {
            return Collections.emptyList();
        }
        return codes.stream().filter(permissionCodes::contains).collect(Collectors.toList());
    }

    @Override
    public Object postQueryProductLineByApp(List<String> appCodes) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyMap();
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(appCodes).and("version").is((Object)tenantVersion));
        List applications = this.mongoTemplate.find(query, Application.class);
        return appCodes.stream().collect(Collectors.toMap(appCode -> appCode, appCode -> applications.stream().filter(application -> application.getCode().equals(appCode)).findFirst().map(Application::getProductLines).orElse(Collections.emptyList()), (existing, replacement) -> existing));
    }
}

