/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.targets.TenantIndicatorForest;
import com.digiwin.athena.knowledgegraph.service.ITenantTargetService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
public class TenantTargetService
implements ITenantTargetService {
    private static final Logger log = LoggerFactory.getLogger(TenantTargetService.class);
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Override
    public Object deleteIndicatorForest() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        this.mongoTemplateUser.findAndRemove(queryUser, TenantIndicatorForest.class, "indicatorForest");
        return null;
    }

    @Override
    public Object getIndicatorForest() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        TenantIndicatorForest tenantIndicatorForest = (TenantIndicatorForest)this.mongoTemplateUser.findOne(queryUser, TenantIndicatorForest.class, "indicatorForest");
        return tenantIndicatorForest;
    }

    @Override
    public Object getIndicatorForests() throws DWBusinessException {
        String tenantVersion = "2.0";
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"version").is((Object)tenantVersion);
        query.addCriteria((CriteriaDefinition)criteria);
        List tenantIndicatorForests = this.mongoTemplateUser.find(query, TenantIndicatorForest.class, "indicatorForest");
        return tenantIndicatorForests;
    }

    @Override
    public Object postIndicatorForest(@Valid TenantIndicatorForest tenantIndicatorForest) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        this.mongoTemplateUser.findAndRemove(queryUser, TenantIndicatorForest.class, "indicatorForest");
        tenantIndicatorForest.setTenantId(tenantId);
        tenantIndicatorForest.setVersion(tenantVersion);
        this.mongoTemplateUser.insert((Object)tenantIndicatorForest, "indicatorForest");
        return null;
    }
}

