/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.topic.Topic;
import com.digiwin.athena.knowledgegraph.dto.topic.TopicDto;
import com.digiwin.athena.knowledgegraph.service.ITopicService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
public class TopicService
implements ITopicService {
    private static final Logger log = LoggerFactory.getLogger(TopicService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    TenantService tenantService;
    @Autowired
    TranslateUtils translateUtils;

    @Override
    public Topic getTopic(String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)code).and("status").is((Object)1).and("version").is((Object)tenantVersion));
        return (Topic)this.mongoTemplate.findOne(query, Topic.class, "topic");
    }

    @Override
    public List<Topic> getAllTopics() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)1).and("version").is((Object)tenantVersion));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"editDate")}));
        return this.mongoTemplate.find(query, Topic.class, "topic");
    }

    @Override
    public boolean postSaveTopic(TopicDto dto) throws DWBusinessException {
        log.info("Route==>TopicService method=postSaveTopic dto={}", (Object)JSON.toJSONString((Object)dto));
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)dto.getCode()).and("version").is((Object)tenantVersion));
        Topic topic = (Topic)this.mongoTemplate.findOne(query, Topic.class, "topic");
        if (Objects.nonNull(topic)) {
            topic.setLang(dto.getLang());
            topic.setDescription(dto.getDescription());
            topic.setName(dto.getName());
            topic.setRelatedApps(dto.getRelatedApps());
            topic.setEditDate(new Date());
            try {
                topic.setEditBy(AthenaUtils.getUserId());
            }
            catch (Exception e) {
                log.error("Route==>TopicService method=updateTopic getUserId is null");
            }
            topic.setStatus(1);
            topic.setApplication("common");
            this.mongoTemplate.save((Object)topic, "topic");
        } else {
            this.addTopicMethod(dto, tenantVersion);
        }
        return true;
    }

    private void addTopicMethod(TopicDto dto, String tenantVersion) {
        Topic topic = new Topic();
        BeanUtils.copyProperties((Object)dto, (Object)topic);
        topic.setLang(dto.getLang());
        topic.setDescription(dto.getDescription());
        topic.setCreateDate(new Date());
        topic.setEditDate(new Date());
        topic.setVersion(tenantVersion);
        try {
            topic.setCreateBy(AthenaUtils.getTenantId());
        }
        catch (Exception e) {
            log.error("Route==>TopicService method=addTopicMethod getUserId is null");
        }
        topic.setStatus(1);
        topic.setApplication("common");
        this.mongoTemplate.insert((Object)topic, "topic");
    }

    @Override
    public boolean postDeleteTopic(String code) throws DWBusinessException {
        log.info("Route==>TopicService method=postDeleteTopic code={}", (Object)code);
        Topic topic = this.getTopic(code);
        if (Objects.nonNull(topic)) {
            topic.setStatus(0);
            topic.setEditDate(new Date());
            this.mongoTemplate.save((Object)topic, "topic");
        }
        return true;
    }
}

