/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.domain.TenantAppRelation;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DataPickService {
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private CACUtils cacUtils;
    @Autowired
    CacService cacService;
    @Autowired
    TenantService tenantService;

    public List<String> userApps() throws DWBusinessException {
        return this.cacUtils.getAppAuth();
    }

    public List<String> tenantApps(String tenantId) {
        return this.cacService.getAuthorizationsApplication(tenantId);
    }

    public List<String> tenantInitializedAppCodes(String tenantId) {
        List list = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantAppRelation.class);
        return list.stream().map(TenantAppRelation::getAppCode).distinct().collect(Collectors.toList());
    }

    public List<TenantAppRelation> tenantInitializedApps(String tenantId) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantAppRelation.class);
    }

    public List<TenantAppRelation> getTenantAppRelationByAppCode(List<String> appCodes) {
        if (CollectionUtils.isEmpty(appCodes)) {
            return new ArrayList<TenantAppRelation>();
        }
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"appCode").in(appCodes)), TenantAppRelation.class);
    }

    public List<String> commonAppCodes(String version) {
        List applications = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"commonApp").is((Object)true).and("version").is((Object)version)), Application.class);
        return applications.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
    }

    public <T extends HierarchicalEntity> T findByCode(String code, Class<T> c, String col) throws DWBusinessException {
        HashMap<String, Object> q = new HashMap<String, Object>();
        q.put("code", code);
        List<T> ts = this.find(q, c, col);
        if (!ts.isEmpty()) {
            return (T)((HierarchicalEntity)ts.get(0));
        }
        return null;
    }

    public <T extends HierarchicalEntity> List<T> find(Map<String, Object> query, Class<T> c, String col) throws DWBusinessException {
        List<T> ts = this.mongoTemplate.find(this.buildQuery(query), c, col);
        ts = this.excludeWithSameCode(ts);
        return ts;
    }

    public <T extends HierarchicalEntity> T findOneByCondition(Criteria criteria, Class<T> c, String col) throws DWBusinessException {
        List<T> ts = this.find(criteria, c, col);
        if (!ts.isEmpty()) {
            return (T)((HierarchicalEntity)ts.get(0));
        }
        return null;
    }

    public <T extends HierarchicalEntity> T findOneByCondition(Criteria criteria, String tenantId, Class<T> c, String col) throws DWBusinessException {
        List<T> ts = this.find(criteria, tenantId, c, col);
        if (!ts.isEmpty()) {
            return (T)((HierarchicalEntity)ts.get(0));
        }
        return null;
    }

    public <T extends HierarchicalEntity> List<T> find(Criteria criteria, Class<T> c, String col) throws DWBusinessException {
        List<T> ts = this.mongoTemplate.find(this.buildQuery(criteria, null), c, col);
        ts = this.excludeWithSameCode(ts);
        return ts;
    }

    public <T extends HierarchicalEntity> List<T> find(Criteria criteria, String tenantId, Class<T> c, String col) throws DWBusinessException {
        List<T> ts = this.mongoTemplate.find(this.buildQuery(criteria, tenantId), c, col);
        ts = this.excludeWithSameCode(ts);
        return ts;
    }

    public <T extends HierarchicalEntity> List<T> excludeWithSameCode(List<T> ts) {
        if (CollectionUtils.isEmpty(ts)) {
            return ts;
        }
        HashMap<String, List> maps = new HashMap<String, List>();
        for (HierarchicalEntity t : ts) {
            String code = t.entityBizCode();
            List ts1 = maps.computeIfAbsent(code, k -> new ArrayList());
            ts1.add(t);
        }
        ArrayList result = new ArrayList();
        maps.forEach((k, v) -> {
            Object t = this.chooseOneWithSameCode((List)v);
            result.add(t);
        });
        return result;
    }

    public <T extends HierarchicalEntity> List<T> excludeWithSameCodeAndFilterTenant(List<T> ts) throws DWBusinessException {
        return this.excludeWithSameCodeAndFilterTenant(ts, null);
    }

    public <T extends HierarchicalEntity> List<T> excludeWithSameCodeAndFilterTenant(List<T> ts, String tenantId) throws DWBusinessException {
        if (CollectionUtils.isEmpty(ts)) {
            return ts;
        }
        String finalTenantId = tenantId = StringUtils.isEmpty((Object)tenantId) ? AthenaUtils.getTenantId() : tenantId;
        ts.removeIf(t -> t.getTenantId() != null && !t.getTenantId().equals(finalTenantId) && !t.getTenantId().equals("SYSTEM"));
        return this.excludeWithSameCode(ts);
    }

    public <T extends HierarchicalEntity> T chooseOneWithSameCode(List<T> ts) {
        if (CollectionUtils.isEmpty(ts)) {
            return null;
        }
        for (HierarchicalEntity t : ts) {
            if ("SYSTEM".equals(t.getTenantId()) || StringUtils.isEmpty((Object)t.getTenantId())) {
                t.setSourceLevel(Integer.valueOf(1000));
            }
            if (null != t.getSourceLevel()) continue;
            t.setSourceLevel(Integer.valueOf(200));
        }
        ts.sort(Comparator.comparing(HierarchicalEntity::getSourceLevel));
        return (T)((HierarchicalEntity)ts.get(0));
    }

    private Query buildQuery(Map<String, Object> query) throws DWBusinessException {
        Criteria tenantCriteria;
        Query query1 = new Query();
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        String tenantId = MapUtils.getString(query, (Object)"tenantId", (String)AthenaUtils.getTenantIdSilent());
        if (null != tenantId) {
            if (!query.containsKey("version")) {
                String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                Criteria versionCriteria = new Criteria().and("version").is((Object)tenantVersion);
                criteriaList.add(versionCriteria);
            }
            tenantCriteria = Criteria.where((String)"tenantId").in(new Object[]{tenantId, "SYSTEM", null});
            criteriaList.add(tenantCriteria);
        } else {
            tenantCriteria = Criteria.where((String)"tenantId").in(new Object[]{"SYSTEM", null});
            criteriaList.add(tenantCriteria);
        }
        query.forEach((k, v) -> {
            if (v instanceof Collection) {
                ArrayList list = new ArrayList();
                Collection collection = (Collection)v;
                collection.forEach(ele -> list.add(ele));
                Criteria in = Criteria.where((String)k).in(list);
                criteriaList.add(in);
            } else if (v instanceof Criteria) {
                criteriaList.add(Criteria.where((String)k).elemMatch((Criteria)v));
            } else {
                Criteria criteria = Criteria.where((String)k).is(v);
                criteriaList.add(criteria);
            }
        });
        Criteria criteria = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
        query1.addCriteria((CriteriaDefinition)criteria);
        return query1;
    }

    private Query buildQuery(Criteria criteria, String tenantId) throws DWBusinessException {
        Query query = new Query();
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        String string = tenantId = StringUtils.isEmpty((Object)tenantId) ? AthenaUtils.getTenantIdSilent() : tenantId;
        if (null != tenantId) {
            if (!criteria.getCriteriaObject().containsKey((Object)"version")) {
                String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                Criteria versionCriteria = new Criteria().and("version").is((Object)tenantVersion);
                criteriaList.add(versionCriteria);
            }
            Criteria tenantCriteria = Criteria.where((String)"tenantId").in(new Object[]{tenantId, "SYSTEM", null});
            criteriaList.add(tenantCriteria);
        } else {
            criteria.and("tenantId").in(new Object[]{"SYSTEM", null});
        }
        criteriaList.add(criteria);
        Criteria criteria1 = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
        query.addCriteria((CriteriaDefinition)criteria1);
        return query;
    }

    public Application tenantAppRelation(String appCode, String tenantId) throws DWBusinessException {
        List<Application> relation = this.tenantAppRelations(Collections.singletonList(appCode), tenantId);
        if (!CollectionUtils.isEmpty(relation)) {
            return relation.get(0);
        }
        return null;
    }

    @Cache(namespace="knowledgegraph", key="tenantIndividualAllAppCodes", language=true, tenant=true, ttlSecs=86400L)
    public List<String> findIndividualAppCodes(String tenantId) throws DWBusinessException {
        String string = tenantId = StringUtils.isEmpty((Object)tenantId) ? AthenaUtils.getTenantIdSilent() : tenantId;
        if (StringUtils.isEmpty((Object)tenantId)) {
            return Collections.emptyList();
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("individualAll").is((Object)true);
        List apps = this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria), Application.class);
        return apps.stream().map(BaseEntity::getCode).collect(Collectors.toList());
    }

    public List<Application> tenantAppRelations(List<String> appCodes, String tenantId) throws DWBusinessException {
        tenantId = StringUtils.isEmpty((Object)tenantId) ? AthenaUtils.getTenantIdSilent() : tenantId;
        Criteria criteria = Criteria.where((String)"code").in(appCodes);
        if (StringUtils.isEmpty((Object)tenantId)) {
            criteria.and("tenantId").in(new Object[]{"SYSTEM", null});
        } else {
            String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
            criteria.and("tenantId").in(new Object[]{tenantId, "SYSTEM", null}).and("version").is((Object)tenantVersion);
        }
        List<Application> relations = this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria), Application.class);
        relations = this.excludeWithSameCode(relations);
        return relations;
    }

    public List<ApplicationRelation> applicationRelations(String appCode, String type, String subType, String tenantId, String version) throws DWBusinessException {
        int queryLevel = 0;
        if ("base_entry".equals(subType) || "statement".equals(subType)) {
            queryLevel = 2;
        } else {
            Application tenantAppRelation = this.tenantAppRelation(appCode, tenantId);
            if (null != tenantAppRelation && Boolean.TRUE.equals(tenantAppRelation.getIndividualAll())) {
                queryLevel = 1;
            }
        }
        String string = tenantId = StringUtils.isEmpty((Object)tenantId) ? AthenaUtils.getTenantIdSilent() : tenantId;
        if (StringUtils.isEmpty((Object)tenantId)) {
            queryLevel = 0;
        }
        String tenantVersion = StringUtils.isEmpty((Object)version) ? this.kgInnerService.getTenantVersion(tenantId) : version;
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode).and("version").is((Object)tenantVersion).and("type").is((Object)type));
        if (null != subType) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"subType").is((Object)subType));
        }
        switch (queryLevel) {
            case 0: {
                query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)"SYSTEM"), Criteria.where((String)"tenantId").is((Object)tenantId).and("sourceLevel").is(null)}));
                break;
            }
            case 1: {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
                break;
            }
            case 2: {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").in(new Object[]{"SYSTEM", tenantId, null}));
            }
        }
        List<ApplicationRelation> relations = this.mongoTemplate.find(query, ApplicationRelation.class);
        relations = this.excludeWithSameCode(relations);
        return relations;
    }

    public List<ApplicationRelation> applicationRelations(List<String> appCodes, String type, String subType, String tenantId, String version) throws DWBusinessException {
        ArrayList<ApplicationRelation> result = new ArrayList();
        List<Application> tenantAppRelations = this.tenantAppRelations(appCodes, tenantId);
        HashMap taMaps = new HashMap();
        tenantAppRelations.forEach(t -> taMaps.put(t.getCode(), t));
        tenantId = StringUtils.isEmpty((Object)tenantId) ? AthenaUtils.getTenantIdSilent() : tenantId;
        String tenantVersion = StringUtils.isEmpty((Object)version) ? this.kgInnerService.getTenantVersion(tenantId) : version;
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").in(appCodes).and("version").is((Object)tenantVersion));
        if (null != type) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        }
        if (null != subType) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"subType").is((Object)subType));
        }
        List relations = this.mongoTemplate.find(query, ApplicationRelation.class);
        for (ApplicationRelation relation : relations) {
            Application tenantAppRelation1 = (Application)taMaps.get(relation.getAppCode());
            if (null == tenantAppRelation1) {
                result.add(relation);
                continue;
            }
            int queryLevel = 0;
            if ("base_entry".equals(relation.getSubType()) || "statement".equals(relation.getSubType())) {
                queryLevel = 2;
            } else if (Boolean.TRUE.equals(tenantAppRelation1.getIndividualAll())) {
                queryLevel = 1;
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                queryLevel = 0;
                tenantId = "SYSTEM";
            }
            switch (queryLevel) {
                case 0: {
                    if (!"SYSTEM".equals(relation.getTenantId()) && !StringUtils.isEmpty((Object)relation.getTenantId()) && (!tenantId.equals(relation.getTenantId()) || relation.getSourceLevel() != null)) break;
                    result.add(relation);
                    break;
                }
                case 1: {
                    if (!tenantId.equals(relation.getTenantId())) break;
                    result.add(relation);
                    break;
                }
                case 2: {
                    result.add(relation);
                }
            }
        }
        result = this.excludeWithSameCode(result);
        return result;
    }

    public List<ApplicationRelation> filterApplicationRelations(List<ApplicationRelation> applicationRelations) throws DWBusinessException {
        ArrayList<ApplicationRelation> baseEntryAndStatement = new ArrayList<ApplicationRelation>();
        ArrayList<ApplicationRelation> otherRelations = new ArrayList<ApplicationRelation>();
        for (ApplicationRelation t : applicationRelations) {
            if ("base_entry".equals(t.getSubType()) || "statement".equals(t.getSubType())) {
                baseEntryAndStatement.add(t);
                continue;
            }
            otherRelations.add(t);
        }
        List<ApplicationRelation> result = this.excludeWithSameCode(baseEntryAndStatement);
        result.addAll(this.filterByIndividual(otherRelations, null, ApplicationRelation::getAppCode));
        return result;
    }

    public List<String> tenantApplicationRelationCodes(String type) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List<String> appCodes = this.tenantApps(tenantId);
        ArrayList<String> codes = new ArrayList<String>();
        List<ApplicationRelation> relations = this.applicationRelations(appCodes, type, null, tenantId, null);
        relations.forEach(r -> {
            if (!codes.contains(r.getCode())) {
                codes.add(r.getCode());
            }
        });
        return codes;
    }

    public List<String> tenantProductCodes(String type, List<String> appCodes) throws DWBusinessException {
        List<ApplicationRelation> relations = this.applicationRelations(appCodes, type, null, null, null);
        ArrayList<String> codes = new ArrayList<String>();
        relations.forEach(r -> {
            if (!codes.contains(r.getCode())) {
                codes.add(r.getCode());
            }
        });
        return codes;
    }

    public List<ApplicationRelation> applicationRelations(String type, List<String> codes) throws DWBusinessException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", type);
        param.put("code", codes);
        Query query = this.buildQuery(param);
        List relations = this.mongoTemplate.find(query, ApplicationRelation.class);
        this.excludeWithSameCode(relations);
        return relations;
    }

    public List<Map<String, Object>> excludeWithSameCode(List<Map<String, Object>> ts, Function<Map<String, Object>, String> uniqueKeyFunc, String appCode, String tenantId, boolean needJudgeIndividual) throws DWBusinessException {
        boolean individualAll = false;
        if (needJudgeIndividual) {
            Application tenantAppRelation = this.tenantAppRelation(appCode, tenantId);
            individualAll = null != tenantAppRelation && Boolean.TRUE.equals(tenantAppRelation.getIndividualAll());
        }
        List<Map<String, Object>> result = individualAll ? ts.stream().filter(t -> MapUtils.getInteger((Map)t, (Object)"sourceLevel", (Integer)1000) < 1000).collect(Collectors.toList()) : new ArrayList(ts.stream().collect(Collectors.toMap(uniqueKeyFunc, t -> t, (t1, t2) -> MapUtils.getInteger((Map)t1, (Object)"sourceLevel", (Integer)1000) <= MapUtils.getInteger((Map)t2, (Object)"sourceLevel", (Integer)1000) ? t1 : t2, LinkedHashMap::new)).values());
        return result;
    }

    public <T extends HierarchicalEntity> List<T> excludeWithSameCode(List<T> ts, String appCode, String tenantId, boolean needJudgeIndividual) throws DWBusinessException {
        boolean individualAll = false;
        if (needJudgeIndividual) {
            Application tenantAppRelation = this.tenantAppRelation(appCode, tenantId);
            individualAll = null != tenantAppRelation && Boolean.TRUE.equals(tenantAppRelation.getIndividualAll());
        }
        List<Object> result = individualAll ? ts.stream().filter(t -> Optional.ofNullable(t.getSourceLevel()).orElse(1000) < 1000).collect(Collectors.toList()) : new ArrayList(ts.stream().collect(Collectors.toMap(HierarchicalEntity::entityBizCode, t -> t, (t1, t2) -> Optional.ofNullable(t1.getSourceLevel()).orElse(1000) <= Optional.ofNullable(t2.getSourceLevel()).orElse(1000) ? t1 : t2, LinkedHashMap::new)).values());
        return result;
    }

    public <T> List<T> excludeWithSameCode(List<T> ts, Function<T, String> uniqueKeyFunc, Function<T, Integer> sourceLevelFunc) throws DWBusinessException {
        return new ArrayList(ts.stream().collect(Collectors.toMap(uniqueKeyFunc, t -> t, (t1, t2) -> Optional.ofNullable(sourceLevelFunc.apply(t1)).orElse(1000) <= Optional.ofNullable(sourceLevelFunc.apply(t2)).orElse(1000) ? t1 : t2, LinkedHashMap::new)).values());
    }

    public <T extends HierarchicalEntity> List<T> filterByIndividual(List<T> ts, String tenantId, Function<T, String> appCodeFunc) throws DWBusinessException {
        if (CollectionUtils.isEmpty(ts)) {
            return ts;
        }
        List<String> individualAppCodes = this.findIndividualAppCodes(tenantId);
        List collect = ts.stream().filter(t -> {
            String appCode = (String)appCodeFunc.apply(t);
            int sourceLevel = Optional.ofNullable(t.getSourceLevel()).orElse(1000);
            return individualAppCodes.contains(appCode) && sourceLevel < 1000 || !individualAppCodes.contains(appCode) && sourceLevel == 1000;
        }).collect(Collectors.toList());
        return this.excludeWithSameCode(collect);
    }

    public void addTenantCondition(Criteria criteria, String appCode, String tenantId) throws DWBusinessException {
        Application application = this.tenantAppRelation(appCode, tenantId);
        if (application != null && application.getIndividualAll().booleanValue()) {
            criteria.and("tenantId").is((Object)tenantId);
        } else {
            criteria.and("tenantId").is((Object)"SYSTEM");
        }
    }
}

