/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set.partParsers;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Phase;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.approve.ApproveInfo;
import com.digiwin.athena.domain.core.approve.ApproveInitiator;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.AtmcData;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.ProjectTarget;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.domain.definition.actions.DataEntity;
import com.digiwin.athena.domain.definition.actions.DataField;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.constant.SmartAdjustConstants;
import com.digiwin.athena.knowledgegraph.po.CommonDrivenSchemaReq;
import com.digiwin.athena.knowledgegraph.service.ATMCService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.KgService;
import com.digiwin.athena.knowledgegraph.service.TagSystemService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.EmailTemplateReq;
import com.digiwin.athena.knowledgegraph.set.DTDRelatedInfo;
import com.digiwin.athena.knowledgegraph.set.EmailEventIdEnum;
import com.digiwin.athena.knowledgegraph.set.IPartParser;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.knowledgegraph.spi.ApimgmtService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import com.digiwin.athena.set.Tag;
import com.digiwin.athena.set.TagEntity;
import com.digiwin.athena.set.part.EmailNotice;
import com.digiwin.athena.set.part.EmailNoticeTimingEnum;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.Processor;
import com.digiwin.athena.set.part.ReturnField;
import com.digiwin.athena.set.part.SmartAdjustProjectPart;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SmartAdjustProjectPartParser
implements IPartParser {
    private static final Logger log = LoggerFactory.getLogger(SmartAdjustProjectPartParser.class);
    @Autowired
    KgService kgService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    TagSystemService tagSystemService;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactoryDomain2;
    @Autowired
    CacService cacService;
    @Autowired
    private ATMCService atmcService;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    ESPUtils espUtils;
    @Autowired
    private ApimgmtService apimgmtService;
    @Autowired
    private IamService iamService;
    @Autowired
    @Qualifier(value="baseExecutor")
    ThreadPoolTaskExecutor executor;
    private static final String TASK_DETAIL = "task-detail";
    private static final String TASK_DETAIL_MOBILE = "task-detail-mobile";
    private static final String QUERY_DATA = "query_data";
    private static final String SUBMIT_ACTION = "submitAction";
    private static final String SUBMIT_ACTIONS = "submitActions";
    private static final String PROJECT_CARD = "project-card";
    private static final String TASK_CARD = "task-card";
    private static final String PART_TYPE = "smartAdjustProject";
    private static final String BUSINESS = "business";
    private static final String RULE = "rule";

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase((CharSequence)PART_TYPE, (CharSequence)part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        HashMap<String, Object> dtdRelatedInfoMap = new HashMap<String, Object>();
        SmartAdjustProjectPart smartAdjustProjectPart = (SmartAdjustProjectPart)JSON.parseObject((String)JSON.toJSONString((Object)part), SmartAdjustProjectPart.class);
        DTDRelatedInfo dtdRelatedInfo = new DTDRelatedInfo();
        dtdRelatedInfo.setVersion(context.getCurrentSet().getVersion());
        context.setDtdRelatedInfo(dtdRelatedInfo);
        this.parseBackstageApiInfo(smartAdjustProjectPart);
        this.buildAction(context, smartAdjustProjectPart);
        this.buildDataDescriptionAndDataState(context, smartAdjustProjectPart);
        this.buildGroupTask(context, smartAdjustProjectPart);
        this.buildManualTask(context, smartAdjustProjectPart);
        this.buildApproveTask(context, smartAdjustProjectPart);
        this.buildBackstageTask(context, smartAdjustProjectPart);
        this.buildProject(context, smartAdjustProjectPart);
        Set<String> showFieldCodes = this.buildPageView(context, smartAdjustProjectPart);
        this.buildEmailSetting(context, smartAdjustProjectPart);
        this.saveDataFieldDefination(context, smartAdjustProjectPart);
        this.buildAppRelation(context);
        this.createNeo4jSql(context);
        log.info("before executeNeo4jScript:{}", context.getNeo4jSql());
        this.executeNeo4jScript(context.getNeo4jSql(), this.sessionFactoryDomain1);
        this.executeNeo4jScript(context.getNeo4jSql(), this.sessionFactoryDomain2);
        this.executor.execute(() -> {
            try {
                this.tagSystemService.syncTags(this.handleTagParams(context, smartAdjustProjectPart.getReturnFields(), showFieldCodes));
            }
            catch (DWBusinessException e) {
                log.error("/tag/batchTags failed,{}", (Object)e.toString());
                throw new RuntimeException(e);
            }
        });
        context.getDtdRelatedInfo().setAppCode(context.getCurrentSet().getAppCode());
        log.info("before translateContent:{}", (Object)JSON.toJSONString((Object)context.getDtdRelatedInfo()));
        String infoStr = this.translateUtils.translateContent(JSON.parseObject((String)JSON.toJSONString((Object)context.getDtdRelatedInfo(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), DTDRelatedInfo.class));
        DTDRelatedInfo dtdRelatedInfoReq = (DTDRelatedInfo)JSON.parseObject((String)infoStr, DTDRelatedInfo.class);
        HashMap<String, String> taskCodeLangMap = new HashMap<String, String>();
        for (Task task : dtdRelatedInfoReq.getTaskList()) {
            if (MapUtils.isEmpty((Map)task.getLang()) || MapUtils.isEmpty((Map)((Map)task.getLang().get("name")))) {
                task.setLang((Map)ImmutableMap.of((Object)"name", (Object)ImmutableMap.of((Object)"zh_CN", (Object)task.getName(), (Object)"zh_TW", (Object)task.getName())));
            }
            taskCodeLangMap.put(task.getCode(), task.getName());
        }
        for (Phase phase : dtdRelatedInfoReq.getProject().getPhases()) {
            String name;
            if (!MapUtils.isEmpty((Map)phase.getLang()) && !MapUtils.isEmpty((Map)((Map)phase.getLang().get("name"))) || (name = (String)taskCodeLangMap.get(phase.getCode())) == null) continue;
            phase.setLang((Map)ImmutableMap.of((Object)"name", (Object)ImmutableMap.of((Object)"zh_CN", (Object)name, (Object)"zh_TW", (Object)name)));
        }
        dtdRelatedInfoMap.put("dtdRelatedInfo", dtdRelatedInfoReq);
        this.dataMapService.requestDataMap("/set/saveDtdRelatedInfo", "post", dtdRelatedInfoMap);
    }

    private void parseBackstageApiInfo(SmartAdjustProjectPart part) {
        List pageViews = part.getPageViews();
        PageView pageView = (PageView)pageViews.get(0);
        JSONObject pages = new JSONObject(pageView.getPages());
        JSONObject submitAction = pages.getJSONObject(TASK_DETAIL).getJSONArray("dataStates").getJSONObject(0).getJSONArray(SUBMIT_ACTIONS).getJSONObject(0);
        part.setProductName(submitAction.getString("productName"));
        part.setServiceName(submitAction.getString("serviceName"));
        part.setActionId(submitAction.getString("actionId"));
        JSONArray params = submitAction.getJSONArray("params");
        if (params != null) {
            List processors = JSONArray.parseArray((String)params.toJSONString(), Processor.class);
            part.setParams(processors);
        } else {
            part.setParams(new ArrayList());
        }
    }

    private void saveDataFieldDefination(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        if (!CollectionUtils.isEmpty((Collection)part.getReturnFields())) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String token = request.getHeader("token");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            }
            CommonDrivenSchemaReq req = new CommonDrivenSchemaReq();
            List<CommonDrivenSchemaReq.Field> fields = SmartAdjustProjectPartParser.getFieldList(part);
            CommonDrivenSchemaReq.Model model = new CommonDrivenSchemaReq.Model();
            req.setModel(model);
            model.setCode("heart_ctl_" + context.getCurrentSet().getCode());
            model.setDescription("heart_ctl_" + context.getCurrentSet().getCode());
            JSONObject appInfo = new JSONObject();
            appInfo.put("prod", (Object)"common-driven");
            model.setAppInfo(appInfo);
            CommonDrivenSchemaReq.Schema schema = new CommonDrivenSchemaReq.Schema();
            schema.setComment("heart_ctl_" + context.getCurrentSet().getCode());
            schema.setFields(fields);
            CommonDrivenSchemaReq.Index index = new CommonDrivenSchemaReq.Index().setId("B001").setMember(Collections.singletonList("heart_control_data_id")).setType("unique");
            schema.setIndex(Collections.singletonList(index));
            schema.setPublished(context.isExists());
            schema.setSystem(true);
            schema.setName("heart_ctl_" + context.getCurrentSet().getCode());
            schema.setPk("heart_control_data_id");
            schema.setSwitchCfg(new CommonDrivenSchemaReq.SwitchCfg());
            model.setSchema(schema);
            log.info("\u968f\u5fc3\u63a7\u4e1a\u52a1\u6570\u636e\u8868\u7ed3\u6784\uff1a{}", (Object)JSON.toJSONString((Object)req));
            try {
                Object execute = this.espUtils.callEspService(model, token, AthenaUtils.getTenantId(), "common-driven", "commondriven.schema.update");
                log.info("\u8bf7\u6c42common-driven\u66f4\u65b0\u8868\u7ed3\u6784\uff0cresponse\uff1a{}", (Object)JSON.toJSONString((Object)execute));
                String testIntegrationToken = this.iamService.getTestIntegrationToken(AthenaUtils.getTenantId());
                log.info("\u83b7\u53d6test\u533a\u7ee7\u627f\u8d26\u53f7token\uff1a{}", (Object)testIntegrationToken);
                String updateScriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/updateApiSaveStruct.json");
                String create = updateScriptTemplate.replaceAll("#apiDescription#", "\u65b0\u589e\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e").replaceAll("#apiName#", "common.driven.heart.ctl." + context.getCurrentSet().getCode() + ".create").replaceAll("#schemaName#", "heart_ctl_" + context.getCurrentSet().getCode());
                this.apimgmtService.publishActionMeataDataToApimgmt(JSONArray.parseArray((String)create), testIntegrationToken);
                String update = updateScriptTemplate.replaceAll("#apiDescription#", "\u66f4\u65b0\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e").replaceAll("#apiName#", "common.driven.heart.ctl." + context.getCurrentSet().getCode() + ".update").replaceAll("#schemaName#", "heart_ctl_" + context.getCurrentSet().getCode());
                this.apimgmtService.publishActionMeataDataToApimgmt(JSONArray.parseArray((String)update), testIntegrationToken);
                this.saveListGetApi(context, part, testIntegrationToken);
            }
            catch (Exception e) {
                throw new DWBusinessException(e.getMessage());
            }
        }
    }

    private void saveListGetApi(SetParseContext context, SmartAdjustProjectPart part, String token) {
        String scriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/apiSaveStruct.json");
        String list = scriptTemplate.replaceAll("#apiDescription#", "\u67e5\u8be2\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e\u5217\u8868").replaceAll("#apiName#", "common.driven.heart.ctl." + context.getCurrentSet().getCode() + ".list.get").replaceAll("#schemaName#", "heart_ctl_" + context.getCurrentSet().getCode());
        JSONArray listApiData = JSONArray.parseArray((String)list);
        JSONObject apiMgmtModelSave = listApiData.getJSONObject(0).getJSONObject("apiMgmtModelSave");
        JSONArray responseMessageSuccessSpec = apiMgmtModelSave.getJSONArray("responseMessageSuccessSpec");
        JSONObject responseField = new JSONObject();
        String uid = UUID.randomUUID().toString();
        JSONObject lang = new JSONObject().fluentPut("en_US", (Object)"\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e").fluentPut("zh_CN", (Object)"\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e").fluentPut("zh_TW", (Object)"\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e");
        JSONObject remarkLang = new JSONObject().fluentPut("en_US", (Object)"\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e").fluentPut("zh_CN", (Object)"\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e").fluentPut("zh_TW", (Object)"\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e");
        responseField.fluentPut("_uid", (Object)uid).fluentPut("canFilter", (Object)"Y").fluentPut("canSort", (Object)"Y").fluentPut("columnType", (Object)"M").fluentPut("dataDescription", (Object)"\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e").fluentPut("dataDescriptionMultilingual", (Object)lang).fluentPut("dataName", (Object)("heart_ctl_" + context.getCurrentSet().getCode())).fluentPut("dataNameRemark", (Object)"\u67e5\u8be2\u968f\u5fc3\u63a7\u6570\u636e\u6570\u636e\u5217\u8868").fluentPut("dataNameRemarkMultilingual", (Object)remarkLang).fluentPut("dataType", (Object)"object").fluentPut("editHistory", (Object)"").fluentPut("id", (Object)10).fluentPut("isArray", (Object)"Y").fluentPut("isBusinessKey", (Object)"N").fluentPut("isDatakey", (Object)"N").fluentPut("isRequired", (Object)"Y").fluentPut("listEnum", (Object)"Y").fluentPut("listEnumMultilingual", (Object)new JSONObject().fluentPut("en_US", (Object)"").fluentPut("zh_CN", (Object)"").fluentPut("zh_TW", (Object)"")).fluentPut("parentId", (Object)0).fluentPut("productPrecision", Collections.emptyMap()).fluentPut("value", (Object)"").fluentPut("type", (Object)"responseSuccess");
        JSONArray children = new JSONArray();
        HashMap<String, String> existsFieldMap = new HashMap<String, String>();
        for (ReturnField returnField : part.getReturnFields()) {
            if ("@taskPerformerId".equals(returnField.getDatasourceField()) || existsFieldMap.containsKey(returnField.getDatasourceField())) continue;
            String dataType = returnField.getValueType();
            if ("number".equals(returnField.getValueType())) {
                dataType = "numeric";
            } else if ("text".equals(returnField.getValueType()) || "percent".equals(returnField.getValueType())) {
                dataType = "string";
            }
            existsFieldMap.put(returnField.getDatasourceField(), "exists");
            JSONObject field = new JSONObject();
            JSONObject fieldLang = new JSONObject().fluentPut("en_US", (Object)returnField.getDisplayName()).fluentPut("zh_CN", (Object)returnField.getDisplayName()).fluentPut("zh_TW", (Object)returnField.getDisplayName());
            field.fluentPut("_uid", (Object)UUID.randomUUID().toString()).fluentPut("canFilter", (Object)"Y").fluentPut("canSort", (Object)"Y").fluentPut("columnType", (Object)"MF").fluentPut("dataDescription", (Object)returnField.getDisplayName()).fluentPut("dataDescriptionMultilingual", (Object)fieldLang).fluentPut("dataName", (Object)returnField.getDatasourceField()).fluentPut("dataType", (Object)dataType).fluentPut("expand", (Object)false).fluentPut("isArray", (Object)"N").fluentPut("isBusinessKey", (Object)"N").fluentPut("isDatakey", (Object)"N").fluentPut("isRequired", (Object)"N").fluentPut("parentId", (Object)uid).fluentPut("type", (Object)"responseSuccess");
            children.add((Object)field);
        }
        JSONObject pkField = new JSONObject();
        JSONObject pkFieldLang = new JSONObject().fluentPut("en_US", (Object)"\u4e3b\u952e").fluentPut("zh_CN", (Object)"\u4e3b\u952e").fluentPut("zh_TW", (Object)"\u4e3b\u952e");
        pkField.fluentPut("_uid", (Object)UUID.randomUUID().toString()).fluentPut("canFilter", (Object)"Y").fluentPut("canSort", (Object)"Y").fluentPut("columnType", (Object)"MF").fluentPut("dataDescription", (Object)"\u4e3b\u952e").fluentPut("dataDescriptionMultilingual", (Object)pkFieldLang).fluentPut("dataName", (Object)"heart_control_data_id").fluentPut("dataType", (Object)"numeric").fluentPut("expand", (Object)false).fluentPut("isArray", (Object)"N").fluentPut("isBusinessKey", (Object)"Y").fluentPut("isDatakey", (Object)"Y").fluentPut("isRequired", (Object)"Y").fluentPut("parentId", (Object)uid).fluentPut("type", (Object)"responseSuccess");
        children.add((Object)pkField);
        responseField.put("childrens", (Object)children);
        responseMessageSuccessSpec.add((Object)responseField);
        this.apimgmtService.publishActionMeataDataToApimgmt(listApiData, token);
    }

    private static List<CommonDrivenSchemaReq.Field> getFieldList(SmartAdjustProjectPart part) {
        ArrayList<CommonDrivenSchemaReq.Field> fields = new ArrayList<CommonDrivenSchemaReq.Field>();
        CommonDrivenSchemaReq.Field pkField = new CommonDrivenSchemaReq.Field();
        pkField.setAutoIncrement(true);
        pkField.setFieldId("heart_control_data_id");
        pkField.setFieldName("\u4e3b\u952e");
        pkField.setFieldType(DataTypeEnum.BIGINT.getName());
        pkField.setPk(true);
        pkField.setSystem(true);
        pkField.setNotNull(true);
        pkField.setSize("20");
        fields.add(pkField);
        CommonDrivenSchemaReq.Field tenantSidField = new CommonDrivenSchemaReq.Field();
        tenantSidField.setAutoIncrement(false);
        tenantSidField.setFieldId("tenantsid");
        tenantSidField.setFieldName("\u79df\u6237sid");
        tenantSidField.setFieldType(DataTypeEnum.BIGINT.getName());
        tenantSidField.setSystem(true);
        tenantSidField.setNotNull(true);
        tenantSidField.setUnique(false);
        tenantSidField.setSize("20");
        fields.add(tenantSidField);
        CommonDrivenSchemaReq.Field statusField = new CommonDrivenSchemaReq.Field();
        statusField.setFieldId("heart_control_data_status");
        statusField.setFieldName("\u6570\u636e\u5ba1\u6279\u72b6\u6001");
        statusField.setFieldType(DataTypeEnum.VARCHAR.getName());
        statusField.setSize("20");
        statusField.setDefaultValue("0");
        fields.add(statusField);
        CommonDrivenSchemaReq.Field sourceIdsField = new CommonDrivenSchemaReq.Field();
        tenantSidField.setAutoIncrement(false);
        sourceIdsField.setFieldId("sourceIds");
        sourceIdsField.setFieldName("\u6765\u6e90id");
        sourceIdsField.setFieldType(DataTypeEnum.VARCHAR.getName());
        sourceIdsField.setSize("20");
        fields.add(sourceIdsField);
        HashMap<String, String> existsFieldMap = new HashMap<String, String>();
        for (ReturnField returnField : part.getReturnFields()) {
            if (returnField.getDatasourceField().equals("heart_control_data_id") || "tenantsid".equals(returnField.getDatasourceField()) || "heart_control_data_status".equals(returnField.getDatasourceField()) || existsFieldMap.containsKey(returnField.getDatasourceField())) continue;
            existsFieldMap.put(returnField.getDatasourceField(), "exists");
            CommonDrivenSchemaReq.Field field = new CommonDrivenSchemaReq.Field();
            field.setFieldId(returnField.getDatasourceField());
            field.setFieldName(returnField.getDisplayName());
            switch (returnField.getValueType()) {
                case "text": {
                    field.setFieldType(DataTypeEnum.TEXT.getName());
                    break;
                }
                case "number": {
                    field.setFieldType(DataTypeEnum.INT.getName());
                    break;
                }
                case "numeric": {
                    field.setFieldType(DataTypeEnum.DECIMAL.getName());
                    field.setScale("4");
                    break;
                }
                case "boolean": {
                    field.setFieldType(DataTypeEnum.BIT.getName());
                    field.setSize("1");
                    break;
                }
                case "datetime": {
                    field.setFieldType(DataTypeEnum.DATETIME.getName());
                    field.setSize(null);
                    break;
                }
                case "date": {
                    field.setFieldType(DataTypeEnum.DATE.getName());
                    field.setSize(null);
                    break;
                }
                case "time": {
                    field.setFieldType(DataTypeEnum.TIME.getName());
                    field.setSize(null);
                    break;
                }
                default: {
                    field.setFieldType(DataTypeEnum.VARCHAR.getName());
                }
            }
            fields.add(field);
        }
        return fields;
    }

    private void buildDataSaveTask(SetParseContext context, SmartAdjustProjectPart smartAdjustProjectPart) {
        List<Activity> activities = this.buildDataSaveActivity(context);
        FlowGraph flowGraph = this.buildWithBackstageGatewayFlow(context, activities);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "dataSave");
        task.setPattern("BUSINESS");
        task.setType(BUSINESS);
        task.setExecuteType("auto");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "dataSave");
        task.setMerge(Boolean.valueOf(false));
        task.setCategory("PROCESS");
        task.setMilestone(Boolean.valueOf(false));
        task.setPriority(Integer.valueOf(0));
        task.setName("\u63a8\u9001\u6570\u636e\u552f\u4e00id");
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_backstage");
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("end0", context.getCurrentSet().getCode() + "_end");
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private Map<String, Object> handleTagParams(SetParseContext context, List<ReturnField> returnFields, Set<String> showFieldCodes) throws DWBusinessException {
        String pluginId = context.getCurrentSet().getCode();
        ArrayList<TagEntity> tagEntities = new ArrayList<TagEntity>();
        List taskList = context.getDtdRelatedInfo().getTaskList().stream().filter(v -> v.getExecuteType().equals("manual")).collect(Collectors.toList());
        TagEntity activityTagEntity = new TagEntity();
        ArrayList<Tag> activityTag = new ArrayList<Tag>();
        String resourceId = "esp_common.driven.heart.ctl." + pluginId + ".list.get";
        for (Task task : taskList) {
            TagEntity fieldTagEntity;
            activityTagEntity.setResourceId(resourceId);
            Tag tag = new Tag();
            tag.setCategory("ACTIVITY");
            tag.setCode(task.getCode());
            activityTag.add(tag);
            int order = 10;
            int step = 10;
            for (ReturnField field : returnFields) {
                if (!showFieldCodes.contains(field.getDatasourceField())) continue;
                fieldTagEntity = new TagEntity();
                fieldTagEntity.setResourceId(resourceId);
                fieldTagEntity.setResourceContent(resourceId + ".response." + "heart_ctl_" + pluginId + "." + field.getDatasourceField());
                fieldTagEntity.setTags(new ArrayList());
                if (!field.isHide()) {
                    fieldTagEntity.getTags().add(Tag.builder().category("ORDER").code("charge__" + task.getCode() + "__ORDER_" + order).build());
                }
                if (!field.isHide()) {
                    fieldTagEntity.getTags().add(Tag.builder().category("ROLE__ACTIVITY").code("charge__" + task.getCode()).build());
                }
                fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() + "__UNEDITABLE").build());
                switch (field.getValueType()) {
                    case "text": {
                        fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() + "__TEXTAREA").build());
                        break;
                    }
                    case "percent": {
                        fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() + "__BUSINESS_PERCENT_INPUT").build());
                        break;
                    }
                    case "numeric": {
                        fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() + "__BUSINESS_AMOUNT").build());
                        break;
                    }
                }
                order += step;
                tagEntities.add(fieldTagEntity);
            }
            for (String s : SmartAdjustConstants.PAGE_VIEW_GROUP_FIELDS) {
                fieldTagEntity = new TagEntity();
                fieldTagEntity.setResourceId(resourceId);
                fieldTagEntity.setResourceContent(resourceId + ".response." + "heart_ctl_" + pluginId + "." + s);
                fieldTagEntity.setTags(new ArrayList());
                fieldTagEntity.getTags().add(Tag.builder().category("ORDER").code("charge__" + task.getCode() + "__ORDER_" + order).build());
                fieldTagEntity.getTags().add(Tag.builder().category("ROLE__ACTIVITY").code("charge__" + task.getCode()).build());
                order += step;
                tagEntities.add(fieldTagEntity);
            }
        }
        activityTagEntity.setTags(activityTag);
        tagEntities.add(activityTagEntity);
        tagEntities.forEach(en -> {
            if (null != en.getResourceContent()) {
                String resourceContent = "{'response': '" + en.getResourceContent() + "'}";
                en.setResourceContent(resourceContent);
            }
        });
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pluginId", pluginId);
        param.put("athena_namespace", context.getCurrentSet().getAppCode());
        param.put("version", context.getCurrentSet().getVersion());
        param.put("tagEntities", tagEntities);
        return param;
    }

    private void createNeo4jSql(SetParseContext context) throws DWBusinessException {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("MATCH (n:Action{pluginId: '" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'})-[r]-() DELETE n, r;");
        sql.add("MATCH (n:DataEntity{pluginId: '" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'})-[r]-() DELETE n, r;");
        sql.add("MATCH (n:DataField{pluginId: '" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'})-[r]-() DELETE n, r;");
        List<Action> actionList = context.getDtdRelatedInfo().getActionList();
        for (Action action : actionList) {
            List createsEntity = action.getCreatesEntity();
            this.handleLang(createsEntity);
            String actionSql = "MERGE (a:Action {athena_namespace: '" + context.getCurrentSet().getAppCode() + "',actionId: '" + action.getActionId() + "',actionName: '" + action.getActionName() + "',version: '" + action.getVersion() + "',request_parameters: '" + action.getRequest_parameters() + "',pluginId: '" + action.getPluginId() + "',emergency: " + action.getEmergency() + ",response_object: '" + this.handleActionResponseObject(createsEntity) + "'});";
            sql.add(actionSql);
            if (createsEntity.isEmpty()) continue;
            DataEntity dataEntity = (DataEntity)createsEntity.get(0);
            String dataEntitySql = "MERGE (a:DataEntity { dataType: 'object',athena_namespace: '" + context.getCurrentSet().getAppCode() + "',fullPath: '" + dataEntity.getName() + "',name: '" + dataEntity.getName() + "',version: '" + action.getVersion() + "',pluginId: '" + action.getPluginId() + "',field: '" + JSON.toJSONString(this.handleDataEntityResponseObject(dataEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}) + "'});";
            sql.add(dataEntitySql);
            if (dataEntity.getField().isEmpty()) continue;
            List field = dataEntity.getField();
            for (DataField dataField : field) {
                String dataFieldSql = "MERGE (a:DataField { required: 'false',is_datakey: 'false',is_array: false,businessKey: false,athena_namespace: '" + context.getCurrentSet().getAppCode() + "',fullPath: '" + dataField.getFullPath() + "',dataType: '" + dataField.getDataType() + "',name: '" + dataField.getName() + "',description: '" + dataField.getDescription() + "',version: '" + action.getVersion() + "',pluginId: '" + action.getPluginId() + "'});";
                sql.add(dataFieldSql);
            }
        }
        sql.add("match (a:Action{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) match (d:DataEntity{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) create(a)-[:Creates]->(d);");
        sql.add("match (de:DataEntity{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) match (df:DataField{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) create(de)-[:Contains]->(df);");
        context.getNeo4jSql().addAll(sql);
    }

    private String handleActionResponseObject(List<DataEntity> createsEntity) {
        if (createsEntity.isEmpty()) {
            return "";
        }
        DataEntity dataEntity = createsEntity.get(0);
        ApiDataFieldMetadataDTO dataFieldMetadataDTO = new ApiDataFieldMetadataDTO();
        dataFieldMetadataDTO.setData_name(dataEntity.getName());
        dataFieldMetadataDTO.setData_type("object");
        dataFieldMetadataDTO.setDescription(new MultiLanguageDTO());
        dataFieldMetadataDTO.setIs_array(Boolean.valueOf(true));
        dataFieldMetadataDTO.setField(this.handleDataEntityResponseObject(dataEntity));
        return JSON.toJSONString((Object)dataFieldMetadataDTO);
    }

    private ArrayList<ApiDataFieldMetadataDTO> handleDataEntityResponseObject(DataEntity dataEntity) {
        ArrayList<ApiDataFieldMetadataDTO> fieldMetadataDTOS = new ArrayList<ApiDataFieldMetadataDTO>();
        List field = dataEntity.getField();
        for (DataField dataField : field) {
            ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = new ApiDataFieldMetadataDTO();
            apiDataFieldMetadataDTO.setData_name(dataField.getName());
            apiDataFieldMetadataDTO.setData_type(dataField.getDataType());
            apiDataFieldMetadataDTO.setFullPath(dataField.getFullPath());
            apiDataFieldMetadataDTO.setRequired("false");
            apiDataFieldMetadataDTO.setDescription((MultiLanguageDTO)JSON.parseObject((String)dataField.getDescription(), MultiLanguageDTO.class));
            fieldMetadataDTOS.add(apiDataFieldMetadataDTO);
        }
        return fieldMetadataDTOS;
    }

    private void handleLang(List<DataEntity> createsEntity) throws DWBusinessException {
        for (DataEntity dataEntity : createsEntity) {
            List fields = dataEntity.getField();
            HashMap<String, String> langMap = new HashMap<String, String>();
            for (DataField field : fields) {
                langMap.put(field.getName(), field.getDescription());
            }
            JSONObject lang = JSON.parseObject((String)this.translateUtils.translateContent(JSON.parseObject((String)JSON.toJSONString(langMap), Object.class))).getJSONObject("lang");
            fields.forEach(v -> v.setDescription(null == lang.getJSONObject(v.getName()) ? "{\"zh_TW\":\"" + v.getDescription() + "\",\"zh_CN\":\" " + v.getDescription() + "\"}" : lang.getJSONObject(v.getName()).toString()));
        }
    }

    public static void main(String[] args) throws DWBusinessException {
        String s = "var info=$(data);\nvar idStr = [];\nif(info&&info.length>0) {\nfor(var i=0;i<info.length;i++){var item=info[i];if(item.heart_control_data_id) {idStr.push({'heart_control_data_id':item.heart_control_data_id});}}}return{'success':true,'processVariable':{'query_condition':idStr},'errorMessage':''};";
        System.out.println(s);
    }

    private void buildAction(SetParseContext context, SmartAdjustProjectPart smartAdjustProjectPart) {
        String version = context.getCurrentSet().getVersion();
        String pluginId = context.getCurrentSet().getCode();
        List<ReturnField> returnFields = context.getReturnFieldAll();
        List showReturnFieldKey = returnFields.stream().map(ReturnField::getDatasourceField).distinct().collect(Collectors.toList());
        List params = smartAdjustProjectPart.getParams();
        List apiKey = params.stream().filter(v -> !v.getType().equals("Constant")).map(Processor::getValue).distinct().collect(Collectors.toList());
        if (smartAdjustProjectPart.getProcessor().getType().equals("field")) {
            apiKey.add(smartAdjustProjectPart.getProcessor().getValue());
        }
        returnFields.forEach(v -> v.setHide(false));
        ArrayList<ReturnField> actionList = new ArrayList<ReturnField>(returnFields);
        this.conventionField(actionList);
        List<ReturnField> returnFieldAll = context.getReturnFieldAll();
        for (ReturnField returnField : returnFieldAll) {
            if (!apiKey.contains(returnField.getDatasourceField()) || showReturnFieldKey.contains(returnField.getDatasourceField())) continue;
            returnField.setHide(true);
            actionList.add(returnField);
        }
        smartAdjustProjectPart.setReturnFields(actionList);
        ArrayList<DataField> dataFields = new ArrayList<DataField>();
        if (!returnFields.isEmpty()) {
            for (ReturnField returnField : actionList) {
                DataField dataField = new DataField();
                dataField.setFullPath("data." + returnField.getDatasourceField());
                dataField.setDataType(returnField.getDataFieldDataType());
                dataField.setVersion(version);
                dataField.setName(returnField.getDatasourceField());
                dataField.setDescription(returnField.getDisplayName());
                dataFields.add(dataField);
            }
        }
        DataEntity dataEntity = new DataEntity();
        dataEntity.setPluginId(pluginId);
        dataEntity.setVersion(version);
        dataEntity.setName("heartControlAction");
        dataEntity.setIsArray(Boolean.valueOf(true));
        dataEntity.setField(dataFields);
        Action action = new Action();
        action.setActionId("heartControlAction_" + pluginId);
        action.setActionName("heartControlAction");
        action.setVersion(version);
        action.setRequest_parameters("[]");
        action.setPluginId(pluginId);
        action.setCreatesEntity(Collections.singletonList(dataEntity));
        context.getDtdRelatedInfo().getActionList().add(action);
    }

    private void buildAppRelation(SetParseContext context) {
        String pluginId = context.getCurrentSet().getCode();
        ArrayList<ApplicationRelation> lists = new ArrayList<ApplicationRelation>();
        DTDRelatedInfo dtdRelatedInfo = context.getDtdRelatedInfo();
        Project project = dtdRelatedInfo.getProject();
        ApplicationRelation applicationRelation = new ApplicationRelation();
        applicationRelation.setCode(project.getCode());
        applicationRelation.setName(project.getName());
        applicationRelation.setType("task");
        applicationRelation.setAppCode(context.getCurrentSet().getAppCode());
        applicationRelation.setPluginId(pluginId);
        applicationRelation.setVersion(context.getCurrentSet().getVersion());
        applicationRelation.setApplication(context.getCurrentSet().getAppCode());
        applicationRelation.setAthena_namespace(context.getCurrentSet().getAppCode());
        lists.add(applicationRelation);
        List<Task> taskList = dtdRelatedInfo.getTaskList();
        for (Task task : taskList) {
            ApplicationRelation applicationRelation1 = new ApplicationRelation();
            applicationRelation1.setCode(task.getCode());
            applicationRelation1.setName(task.getName());
            applicationRelation1.setType("activity");
            applicationRelation1.setAppCode(context.getCurrentSet().getAppCode());
            applicationRelation1.setPluginId(pluginId);
            applicationRelation1.setVersion(context.getCurrentSet().getVersion());
            applicationRelation1.setApplication(context.getCurrentSet().getAppCode());
            applicationRelation1.setAthena_namespace(context.getCurrentSet().getAppCode());
            applicationRelation1.setTenantId("SYSTEM");
            lists.add(applicationRelation1);
        }
        this.mongoTemplateSystem.insert(lists, "applicationRelation");
    }

    private void buildDataDescriptionAndDataState(SetParseContext context, SmartAdjustProjectPart part) {
        String version = context.getCurrentSet().getVersion();
        DataDescription dataDescription = new DataDescription();
        dataDescription.setCode(context.getCurrentSet().getCode());
        dataDescription.setTenantId("SYSTEM");
        dataDescription.setApplication(context.getCurrentSet().getAppCode());
        dataDescription.setVersion(version);
        FieldDescription dataStruct = new FieldDescription();
        dataStruct.setDataType("OBJECT");
        dataStruct.setKey("data");
        dataStruct.setFields(this.getFields(part));
        dataDescription.setDataStruct(dataStruct);
        dataDescription.setUniKeys(this.getUnKeys(part));
        dataDescription.setPluginId(context.getCurrentSet().getCode());
        ArrayList<DataState> dataStateList = new ArrayList<DataState>();
        DataState dataState = new DataState();
        dataState.setTenantId("SYSTEM");
        dataState.setApplication(context.getCurrentSet().getAppCode());
        dataState.setVersion(version);
        dataState.setCode(context.getCurrentSet().getCode() + "_start");
        dataState.setDataCode(dataDescription.getCode());
        dataState.setName("start");
        dataState.setPluginId(context.getCurrentSet().getCode());
        DataState dataState1 = new DataState();
        dataState1.setTenantId("SYSTEM");
        dataState1.setApplication(context.getCurrentSet().getAppCode());
        dataState1.setVersion(version);
        dataState1.setCode(context.getCurrentSet().getCode() + "_task");
        dataState1.setDataCode(dataDescription.getCode());
        dataState1.setName("task");
        dataState1.setPluginId(context.getCurrentSet().getCode());
        DataState dataState2 = new DataState();
        dataState2.setTenantId("SYSTEM");
        dataState2.setApplication(context.getCurrentSet().getAppCode());
        dataState2.setVersion(version);
        dataState2.setCode(context.getCurrentSet().getCode() + "_approve");
        dataState2.setDataCode(dataDescription.getCode());
        dataState2.setName("approve");
        dataState2.setPluginId(context.getCurrentSet().getCode());
        DataState dataState3 = new DataState();
        dataState3.setTenantId("SYSTEM");
        dataState3.setApplication(context.getCurrentSet().getAppCode());
        dataState3.setVersion(version);
        dataState3.setCode(context.getCurrentSet().getCode() + "_backstage");
        dataState3.setDataCode(dataDescription.getCode());
        dataState3.setName("backstage");
        dataState3.setPluginId(context.getCurrentSet().getCode());
        DataState dataState4 = new DataState();
        dataState4.setTenantId("SYSTEM");
        dataState4.setApplication(context.getCurrentSet().getAppCode());
        dataState4.setVersion(version);
        dataState4.setCode(context.getCurrentSet().getCode() + "_end");
        dataState4.setDataCode(dataDescription.getCode());
        dataState4.setName("end");
        dataState4.setPluginId(context.getCurrentSet().getCode());
        dataStateList.add(dataState);
        dataStateList.add(dataState1);
        dataStateList.add(dataState2);
        dataStateList.add(dataState3);
        dataStateList.add(dataState4);
        context.getDtdRelatedInfo().setDataDescription(dataDescription);
        context.getDtdRelatedInfo().setDataStateList(dataStateList);
        context.getDtdRelatedInfo().setProjectInitDataState(dataState);
        context.getDtdRelatedInfo().setProjectEndDataState(dataState4);
    }

    private List<String> getUnKeys(SmartAdjustProjectPart part) {
        ArrayList<String> unKeys = new ArrayList<String>();
        List returnFields = part.getReturnFields();
        if (!CollectionUtils.isEmpty((Collection)returnFields)) {
            unKeys.addAll(returnFields.stream().map(ReturnField::getDatasourceField).distinct().collect(Collectors.toList()));
        }
        return unKeys;
    }

    private List<FieldDescription> getFields(SmartAdjustProjectPart part) {
        ArrayList<FieldDescription> list = new ArrayList<FieldDescription>();
        List returnFields = part.getReturnFields();
        if (!CollectionUtils.isEmpty((Collection)returnFields)) {
            for (ReturnField returnField : returnFields) {
                FieldDescription fieldDescription = new FieldDescription();
                fieldDescription.setDataType(returnField.getDataDescriptionFieldType());
                fieldDescription.setKey(returnField.getDatasourceField());
                fieldDescription.setName(returnField.getDisplayName());
                list.add(fieldDescription);
            }
        }
        return list;
    }

    private void buildProject(SetParseContext context, SmartAdjustProjectPart part) {
        Project project = new Project();
        project.setTenantId("SYSTEM");
        project.setApplication(context.getCurrentSet().getAppCode());
        project.setVersion(context.getCurrentSet().getVersion());
        project.setPluginId(context.getCurrentSet().getCode());
        project.setCode("ProjectBySet_" + context.getCurrentSet().getCode());
        project.setName(context.getCurrentSet().getName());
        project.setDescription(context.getCurrentSet().getName());
        project.setType("BUSINESS");
        project.setExecuteType("user");
        project.setPresetVariables(Collections.emptyList());
        project.setMerge(Boolean.valueOf(false));
        project.setAtmcDatas(this.atmcDatas());
        project.setEnd(context.getDtdRelatedInfo().getProjectEndDataState());
        project.setInit(context.getDtdRelatedInfo().getProjectInitDataState());
        project.setPersonInCharge(this.getUserDefinition(part.getPersonIncharge(), "$(charge_id)"));
        project.setPhases(this.getPhases(context.getDtdRelatedInfo().getTaskList()));
        project.setMainLineTasks(this.getMainLineTask(context.getDtdRelatedInfo().getTaskList()));
        ProjectTarget projectTarget = new ProjectTarget();
        projectTarget.setName(part.getTaskName());
        projectTarget.setCode("ProjectBySet_" + context.getCurrentSet().getCode());
        project.setTarget(projectTarget);
        project.setSourceName((Object)part.getTaskName());
        project.setSourceEntityName("sourceIds");
        project.setAssignAble(Boolean.valueOf(false));
        project.setConfig((Map)ImmutableMap.of((Object)"hideDeliverySetting", (Object)true));
        context.getDtdRelatedInfo().setProject(project);
    }

    private List<String> getMainLineTask(List<Task> tasks) {
        return tasks.stream().map(BaseEntity::getCode).collect(Collectors.toList());
    }

    private List<Phase> getPhases(List<Task> tasks) {
        ArrayList<Phase> phases = new ArrayList<Phase>();
        for (Task task : tasks) {
            if (!task.getMilestone().booleanValue()) continue;
            Phase phase = new Phase();
            phase.setCode(task.getCode());
            phase.setName(task.getName());
            phase.setTaskCodes(Collections.singletonList(task.getCode()));
            phases.add(phase);
        }
        return phases;
    }

    private void buildGroupTask(SetParseContext context, SmartAdjustProjectPart part) {
        List<Activity> activities = this.buildGroupActivity(context, part);
        FlowGraph flowGraph = this.buildFlow(context, activities, "group");
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "group");
        task.setPattern("BUSINESS");
        task.setType(BUSINESS);
        task.setExecuteType("auto");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "group");
        task.setMerge(Boolean.valueOf(false));
        task.setCategory("PROCESS");
        task.setMilestone(Boolean.valueOf(false));
        task.setPriority(Integer.valueOf(0));
        task.setName("\u6570\u636e\u5206\u7ec4");
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_start"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_start");
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("end0", context.getCurrentSet().getCode() + "_task");
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private TimeDefinition defaultDueDate() {
        TimeDefinition timeDefinition = new TimeDefinition();
        timeDefinition.setDatatype("second");
        timeDefinition.setIsBusiness(Boolean.valueOf(false));
        timeDefinition.setValue((Object)86400);
        return timeDefinition;
    }

    private void buildManualTask(SetParseContext context, SmartAdjustProjectPart part) {
        List<Activity> activities = this.buildDataSaveActivity(context);
        activities.addAll(this.buildManualActivity(context, part));
        FlowGraph flowGraph = this.buildFlow(context, activities, "manual");
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setDueDate(Objects.isNull(part.getDueDate()) ? this.defaultDueDate() : part.getDueDate());
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "manual");
        task.setPattern("BUSINESS");
        task.setType(BUSINESS);
        task.setExecuteType("manual");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "manual");
        task.setMerge(Boolean.valueOf(false));
        task.setCategory("PROCESS");
        task.setMilestone(Boolean.valueOf(true));
        task.setPriority(Integer.valueOf(0));
        task.setName(part.getTaskName());
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_approve"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_task");
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("end0", context.getCurrentSet().getCode() + "_approve");
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private void buildApproveTask(SetParseContext context, SmartAdjustProjectPart part) {
        List<Activity> activities = this.buildApproveActivity(context, part);
        FlowGraph flowGraph = this.buildWithRefuseGatewayFlow(context, activities);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setDueDate(this.defaultDueDate());
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "approve");
        task.setPattern("BUSINESS");
        task.setType("approve");
        task.setExecuteType("manual");
        task.setFlowCode(flowGraph.getCode());
        task.setStartApproveActivity(Collections.singletonList(context.getCurrentSet().getCode() + "_" + "task" + "_" + "manual"));
        task.setStartApproveActivityName(part.getTaskName());
        task.setPageCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "approve");
        task.setMerge(Boolean.valueOf(false));
        task.setCategory("APPROVAL");
        task.setMilestone(Boolean.valueOf(true));
        task.setPriority(Integer.valueOf(0));
        task.setName(part.getTaskName() + "\u7b7e\u6838");
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_approve"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_backstage"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_approve");
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("end0", context.getCurrentSet().getCode() + "_backstage");
        output.put("end1", context.getCurrentSet().getCode() + "_task");
        output.put("projectEnd", context.getCurrentSet().getCode() + "_end");
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private void buildBackstageTask(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        List<Activity> activities = this.buildBackstageActivity(context, part);
        FlowGraph flowGraph = this.buildWithBackstageGatewayFlow(context, activities);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "backstage");
        task.setPattern("BUSINESS");
        task.setType(BUSINESS);
        task.setExecuteType("auto");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + "backstage");
        task.setMerge(Boolean.valueOf(false));
        task.setCategory("PROCESS");
        task.setMilestone(Boolean.valueOf(false));
        task.setPriority(Integer.valueOf(0));
        task.setName("\u8c03\u7528esp\u56de\u5199");
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_backstage"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_end"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_backstage");
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("end0", context.getCurrentSet().getCode() + "_end");
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private List<AtmcData> atmcDatas() {
        ArrayList<AtmcData> atmcDatas = new ArrayList<AtmcData>();
        AtmcData atmcData = new AtmcData();
        atmcData.setProVarKey("personInCharge");
        atmcData.setAthenaKey("personInCharge");
        atmcDatas.add(atmcData);
        AtmcData atmcData2 = new AtmcData();
        atmcData2.setProVarKey("dueDate");
        atmcData2.setAthenaKey("dueDate");
        atmcDatas.add(atmcData2);
        AtmcData atmcData3 = new AtmcData();
        atmcData3.setProVarKey("$(data[0].sourceIds)");
        atmcData3.setAthenaKey("sourceIds");
        atmcDatas.add(atmcData3);
        AtmcData atmcData4 = new AtmcData();
        atmcData4.setProVarKey("performer_id");
        atmcData4.setAthenaKey("performer_id");
        atmcDatas.add(atmcData4);
        AtmcData atmcData5 = new AtmcData();
        atmcData5.setProVarKey("charge_id");
        atmcData5.setAthenaKey("charge_id");
        atmcDatas.add(atmcData5);
        AtmcData atmcData6 = new AtmcData();
        atmcData6.setProVarKey("query_condition");
        atmcData6.setAthenaKey("query_condition");
        atmcDatas.add(atmcData6);
        return atmcDatas;
    }

    private FlowGraph buildFlow(SetParseContext context, List<Activity> activities, String suffix) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(context.getCurrentSet().getCode() + "_" + "task" + "_" + suffix);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setApplication(context.getCurrentSet().getAppCode());
        flowGraph.setPluginId(context.getCurrentSet().getCode());
        flowGraph.setVersion(context.getCurrentSet().getVersion());
        flowGraph.setLinks(new ArrayList());
        flowGraph.setNodes(new ArrayList());
        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();
        FlowNode start = new FlowNode();
        start.setId(startNodeId);
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId(endNodeId);
        if (!"group".equals(suffix)) {
            endNode.setDataKey("end0");
        }
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);
        String from = startNodeId;
        for (Activity activity : activities) {
            FlowNode endNode2 = new FlowNode();
            endNode2.setId(activity.getCode());
            endNode2.setActivityCode(activity.getCode());
            endNode2.setName(activity.getName());
            endNode2.setType("activity");
            flowGraph.getNodes().add(endNode2);
            FlowLink flowLink = new FlowLink();
            flowLink.setFrom(from);
            flowLink.setTo(activity.getCode());
            flowGraph.getLinks().add(flowLink);
            from = activity.getCode();
        }
        FlowLink flowLink2 = new FlowLink();
        flowLink2.setFrom(from);
        flowLink2.setTo(endNodeId);
        flowGraph.getLinks().add(flowLink2);
        return flowGraph;
    }

    private FlowGraph buildWithRefuseGatewayFlow(SetParseContext context, List<Activity> activities) {
        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();
        String gatewayNodeId = "gateway_" + context.getCurrentSet().getCode();
        FlowGraph flowGraph = this.buildFlowGraph(context, activities, "_task_approve");
        FlowNode endNode = new FlowNode();
        endNode.setId("end1_" + context.getCurrentSet().getCode());
        endNode.setType("end");
        endNode.setDataKey("end1");
        flowGraph.getNodes().add(endNode);
        FlowNode projectEndNode = new FlowNode();
        projectEndNode.setId("projectEnd" + context.getCurrentSet().getCode());
        projectEndNode.setType("end");
        projectEndNode.setDataKey("projectEnd");
        flowGraph.getNodes().add(projectEndNode);
        flowGraph.getLinks().add(FlowLink.builder().from(startNodeId).to(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "approve").build());
        flowGraph.getLinks().add(FlowLink.builder().from(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "approve").to(gatewayNodeId).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("'$(_approveResult)' == 'agree'").from(gatewayNodeId).to(endNodeId).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("'$(_approveResult)' == 'disagree'").from(gatewayNodeId).to(projectEndNode.getId()).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("'$(_approveResult)' == 'reexecute'").from(gatewayNodeId).to("end1_" + context.getCurrentSet().getCode()).build());
        return flowGraph;
    }

    private FlowGraph buildWithBackstageGatewayFlow(SetParseContext context, List<Activity> activities) {
        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();
        String gatewayNodeId = "gateway_" + context.getCurrentSet().getCode();
        FlowGraph flowGraph = this.buildFlowGraph(context, activities, "_task_backstage");
        flowGraph.getLinks().add(FlowLink.builder().from(startNodeId).to(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "filter").build());
        flowGraph.getLinks().add(FlowLink.builder().from(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "filter").to(gatewayNodeId).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("$(apiData).length == 0").from(gatewayNodeId).to(endNodeId).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("$(apiData).length > 0").from(gatewayNodeId).to(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "backstage").build());
        flowGraph.getLinks().add(FlowLink.builder().from(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "backstage").to(endNodeId).build());
        return flowGraph;
    }

    private FlowGraph buildFlowGraph(SetParseContext context, List<Activity> activities, String code) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(context.getCurrentSet().getCode() + code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setApplication(context.getCurrentSet().getAppCode());
        flowGraph.setPluginId(context.getCurrentSet().getCode());
        flowGraph.setVersion(context.getCurrentSet().getVersion());
        flowGraph.setLinks(new ArrayList());
        flowGraph.setNodes(new ArrayList());
        FlowNode start = new FlowNode();
        start.setId("start_" + context.getCurrentSet().getCode());
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId("end_" + context.getCurrentSet().getCode());
        endNode.setType("end");
        endNode.setDataKey("end0");
        flowGraph.getNodes().add(endNode);
        FlowNode gatewayNode = new FlowNode();
        gatewayNode.setId("gateway_" + context.getCurrentSet().getCode());
        gatewayNode.setType("gateway");
        gatewayNode.setGateType("exclusive");
        flowGraph.getNodes().add(gatewayNode);
        for (Activity activity : activities) {
            FlowNode activityNode = new FlowNode();
            activityNode.setId(activity.getCode());
            activityNode.setActivityCode(activity.getCode());
            activityNode.setName(activity.getName());
            activityNode.setType("activity");
            flowGraph.getNodes().add(activityNode);
        }
        return flowGraph;
    }

    private List<Activity> buildGroupActivity(SetParseContext context, SmartAdjustProjectPart part) {
        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "group");
        activity.setType("createData");
        activity.setName("\u6570\u636e\u5206\u7ec4\u53d1\u5361");
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("dataKey", "end0");
        config.put("groupType", "ByKey");
        config.put("groupedVariable", "data");
        config.put("dataVariable", "data");
        if (part.getProcessor().getType().equals("field")) {
            config.put("groupKeys", Collections.singletonList(part.getProcessor().getValue()));
        } else {
            config.put("groupKeys", Collections.singletonList("groupKeys"));
        }
        activity.setConfig(config);
        activity.setMilestone(Boolean.valueOf(false));
        ArrayList<Activity> lists = new ArrayList<Activity>();
        lists.add(activity);
        return lists;
    }

    private List<Activity> buildDataSaveActivity(SetParseContext context) {
        ArrayList<Activity> lists = new ArrayList<Activity>();
        Activity filterActivity = new Activity();
        filterActivity.setTenantId("SYSTEM");
        filterActivity.setApplication(context.getCurrentSet().getAppCode());
        filterActivity.setVersion(context.getCurrentSet().getVersion());
        filterActivity.setPluginId(context.getCurrentSet().getCode());
        filterActivity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "dataSave");
        filterActivity.setType("script");
        filterActivity.setName("\u63a8\u9001\u6570\u636e\u552f\u4e00id");
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("executionMode", "script");
        filterConfig.put("scriptMode", (String)ImmutableMap.of((Object)"responseScript", (Object)this.getDataSaveRequestScript()));
        filterActivity.setConfig(filterConfig);
        filterActivity.setMilestone(Boolean.valueOf(false));
        lists.add(filterActivity);
        return lists;
    }

    private String getDataSaveRequestScript() {
        return "var info=$(data);\nvar idStr = [];\nif(info&&info.length>0) {\nfor(var i=0;i<info.length;i++){var item=info[i];if(item.heart_control_data_id) {idStr.push({'heart_control_data_id':item.heart_control_data_id});}}}return{'success':true,'processVariable':{'query_condition':idStr},'errorMessage':''};";
    }

    private List<Activity> buildManualActivity(SetParseContext context, SmartAdjustProjectPart part) {
        Activity activity;
        ArrayList<Activity> lists = new ArrayList<Activity>();
        if (part.getProcessor().getType().equals("field")) {
            activity = new Activity();
            activity.setTenantId("SYSTEM");
            activity.setApplication(context.getCurrentSet().getAppCode());
            activity.setVersion(context.getCurrentSet().getVersion());
            activity.setPluginId(context.getCurrentSet().getCode());
            activity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "extractPerformer");
            activity.setName("\u83b7\u53d6\u6267\u884c\u4eba");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("executionMode", "script");
            if (part.getProcessor().isConvert()) {
                activity.setType("http");
                config.put("method", "post");
                config.put("domain", "eoc");
                config.put("contentType", "json");
                config.put("url", "/api/eoc/v2/emp/user/id");
                config.put("headers", (String)ImmutableMap.of((Object)"security-token", (Object)"$(_ActLatelySecurityToken)"));
                config.put("scriptMode", (String)ImmutableMap.of((Object)"responseScript", (Object)"var response=$(response);return{\"success\":response.success,\"processVariable\":{\"performer_id\":response.data},\"errorMessage\":response.message};", (Object)"requestScript", (Object)("var info=$(data);var request={'empId':info[0]." + part.getProcessor().getValue() + "};return request;")));
            } else {
                config.put("scriptMode", (String)ImmutableMap.of((Object)"responseScript", (Object)this.extractPerformerResponseScript(part.getProcessor().getValue())));
                activity.setType("script");
            }
            activity.setConfig(config);
            activity.setMilestone(Boolean.valueOf(false));
            lists.add(activity);
        }
        activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "manual");
        activity.setType("manual");
        activity.setName("\u4eba\u5de5\u4efb\u52a1");
        activity.setExecutor(this.getUserDefinition(part.getProcessor(), "$(performer_id)"));
        activity.setMilestone(Boolean.valueOf(true));
        lists.add(activity);
        this.buildSubmitterManualActivity(context, part, lists);
        return lists;
    }

    private void buildSubmitterManualActivity(SetParseContext context, SmartAdjustProjectPart part, List<Activity> lists) {
        List params = part.getParams();
        if (CollUtil.isEmpty((Collection)params)) {
            return;
        }
        if (params.stream().anyMatch(e -> StrUtil.equals((CharSequence)e.getType(), (CharSequence)"processVariable"))) {
            Activity activity = new Activity();
            activity.setTenantId("SYSTEM");
            activity.setApplication(context.getCurrentSet().getAppCode());
            activity.setVersion(context.getCurrentSet().getVersion());
            activity.setPluginId(context.getCurrentSet().getCode());
            activity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "taskSubmitter");
            activity.setName("\u83b7\u53d6\u4efb\u52a1\u63d0\u4ea4\u4eba");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("executionMode", "script");
            activity.setType("http");
            config.put("method", "post");
            config.put("domain", "eoc");
            config.put("contentType", "json");
            config.put("url", "/api/eoc/v2/emp/id");
            config.put("headers", (String)ImmutableMap.of((Object)"security-token", (Object)"$(_ActLatelySecurityToken)"));
            config.put("scriptMode", (String)ImmutableMap.of((Object)"responseScript", (Object)"var response=$(response);return{\"success\":response.success,\"processVariable\":{\"@taskPerformerId\":response.data},\"errorMessage\":response.message};", (Object)"requestScript", (Object)"var request={'userId':'$(_ActLatelyPerformerId)'};return request;"));
            activity.setConfig(config);
            activity.setMilestone(Boolean.valueOf(false));
            lists.add(activity);
        }
    }

    private Object extractPerformerResponseScript(String performer) {
        return "var data=$(data);return{'success':true,'processVariable':{'performer_id':data[0]." + performer + "},'errorMessage':''};";
    }

    private List<Activity> buildApproveActivity(SetParseContext context, SmartAdjustProjectPart part) {
        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "approve");
        activity.setType("approve");
        activity.setName("\u7b7e\u6838");
        HashMap<String, ApproveInfo> config = new HashMap<String, ApproveInfo>();
        ApproveInfo approve = part.getApprove();
        ApproveInitiator approveInitiator = new ApproveInitiator();
        approveInitiator.setType("processVariable");
        approveInitiator.setValue("personInCharge");
        approve.setInitiator(approveInitiator);
        config.put("approve", part.getApprove());
        activity.setConfig(config);
        activity.setMilestone(Boolean.valueOf(true));
        ArrayList<Activity> lists = new ArrayList<Activity>();
        lists.add(activity);
        return lists;
    }

    private List<Activity> buildBackstageActivity(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        ArrayList<Activity> lists = new ArrayList<Activity>();
        Activity filterActivity = new Activity();
        filterActivity.setTenantId("SYSTEM");
        filterActivity.setApplication(context.getCurrentSet().getAppCode());
        filterActivity.setVersion(context.getCurrentSet().getVersion());
        filterActivity.setPluginId(context.getCurrentSet().getCode());
        filterActivity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "filter");
        filterActivity.setType("script");
        filterActivity.setName("\u7b5b\u9009\u6570\u636e");
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("executionMode", "script");
        filterConfig.put("scriptMode", (String)ImmutableMap.of((Object)"responseScript", (Object)this.filerResponseScript(part)));
        filterActivity.setConfig(filterConfig);
        filterActivity.setMilestone(Boolean.valueOf(false));
        lists.add(filterActivity);
        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + "_" + "activity" + "_" + "backstage");
        activity.setType("esp");
        activity.setName("\u56de\u5199");
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("async", false);
        config.put("executionMode", "script");
        config.put("product", part.getProductName());
        String serviceName = part.getServiceName();
        config.put("serviceName", serviceName);
        config.put("headers", ImmutableMap.of((Object)"security-token", (Object)"$(_ActLatelySecurityToken)"));
        config.put("scriptMode", ImmutableMap.of((Object)"responseScript", (Object)this.getResponseScript(), (Object)"requestScript", (Object)this.getRequestScript(part, context)));
        activity.setConfig(config);
        activity.setMilestone(Boolean.valueOf(true));
        lists.add(activity);
        return lists;
    }

    private Object filerResponseScript(SmartAdjustProjectPart part) {
        List params = part.getParams();
        ArrayList<StringBuilder> stringBuilderArrayList = new ArrayList<StringBuilder>();
        for (Processor param : params) {
            StringBuilder stringBuilder = new StringBuilder();
            if (param.getType().equals("Constant")) {
                stringBuilder.append("newItem.").append(param.getName()).append("= '").append(param.getValue()).append("'");
            } else if (param.getType().equals("processVariable")) {
                stringBuilder.append("newItem.").append(param.getName()).append("= ").append("'$(@taskPerformerId)'");
            } else {
                stringBuilder.append("newItem.").append(param.getName()).append("= item.").append(param.getValue());
            }
            stringBuilderArrayList.add(stringBuilder);
        }
        String collect = String.join((CharSequence)";", stringBuilderArrayList);
        return "var rd=$(data);var info=[];if(rd&&rd.length>0){for(var i=0;i<rd.length;i++){var item=rd[i];if(item.adjust===true){var newItem={};" + collect + ";info.push(newItem)}}};var success=true;var errorMessage='';return{'success':success,'processVariable':{'apiData':info},'errorMessage':errorMessage};";
    }

    private String getRequestScript(SmartAdjustProjectPart part, SetParseContext context) throws DWBusinessException {
        List<ApiDataFieldMetadataDTO> actionParameters = this.kgService.getActionParameters(part.getActionId(), AthenaUtils.getTenantId(), context.getCurrentSet().getVersion());
        String credit_info = "credit_info";
        if (!actionParameters.isEmpty()) {
            credit_info = actionParameters.get(0).getData_name();
        }
        return "var request={'std_data':{'parameter':{'" + credit_info + "':$(apiData)}}};return request;";
    }

    private String getResponseScript() {
        return "var response = $(response);\n  var success = true;\n  var result = '';\n  var errorMessage = '';\n  if (response['std_data']['execution']['code'] == '0') {\n      errorMessage = 'Success';\n      result = response['std_data']['parameter']['result'];\n  } else {\n      success = false;\n      errorMessage = response['std_data']['execution']['description'];\n  }\n  return {\n      'success': success,\n      'processVariable': {\n          'process_result': result\n      },\n      'errorMessage': errorMessage\n  };";
    }

    private Set<String> buildPageView(SetParseContext context, SmartAdjustProjectPart part) {
        List pageViews = part.getPageViews();
        String code = context.getCurrentSet().getCode();
        HashSet<String> showFieldCodes = new HashSet<String>();
        if (CollectionUtils.isEmpty((Collection)pageViews)) {
            ArrayList<PageView> pageViewList = new ArrayList<PageView>();
            List taskList = context.getDtdRelatedInfo().getTaskList().stream().filter(v -> v.getExecuteType().equals("manual")).collect(Collectors.toList());
            for (Task task : taskList) {
                String scriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/" + task.getType() + "TaskPageView.json");
                String replaced = scriptTemplate.replaceAll("#pluginId#", code).replaceAll("#appCode#", context.getCurrentSet().getAppCode()).replaceAll("#name#", task.getName()).replaceAll("#code#", task.getCode()).replaceAll("#taskName#", part.getTaskName()).replaceAll("#version#", context.getCurrentSet().getVersion());
                pageViewList.add((PageView)JSON.parseObject((String)replaced, PageView.class));
            }
            context.getDtdRelatedInfo().setPageViewList(pageViewList);
        } else {
            PageView pageView = (PageView)pageViews.get(0);
            Map pageViewPages = pageView.getPages();
            Object taskDetail = pageViewPages.get(TASK_DETAIL);
            Object taskDetailMobile = pageViewPages.get(TASK_DETAIL_MOBILE);
            Object projectCard = pageViewPages.get(PROJECT_CARD);
            Object taskCard = pageViewPages.get(TASK_CARD);
            ArrayList<PageView> pageViewList = new ArrayList<PageView>();
            JSONArray rules = null;
            JSONArray mobileRules = null;
            List taskList = context.getDtdRelatedInfo().getTaskList().stream().filter(v -> v.getExecuteType().equals("manual")).collect(Collectors.toList());
            String queryServiceName = "common.driven.heart.ctl." + context.getCurrentSet().getCode() + ".list.get";
            String submitServiceName = "common.driven.heart.ctl." + context.getCurrentSet().getCode() + ".update";
            String schemaName = "heart_ctl_" + context.getCurrentSet().getCode();
            String defaultPageViewField = AthenaUtils.loadStream("/sets/smartAdjust/defaultPageViewFields.json");
            String defaultPageViewFieldReplaced = defaultPageViewField.replaceAll("#queryActionId#", "esp_" + queryServiceName).replaceAll("#queryServiceName#", queryServiceName).replaceAll("#submitActionId#", "esp_" + submitServiceName).replaceAll("#submitServiceName#", submitServiceName).replaceAll("#submitActionSchema#", schemaName).replaceAll("#version#", context.getCurrentSet().getVersion());
            JSONObject defaultPageViewFieldObj = JSON.parseObject((String)defaultPageViewFieldReplaced);
            JSONObject submitAction = this.buildSubmitParams(defaultPageViewFieldObj, part, schemaName);
            for (Task task : taskList) {
                String scriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/" + task.getType() + "TaskPageView.json");
                String replaced = scriptTemplate.replaceAll("#pluginId#", code).replaceAll("#appCode#", context.getCurrentSet().getAppCode()).replaceAll("#name#", task.getName()).replaceAll("#code#", task.getCode()).replaceAll("#taskName#", part.getTaskName()).replaceAll("#dataSourceName#", schemaName).replaceAll("#version#", context.getCurrentSet().getVersion());
                PageView parsedPageView = (PageView)JSON.parseObject((String)replaced, PageView.class);
                HashMap<String, Object> dataSources = new HashMap<String, Object>();
                dataSources.put("heart_ctl_" + context.getCurrentSet().getCode(), defaultPageViewFieldObj.get((Object)"dataSources"));
                parsedPageView.setDataSources(dataSources);
                JSONObject pages = new JSONObject(parsedPageView.getPages());
                Object submitActions = pages.getJSONObject(TASK_DETAIL).getJSONArray("dataStates").getJSONObject(0).get((Object)SUBMIT_ACTIONS);
                String taskDetailStr = JSON.toJSONString(taskDetail);
                JSONObject taskDetailObject = JSONObject.parseObject((String)taskDetailStr.replaceAll(QUERY_DATA, schemaName).replaceAll("heartControlAction", schemaName));
                rules = taskDetailObject.getJSONArray(RULE);
                this.setProveTaskDisable(taskDetailObject, showFieldCodes, task.getType(), submitAction, submitActions, true);
                pages.put(TASK_DETAIL, (Object)taskDetailObject);
                if (!Objects.isNull(taskDetailMobile)) {
                    String taskDetailMobileStr = JSON.toJSONString(taskDetailMobile);
                    JSONObject taskDetailMobileObject = JSONObject.parseObject((String)taskDetailMobileStr.replaceAll(QUERY_DATA, schemaName).replaceAll("heartControlAction", schemaName));
                    mobileRules = taskDetailMobileObject.getJSONArray(RULE);
                    this.setProveTaskDisable(taskDetailMobileObject, showFieldCodes, task.getType(), submitAction, submitActions, true);
                    pages.put(TASK_DETAIL_MOBILE, (Object)taskDetailMobileObject);
                }
                pages.put(PROJECT_CARD, (Object)this.handleCard(JSONObject.parseObject((String)JSON.toJSONString(projectCard).replaceAll("heartControlAction", schemaName)), queryServiceName));
                pages.put(TASK_CARD, (Object)this.handleCard(JSONObject.parseObject((String)JSON.toJSONString(taskCard).replaceAll("heartControlAction", schemaName)), queryServiceName));
                parsedPageView.setPages((Map)pages);
                JSONObject parsedDataSource = new JSONObject(parsedPageView.getDataSources()).getJSONObject("heart_ctl_" + context.getCurrentSet().getCode());
                JSONObject dataSource = new JSONObject(pageView.getDataSources()).getJSONObject("heartControlAction");
                JSONObject replacedDataSource = JSON.parseObject((String)dataSource.toJSONString().replaceAll(QUERY_DATA, schemaName));
                for (String key : replacedDataSource.keySet()) {
                    JSONArray metadataFields;
                    if (parsedDataSource.containsKey((Object)key)) continue;
                    if ("metadataFields".equals(key) && !CollectionUtils.isEmpty((Collection)(metadataFields = replacedDataSource.getJSONArray("metadataFields")))) {
                        replacedDataSource.put(key, metadataFields.getJSONObject(0).get((Object)"subFields"));
                    }
                    parsedDataSource.put(key, replacedDataSource.get((Object)key));
                }
                parsedPageView.getDataSources().put("heart_ctl_" + context.getCurrentSet().getCode(), parsedDataSource);
                pageViewList.add(parsedPageView);
            }
            this.saveRules(context, rules);
            this.saveRules(context, mobileRules);
            context.getDtdRelatedInfo().setPageViewList(pageViewList);
        }
        return showFieldCodes;
    }

    private JSONObject buildSubmitParams(JSONObject jsonObject, SmartAdjustProjectPart part, String schemaName) {
        JSONObject submitAction = jsonObject.getJSONObject(SUBMIT_ACTION);
        ArrayList<JSONObject> actionParams = new ArrayList<JSONObject>();
        for (ReturnField returnField : part.getReturnFields()) {
            JSONObject field = new JSONObject();
            field.put("name", (Object)(schemaName + "." + returnField.getDatasourceField()));
            field.put("source", (Object)"");
            field.put("type", (Object)"GET_ACTION_RESPONSE");
            field.put("value", (Object)(schemaName + "." + returnField.getDatasourceField()));
            actionParams.add(field);
        }
        actionParams.add(new JSONObject().fluentPut("name", (Object)(schemaName + "." + "heart_control_data_id")).fluentPut("source", (Object)"").fluentPut("type", (Object)"GET_ACTION_RESPONSE").fluentPut("value", (Object)(schemaName + "." + "heart_control_data_id")));
        submitAction.put("actionParams", actionParams);
        return submitAction;
    }

    private JSONObject handleCard(JSONObject cardObj, String serviceName) {
        JSONObject dataState;
        JSONArray summaryFields;
        JSONArray dataStates;
        if (cardObj != null && !CollectionUtils.isEmpty((Collection)(dataStates = cardObj.getJSONArray("dataStates"))) && !CollectionUtils.isEmpty((Collection)(summaryFields = (dataState = dataStates.getJSONObject(0)).getJSONArray("summaryFields")))) {
            for (int i = 0; i < summaryFields.size(); ++i) {
                JSONObject summaryField = summaryFields.getJSONObject(i);
                summaryField.put("actionId", (Object)("esp_" + serviceName));
            }
        }
        return cardObj;
    }

    private void saveRules(SetParseContext context, JSONArray rules) {
        if (null != rules && !rules.isEmpty()) {
            String code = context.getCurrentSet().getCode();
            String appCode = context.getCurrentSet().getAppCode();
            String version = context.getCurrentSet().getVersion();
            String activityCode = code + "_" + "task" + "_" + "manual";
            List ruleList = JSONObject.parseArray((String)rules.toJSONString(), Rule.class);
            for (Rule rule : ruleList) {
                rule.setApplication(appCode);
                rule.setDomain(PresetDomainEnum.ACTIVITY);
                rule.setDomainId(activityCode);
                rule.setPluginId(code);
                rule.setVersion(version);
            }
            this.dataMapService.saveRules(ruleList);
        }
    }

    private void buildEmailSetting(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        List<EmailNotice> lastEmailNotices = context.getEmailNotices();
        if (!CollectionUtils.isEmpty(lastEmailNotices)) {
            List emailNotices = Optional.ofNullable(part.getEmailNotices()).orElse(new ArrayList());
            List needCloseList = lastEmailNotices.stream().filter(e -> emailNotices.stream().noneMatch(e1 -> e1.getTiming().equals(e.getTiming()))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(needCloseList)) {
                String appCode = context.getCurrentSet().getAppCode();
                String code = context.getCurrentSet().getCode();
                List<String> tenantIds = this.getTenantIds(appCode);
                String userId = AthenaUtils.getUserId();
                String currentLocale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
                String projectCode = "ProjectBySet_" + code;
                String manualTaskCode = code + "_" + "task" + "_" + "manual";
                if (!CollectionUtils.isEmpty(tenantIds)) {
                    for (EmailNotice emailNotice : needCloseList) {
                        if (CollectionUtils.isEmpty((Collection)emailNotice.getReceivers())) continue;
                        EmailNoticeTimingEnum timingEnum = EmailNoticeTimingEnum.getByCode((String)emailNotice.getTiming());
                        for (String tenantId : tenantIds) {
                            EmailTemplateReq req = new EmailTemplateReq();
                            req.setTenantId(tenantId);
                            req.setAppCode(appCode);
                            JSONObject name = new JSONObject();
                            name.put("zh_CN", (Object)String.format("\u4e1a\u52a1\u8fc7\u7a0b\u968f\u5fc3\u63a7%s\u90ae\u4ef6\u901a\u77e5", timingEnum.getDesc()));
                            name.put("zh_TW", (Object)String.format("\u4e1a\u52a1\u8fc7\u7a0b\u968f\u5fc3\u63a7%s\u90ae\u4ef6\u901a\u77e5", timingEnum.getDesc()));
                            name.put("en_US", (Object)String.format("\u4e1a\u52a1\u8fc7\u7a0b\u968f\u5fc3\u63a7%s\u90ae\u4ef6\u901a\u77e5", timingEnum.getDesc()));
                            req.setEmailName(name);
                            req.setDescription(name);
                            switch (timingEnum) {
                                case TASK_END: {
                                    req.setType(2);
                                    break;
                                }
                                case PROJECT_BEGIN: {
                                    req.setType(3);
                                    break;
                                }
                                case PROJECT_END: {
                                    req.setType(4);
                                    break;
                                }
                                default: {
                                    req.setType(1);
                                }
                            }
                            req.setState(0);
                            req.setUpdateBy(userId);
                            req.setReceiveStaff(emailNotice.getReceivers());
                            req.setLangName(currentLocale);
                            ArrayList<Map<String, String>> activities = new ArrayList<Map<String, String>>();
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("taskId", projectCode);
                            map.put("activityId", EmailNoticeTimingEnum.PROJECT_END.equals((Object)timingEnum) ? null : manualTaskCode);
                            activities.add(map);
                            req.setActivityList(activities);
                            req.setPreviewId(EmailEventIdEnum.getEmailEventId(timingEnum.getCode(), currentLocale));
                            this.atmcService.addEmailTemplate(req);
                        }
                    }
                }
            }
        }
    }

    private List<String> getTenantIds(String appCode) {
        List<String> tenantIds = new ArrayList<String>();
        List tenantIdDataList = this.cacService.getAllEffectiveTenantAndAppInfo(appCode).getList();
        if (!CollectionUtils.isEmpty((Collection)tenantIdDataList)) {
            tenantIds = tenantIdDataList.stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
        }
        return tenantIds;
    }

    private UserDefinition getUserDefinition(Processor processor, String variable) {
        UserDefinition userDefinition = new UserDefinition();
        userDefinition.setChoosePolicy("single");
        userDefinition.setProcessType("signOr");
        Identity identity = new Identity();
        if (processor.getType().equals("field")) {
            identity.setPerformerType("user");
            identity.setPerformerValue((Object)variable);
        } else {
            identity.setPerformerType(processor.getType());
            identity.setPerformerValue((Object)processor.getValue());
        }
        identity.setPerformerName(processor.getName());
        userDefinition.setIdentities(Collections.singletonList(identity));
        return userDefinition;
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(executeNeo4jScripts)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session = sessionFactory.openSession();
        try (Transaction transaction = session.beginTransaction();){
            for (String str : executeNeo4jScripts) {
                session.query(str, new HashMap());
            }
            transaction.commit();
        }
        catch (Exception e) {
            log.error("executeNeo4jScript error:{}", (Object)e.toString());
        }
        session.clear();
    }

    private void conventionField(ArrayList<ReturnField> actionList) {
        ReturnField performerField = new ReturnField();
        performerField.setHide(true);
        performerField.setEditable(false);
        performerField.setValueType("string");
        performerField.setDatasourceField("performer_id");
        performerField.setDisplayName("\u6267\u884c\u4eba");
        actionList.add(performerField);
        ReturnField chargeField = new ReturnField();
        chargeField.setHide(true);
        chargeField.setEditable(false);
        chargeField.setValueType("string");
        chargeField.setDatasourceField("charge_id");
        chargeField.setDisplayName("\u5f53\u8d23\u8005");
        actionList.add(chargeField);
        ReturnField adjustField = new ReturnField();
        adjustField.setHide(true);
        adjustField.setEditable(false);
        adjustField.setValueType("boolean");
        adjustField.setType("Fixed");
        adjustField.setDatasourceField("adjust");
        adjustField.setDisplayName("\u662f\u5426\u8c03\u6574");
        actionList.add(adjustField);
        ReturnField remarkField = new ReturnField();
        remarkField.setHide(true);
        remarkField.setEditable(false);
        remarkField.setValueType("text");
        remarkField.setType("Fixed");
        remarkField.setDatasourceField("remark");
        remarkField.setDisplayName("\u5907\u6ce8/\u8bf4\u660e");
        actionList.add(remarkField);
        ReturnField taskPerformerField = new ReturnField();
        taskPerformerField.setHide(true);
        taskPerformerField.setEditable(false);
        taskPerformerField.setValueType("string");
        taskPerformerField.setType("processVariable");
        taskPerformerField.setDatasourceField("@taskPerformerId");
        taskPerformerField.setDisplayName("\u4efb\u52a1\u63d0\u4ea4\u4eba\u5458\u5de5Id");
        actionList.add(taskPerformerField);
    }

    public void setProveTaskDisable(JSONObject taskDetailObject, Set<String> showFieldCodes, String taskType, JSONObject submitAction, Object submitActions, boolean isSetAction) {
        JSONArray dataStates = taskDetailObject.getJSONArray("dataStates");
        if (dataStates != null && !dataStates.isEmpty()) {
            JSONObject jsonObject = dataStates.getJSONObject(0);
            JSONArray layout = jsonObject.getJSONArray("layout");
            if (!CollectionUtils.isEmpty((Collection)layout)) {
                for (int i = 0; i < layout.size(); ++i) {
                    JSONArray columnDefs;
                    JSONObject layoutItem = layout.getJSONObject(i);
                    if (layoutItem == null || !"ATHENA_TABLE".equals(layoutItem.getString("type")) || CollectionUtils.isEmpty((Collection)(columnDefs = layoutItem.getJSONArray("columnDefs")))) continue;
                    for (int j = 0; j < columnDefs.size(); ++j) {
                        JSONArray columns = columnDefs.getJSONObject(j).getJSONArray("columns");
                        if (CollectionUtils.isEmpty((Collection)columns)) continue;
                        JSONObject column = columns.getJSONObject(0);
                        showFieldCodes.add(column.getString("schema"));
                        if (!StringUtils.equals((CharSequence)"approve", (CharSequence)taskType)) continue;
                        column.put("disabled", (Object)true);
                    }
                }
            }
            if (isSetAction) {
                if (StringUtils.equals((CharSequence)BUSINESS, (CharSequence)taskType)) {
                    jsonObject.put(SUBMIT_ACTIONS, Collections.singletonList(submitAction));
                } else {
                    jsonObject.put(SUBMIT_ACTIONS, submitActions);
                }
            }
        }
    }
}

