/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.support;

import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RabbitService {
    @Value(value="${rabbitMQExchangeName}")
    private String rabbitMQExchangeName;
    @Value(value="${scheduleRuleConfigRoutingKey}")
    private String scheduleRuleConfigRoutingKey;
    @Value(value="${monitorRuleConfigRoutingKey}")
    private String monitorRuleConfigRoutingKey;
    @Autowired(required=false)
    @Qualifier(value="kgrabbitTemplate")
    private RabbitTemplate rabbitTemplate;

    public void sendScheduleRuleConfig(Object message) {
        if (this.rabbitTemplate == null) {
            return;
        }
        this.rabbitTemplate.convertAndSend(this.rabbitMQExchangeName, this.scheduleRuleConfigRoutingKey, message);
    }

    public void sendMonitorRuleConfig(Object message) {
        if (this.rabbitTemplate == null) {
            return;
        }
        this.rabbitTemplate.convertAndSend(this.rabbitMQExchangeName, this.monitorRuleConfigRoutingKey, message);
    }
}

