/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionScheduleParam;
import com.digiwin.athena.knowledgegraph.service.impl.DataSubscriptionService;
import com.digiwin.athena.knowledgegraph.synonym.controller.ISubscriptionService;
import com.digiwin.athena.knowledgegraph.synonym.dao.SubscriptionDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.DeleteDto;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.EntryInfo;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.GetSubscriptionByPageRequest;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.SubscriberInfo;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.Subscription;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import com.digiwin.athena.knowledgegraph.synonym.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubscriptionServiceImpl
implements ISubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionServiceImpl.class);
    @Resource
    private SubscriptionDao subscriptionDao;
    @Autowired
    private DataSubscriptionService dataSubscriptionService;

    @Override
    public ResultBean<Object> createEntry(Subscription subscription) {
        try {
            subscription.setCreateDate(DateUtil.getStringDate(new Date()));
            this.subscriptionDao.insertOne(subscription);
            return ResultBean.success("");
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> updateEntry(Subscription subscription) {
        try {
            subscription.setEditDate(DateUtil.getStringDate(new Date()));
            this.subscriptionDao.saveOne(subscription);
            return ResultBean.success("");
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getEntryDetail(String code) {
        try {
            return ResultBean.success(this.subscriptionDao.fineOne(new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code))));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getEntryPage(GetSubscriptionByPageRequest request) {
        Integer pageNum = request.getPage();
        Integer pageSize = request.getPageSize();
        String question = request.getQuestion();
        String tenantId = request.getTenantId();
        try {
            return ResultBean.success(this.subscriptionDao.getEntryPage(pageNum, pageSize, question, tenantId));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getSubscriptionPage(GetSubscriptionByPageRequest request) {
        try {
            return ResultBean.success(this.subscriptionDao.getSubscriptionPage(request));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> deleteSubscription(DeleteDto deleteDto) {
        try {
            List<Subscription> dtoList = deleteDto.getCodes();
            if (!CollectionUtils.isEmpty(dtoList)) {
                List<String> ruleIds = dtoList.stream().map(Subscription::getCode).collect(Collectors.toList());
                Object result = this.dataSubscriptionService.postRemoveDataSubscriptionConfig(deleteDto.getTenantId(), ruleIds);
                if (StringUtils.equals((CharSequence)String.valueOf(result), (CharSequence)"success")) {
                    this.subscriptionDao.deleteSubscription(deleteDto.getTenantId(), ruleIds);
                }
            }
            return ResultBean.success("");
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> deleteEntry(DeleteDto deleteDto) {
        try {
            this.subscriptionDao.deleteEntry(deleteDto);
            return ResultBean.success("");
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> createSubscription(Subscription subscription) {
        try {
            String tenantId = subscription.getTenantId();
            EntryInfo entryInfo = subscription.getQuestion();
            String question = entryInfo.getQuestion();
            String sceneCode = entryInfo.getSceneCode();
            List<String> metricIdList = entryInfo.getMetricIdList();
            List<String> datasetIdList = entryInfo.getDatasetIdList();
            List<SubscriberInfo> subscribers = subscription.getSubscribers();
            if (!CollectionUtils.isEmpty(subscribers)) {
                for (SubscriberInfo subscriber : subscribers) {
                    Object dataSubscriptionRules = this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, subscriber.getUserId(), question, sceneCode, (List)metricIdList, (List)datasetIdList, "asada");
                    if (CollectionUtils.isEmpty((Collection)dataSubscriptionRules)) {
                        this.createSystemSubscription(tenantId, subscriber, subscription);
                        continue;
                    }
                    List system = dataSubscriptionRules.stream().filter(e -> e.getScheduleParam().getUndeletable()).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(system)) {
                        this.createSystemSubscription(tenantId, subscriber, subscription);
                        continue;
                    }
                    DataSubscriptionRule dataSubscriptionRule = (DataSubscriptionRule)system.get(0);
                    Subscription subs = this.subscriptionDao.fineOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)dataSubscriptionRule.getRuleId())));
                    if (!Objects.isNull(subs)) continue;
                    Subscription copy = new Subscription();
                    BeanUtils.copyProperties((Object)subscription, (Object)copy);
                    copy.setObjectId(null);
                    copy.setCode(dataSubscriptionRule.getRuleId());
                    copy.setSubscriber(subscriber.getUserId());
                    copy.setSubscriberName(subscriber.getUserName());
                    copy.setSubscribers(null);
                    copy.setCreateDate(DateUtil.getStringDate(new Date()));
                    copy.setEditDate(null);
                    copy.setEditBy(null);
                    this.subscriptionDao.insertOne(copy);
                }
            }
        }
        catch (Exception e2) {
            return ResultBean.fail(1, e2.getMessage());
        }
        return ResultBean.success("");
    }

    private void createSystemSubscription(String tenantId, SubscriberInfo subscriber, Subscription subscription) {
        try {
            List system;
            Object rules;
            DataSubscriptionRule config = DataSubscriptionRule.builder().tenantId(tenantId).caller("agileSubscribe").enableStatus("Y").build();
            DataSubscriptionScheduleParam scheduleParam = this.convertScheduleParam(subscription.getQuestion(), subscriber.getUserId(), subscriber.getUserName());
            config.setScheduleParam(scheduleParam);
            config.setTriggers(subscription.getFrequency());
            Object result = this.dataSubscriptionService.postAddDataSubscriptionConfig(config);
            if (!StringUtils.equals((CharSequence)String.valueOf(result), (CharSequence)"success")) {
                log.error("\u7cfb\u7edf\u8ba2\u9605\u521b\u5efa\u5931\u8d25,tenantId:{},question:{},userId:{}", new Object[]{tenantId, subscription.getQuestion().getQuestion(), subscriber.getUserId()});
            }
            if (!CollectionUtils.isEmpty((Collection)(rules = this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, subscriber.getUserId(), subscription.getQuestion().getQuestion(), subscription.getQuestion().getSceneCode(), (List)subscription.getQuestion().getMetricIdList(), (List)subscription.getQuestion().getDatasetIdList(), "asada"))) && !CollectionUtils.isEmpty(system = rules.stream().filter(e -> e.getScheduleParam().getUndeletable()).collect(Collectors.toList()))) {
                String ruleId = ((DataSubscriptionRule)system.get(0)).getRuleId();
                Subscription copy = new Subscription();
                BeanUtils.copyProperties((Object)subscription, (Object)copy);
                copy.setObjectId(null);
                copy.setCode(ruleId);
                copy.setSubscriber(subscriber.getUserId());
                copy.setSubscriberName(subscriber.getUserName());
                copy.setSubscribers(null);
                copy.setCreateDate(DateUtil.getStringDate(new Date()));
                copy.setEditDate(null);
                copy.setEditBy(null);
                this.subscriptionDao.insertOne(copy);
            }
        }
        catch (Exception ex) {
            log.error("\u7cfb\u7edf\u8ba2\u9605\u521b\u5efa\u5931\u8d25:{}", (Object)ex.getMessage());
        }
    }

    private DataSubscriptionScheduleParam convertScheduleParam(EntryInfo question, String userId, String userName) {
        DataSubscriptionScheduleParam scheduleParam = new DataSubscriptionScheduleParam();
        scheduleParam.setUserId(userId);
        scheduleParam.setAsaCode("asada");
        scheduleParam.setUserName(userName);
        scheduleParam.setQuestion(question.getQuestion());
        scheduleParam.setSceneCode(question.getSceneCode());
        scheduleParam.setMetricIdList(question.getMetricIdList());
        scheduleParam.setUndeletable(true);
        return scheduleParam;
    }

    @Override
    public ResultBean<Object> editSubscription(Subscription subscription) {
        try {
            DataSubscriptionRule dataSubscriptionRule = (DataSubscriptionRule)this.dataSubscriptionService.getSingleDataSubscriptionConfig(subscription.getCode());
            if (Objects.isNull(dataSubscriptionRule) || !dataSubscriptionRule.getScheduleParam().getUndeletable().booleanValue()) {
                throw new BusinessException("\u8be5\u7cfb\u7edf\u8ba2\u9605\u4e0d\u5b58\u5728");
            }
            dataSubscriptionRule.setTriggers(subscription.getFrequency());
            Object result = this.dataSubscriptionService.postAddDataSubscriptionConfig(dataSubscriptionRule);
            if (StringUtils.equals((CharSequence)String.valueOf(result), (CharSequence)"success")) {
                subscription.setEditDate(DateUtil.getStringDate(new Date()));
                this.subscriptionDao.saveOne(subscription);
            }
        }
        catch (Exception e) {
            return ResultBean.fail(1, e.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public List<Subscription> findByQuestion(String tenantId, String question) {
        try {
            return this.subscriptionDao.findByQuestion(tenantId, question);
        }
        catch (Exception e) {
            return new ArrayList<Subscription>();
        }
    }
}

