/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.BusinessVariables;
import com.digiwin.athena.knowledgegraph.synonym.domain.BusinessVariablesValue;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.enums.SourceEnum;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import com.mongodb.bulk.BulkWriteResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BusinessVariablesDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void insertBusinessVariables(List<BusinessVariablesValue> businessVariables) {
        this.mongoTemplate.insertAll(businessVariables);
    }

    public void updateBusinessVariables(BusinessVariablesValue businessVariables) {
        if (StringUtils.isEmpty((CharSequence)businessVariables.getSource())) {
            businessVariables.setSource(SourceEnum.CUSTOM.getType());
        }
        this.mongoTemplate.save((Object)businessVariables);
    }

    public int saveBusinessVariables(List<BusinessVariablesValue> list) {
        ArrayList updateList = new ArrayList(list.size());
        BulkOperations operations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, "agiledata_business_variables_value");
        list.forEach(data -> {
            Query query = new Query((CriteriaDefinition)new Criteria("_id").is((Object)data.getId()));
            Update update = new Update();
            update.set("source", (Object)data.getSource());
            Pair updatePair = Pair.of((Object)query, (Object)update);
            updateList.add(updatePair);
        });
        operations.upsert(updateList);
        BulkWriteResult result = operations.execute();
        return result.getModifiedCount();
    }

    public void deleteBusinessVariables(DeleteVo deleteVo) {
        if (StringUtils.isEmpty((CharSequence)deleteVo.getTid())) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)deleteVo.getTid());
        criteria.and("appCode").is((Object)deleteVo.getAppCode());
        if (!CollectionUtils.isEmpty(deleteVo.getIds())) {
            criteria.and("id").in(deleteVo.getIds());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, BusinessVariablesValue.class);
    }

    public PageVo<BusinessVariablesValue> queryBusinessVariables(String appCode, String tid, int pageNum, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        --pageNum;
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)});
        criteria.and("appCode").is((Object)appCode);
        criteria.and("source").ne((Object)SourceEnum.SYSTEM.getType());
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"data_name"});
        long totalCount = this.mongoTemplate.count(query, BusinessVariablesValue.class);
        List entityTypes = this.mongoTemplate.find(query.with((Pageable)pageable), BusinessVariablesValue.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo<BusinessVariablesValue>((int)totalCount, entityTypes, pageNum, pageSize, totalPage);
    }

    public List<BusinessVariablesValue> queryBusinessVariablesValue(String tid, String appCode) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)});
        criteria.and("appCode").is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, BusinessVariablesValue.class);
    }

    public List<BusinessVariablesValue> queryAll() {
        Query query = new Query();
        Criteria criteria = new Criteria();
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, BusinessVariablesValue.class);
    }

    public List<BusinessVariables> queryBusinessVariables(String appCode, String tenantVersion) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"version").is((Object)tenantVersion)});
        criteria.and("appCode").is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.systemMongoTemplate.find(query, BusinessVariables.class);
    }
}

