/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.task;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.task.model.DecisionRuleTenantConfigDO;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DecisionRuleTenantConfigManager {
    private static final String PRODUCT_CONFIG_COLLECTION_NAME = "decisionRuleTenantConfig";
    private static final String PRODUCT_CONFIG_INDEX_NAME = "idx_DecisionRuleTenantConfig";
    private static final String TENANT_ID_FIELD = "tenantId";
    private static final String RULE_ID_FIELD = "ruleId";
    private static final String DECISION_RULE_FIELD = "decisionRule";

    public DecisionRuleTenantConfigDO readTenantConfig(String tenantId, String ruleId) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, RULE_ID_FIELD, DECISION_RULE_FIELD);
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)TENANT_ID_FIELD, (Object)tenantId), Filters.eq((String)RULE_ID_FIELD, (Object)ruleId)})).first();
        if (doc != null) {
            DecisionRuleTenantConfigDO decisionRuleConfigDO = (DecisionRuleTenantConfigDO)JSON.parseObject((String)doc.toJson(), DecisionRuleTenantConfigDO.class);
            return decisionRuleConfigDO;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.decisionRuleNotFound", tenantId, ruleId));
    }
}

