/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.knowledgegraph.domain.esp.EspBody;
import com.digiwin.athena.knowledgegraph.domain.esp.EspResponse;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESPInvokeUtil {
    private static final Logger log = LoggerFactory.getLogger(ESPInvokeUtil.class);
    private static final Set<String> SUCCESS_CODES = new HashSet<String>();

    private ESPInvokeUtil() {
    }

    public static EspResponse invokeRestSync(String serviceName, String productName, String token, String tenantId, String jsonMsg, Map<String, Object> headerParamMap, Map<String, Object> eocMap) {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage("zh_CN");
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(serviceName);
        requestModel.setEocMap(eocMap);
        String body = null;
        body = StringUtils.isNotEmpty((CharSequence)jsonMsg) ? "{\"std_data\":{\"parameter\":" + jsonMsg + "}}" : "{\"std_data\":{\"parameter\":" + JSONObject.toJSONString((Object)new JSONObject()) + "}}";
        requestModel.setBodyJsonString(body);
        LoginInfo loginInfo = KgFilter.getLoginInfo();
        if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty((CharSequence)loginInfo.getApplication())) {
            HashMap<String, String> datakeyMap = new HashMap<String, String>();
            datakeyMap.put("appCode", loginInfo.getApplication());
            requestModel.setDatakeyMap(datakeyMap);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("token", token);
        headerMap.put("routerKey", tenantId);
        if (headerParamMap != null) {
            Set<Map.Entry<String, Object>> entries = headerParamMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                headerMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        requestModel.setHeaderMap(headerMap);
        try {
            DWServiceChainUtils.beforeInvokeOutterAPI(headerMap::put);
            ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            String response = responseModel.getBodyJsonString();
            log.info("invoke Result:{}", (Object)response);
            EspBody espBody = (EspBody)JSONObject.parseObject((String)response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if (SUCCESS_CODES.contains(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            }
            espResponse.setMsg(espBody.getStd_data().getExecution().getDescription());
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        catch (Exception e) {
            log.error("call esp error:{}", (Object)e.getMessage());
            EspResponse espResponse = new EspResponse();
            espResponse.setMsg(e.getMessage());
            espResponse.setStatus(EspResponse.Status.FAILED);
            if (e instanceof InvocationException) {
                espResponse.setErrorCode(((InvocationException)e).getErrorCode());
                espResponse.setChainInfo(((InvocationException)e).getChainInfo());
            }
            return espResponse;
        }
    }

    static {
        SUCCESS_CODES.add("0");
        SUCCESS_CODES.add("000");
    }
}

