/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.utils;

import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class OperationRecordUtil {
    private static final Logger log = LoggerFactory.getLogger(OperationRecordUtil.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    public void recordInfo(OperationRecord operationRecord) {
        try {
            LocalDateTime currentDateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String currentTime = currentDateTime.format(formatter);
            operationRecord.setTime(currentTime);
            this.mongoTemplate.insert((Object)operationRecord);
        }
        catch (Exception e) {
            log.warn("OperationRecordUtil.recordSensitiveOperation warn,{}", (Object)e.toString());
        }
    }

    public void cleanOperationRecord() {
        LocalDateTime currentDateTime = LocalDateTime.now().minusDays(30L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String currentTime = currentDateTime.format(formatter);
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"time").lt((Object)currentTime).and("type").is((Object)OperationRecordType.CLEAN_REDIS.toString())), OperationRecord.class);
    }
}

