/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;

public class SQLIndexSuggestionUtils {
    private static void extractTablesWithAlias(SelectItem selectItem, Map<String, String> tableAliasMap, Set<String> joinColumnsSet) {
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
            SQLIndexSuggestionUtils.extractTablesWithAliasFromItem(expressionItem.getExpression(), tableAliasMap, joinColumnsSet);
        }
    }

    private static void extractTablesWithAliasFromItem(Expression expression, Map<String, String> tableAliasMap, Set<String> joinColumnsSet) {
        if (expression instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)expression;
            SQLIndexSuggestionUtils.extractTablesWithAlias(subSelect.getSelectBody(), tableAliasMap, joinColumnsSet);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            SQLIndexSuggestionUtils.extractTablesWithAliasFromItem(binaryExpression.getLeftExpression(), tableAliasMap, joinColumnsSet);
            SQLIndexSuggestionUtils.extractTablesWithAliasFromItem(binaryExpression.getRightExpression(), tableAliasMap, joinColumnsSet);
        } else if (expression instanceof Function) {
            Function function = (Function)expression;
            for (Expression param : function.getParameters().getExpressions()) {
                SQLIndexSuggestionUtils.extractTablesWithAliasFromItem(param, tableAliasMap, joinColumnsSet);
            }
        } else if (expression instanceof Column) {
            String tableAlias;
            Column column = (Column)expression;
            String tableName = column.getTable() != null ? column.getTable().getName() : "";
            String string = tableAlias = column.getTable() != null && column.getTable().getAlias() != null ? column.getTable().getAlias().getName() : "";
            if (!tableName.isEmpty() && !tableAlias.isEmpty()) {
                tableAliasMap.put(tableAlias, tableName);
            }
        }
    }

    private static void extractTablesWithAlias(FromItem fromItem, Map<String, String> tableAliasMap, Set<String> joinColumnsSet) {
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            SQLIndexSuggestionUtils.extractTablesWithAlias(subSelect.getSelectBody(), tableAliasMap, joinColumnsSet);
        } else if (fromItem instanceof Join) {
            Join join = (Join)fromItem;
            SQLIndexSuggestionUtils.extractTablesWithAliasFromItem(join.getOnExpression(), tableAliasMap, joinColumnsSet);
        } else if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            tableAliasMap.put(table.getAlias() != null ? table.getAlias().getName() : "", table.getName());
        }
    }

    public static void extractTablesWithAlias(SelectBody selectBody, Map<String, String> tableAliasMap, Set<String> joinColumnsSet) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            if (plainSelect.getFromItem() != null) {
                SQLIndexSuggestionUtils.extractTablesWithAlias(plainSelect.getFromItem(), tableAliasMap, joinColumnsSet);
                SQLIndexSuggestionUtils.extractFromTableAndColumn(plainSelect, joinColumnsSet);
            }
            if (plainSelect.getJoins() != null) {
                for (Join join : plainSelect.getJoins()) {
                    SQLIndexSuggestionUtils.extractTablesWithAlias(join.getRightItem(), tableAliasMap, joinColumnsSet);
                    SQLIndexSuggestionUtils.extractJoinTableAndColumn(join, tableAliasMap, joinColumnsSet);
                }
            }
            if (plainSelect.getSelectItems() != null) {
                for (SelectItem selectItem : plainSelect.getSelectItems()) {
                    SQLIndexSuggestionUtils.extractTablesWithAlias(selectItem, tableAliasMap, joinColumnsSet);
                }
            }
            SQLIndexSuggestionUtils.extractWhereTableAndColumn(plainSelect, tableAliasMap, joinColumnsSet);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            for (SelectBody select : setOperationList.getSelects()) {
                SQLIndexSuggestionUtils.extractTablesWithAlias(select, tableAliasMap, joinColumnsSet);
            }
        }
    }

    private static void extractFromTableAndColumn(PlainSelect plainSelect, Set<String> joinColumnsSet) {
        String mainTableAlias;
        FromItem fromItem = plainSelect.getFromItem();
        String string = mainTableAlias = fromItem.getAlias() != null ? fromItem.getAlias().getName() : "";
        if (fromItem instanceof Table) {
            mainTableAlias = ((Table)fromItem).getName();
        }
        List selectItems = plainSelect.getSelectItems();
        for (SelectItem selectItem : selectItems) {
            SelectExpressionItem expressionItem;
            if (!(selectItem instanceof SelectExpressionItem) || !((expressionItem = (SelectExpressionItem)selectItem).getExpression() instanceof Column)) continue;
            Column column = (Column)expressionItem.getExpression();
            String columnName = column.getColumnName();
            String string2 = Objects.isNull(column.getTable()) ? "" : column.getTable().getName();
        }
    }

    private static void extractJoinTableAndColumn(Join join, Map<String, String> tableAliasMap, Set<String> joinColumnsSet) {
        String joinTableAlias;
        FromItem joinItem = join.getRightItem();
        String string = joinTableAlias = joinItem.getAlias() != null ? joinItem.getAlias().getName() : "";
        if (joinItem instanceof Table) {
            joinTableAlias = ((Table)joinItem).getName();
        }
        List joinColumns = join.getUsingColumns();
        for (Column joinColumn : joinColumns) {
            String joinColumnName = joinColumn.getColumnName();
            joinColumnsSet.add(joinTableAlias + "." + joinColumnName);
        }
        Collection onExpressions = join.getOnExpressions();
        if (CollectionUtils.isNotEmpty((Collection)onExpressions)) {
            for (Expression onExpression : onExpressions) {
                SQLIndexSuggestionUtils.processJoinExpression(onExpression, tableAliasMap, joinColumnsSet);
            }
        }
    }

    private static void extractWhereTableAndColumn(PlainSelect plainSelect, Map<String, String> tableAliasMap, Set<String> joinColumnsSet) {
        Expression whereExpression = plainSelect.getWhere();
        if (whereExpression != null) {
            SQLIndexSuggestionUtils.processWhereExpression(whereExpression, tableAliasMap, joinColumnsSet);
        }
    }

    private static void processJoinExpression(Expression expression, Map<String, String> tableAliasMap, Set<String> tableColumnsList) {
        if (expression instanceof BinaryExpression) {
            SQLIndexSuggestionUtils.processBinaryExpression((BinaryExpression)expression, tableAliasMap, tableColumnsList);
        } else {
            Expression expressionValue = ((Parenthesis)expression).getExpression();
            SQLIndexSuggestionUtils.processJoinExpression(expressionValue, tableAliasMap, tableColumnsList);
        }
    }

    private static void processBinaryExpression(BinaryExpression binaryExpression, Map<String, String> tableAliasMap, Set<String> tableColumnsList) {
        String rightValue;
        Expression leftExpression = binaryExpression.getLeftExpression();
        Expression rightExpression = binaryExpression.getRightExpression();
        SimpleNode type = binaryExpression.getASTNode();
        if (null != type && Objects.equals(type.toString(), "LikeExpression") && (rightValue = ((StringValue)rightExpression).getValue()).startsWith("%")) {
            return;
        }
        if (leftExpression instanceof BinaryExpression) {
            SQLIndexSuggestionUtils.processWhereExpression(leftExpression, tableAliasMap, tableColumnsList);
        } else {
            SQLIndexSuggestionUtils.processSingleExpression(leftExpression, tableAliasMap, tableColumnsList);
        }
        if (rightExpression instanceof BinaryExpression) {
            SQLIndexSuggestionUtils.processWhereExpression(rightExpression, tableAliasMap, tableColumnsList);
        } else {
            SQLIndexSuggestionUtils.processSingleExpression(rightExpression, tableAliasMap, tableColumnsList);
        }
    }

    private static void processBetweenExpression(Between binaryExpression, Map<String, String> tableAliasMap, Set<String> tableColumnsList) {
        Expression leftExpression = binaryExpression.getLeftExpression();
        if (leftExpression instanceof BinaryExpression) {
            SQLIndexSuggestionUtils.processWhereExpression(leftExpression, tableAliasMap, tableColumnsList);
        } else {
            SQLIndexSuggestionUtils.processSingleExpression(leftExpression, tableAliasMap, tableColumnsList);
        }
    }

    private static void processWhereExpression(Expression expression, Map<String, String> tableAliasMap, Set<String> tableColumnsList) {
        if (expression instanceof BinaryExpression) {
            SQLIndexSuggestionUtils.processBinaryExpression((BinaryExpression)expression, tableAliasMap, tableColumnsList);
        } else if (expression instanceof Parenthesis) {
            Expression expressionValue = ((Parenthesis)expression).getExpression();
            SQLIndexSuggestionUtils.processWhereExpression(expressionValue, tableAliasMap, tableColumnsList);
        } else if (expression instanceof Between) {
            Between betweenExpression = (Between)expression;
            SQLIndexSuggestionUtils.processBetweenExpression(betweenExpression, tableAliasMap, tableColumnsList);
        }
    }

    private static void processSingleExpression(Expression expression, Map<String, String> tableAliasMap, Set<String> tableColumnsList) {
        if (expression instanceof Column) {
            Column column = (Column)expression;
            Table tableName = column.getTable();
            String tableAlias = tableName != null ? tableName.getName() : "";
            String columnName = column.getColumnName();
            String tableColumn = tableAlias.isEmpty() ? columnName : tableAlias + "%" + columnName;
            tableColumnsList.add(tableColumn);
        } else {
            if (expression instanceof Function) {
                return;
            }
            if (expression instanceof Between) {
                Between betweenExpression = (Between)expression;
                SQLIndexSuggestionUtils.processBetweenExpression(betweenExpression, tableAliasMap, tableColumnsList);
            } else if (expression instanceof Parenthesis) {
                Expression expressionValue = ((Parenthesis)expression).getExpression();
                SQLIndexSuggestionUtils.processSingleExpression(expressionValue, tableAliasMap, tableColumnsList);
            }
        }
    }

    public static List<String> getOptimizationSuggestions(List<String> tablesList, Map<String, String> tableAliasMap, List<String> joinColumnsList) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(joinColumnsList) && CollectionUtils.isNotEmpty(tablesList)) {
            for (String table : tablesList) {
                StringBuilder sb = new StringBuilder();
                sb.append(table).append(".");
                for (String suggestion : joinColumnsList) {
                    String[] data = suggestion.split("%");
                    if (data.length > 1) {
                        String tableName = tableAliasMap.getOrDefault(data[0], data[0]);
                        String column = data[1];
                        if (table.contains(tableName)) {
                            sb.append(column).append(",");
                        }
                    }
                    if (data.length != 1 || tablesList.size() != 1) continue;
                    sb.append(data[0]).append(",");
                }
                String inputString = sb.toString();
                if (!inputString.endsWith(",")) continue;
                inputString = inputString.substring(0, inputString.length() - 1);
                suggestions.add(inputString);
            }
        }
        return suggestions;
    }
}

