/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.utils;

import cn.hutool.core.util.RandomUtil;
import com.digiwin.athena.domain.core.app.Application;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TestUtil {
    public static Object fillObject(Class<?> clazz) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Field[] fields;
        Object o = clazz.newInstance();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String typeName = field.getType().getName();
            Object value = TestUtil.getValue(typeName);
            if (value != null) {
                field.set(o, value);
                continue;
            }
            if (typeName.contains("List")) {
                ArrayList<Object> list = new ArrayList<Object>();
                String genericTypeName = field.getGenericType().getTypeName();
                Object value2 = TestUtil.getValue(genericTypeName);
                if (value2 != null) {
                    for (int i = 0; i < 10; ++i) {
                        list.add(TestUtil.getValue(genericTypeName));
                    }
                } else {
                    String generatorTypeRoute = genericTypeName.substring(genericTypeName.indexOf("<") + 1, genericTypeName.indexOf(">"));
                    for (int i = 0; i < 10; ++i) {
                        list.add(TestUtil.fillObject(Class.forName(generatorTypeRoute)));
                    }
                }
                field.set(o, list);
                continue;
            }
            field.set(o, TestUtil.fillObject(Class.forName(typeName)));
        }
        return o;
    }

    private static Object getValue(String type) {
        if (type.contains("String")) {
            return GenerateData.getString(10);
        }
        if (type.contains("int") || type.contains("Integer")) {
            return GenerateData.getInt(0, 100);
        }
        if (type.contains("long") || type.contains("Long")) {
            return GenerateData.getInt(0, 100);
        }
        if (type.contains("float") || type.contains("Float")) {
            return GenerateData.getDouble(0, 100);
        }
        if (type.contains("double") || type.contains("Double")) {
            return GenerateData.getDouble(0, 100);
        }
        return null;
    }

    public static void main(String[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Application application = (Application)TestUtil.fillObject(Application.class);
        System.out.println(application);
    }

    private static class GenerateData {
        private GenerateData() {
        }

        public static String getUUID() {
            return UUID.randomUUID().toString();
        }

        public static String getString(int length) {
            return RandomUtil.randomString((int)length);
        }

        public static int getInt(int min, int max) {
            return RandomUtil.randomInt((int)min, (int)max);
        }

        public static double getDouble(int min, int max) {
            return RandomUtil.randomDouble((double)min, (double)max);
        }

        public static List<String> getList(int size, int length) {
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                result.add(GenerateData.getString(length));
            }
            return result;
        }
    }
}

