/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.knowledgegraph.domain.AppEntity;
import com.digiwin.athena.knowledgegraph.domain.TenantAppInfoDTO;
import com.digiwin.athena.knowledgegraph.domain.TenantAppInfosDTO;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import java.util.List;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface TenantEntityRepository
extends Neo4jRepository<TenantEntity, Long> {
    @Query(value="match(te:TenantEntity) where te.ifCommon is null or te.ifCommon = false return te")
    public List<TenantEntity> allTenantEntity();

    @Query(value="match(te:TenantEntity{version:$0}) where te.ifCommon is null or te.ifCommon = false return te")
    public List<TenantEntity> allTenantEntity(String var1);

    @Query(value="match(te:TenantEntity{tenantId:$0}) return te")
    public TenantEntity tenantEntity(String var1);

    @Query(value="match(te:TenantEntity{tenantId:$0}) optional match (te)-[:USE]->(app:AppEntity{code:$1}) return te.tenantId as tenantId, te.tenantName as tenantName, app.code as appCode, app.namespace as namespace")
    public TenantAppInfoDTO tenantEntity(String var1, String var2);

    @Query(value="match(te:TenantEntity{tenantId:$0}) optional match (te)-[:USE]->(app:AppEntity) return app.code as appCode")
    public List<TenantAppInfoDTO> tenantAppEntity(String var1);

    @Query(value="match(te:AppEntity{code:$0}) return te LIMIT 1")
    public AppEntity appEntity(String var1);

    @Query(value="match(te:AppEntity) return te")
    public List<AppEntity> queryAllAppEntity();

    @Query(value="match(te:TenantEntity{tenantId:$0})-[:USE]->(app:AppEntity{code:$1}) return te.tenantId as tenantId, te.tenantName as tenantName, app.code as appCode, app.namespace as namespace")
    public TenantAppInfoDTO tenantWithAppEntity(String var1, String var2);

    @Query(value="match (te:TenantEntity)-[:USE]->(app:AppEntity) where app.code in $0 return te.tenantId as tenantId, te.tenantName as tenantName, te.customerServiceCode as customerServiceCode, app.code as appCode")
    public List<TenantAppInfoDTO> queryTenant(List<String> var1);

    @Query(value="match(te:TenantEntity{tenantId:$0}) optional match (te)-[:USE]->(app:AppEntity) return app.code as appCode, app.name as appName,te.tenantId as tenantId")
    public List<TenantAppInfosDTO> tenantAppsEntity(String var1);

    @Query(value="match (te:TenantEntity{tenantId:$0})-[:USE]->(app:AppEntity) return app.code as code ")
    public List<String> appCodes(String var1);
}

