package com.digiwin.athena.knowledgegraph.action.dao;

import com.digiwin.athena.kg.action.ActionMetadata;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;



@Repository
public class ActionMetadataDAO {
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplate;

    public ActionMetadata getActionMetadata(String actionId, String tenantId){
       if(StringUtils.startsWith(actionId,"esp_")){
           //通过用户去查对应版本的元数据信息
           String version = "";
           return this.getActionMetadataByActionId(actionId, version);
       }else{
            return this.getActionMetadataByActionId(actionId);
       }
    }


    public ActionMetadata getActionMetadataByActionId(String actionId){
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionId));
        return this.mongoTemplate.findOne(query, ActionMetadata.class);
    }

    public ActionMetadata getActionMetadataByActionId(String actionId, String version){
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionId).and("serviceVersion").is(version));
        return this.mongoTemplate.findOne(query, ActionMetadata.class);
    }

    public void upsertActionMetadata(String actionId, String serviceVersion, Object request, Object response, String serviceName){
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionId));
        Update update = new Update();
        update.set("requestParameters",request).set("responseObject",response)
                .set("serviceName",serviceName).set("serviceVersion",serviceVersion);


        this.mongoTemplate.upsert(query,update,"actionMetadata");
    }
}
