package com.digiwin.athena.knowledgegraph.action.model.report;

import lombok.Data;

import java.io.IOException;

/**
 * @title: Aggregator
 * @author: linc
 * @date 2023/11/22 19:20
 * @version: 1.0
 */
@Data
public class Aggregator {
    /**
     * 是否去重
     */
    private boolean distinct;
    /**
     * 聚合函数
     */
    private Function function;
}

enum Function {
    AVG, COUNT, MAX, MIN, SUM;

    public String toValue() {
        switch (this) {
            case AVG: return "avg";
            case COUNT: return "count";
            case MAX: return "max";
            case MIN: return "min";
            case SUM: return "sum";
        }
        return null;
    }

    public static Function forValue(String value) throws IOException {
        if (value.equals("avg")) return AVG;
        if (value.equals("count")) return COUNT;
        if (value.equals("max")) return MAX;
        if (value.equals("min")) return MIN;
        if (value.equals("sum")) return SUM;
        throw new IOException("Cannot deserialize Function");
    }
}
