package com.digiwin.athena.knowledgegraph.action.model.report;

import lombok.Data;

import java.io.IOException;
import java.util.List;

/**
 * @title: SortField
 * @author: linc
 * @date 2023/11/22 19:22
 * @version: 1.0
 */
@Data
public class SortField {
    /**
     * 字段code
     */
    private String field;
    /**
     * 排序顺序
     */
    private Order order;
    /**
     * 自定义排序顺序，当order为custom生效
     */
    private List<String> orderCustom;
    private Object the01H8P22Hnb1Kedbr2Xph6Twznx;
}

enum Order {
    ASC, CUSTOM, DESC;

    public String toValue() {
        switch (this) {
            case ASC: return "asc";
            case CUSTOM: return "custom";
            case DESC: return "desc";
        }
        return null;
    }

    public static Order forValue(String value) throws IOException {
        if (value.equals("asc")) return ASC;
        if (value.equals("custom")) return CUSTOM;
        if (value.equals("desc")) return DESC;
        throw new IOException("Cannot deserialize Order");
    }
}

