package com.digiwin.athena.knowledgegraph.action.transrule;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.mongodb.client.MongoCollection;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.stereotype.Component;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

@Component
public class TransformActionRuleManager {
    private static final String TRANS_RULE_COLLECTION_NAME = "transformActionRule";

    private static final String TRANS_RULE_INDEX_NAME = "idx_transformActionRule";
    private static final String RULE_ID_FIELD = "ruleId";
    private static final String VERSION_FIELD = "version";
    private static final String TENANT_ID_FIELD = "tenantId";

    public Object getRuleById(String ruleId, String tenantId, String tenantVersion) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(
                TRANS_RULE_COLLECTION_NAME, TRANS_RULE_INDEX_NAME, RULE_ID_FIELD, TENANT_ID_FIELD, VERSION_FIELD);
        //获取的配置必须是启用状态
        Document doc = col.find(and(eq(RULE_ID_FIELD, ruleId), eq(TENANT_ID_FIELD, tenantId), eq(VERSION_FIELD, tenantVersion))).first();
        if (doc != null) {
            Object transformActionRule = JSON.parseObject(doc.toJson(), Object.class);
            return transformActionRule;
        } else {
            return null;
        }
    }

    /*public Object getRuleByRuleIdAndTenantId(String ruleId, String tenantId) throws DWBusinessException {
        if (StringUtils.isEmpty(tenantId)) {
            return getRuleById(ruleId, tenantVersion);
        } else {
            MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(TRANS_RULE_COLLECTION_NAME, TRANS_RULE_INDEX_NAME, RULE_ID_FIELD, TENANT_ID_FIELD);
            //获取的配置必须是启用状态
            Document doc = col.find(and(eq(RULE_ID_FIELD, ruleId), eq(TENANT_ID_FIELD, tenantId))).first();
            if (doc != null) {
                Object transformActionRule = JSON.parseObject(doc.toJson(), Object.class);
                return transformActionRule;
            } else {
                return getRuleById(ruleId, tenantVersion);
            }
        }
    }*/
}
