package com.digiwin.athena.knowledgegraph.clients;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class EocService {

    @Autowired
    @Qualifier("eocRestTemplate")
    RestTemplate restTemplate;

    @Value("${eocUrl}")
    private String eocUrl;

    @Value("${iamApToken}")
    private String iamApToken;

    private static final String EOC_DUTY = "/api/eoc/v2/duty/list?pageSize=99999";

    private static final String EOC_STAFF = "/api/eoc/v2/emp?pageSize=99999";

    private static final String EOC_DEPT_STAFF = "/api/eoc/v2/dept/cascade?pageSize=99999";

    private static final String EOC_DUTY_STAFF = "/api/eoc/v2/duty/dept/emps";

    private static final String CORP_ALL = "/api/eoc/v2/corp/all";

    private static final String EOC_STAFF_USER = "/api/eoc/v2/emp/infos";

    /**
     * "/api/eoc/v2/emp/dept/byuser/check"
     * @param token
     * @param dutyIds
     * @return
     */
    public Object checkByUser(String token, List<String> dutyIds, List<String> appIds){
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("dutyIds", dutyIds);
        requestMap.put("appIds", appIds);
        requestMap.put("version", "v2");

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        log.info("checkByUser url:{}, requestMap:{}", eocUrl + "/api/eoc/v2/emp/dept/byuser/check", requestMap);
        ResponseEntity<Object> resEntity = restTemplate.exchange(eocUrl + "/api/eoc/v2/emp/dept/byuser/check", HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        log.info("checkByUser url:{}, dutyIds:{}, result:{}", eocUrl + "/api/eoc/v2/emp/dept/byuser/check", dutyIds, body);
        return body;

    }


    /**
     * /api/eoc/v2/emp/dept/byusers/check
     * [
     *      {                //类型：Object  必有字段  备注：租户笔数上限限定10笔
     *         "tenantId":"mock",                //类型：String  必有字段  备注：租户id
     *         "dutyIds":  [                //类型：Array  必有字段  备注：职能id
     *             "mock"                //类型：String  必有字段  备注：无
     *         ]
     *     }
     * ]
     * @param token
     * @return
     */
    public Object checkByUsers(String token, List<Map> requestParam){
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);

        HttpEntity<List> requestEntity = new HttpEntity<>(requestParam, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(eocUrl + "/api/eoc/v2/emp/dept/byusers/check", HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        log.info("checkByUsers url:{}, requestParam:{}, result:{}", eocUrl + "/api/eoc/v2/emp/dept/byusers/check", requestParam, body);
        return body;
    }

    public List<Map> getEocStaff() throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", iamApToken);

        ResponseEntity<Map<String, Object>> response = restTemplate.exchange(eocUrl + EOC_STAFF, HttpMethod.GET,
                new HttpEntity<>(headers), new ParameterizedTypeReference<Map<String, Object>>() {});

        if (response.getStatusCode() == HttpStatus.OK) {
            Map<String, Object> body = response.getBody();
            Map<String,Map<String, Object>> dataMap = (Map<String,Map<String, Object>>) body.get("data");
            if (!CollectionUtils.isEmpty(dataMap)) {
                return (List<Map>) dataMap.get("list");
            }
            return Collections.emptyList();
        }

        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocStaffError"));
    }


    public List<String> getEocDuty() throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", iamApToken);

        ResponseEntity<Map<String, Object>> response = restTemplate.exchange(eocUrl + EOC_DUTY, HttpMethod.GET,
                new HttpEntity<>(headers), new ParameterizedTypeReference<Map<String, Object>>() {});

        if (response.getStatusCode() == HttpStatus.OK) {
            Map<String, Object> body = response.getBody();
            Map<String,Map<String, Object>> dataMap = (Map<String,Map<String, Object>>) body.get("data");
            if (!CollectionUtils.isEmpty(dataMap)) {
                List<Map> dataList = (List<Map>) dataMap.get("list");
                if (!CollectionUtils.isEmpty(dataList)) {
                    return dataList.stream().map(data -> data.get("id").toString()).collect(Collectors.toList());
                }
            }
            return Collections.emptyList();
        }

        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDutyError"));
    }

    public List<Map> getEocDeptAndStaff() throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", iamApToken);

        ResponseEntity<Map<String, Object>> response = restTemplate.exchange(eocUrl + EOC_DEPT_STAFF, HttpMethod.GET,
                new HttpEntity<>(headers), new ParameterizedTypeReference<Map<String, Object>>() {});

        if (response.getStatusCode() == HttpStatus.OK) {
            Map<String, Object> body = response.getBody();
            Map<String,Map<String, Object>> dataMap = (Map<String,Map<String, Object>>) body.get("data");
            if (!CollectionUtils.isEmpty(dataMap)) {
                return (List<Map>) dataMap.get("list");
            }
            return Collections.emptyList();
        }

        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDeptAndStaff"));
    }

    public List<String> getEocDutyAndStaff(String dutyId) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", AthenaUtils.getHeaderToken());
        headers.set("digi-middleware-auth-app", iamApToken);
        Map<String,String> requestParam = new HashMap<>();
        requestParam.put("dutyId",dutyId);
        ResponseEntity<Map<String, Object>> response = restTemplate.exchange(eocUrl + EOC_DUTY_STAFF, HttpMethod.POST,
                new HttpEntity<>(requestParam,headers), new ParameterizedTypeReference<Map<String, Object>>() {});

        if (response.getStatusCode() == HttpStatus.OK) {
            Map<String, Object> body = response.getBody();
            List<Map<String, Object>> dataList = (List<Map<String, Object>>) body.get("data");
            if (!CollectionUtils.isEmpty(dataList)) {
                return dataList.stream().map(data -> data.get("empId").toString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDutyAndStaff"));
    }

    public List<String> getUserIdsByStaffs(List<String> eocIds, String token) throws DWBusinessException {

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);
        Map<String, Object> requestParam = new HashMap<>();
        requestParam.put("empIds", eocIds);
        ResponseEntity<Map<String, Object>> response = restTemplate.exchange(eocUrl + EOC_STAFF_USER, HttpMethod.POST,
                new HttpEntity<>(requestParam, headers), new ParameterizedTypeReference<Map<String, Object>>() {
                });

        if (response.getStatusCode() == HttpStatus.OK) {
            Map<String, Object> body = response.getBody();
            List<Map<String, Object>> dataList = (List<Map<String, Object>>) body.get("data");
            if (!CollectionUtils.isEmpty(dataList)) {
                return dataList.stream().map(data -> data.get("userId").toString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getEocDutyAndStaff"));
    }


    /**
     * @Author zhuangli
     * @Description 查询应用下授权员工id
     * @Date 13:37 2023/9/27
     * @Param
     * @return
     **/
    public Set<String> appHasUser(String appId, String tenantId, String token) throws DWBusinessException {
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("appId", appId);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Map> result = restTemplate.exchange(eocUrl + "/api/eoc/v2/emp/app/has/user", HttpMethod.POST, requestEntity, Map.class);
        if (result.getStatusCodeValue() == 200) {
            Map userData = result.getBody();
            if (!org.springframework.util.CollectionUtils.isEmpty(userData)) {
                List<Map<String, Object>> userDataMap = (List<Map<String, Object>>) userData.get("data");
                return userDataMap.stream().map(item -> item.get("empUserId").toString()).collect(Collectors.toSet());
            } else {
                return Collections.emptySet();
            }
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getProductError", ""));
        }
    }


    public Map getOperationUnitWithToken(String token) throws DWBusinessException {

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);

        ResponseEntity<Map<String, Object>> response = restTemplate.exchange(eocUrl + CORP_ALL, HttpMethod.GET,
                new HttpEntity<>(headers), new ParameterizedTypeReference<Map<String, Object>>() {});

        if (response.getStatusCode() == HttpStatus.OK) {
            Map<String, Object> body = response.getBody();
            Map<String,Object> dataMap = (Map<String,Object>) body.get("data");
            if (dataMap != null) {
                return dataMap;
            }
            return new HashMap();
        }

        throw new DWBusinessException("getOperationUnit error");
    }



}
