package com.digiwin.athena.knowledgegraph.clients;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class GMCService {

    @Autowired
    @Qualifier("gmcRestTemplate")
    RestTemplate restTemplate;

    @Value("${gmcUrl}")
    private String gmcUrl;

    @Value("${iamApToken}")
    String appToken;


//    @Value("${gmcLoginToken}")
//    private String gmcLoginToken;


//    private String getGmcLoginToken() throws DWBusinessException{
//        String appCode = "";
//        Query query = new Query();
//        query.fields().include("gmcLoginToken");
//        query.addCriteria(Criteria.where("appCode").is(appCode));
//        Map<String, Object> gmcLogin = this.mongoTemplateUser.findOne(query, Map.class, "gmcLogin");
//       if(gmcLogin == null || StringUtils.isEmpty(String.valueOf(gmcLogin.get("gmcLoginToken")))){
//           throw new DWBusinessException("用户通过gmc系统操作应用" + appCode + "操作的token信息缺失");
//       }
//       return String.valueOf(gmcLogin.get("gmcLoginToken"));
//    }

    public Object getCloudGood(String appId){
        String requestUrl = gmcUrl + "/api/cloudgoods/" + appId;
        Object forObject = this.restTemplate.getForObject(requestUrl, Object.class);
        return forObject;
    }


    public Object updateCloudGood(Object requestObj)  throws DWBusinessException{
        String requestUrl = gmcUrl + "/api/cloudgoods/";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, this.getGmcToken());

        HttpEntity httpEntity = new HttpEntity(requestObj, headers);
        ResponseEntity<Object> stringResponseEntity = this.restTemplate.postForEntity(requestUrl, httpEntity, Object.class);

        return stringResponseEntity.getBody();
    }

    public Object goodOff(String goodscode) throws DWBusinessException{
        return this.goodOnSale(goodscode, "0");
    }


    public Object goodOn(String goodscode) throws DWBusinessException{
        return this.goodOnSale(goodscode, "1");
    }

    public Object applyGoodOn(String goodscode) throws DWBusinessException{
        return this.goodOnSale(goodscode, "2");
    }

    public Object goodOnSale(String goodscode, String onsale)  throws DWBusinessException{
        log.info("goodscode:{}, onsale:{}", goodscode, onsale);

        String requestUrl = gmcUrl + "/api/cloudgoods/{goodscode}/{onsale}";
        Map<String, String> varMap = new HashMap();
        varMap.put("goodscode", goodscode);
        varMap.put("onsale", onsale);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, this.getGmcToken());

        HttpEntity httpEntity = new HttpEntity(null, headers);
        ResponseEntity<Object> stringResponseEntity = this.restTemplate.postForEntity(requestUrl, httpEntity, Object.class, varMap);
        return stringResponseEntity.getBody();

    }

    public Object multiLanguage(Object requestObj) throws DWBusinessException{


        String requestUrl = gmcUrl + "/api/gmc/v2/multi/language";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, this.getGmcToken());

        HttpEntity httpEntity = new HttpEntity(requestObj, headers);
        ResponseEntity<Object> stringResponseEntity = this.restTemplate.postForEntity(requestUrl, httpEntity, Object.class);

        return stringResponseEntity.getBody();
    }

    private String getGmcToken()  throws DWBusinessException{
        Map<String, Object> requestHeader = DWServiceContext.getContext().getRequestHeader();
        String token = requestHeader == null ? "" : (String)requestHeader.get("gmctoken");
        if(StringUtils.isEmpty(token)){
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tokenMiss"));
        }
        return token;
    }

    /**
     * 更新商品模组，不需要上下架即可生效
     * @param requestObj
     * @return
     * @throws DWBusinessException
     */
    public Object updateCloudGoodModules(Object requestObj)  throws DWBusinessException{
        String requestUrl = gmcUrl + "/api/cloudgoods/modules";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, this.getGmcToken());

        HttpEntity httpEntity = new HttpEntity(requestObj, headers);
        ResponseEntity<Object> stringResponseEntity = this.restTemplate.postForEntity(requestUrl, httpEntity, Object.class);

        return stringResponseEntity.getBody();
    }
}
