package com.digiwin.athena.knowledgegraph.component.applies;

import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyContext;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-30 16:36
 **/
@Service
@Order(100)
public class DefaultComponentApplyService implements ComponentApplyService {

    @Autowired
    DataMapService dataMapService;

    @Override
    public boolean accept(ComponentBO componentBO) {
        return ComponentTypeEnum.MechanismDefault.equals(componentBO.getType());
    }

    @Override
    public void apply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        Map<String,Object> param = new HashMap<>();
        param.put("type",componentBO.getType().name());
        param.put("pluginId",componentBO.getCode());
        dataMapService.bindMechanismComponent(param);
    }

    @Override
    public void unApply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        Map<String,Object> param = new HashMap<>();
        param.put("type",componentBO.getType().name());
        param.put("pluginId",componentBO.getCode());
        dataMapService.unBindMechanismComponent(param);
    }
}
